<?php

namespace App\Http\Controllers\HR;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\EmployeeAttendance;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;


class EmployeeAttendanceController extends Controller
{
    public function index()
    {
        $employee = Employee::all();
        $attendance = EmployeeAttendance::orderBy('id','desc')->paginate(20);
        return view('HR.attendance.index', compact('attendance'));
    }
    public function create()
    {
        $employees = Employee::all();
        return view('HR.attendance.create', compact('employees'));
    }
    public function store(Request $request)
    {

        $count = $request->count_emp;
        $date = explode('-', $request->date);
        $year = $date[0];
        $month = $date[1];
        $day = $date[2];


        for ($i = 0; $i < $count; $i++) {
            $attendance = new EmployeeAttendance();
            $attendance->employee_id = $request->employee_id[$i];
            $attendance->reson = $request->reson[$i];
            $attendance->status = $request->status[$i];
            $attendance->date = $request->date;
            $attendance->year = $year;
            $attendance->month = $month;
            $attendance->day = $day;
            $attendance->user_id = Auth::user()->id;
            $attendance->save();
        }
        // exit();
        session()->flash("msg", "Success");
        return redirect()->route('employee_attendance.index');


    }

    public function edit($id)
    {
        $emp_attendance = EmployeeAttendance::find($id);
        return view('HR.attendance.edit', compact('emp_attendance'));
    }

    public function update(Request $request, $id)
    {

        $count = $request->count_emp;
        $date = explode('-', $request->date);
        $year = $date[0];
        $month = $date[1];
        $day = $date[2];


        $attendance = EmployeeAttendance::find($id);
        $attendance->employee_id = $request->employee_id;
        $attendance->reson = $request->reson;
        $attendance->status = $request->status;
        $attendance->date = $request->date;
        $attendance->year = $year;
        $attendance->month = $month;
        $attendance->day = $day;
        $attendance->user_id = Auth::user()->id;
        $attendance->save();
        session()->flash("msg", "Success!");
        return redirect()->route('employee_attendance.index');


    }

    public function report_show()
    {
        $employees = Employee::all();
        return view('HR.attendance.report', compact('employees'));
    }

    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $date = $request->date;
        $employee_id = $request->employee_id;
        $month_id = $request->month_id;
        $data = "";
        $date = explode('-', $request->date);
        $year = $date[0];
        $employee = Employee::find($employee_id);
        if ($employee_id == "all") {
            $attendance = EmployeeAttendance::where('year', $year)
                ->where('month', $month_id)->get();
            $data .= "<h6 style='text-align:center'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center'>All Employee Attendance Report of $month_id Month</h6><p style='text-align:center'></p>";
            $data .= '<table class="" id="table_style">';
            $data .= '<thead>';
            $data .= '<tr>';
            $data .= '<th>Name</th>';
            $data .= '<th>year</th>';
            $data .= '<th>Month</th>';
            $data .= '<th>Opsent</th>';
            $data .= '<th>Leve</th>';
            $data .= '<th>Present</th>';
            // $data .= '<th>Up-to-days</th>';
            $data .= '</tr>';
            $data .= '</thead>';
            $data .= '<tbody>';

            foreach (Employee::all() as $row) {
                $present = $attendance->where('employee_id', $row->id)->where('status', 1)->count('id');
                $opsent = $attendance->where('employee_id', $row->id)->where('status', 2)->count('id');
                $leve = $attendance->where('employee_id', $row->id)->where('status', 3)->count('id');
                $days = $attendance->where('employee_id', $row->id)->count('id');
                $data .= '<tr>';
                $data .= "<td>" . $row->name . "</td>";
                $data .= "<td>" . $year . "</td>";
                $data .= "<td>" . $month_id . "</td>";
                $data .= "<td>" . $opsent . "</td>";
                $data .= "<td>" . $leve . "</td>";
                $data .= "<td>" . $present . "</td>";
                // $data .= "<td>" . $days . "</td>";
                $data .= '</tr>';
            }

            $data .= '</tbody>';
            $data .= '</table>';

        } else {
            $attendance = EmployeeAttendance::where('year', $year)
                ->where('month', $month_id)->where('employee_id', $employee_id)->get();
            $data .= "<h6 style='text-align:center'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center'>$employee->name   Attendance Report of $month_id Month</h6><p style='text-align:center'></p>";
            $data .= '<table class="" id="table_style">';
            $data .= '<thead>';
            $data .= '<tr>';
            $data .= '<th>date</th>';
            $data .= '<th>status</th>';
            $data .= '<th>reson</th>';
            $data .= '</tr>';
            $data .= '</thead>';
            $data .= '<tbody>';
            foreach ($attendance as $row) {
                $data .= '<tr>';
                $data .= "<td>" . $row->date . "</td>";
                $data .= "<td>";
                if ($row->status == 1) {
                    $data .= "Present";
                } else if ($row->status == 2) {
                    $data .= "Upsent";
                } else {
                    $data .= "leave";

                }
                $data .= "</td>";
                $data .= "<td>" . $row->reson . "</td>";
                $data .= '</tr>';
            }


            $data .= '</tbody>';
            $data .= '</table>';

        }

        return $data;
    }

    public function filter_find(Request $request){
        $bname=\App\Models\Info::find(1)->business_name;
        $employee = Employee::all();
        $attendance = EmployeeAttendance::where('date',$request->date)->paginate(20);
        return view('HR.attendance.index', compact('attendance'));
    }
}
