<?php

namespace App\Http\Controllers\HR\multiple;

use App\Http\Controllers\Controller;
use App\Models\Employee;
use Illuminate\Http\Request;
use App\Models\EmployeeAdvance;
use App\Models\CashJournal;
use App\Models\Info;
use App\Models\Project;
use Auth;
use Illuminate\Support\Facades\Config;

class EmpAdvanceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $payments = EmployeeAdvance::orderBy('id','desc')->paginate(20);
        $projects = Project::orderBy('id','desc')->where('status','!=',3)->get();
        $employees = Employee::all();
        return view('HR.advance.index', compact('payments', 'employees','projects'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'payment' => 'required',
            'date' => 'required',
            'employee_id' => 'required',

        ]);
        $payment = new EmployeeAdvance();
        $payment->employee_id = $request->employee_id;
        $payment->project_id = $request->project_id;
        $payment->type_id = $request->type_id;
        $payment->payment = $request->payment;
        $payment->date = $request->date;
        $data = explode('-', $request->date);
        $year = $data[0];
        $month = $data[1];
        $day = $data[2];
        $payment->year = $year;
        $payment->month = $month;
        $payment->day = $day;
        $payment->title = $request->title;
        $payment->details = $request->details;
        $payment->status = 1;
        $payment->c_target=$request->cash_id;
        $payment->user_id = Auth::user()->id;
        $payment->save();
        if($payment){
            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = $payment->title;
                $cash->date = $payment->date;
                $cash->outgoing = $payment->payment;
                $cash->currency_id = 1;
                $cash->ex_rate = 1;
                $cash->module_id = 26;
                $cash->type_id = 26;
                $cash->module_record_id = $payment->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Cash Target From Employee Advance";
                $cash->save();
            }
        }
        session()->flash("msg", "Success!");
        return back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $employees = Employee::all();
        $payment = EmployeeAdvance::find($id);
        $projects = Project::orderBy('id','desc')->where('status','!=',3)->get();
        return view('HR.advance.edit', compact('payment', 'employees','projects'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required',
            'payment' => 'required',
            'date' => 'required',
        ]);
        $payment = EmployeeAdvance::find($id);
        $payment->employee_id = $request->employee_id;
        $payment->payment = $request->payment;
        $payment->project_id = $request->project_id;
        $payment->type_id = $request->type_id;
        $payment->date = $request->date;
        $data = explode('-', $request->date);
        $year = $data[0];
        $month = $data[1];
        $day = $data[2];
        $payment->year = $year;
        $payment->month = $month;
        $payment->day = $day;
        $payment->title = $request->title;
        $payment->c_target=$request->cash_id;
        $payment->details = $request->details;
        $payment->user_id = Auth::user()->id;
        $payment->save();
        if($payment){
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 26)->where('module_record_id', $payment->id)->first();
                if ($cash != null) {
                    $cash->title = $payment->title;
                    $cash->date = $payment->date;
                    $cash->outgoing = $payment->payment;
                    $cash->currency_id = 1;
                    $cash->ex_rate = 1;
                    $cash->module_id = 26;
                    $cash->type_id = 26;
                    $cash->module_record_id = $payment->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Target From Employee Advance";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $payment->title;
                    $cash->date = $payment->date;
                    $cash->outgoing = $payment->payment;
                    $cash->currency_id = 1;
                    $cash->ex_rate = 1;
                    $cash->module_id = 26;
                    $cash->type_id = 26;
                    $cash->module_record_id = $payment->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Target From Employee Advance";
                    $cash->save();
                }
            } else {
                $cash = CashJournal::where('module_id', 26)->where('module_record_id', $payment->id)->delete();
            }
        }
        session()->flash("msg", "Success!");
        return redirect()->route('employee_advances.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $payment = EmployeeAdvance::find($id)->delete();
        $cash = CashJournal::where('module_id', 26)->where('module_record_id', $payment->id)->delete();
        session()->flash("msg", "Success!");
        return back();
    }

    public function report_show()
    {
        $employees = Employee::all();
        return view('HR.advance.report', compact('employees'));
    }
    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $employee_id = $request->employee_id;
        $employee = Employee::find($employee_id);
        $data = "";
        if ($employee_id == "all") {
            $payments = EmployeeAdvance::whereBetween('date', [$fDate, $tDate])->get();
            $data .= "<h6 style='text-align:center'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center'>All Employees Payment Report</h6><p style='text-align:center'>From ($fDate) to ($tDate)</p>";
            $data .= "<h6 style='text-align:center'>Print Date" . date('Y-M-d') . "</h6>";

            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>#</th>';
            $data .= '<th>Employee</th>';
            $data .= '<th>Title</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>Advance</th>';
            $data .= '<th>Details</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            foreach ($payments as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->employee->name . "</td>";
                $data .= "<td>" . $row->title . "</td>";
                $data .= "<td>" . $row->date . "</td>";
                $data .= "<td>" . $row->payment . " </td>";
                $data .= "<td>" . $row->details . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
            }
            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '</table>';
            $data .= '<table class="">';
            $data .= ' <tr>';
            $data .= '<th colspan="0" rowspan="2"> Sub Total</th>';
            $data .= '<th colspan="">Amount</th>';
            $data .= ' </tr>';
            $data .= ' <tr>';
            $data .= '<td>' . $payments->sum('payment') . '</td>';
            $data .= '</tr>';
            $data .= '</table>';
        } else {
            $payments = EmployeeAdvance::whereBetween('date', [$fDate, $tDate])->where('employee_id', $employee_id)->get();
            $data .= "<h6 style='text-align:center'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center'>$employee->name Payment Report</h6><p style='text-align:center'>From ($fDate) to ($tDate)</p>";
            $data .= "<h6 style='text-align:center'>Print Date" . date('Y-M-d') . "</h6>";

            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>Number</th>';
            $data .= '<th>Title</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>Advance</th>';
            $data .= '<th>Details</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            foreach ($payments as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->title . "</td>";
                $data .= "<td>" . $row->date . "</td>";
                $data .= "<td>" . $row->payment . " </td>";
                $data .= "<td>" . $row->details . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
            }
            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '</table>';
            $data .= '<table class="">';
            $data .= ' <tr>';
            $data .= '<th colspan="0" rowspan="2"> Sub Total</th>';
            $data .= '<th colspan="">Amount</th>';
            $data .= ' </tr>';
            $data .= ' <tr>';
            $data .= '<td>' . $payments->sum('payment') . '</td>';
            $data .= '</tr>';
            $data .= '</table>';
        }

        return $data;
    }
    public function filter_find(Request $request){
        if($request->type_id==1){
            $payments=EmployeeAdvance::Where('title','like','%'.$request->title.'%')
           
            ->paginate(20);
        }else if($request->type_id==2){
            $payments=EmployeeAdvance::Where('payment',$request->payment)
           
            ->paginate(20);
        }
        else{
            $payments=EmployeeAdvance::WhereBetween('date',[$request->f_date,$request->t_date])
           
            ->paginate(20);
        }
        $employees = Employee::all();
        return view('HR.advance.index',compact('payments','employees'));
    }
}
