<?php

namespace App\Http\Controllers;

use App\Models\CashType;
use App\Models\CustomerBillItem;
use App\Models\CustomerRetailBill;
use App\Models\CustomerReturnBill;
use App\Models\ExpenseType;
use App\Models\Scategory;
use App\Models\SupplierAdvance;
use App\Models\User;
use App\Models\BankAccount;
use App\Models\BankJournal;
use App\Models\CashJournal;
use App\Models\ExpenseJournal;
use App\Models\Employee;
use App\Models\EmployeeAdvance;
use App\Models\EmployeeOverTime;
use App\Models\EmployeeSalaries;
use App\Models\Customer;
use App\Models\CustomerBill;
use App\Models\CustomerAdvance;
use App\Models\CustomerRecieved;
use App\Models\SUnit;
use App\Models\SWeight;

use App\Models\Supplier;
use App\Models\SupplierBill;
use App\Models\SupplierPayment;
use App\Models\Stock;
use App\Models\Currency;
use App\Models\DebitorAccount;
use App\Models\InvestorAccount;
use App\Models\InvestorJournal;
use App\Models\Tex;
use App\Models\CompanyAsset;
use App\Models\assetAccounts;
use Carbon\Carbon;
use Storage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
class HomeController extends Controller
{


  public function dashboard()
  {

    $taday = Carbon::today();
    $now = Carbon::now();
    $weekStartDate = $now->startOfWeek()->format('Y-m-d');
    $weekEndDate = $now->endOfWeek()->format('Y-m-d');
    $monthStart = $now->startOfMonth()->format('Y-m-d');
    $users = user::count();
    $bankers = BankAccount::count();
    $customers = Customer::count();
    $employees = Employee::count();
    $suppliers = Supplier::count();
    $currencies = Currency::all();
    $sale = CustomerBill::all();
    $received = CustomerRecieved::all();
    $purchase = SupplierBill::all();
    $payment = SupplierPayment::all();
    $cash = CashJournal::all();
    $expense = ExpenseJournal::all();
    $bank = BankJournal::all();
    $employee_salaries = EmployeeSalaries::all();
    $employee_overtimes = EmployeeOverTime::all();
    $employee_advance = EmployeeAdvance::all();
    $customer_advance = CustomerAdvance::all();
    $investors = InvestorAccount::count();
    $debitors = DebitorAccount::count();
    return view('dashboard.dashboard', compact('users', 'currencies', 'sale', 'received', 'purchase', 'payment', 'cash', 'bank', 'expense', 'customers', 'employees', 'bankers', 'suppliers', 'employee_salaries', 'employee_overtimes', 'employee_advance', 'investors', 'debitors'));

  }

  public function income_statement_show()
  {
    return view('dashboard.income-statement');
  }

  public function income_statement_find(Request $request)
  {
    $bname = \App\Models\Info::find(1)->business_name;

    $fDate = $request->fromDate;
    $tDate = $request->toDate;
    $bill = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->get();
    $rtlbill = CustomerRetailBill::whereBetween('invoice_date', [$fDate, $tDate])->get();
    $rbill = CustomerReturnBill::whereBetween('invoice_date', [$fDate, $tDate])->get();
    $expense_type = ExpenseType::all();
    $expenseJournal = ExpenseJournal::whereBetween('date', [$fDate, $tDate])->get();
    $bill_items = CustomerBillItem::whereBetween('date', [$fDate, $tDate])->get();
    $tax = Tex::whereBetween('date', [$fDate, $tDate])->get();
    $data = "";
    $data .= "<div style='background-color:#013220; height:auto;'>";
    $data .= "<h3  style='text-align:center; color:#fff; '>" . $bname . "</h3>";
    $data .= "<h4  style='text-align:center; color:#fff; '>Company Income Statment</h4>";
    $data .= "<h5  style='text-align:center; color:#fff; '>From ($fDate) to ($tDate)</h5>";
    $data .= "</div>";
    $data .= "<h4>Revenue</h4>";
    $data .= '<table class="" id="table_style">';
    $data .= '<thead>';
    $data .= '<tr>';
    $data .= '<th style="width:300px;">Gross Sale</th>';
    $data .= '<th>' . $bill->sum('grand_total') . '</th>';
    $data .= '</tr>';
    $data .= '<tr>';
    $data .= '<th style="width:300px;">Less Sale Return</th>';
    $data .= '<th>' . $rbill->sum('amount') . '</th>';
    $data .= '</tr>';
    $data .= '<tr>';
    $data .= '<th style="width:300px;">Net Sale</th>';
    $net_sale = $bill->sum('grand_total') - $rbill->sum('amount');
    $data .= '<th>' . $net_sale . '</th>';
    $data .= '</tr>';
    $data .= '<tr>';
    $data .= '<th style="font-sixe:24px;">Cost Of Goods Sold</th>';
    $data .= '<th style="font-sixe:24px;">' . $bill_items->sum('cost_total') . '</th>';
    $data .= '</tr>';
    $data .= '<tr>';
    $data .= '<th style="font-sixe:24px;">Gross Profit (Loss)</th>';
    $gpl = $net_sale - $bill_items->sum('cost_total');
    $data .= '<th style="font-sixe:24px;">' . $gpl . '</th>';
    $data .= '</tr>';
    $data .= '</thead>';
    $data .= '</table>';

    $data .= '<table class="" id="table_style">';
    $data .= '<thead>';
    $data .= '<tr>';
    $data .= '<th style="font-sixe:24px;">Operating Expenses</th>';
    $data .= '</tr>';
    $data .= '<table class="" id="table_style">';
    $data .= '<thead>';
    foreach ($expense_type as $row) {
      $data .= '<tr>';
      $data .= '<th style="width:300px;">' . $row->title_en . '</th>';
      $data .= '<th>' . $expenseJournal->where('type_id', $row->id)->sum('amount') . '</th>';
      $data .= '</tr>';
    }
    $data .= '<tr>';
    $data .= '<th style="font-sixe:24px;">Total Operating Expenses</th>';
    $data .= '<th style="font-sixe:24px;">' . $expenseJournal->sum('amount') . '</th>';
    $data .= '</tr>';

    $data .= '<tr>';
    $data .= '<th style="font-sixe:24px;">Profit (Loss) Before Taxes</th>';
    $plbt = $gpl - $expenseJournal->sum('amount');
    $data .= '<th style="font-sixe:24px;">' . $plbt . '</th>';
    $data .= '</tr>';

    $data .= '<tr>';
    $data .= '<th style="font-sixe:24px;">(Loss) Tax Expenses</th>';
    $data .= '<th style="font-sixe:24px;">' . $tax->sum('amount') . '</th>';
    $data .= '</tr>';

    $data .= '<tr>';
    $data .= '<th style="font-sixe:24px;">Net Profit (loos)</th>';
    $npl = $plbt - $tax->sum('amount');
    $data .= '<th style="font-sixe:24px;">' . $npl . '</th>';
    $data .= '</tr>';

    $data .= '</thead>';
    $data .= '</table>';




    return $data;

  }

  public function reporting()
  {
    return view('dashboard.reporting');
  }

  public function chart_of_accounts_show()
  {
    $data = "";
    return view('dashboard.chart_of_account', compact('data'));
  }

  public function chart_of_accounts_find(Request $request)
  {
    $data = "1";
    $fDate = $request->fromDate;
    $tDate = $request->toDate;
    $f_data = explode('-', $request->fromDate);
    $f_year = $f_data[0];
    $f_month = $f_data[1];
    $t_data = explode('-', $request->toDate);
    $t_year = $t_data[0];
    $t_month = $t_data[1];

    $currencies = Currency::all();
    $bankers = BankAccount::count();
    $customers = Customer::count();
    $employees = Employee::all();
    $suppliers = Supplier::count();
    $currencies = Currency::all();
    $sale = CustomerBill::all();
    $received = CustomerRecieved::all();
    $purchase = SupplierBill::all();
    $payment = SupplierPayment::all();
    $cash = CashJournal::all();
    $expense = ExpenseJournal::all();
    $bank = BankJournal::all();
    $employee_salaries = EmployeeSalaries::all();
    $employee_overtimes = EmployeeOverTime::all();
    $employee_advance = EmployeeAdvance::all();
    $customer_advance = CustomerAdvance::all();
    $investors = InvestorAccount::all();
    $investor_journal = InvestorJournal::all();
    $debitors = DebitorAccount::count();
    $assets = CompanyAsset::all();
    $taxes = Tex::all();

    return view('dashboard.chart_of_account', compact(
      'currencies',
      'sale',
      'received',
      'purchase',
      'payment',
      'cash',
      'bank',
      'expense',
      'customers',
      'employees',
      'bankers',
      'suppliers',
      'employee_salaries',
      'employee_overtimes',
      'employee_advance',
      'investors',
      'investor_journal',
      'debitors',
      'assets',
      'taxes',
      'fDate',
      'tDate',
      'data'
    ));
  }

  public function coa_asset_ar()
  {
    $customers = Customer::all();
    $sale = CustomerBill::all();
    $received = CustomerRecieved::all();
    $advances = CustomerAdvance::all();
    $currencies = Currency::all();
    return view('dashboard.coa_asset_ar', compact('customers', 'sale', 'received', 'currencies', 'advances'));
  }

  public function coa_asset_emp_advance($date)
  {
    $date;
    $date_array = explode('d', $date);
    $from = $date_array[0];
    $to = $date_array[1];
    $employees = Employee::all();
    $emloyees_advance = EmployeeAdvance::whereBetween('date', [$from, $to])->get();
    return view('dashboard.coa_asset_emp_advance', compact('employees', 'emloyees_advance'));
  }

  public function coa_asset_cash()
  {
    $cash_types = CashType::all();
    $cash = CashJournal::all();
    $currencies = Currency::all();
    return view('dashboard.coa_asset_cash', compact('cash_types', 'cash', 'currencies'));
  }

  public function coa_asset_long_term()
  {
    $types = assetAccounts::all();
    $assets = CompanyAsset::all();
    $currencies = Currency::all();
    return view('dashboard.coa_asset_long-term', compact('types', 'assets', 'currencies'));
  }



  public function coa_asset_bank()
  {
    $banks = BankAccount::all();
    $currencies = Currency::all();
    $journal = BankJournal::all();
    return view('dashboard.coa_asset_bank', compact('banks', 'currencies', 'journal'));
  }

  public function coa_liabilities_ap()
  {
    $suppliers = Supplier::all();
    $currencies = Currency::all();
    $purchase = SupplierBill::all();
    $payment = SupplierPayment::all();
    $advances = SupplierAdvance::all();
    return view('dashboard.coa_liabilities_ap', compact('suppliers', 'currencies', 'purchase', 'advances', 'payment'));

  }

  public function coa_liabilities_emp_salary($date)
  {
    $date;
    $date_array = explode('d', $date);
    $from = $date_array[0];
    $to = $date_array[1];
    $employees = Employee::all();
    $emloyees_advance = EmployeeAdvance::whereBetween('date', [$from, $to])->get();
    $overtime = EmployeeOverTime::whereBetween('date', [$from, $to])->get();
    return view('dashboard.coa_asset_emp_advance', compact('employees', 'emloyees_advance'));
  }




  // start work of vouchers
  public function market_outstanding_ar()
  {
    $customers = Customer::all();
    $sale = CustomerBill::all();
    $received = CustomerRecieved::all();
    $advances = CustomerAdvance::all();
    $currencies = Currency::all();
    return view('market-outstanding.ar', compact('customers', 'sale', 'received', 'currencies', 'advances'));
  }

  public function market_outstanding_ap()
  {
    $suppliers = Supplier::all();
    $currencies = Currency::all();
    $purchase = SupplierBill::all();
    $payment = SupplierPayment::all();
    $advances = SupplierAdvance::all();
    return view('market-outstanding.ap', compact('suppliers', 'currencies', 'purchase', 'advances', 'payment'));
  }

  public function market_outstanding_cash(){
    $cash_types = CashType::all();
    $cash = CashJournal::all();
    $currencies = Currency::all();
    return view('market-outstanding.cash', compact('cash_types', 'cash', 'currencies'));
  }

  public function market_outstanding_expense_show(){
    $page="date";
    $types=ExpenseType::all();
    $expense=ExpenseJournal::all();
    $currencies=Currency::all();
    return view('market-outstanding.expense',compact('types','expense','currencies','page'));
  }

  public function market_outstanding_expense_find(Request $request){
    $page="";
    $types=ExpenseType::all();
    $expense=ExpenseJournal::whereBetween('date',[$request->fromDate,$request->toDate])->get();
    $currencies=Currency::all();
    return view('market-outstanding.expense',compact('types','expense','currencies','page'));
  }

  public function market_outstanding_bank_show(){
    $page="date";
    $bankers=BankAccount::all();
    $journal=ExpenseJournal::all();
    $currencies=Currency::all();
    return view('market-outstanding.bank',compact('bankers','journal','currencies','page'));
  }

  public function market_outstanding_bank_find(Request $request){
    $page="";
    $bankers=BankAccount::all();
    $journal=ExpenseJournal::whereBetween('date',[$request->fromDate,$request->toDate])->get();
    $currencies=Currency::all();
    return view('market-outstanding.bank',compact('bankers','journal','currencies','page'));
  }

}
