<?php

namespace App\Http\Controllers\Project;

use App\Http\Controllers\Controller;
use App\Models\DonerAndPartner;
use App\Models\EmployeeAdvance;
use App\Models\EmployeeOverTime;
use App\Models\ExpenseJournal;
use Illuminate\Http\Request;
use App\Models\Project;
use App\Models\Currency;
use App\Models\SupplierBill;
use App\Models\Archive;
use App\Models\SupplierPayment;
use App\Models\PurchaseStock;
use App\Models\ProcessRowStock;
use App\Models\EmployeeSalaries;

class ProjectController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Project::orderBy('id', 'desc')->paginate(10);
        return view('projects.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $donners = DonerAndPartner::all();
        $currency = Currency::All();
        return view('projects.create', compact('donners', 'currency'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            's_date' => 'required',
            'e_date' => 'required',
            'deadline' => 'required',
        ]);
        $data = new Project();
        $data->name = $request->name;
        $data->start_date = $request->s_date;
        $data->end_date = $request->e_date;
        $data->deadline = $request->deadline;
        $data->location = $request->location;
        $data->code = $request->code;
        $data->donners = $request->donner_id;
        $data->approved_budget = $request->approved_budget;
        $data->estimation_budget = $request->estimation_budget;
        $data->currency = $request->currency_id;
        $data->type = $request->type_id;
        $data->status = $request->status;
        $data->details = $request->details;
        $date = date("Y-m-d");
        if (request()->hasFile('attachment')) {
            $filename = 'projects-' . time() . '-' . request()->file('attachment')->getClientOriginalName();
            $path = request()->file('attachment')->storeAs('projects/' . $date . '/', $filename, 'public');
        } else {
            $path = "projects/noimage.jpg";
        }
        $data->attachments = $path;
        $data->save();
        session()->flash("msg", "Success!");
        return redirect()->route('projects.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = Project::find($id);
        $currencies = Currency::all();
        $purchase = SupplierBill::where('project_id', $id)->get();
        $payment = SupplierPayment::where('project_id', $id)->get();
        $stock = PurchaseStock::where('project_id', $id)->get();
        $use_stock = ProcessRowStock::where('project_id', $id)->get();
        $expencies = ExpenseJournal::where('status', 2)->get();
        return view('projects.show', compact('data', 'currencies', 'purchase', 'payment', 'stock', 'use_stock', 'expencies'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $donners = DonerAndPartner::all();
        $currency = Currency::All();
        $data = Project::find($id);
        return view('projects.edit', compact('donners', 'currency', 'data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            's_date' => 'required',
            'e_date' => 'required',
            'deadline' => 'required',
        ]);
        $data = Project::find($id);
        $data->name = $request->name;
        $data->start_date = $request->s_date;
        $data->end_date = $request->e_date;
        $data->deadline = $request->deadline;
        $data->location = $request->location;
        $data->code = $request->code;
        $data->donners = $request->donner_id;
        $data->approved_budget = $request->approved_budget;
        $data->estimation_budget = $request->estimation_budget;
        $data->currency = $request->currency_id;
        $data->type = $request->type_id;
        $data->status = $request->status;
        $data->details = $request->details;
        $date = date("Y-m-d");
        if (request()->hasFile('attachment')) {
            $filename = 'projects-' . time() . '-' . request()->file('attachment')->getClientOriginalName();
            $path = request()->file('attachment')->storeAs('projects/' . $date . '/', $filename, 'public');
        } else {
            $path = $data->attachments;
        }
        $data->attachments = $path;
        $data->save();
        session()->flash("msg", "Success!");
        return redirect()->route('projects.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function project_archive($id)
    {
        $data = Archive::orderBy('id', 'desc')->where('project_id', $id)->paginate(20);
        return view('archive.r_project', compact('data'));
    }

    public function project_purchase($id)
    {
        $bills = supplierBill::orderBy('id', 'desc')->where('project_id', $id)->paginate(10);
        return view('purchase.bills.r_projec', compact('bills'));
    }

    public function project_payment($id)
    {
        $payments = SupplierPayment::orderBy('id', 'desc')->where('project_id', $id)->paginate(10);
        return view('purchase.payments.r_project', compact('payments'));
    }

    public function project_stock($id)
    {
        $stock = PurchaseStock::orderBy('id', 'desc')->where('project_id', $id)->paginate(10);
        return view('stock.rowStock.r_project', compact('stock'));
    }

    public function project_distribution($id)
    {
        $stock = ProcessRowStock::orderBy('id', 'desc')->where('project_id', $id)->paginate(10);
        return view('stock.row_stock_process.r_project', compact('stock'));
    }

    public function project_expences($id)
    {
        $expenseJournal = ExpenseJournal::orderBy('id', 'desc')->where('project_id', $id)->paginate(10);
        return view('journals.expense.r_project', compact('expenseJournal'));
    }

    public function project_stuff_salaries($id)
    {
        $salaries = EmployeeSalaries::orderBy('id', 'desc')->paginate(20);
        return view('HR.salaries.r_project', compact('salaries'));
    }

    public function project_report($id)
    {
        $data = Project::find($id);
        $currencies = Currency::all();
        $purchase = SupplierBill::where('project_id', $id)->get();
        $payment = SupplierPayment::where('project_id', $id)->get();
        $stock = PurchaseStock::where('project_id', $id)->get();
        $use_stock = ProcessRowStock::where('project_id', $id)->get();
        $expencies = ExpenseJournal::where('project_id', $id)->get();
        $salaries = EmployeeSalaries::where('project_id', $id)->get();
        $overtimes = EmployeeOverTime::where('project_id', $id)->get();
        $advances = EmployeeAdvance::where('project_id', $id)->get();
        $currencies = Currency::all();
        return view('projects.details-report', compact('data', 'currencies', 'purchase', 'payment', 'stock', 'use_stock', 'expencies', 'salaries', 'overtimes', 'advances'));

    }

    public function filter_find(Request $request)
    {
        if ($request->type_id == 1) {
            $data = Project::where('name', 'like', '%' . $request->name . '%')->paginate(20);
        }
        if ($request->type_id == 2) {
            $data = Project::where('code', 'like', '%' . $request->code . '%')->paginate(20);
        }

        return view('projects.index', compact('data'));
    }

    public function report_show()
    {
        return view('projects.report');
    }

    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $project_id = $request->project_id;
        $data = "";
        $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
        $data .= "<h6 style='text-align:center;'>All Projects</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
        $data .= "<h6 style='text-align:center;'>Report</h6>";
        $data .= '<table class="" id="table_style">';
        $data .= '<tr>';
        $data .= '<th>Name</th>';
        $data .= '<th>Start Date</th>';
        $data .= '<th>End Date</th>';
        $data .= '<th>Deadline</th>';
        $data .= '<th>Budget</th>';
        $data .= '</tr>';
        $data .= '<tbody>';
        $i = 1;
        $record = Project::whereBetween('start_date', [$fDate, $tDate])->get();
        foreach ($record as $row) {
            $data .= "<tr>";
            $data .= "<td>" . $i . "</td>";
            $data .= "<td>" . $row->name . "</td>";
            $data .= "<td>" . $row->code . "</td>";
            $data .= "<td>" . $row->start_date . "</td>";
            $data .= "<td>" . $row->end_date . "</td>";
            $data .= "<td>" . $row->deadline . "</td>";
            $data .= "<td>" . $row->budget . "</td>";
            $data .= "</tr>";
            $i++;
        }
        if ($i == 1) {
            $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
        }
        $data .= "</tbody>";
        $data .= '</table>';
        $data .= '</table>';
        return $data;
    }

}
