<?php

namespace App\Http\Controllers\PurchaseAdministration;

use App\Http\Controllers\Controller;
use App\Models\PCategory;
use App\Models\PUnit;
use App\Models\Supplier;
use App\Models\SupplierBill;
use App\Models\SupplierBillItem;
use App\Models\Currency;
use App\Models\SupplierPayment;
use App\Models\PurchaseStock;
use App\Models\CashJournal;
use App\Models\Info;

// its for when this application is used for tread 
use App\Models\PurchaseBillItem;
use App\Models\Scategory;
use App\Models\SSubCategory;
use App\Models\SUnit;
use App\Models\SWeight;
use App\Models\Stock;
use App\Models\StockLocation;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SupplierBillController extends Controller
{
    public function index($id)
    {

        $supplier = Supplier::find($id);
        $bills = SupplierBill::where('supplier_id', $id)->orderBy('id', 'desc')->paginate();
        $currencies = Currency::all();
        return view('purchase.suppliers.bills.index', compact('supplier', 'bills', 'currencies'));
    }
    public function create($id)
    {
        $supplier = Supplier::find($id);
        $currencies = Currency::all();
        $invoice_number = SupplierBill::orderBy('id', 'desc')->get()->first();
        $number = "";
        // if ($invoice_number == "") {
        //     $number = $invoice_number = 1;
        // } else {
        //     $number = $invoice_number->invoice_number + 1;
        // }
        return view('purchase.suppliers.bills.bill-create', compact('supplier', 'currencies', 'number'));
    }
    public function store(Request $request)
    {
        $request->validate([
            'date' => 'required',
            'supplier_id' => 'required',
            'invoice_number' => 'required',
            'currency_id' => 'required',
        ]);
        $bill = new SupplierBill();
        $bill->supplier_id = $request->supplier_id;
        $bill->type_id = $request->type_id;
        $bill->invoice_date = $request->date;
        $bill->invoice_number = $request->invoice_number;
        $bill->title = $request->title;
        $bill->currency_id = $request->currency_id;
        $bill->ex_rate = $request->ex_rate;
        $bill->status = 0;
        $date = date("Y-m-d");
        if (request()->hasFile('bill_files')) {
            $filename = 'bill_files-' . time() . '-' . request()->file('bill_files')->getClientOriginalName();
            $path = request()->file('bill_files')->storeAs('supplier_bill_files/' . $date . '/', $filename, 'public');
        } else {
            $path = "bill_files/noimage.jpg";
        }
        $bill->invoice_file = $path;
        $bill->save();
        if ($bill) {
            return redirect()->route('supplier_bill.create_next', $bill->id);
        }
    }
    public function create_next($id)
    {
        $bill = SupplierBill::find($id);
        $bill_id = $bill->id;
        $supplier_id = $bill->supplier_id;
        $supplier = Supplier::find($bill->supplier_id);
        $categories = PCategory::all();
        $units = PUnit::all();
        $bill_items = SupplierBillItem::where('bill_id', $bill_id)->get();
        $bussiness_check = Info::find('1');
        if ($bill->type_id == 1 || $bill->type_id == null) {
            return view('purchase.suppliers.bills.bill-create-next', compact('supplier', 'categories', 'units', 'bill_id', 'supplier_id', 'bill', 'bill_items'));
        } else {
            $categories = Scategory::all();
            $subcategories = SSubCategory::all();
            $units = SUnit::all();
            $weights = SWeight::all();
            $bill_items = PurchaseBillItem::where('bill_id', $bill_id)->get();
            $location = StockLocation::all();
            return view('purchase.suppliers.bills.tread.bill-create-next', compact('supplier', 'categories', 'weights', 'units', 'bill_id', 'bill_items', 'location'));
        }
    }
    public function store_item(Request $request)
    {
        $request->validate([
            'cat_id' => 'required',
            'unit_id' => 'required',
            'spi' => 'required',
            'cpi' => 'required',
            'qty' => 'required',
        ]);
        $items = new SupplierBillItem();
        $items->bill_id = $request->bill_id;
        $items->cat_id = $request->cat_id;
        $items->scat_id = $request->scat_id;
        $items->unit_id = $request->unit_id;
        $items->qty = $request->qty;
        $items->cpi = $request->cpi;
        $items->spi = $request->spi;
        $items->user_id = Auth::user()->id;
        $items->total = $request->cpi * $request->qty;
        $items->date = date('Y-m-d');
        $items->save();
        $bill = SupplierBill::find($request->bill_id);
        if ($items) {
            $find_stock_value = PurchaseStock::where('cat_id', $items->cat_id)
                ->where('scat_id', $items->scat_id)
                ->where('unit_id', $items->unit_id)
                ->count();
            if ($find_stock_value == 0) {
                $stock = new PurchaseStock();
                $stock->cat_id = $items->cat_id;
                $stock->scat_id = $items->scat_id;
                $stock->unit_id = $items->unit_id;
                $stock->qty = $items->qty;
                $stock->cpi = $items->cpi;
                $stock->spi = $items->spi;
                $stock->currency_id = $bill->currency_id;
                $stock->date = date('Y-m-d');
                $stock->user_id = Auth::user()->id;
                $save = $stock->save();

            } else {
                $stock = PurchaseStock::where('cat_id', $items->cat_id)
                    ->where('scat_id', $items->scat_id)
                    ->where('unit_id', $items->unit_id)
                    ->get()->first();
                $stock = PurchaseStock::find($stock->id);
                $qty = $stock->qty + $items->qty;
                $stock->qty = $qty;
                $save = $stock->save();

            }
            session()->flash("msg", "Success");
            return back();
        }
    }
    public function item_delete($id)
    {
        $item = SupplierBillItem::find($id);
        $find_stock_value = PurchaseStock::where('cat_id', $item->cat_id)
            ->where('unit_id', $item->unit_id)->get()->first();
        if ($find_stock_value != "") {
            $s_qty = $find_stock_value->qty;
            $qty = $s_qty - $item->qty;
            $find_stock_value->qty = $qty;
            $find_stock_value->save();
        }

        $item->delete();
        session()->flash("msg", "Success!");
        return back();

    }
    // purchase for shop
    public function pstore_item(Request $request)
    {
        $request->validate([
            'cat_id' => 'required',
            'sub_cat_id' => 'required',
            'unit_id' => 'required',
            'weight_id' => 'required',
            'price' => 'required',
            'qty' => 'required',
        ]);

        $items = new PurchaseBillItem();
        $items->bill_id = $request->bill_id;
        $items->supplier_id = $request->supplier_id;
        $items->location_id = $request->location_id;
        $items->cat_id = $request->cat_id;
        $items->sub_cat_id = $request->sub_cat_id;
        $items->unit_id = $request->unit_id;
        $items->weight_id = $request->weight_id;
        $items->spi = $request->spi;
        $items->qty = $request->qty;
        $items->price = $request->price;
        $items->total = $request->price * $request->qty;
        $save = $items->save();
        if ($save) {
            $find_stock_value = Stock::where('cat_id', $items->cat_id)
                ->where('sub_cat_id', $items->sub_cat_id)
                ->where('unit_id', $items->unit_id)
                ->where('weight_id', $items->weight_id)->count();
            if ($find_stock_value == 0) {
                $stock = new Stock();
                $stock->cat_id = $items->cat_id;
                $stock->sub_cat_id = $items->sub_cat_id;
                $stock->unit_id = $items->unit_id;
                $stock->weight_id = $items->weight_id;
                $stock->location_id = $items->location_id;
                $stock->qty = $items->qty;
                $stock->cpi = $items->price;
                $stock->spi = $items->spi;
                $stock->date = date('Y-m-d');
                $stock->user_id = Auth::user()->id;
                $save = $stock->save();
            } else {
                $stock = Stock::where('cat_id', $items->cat_id)
                    ->where('sub_cat_id', $items->sub_cat_id)
                    ->where('unit_id', $items->unit_id)
                    ->where('weight_id', $items->weight_id)->get()->first();
                $stock = Stock::find($stock->id);
                $qty = $stock->qty + $items->qty;
                $stock->qty = $qty;
                $save = $stock->save();
            }
            session()->flash("msg", "Success!");
            return back();
        }
    }
    public function pitem_delete($id)
    {
        $item = PurchaseBillItem::find($id);
        $find_stock_value = Stock::where('cat_id', $item->cat_id)
            ->where('sub_cat_id', $item->sub_cat_id)
            ->where('unit_id', $item->unit_id)
            ->where('weight_id', $item->weight_id)
            ->get()
            ->first();
        if ($find_stock_value != "") {
            $s_qty = $find_stock_value->qty;
            $qty = $s_qty - $item->qty;
            $find_stock_value->qty = $qty;
            $find_stock_value->save();
        }

        $item->delete();
        session()->flash("msg", "Success!");
        return back();

    }
    public function next_store(Request $request)
    {
        $request->validate([
            'grand_total' => 'required',
            'payment' => 'required',
        ]);
        $bill = SupplierBill::find($request->bill_id);
        $bill->grand_total = $request->grand_total;
        $bill->payment = $request->payment;
        if ($request->balance_value == "" || $request->balance_value == 0) {
            $bill->balance = $request->grand_total;
        } else {
            $bill->balance = $request->balance_value;
        }
        $bill->payment_by = $request->payment_by;
        $bill->transaction_id = $request->transaction_id;
        $bill->save();

        if ($bill) {
            if ($request->payment != 0) {
                $payment = new SupplierPayment();
                $payment->supplier_id = $bill->supplier_id;
                $payment->currency_id = $bill->currency_id;
                $payment->invoice_number = $bill->invoice_number;
                $payment->bill_id = $bill->id;
                $payment->title = "Payment is Added From Invoice Number  " . $bill->invoice_number;
                $payment->amount = $request->payment;
                $payment->date = $bill->invoice_date;
                $payment->ex_rate = $bill->ex_rate;
                $payment->load_from_bill = 1;
                $payment->details = "Payment is Added From Invoice Number  " . $bill->invoice_number;
                $payment->save();
            }
          
            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = $bill->title . " Invoice" . $bill->invoice_number;
                $cash->date = $bill->invoice_date;
                $cash->outgoing = $bill->payment;
                $cash->currency_id = $bill->currency_id;
                $cash->module_id = 21;
                $cash->type_id = 21;
                $cash->module_record_id = $bill->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Target cash From Purchase";
                $cash->save();
            }

        }
        session()->flash("msg", "Success!");
        return redirect()->route('supplier_bill.index', $bill->supplier_id);
    }
    public function edit($id)
    {
        $bill = SupplierBill::find($id);
        $bill_id = $bill->id;
        $supplier_id = $bill->supplier_id;
        $bill_items = SupplierBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
        $supplier = Supplier::find($bill->supplier_id);
        $categories = PCategory::all();
        $units = PUnit::all();
        $currencies = Currency::all();
        $bussiness_check = Info::find('1');
        if ($bill->type_id == 1 || $bill->type_id == null) {
            return view('purchase.suppliers.bills.edit', compact('bill', 'bill_items', 'supplier', 'categories', 'units', 'currencies', 'bill_id', 'supplier_id'));
        } else {
            $bill_items = PurchaseBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
            $categories = Scategory::all();
            $subcategories = SSubCategory::all();
            $units = SUnit::all();
            $weights = SWeight::all();
            $currencies = Currency::all();
            $location = StockLocation::all();
            return view('purchase.suppliers.bills.tread.edit', compact('bill', 'bill_items', 'supplier', 'categories', 'units', 'weights', 'currencies', 'bill_id', 'supplier_id', 'location'));
        }

    }
    public function update(Request $request, $id)
    {
        $request->validate([
            'grand_total' => 'required',
            'payment' => 'required',
        ]);
        $bill = SupplierBill::find($id);
        $bill->supplier_id = $request->supplier_id;
        $bill->invoice_date = $request->date;
        $bill->invoice_number = $request->invoice_number;
        $bill->title = $request->title;
        $bill->currency_id = $request->currency_id;
        $bill->ex_rate = $request->ex_rate;
        $bill->status = 0;
        $date = date("Y-m-d");
        if (request()->hasFile('bill_files')) {
            $filename = 'bill_files-' . time() . '-' . request()->file('bill_files')->getClientOriginalName();
            $path = request()->file('bill_files')->storeAs('supplier_bill_files/' . $date . '/', $filename, 'public');
        } else {
            $path = "bill_files/noimage.jpg";
        }
        $bill->invoice_file = $path;
        $bill->grand_total = $request->grand_total;
        $bill->payment = $request->payment;
        if ($request->balance_value == "" || $request->balance_value == 0) {
            $bill->balance = $request->grand_total;
        } else {
            $bill->balance = $request->balance_value;
        }
        $bill->payment_by = $request->payment_by;
        $bill->transaction_id = $request->transaction_id;
        $bill->save();
        if ($bill) {
            $payment_in_payment_table = SupplierPayment::where('supplier_id', $bill->supplier_id)->where('bill_id', $bill->id)->first();
            if ($payment_in_payment_table != null) {
                SupplierPayment::where('supplier_id', $bill->supplier_id)->where('bill_id', $bill->id)->delete();
                if ($request->payment != 0) {
                    $payment = new SupplierPayment();
                    $payment->supplier_id = $bill->supplier_id;
                    $payment->currency_id = $bill->currency_id;
                    $payment->ex_rate = $bill->ex_rate;
                    $payment->bill_id = $bill->id;
                    $payment->title = "Payment is Added From Invoice Number  " . $bill->invoice_number;
                    $payment->amount = $request->payment;
                    $payment->invoice_number = $request->invoice_number;
                    $payment->date = $bill->date;
                    $payment->details = "Payment is Added From Invoice Number  " . $bill->invoice_number;
                    $payment->save();
                }
            } else {
                if ($request->payment != 0) {
                    $payment = new SupplierPayment();
                    $payment->supplier_id = $bill->supplier_id;
                    $payment->currency_id = $bill->currency_id;
                    $payment->ex_rate = $bill->ex_rate;
                    $payment->bill_id = $bill->id;
                    $payment->title = "Payment is Added From Invoice Number  " . $bill->invoice_number;
                    $payment->amount = $request->payment;
                    $payment->invoice_number = $request->invoice_number;
                    $payment->date = $bill->date;
                    $payment->details = "Payment is Added From Invoice Number  " . $bill->invoice_number;
                    $payment->save();
                }
            }
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 21)->where('module_record_id', $bill->id)->first();
                if ($cash != null) {
                    $cash->title = $bill->title . " Invoice" . $bill->invoice_number;
                    $cash->date = $bill->invoice_date;
                    $cash->outgoing = $bill->payment;
                    $cash->currency_id = $bill->currency_id;
                    $cash->module_id = 21;
                    $cash->type_id = 21;
                    $cash->module_record_id = $bill->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Target cash From Purchase";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $bill->title . " Invoice" . $bill->invoice_number;
                    $cash->date = $bill->invoice_date;
                    $cash->outgoing = $bill->payment;
                    $cash->currency_id = $bill->currency_id;
                    $cash->module_id = 21;
                    $cash->type_id = 21;
                    $cash->module_record_id = $bill->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Target cash From Purchase";
                    $cash->save();
                }
            } else {
                $cash = CashJournal::where('module_id', 21)->where('module_record_id', $bill->id)->delete();

            }


        }
        session()->flash("msg", "Success Updaded!");
        return redirect()->route('supplier_bill.index', $bill->supplier_id);
    }
    public function show($id)
    {
        $bill = SupplierBill::find($id);
        $bill_items = SupplierBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
        $supplier = Supplier::find($bill->supplier_id);
        if ($bill->type_id == 1 || $bill->type_id == null) {
            return view('purchase.suppliers.bills.show', compact('bill', 'bill_items', 'supplier'));
        } else {
            $bill_items = PurchaseBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
            return view('purchase.suppliers.bills.tread.show', compact('bill', 'bill_items'));
        }
    }
    public function delete($id)
    {
        $row_material_items = SupplierBillItem::where('bill_id', $id)->get();
        $fineish_good_items = PurchaseBillItem::where('bill_id', $id)->get();

        $bill = SupplierBill::find($id);
        if ($bill->type_id == 1) {
            if ($row_material_items->count() != 0) {
                foreach ($row_material_items as $item) {
                    $find_related_stock = PurchaseStock::where('cat_id', $item->cat_id)
                        ->where('scat_id', $item->scat_id)
                        ->where('unit_id', $item->unit_id)
                        ->first();
                    if ($find_related_stock != "") {
                        $quantity = $find_related_stock->qty;
                        $quantity = $quantity - $item->qty;
                        $find_related_stock->qty = $quantity;
                        $find_related_stock->save();
                    }
                }
                SupplierBillItem::where('bill_id', $id)->delete();
            }
        } else {
            if ($fineish_good_items->count() != 0) {
                foreach ($fineish_good_items as $item) {
                    $find_related_stock = Stock::where('cat_id', $item->cat_id)
                        ->where('cat_id', $item->cat_id)
                        ->where('sub_cat_id', $item->sub_cat_id)
                        ->where('unit_id', $item->unit_id)
                        ->where('weight_id', $item->weight_id)
                        ->first();
                    if ($find_related_stock != "") {
                        $quantity = $find_related_stock->qty;
                        $quantity = $quantity - $item->qty;
                        $find_related_stock->qty = $quantity;
                        $find_related_stock->save();
                    }
                }
                PurchaseBillItem::where('bill_id', $id)->delete();
            }
        }
        $bill->delete();

        session()->flash("msg", "Success Impact on Bill, Bill Items, Stock, Customer Recieved!");
        return back();

    }
    public function report_show($id)
    {
        $supplier = Supplier::find($id);
        $currencies = Currency::all();
        return view('purchase.suppliers.bills.report', compact('supplier', 'currencies'));
    }
    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $supplier_id = $request->supplier_id;
        $currency_id = $request->currency_id;
        $supplier = Supplier::find($supplier_id);
        $currency = Currency::find($currency_id);
        $currencies = Currency::all();
        $bills = SupplierBill::all();
        $data = "";
        if ($currency_id == "all") {
            $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
            $data .= "<h6 style='text-align:center;'>Purchase Invoices Report</h6>";
            $data .= "<h6 style='text-align:center;'>$supplier->name</h6>";
            $data .= "<p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
            $data .= "<p style='text-align:center;'>Print Date " . date('Y-M-d') . "</p>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>#</th>';
            $data .= '<th>Invoice Number</th>';
            $data .= '<th>Title</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>Total</th>';
            $data .= '<th>Payment</th>';
            $data .= '<th>Balance</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $supplier_bill = SupplierBill::whereBetween('invoice_date', [$fDate, $tDate])->orderBy('invoice_date', 'asc')->where('supplier_id', $supplier_id)->get();
            foreach ($supplier_bill as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->invoice_number . "</td>";
                $data .= "<td>" . $row->title . "</td>";
                $data .= "<td>" . $row->invoice_date . "</td>";
                $data .= "<td>" . $row->grand_total . "</td>";
                $data .= "<td>" . $row->payment . "</td>";
                $data .= "<td>" . $row->balance . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
            }

            $data .= "</tbody>";
            $data .= '</table>';
            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '<table class="">';
            $data .= ' <tr>';
            $data .= '<th colspan="21" rowspan="2"> Sub Total</th>';
            $data .= '<th colspan="' . $currencies->count() . '" class="">Grand Total </th>';
            $data .= '<th colspan="' . $currencies->count() . '" class="">Payment</th>';
            $data .= '<th colspan="' . $currencies->count() . '" class="">Balance</th>';
            $data .= ' </tr>';
            $data .= ' <tr>';
            foreach (Currency::all() as $row) {
                $grand_total = $bills->where('currency_id', $row->id)->whereBetween('invoice_date', [$fDate, $tDate])->sum('grand_total');
                $data .= '<td>' . $row->title_en . "/" . $grand_total . '</td>';
            }
            foreach (Currency::all() as $row) {
                $payment = $bills->where('currency_id', $row->id)->whereBetween('invoice_date', [$fDate, $tDate])->sum('payment');
                $data .= '<td>' . $row->title_en . "/" . $payment . '</td>';
            }
            foreach (Currency::all() as $row) {
                $grand_total = $bills->where('currency_id', $row->id)->whereBetween('invoice_date', [$fDate, $tDate])->sum('grand_total');
                $payment = $bills->where('currency_id', $row->id)->whereBetween('invoice_date', [$fDate, $tDate])->sum('payment');
                $balance = $grand_total - $payment;
                $data .= '<td>' . $row->title_en . "/" . $balance . '</td>';
            }

            $data .= '</tr>';
            $data .= '</table>';
        } else {
            $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
            $data .= "<h6 style='text-align:center;'>Purchase Invoices Report</h6>";
            $data .= "<h6 style='text-align:center;'>$supplier->name</h6>";
            $data .= "<h6 style='text-align:center;'>$currency->title_en</h6>";
            $data .= "<p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
            $data .= "<p style='text-align:center;'>Print Date " . date('Y-M-d') . "</p>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>#</th>';
            $data .= '<th>Invoice Number</th>';
            $data .= '<th>Title</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>Total</th>';
            $data .= '<th>Payment</th>';
            $data .= '<th>Balance</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $supplier_bill = SupplierBill::whereBetween('invoice_date', [$fDate, $tDate])->orderBy('invoice_date', 'asc')->where('supplier_id', $supplier_id)->where('currency_id', $currency_id)->get();
            foreach ($supplier_bill as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->invoice_number . "</td>";
                $data .= "<td>" . $row->title . "</td>";
                $data .= "<td>" . $row->invoice_date . "</td>";
                $data .= "<td>" . $row->grand_total . "</td>";
                $data .= "<td>" . $row->payment . "</td>";
                $data .= "<td>" . $row->balance . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
            }

            $data .= "<tr>";
            $data .= '<th rowspan="2">Overview</th>';
            $data .= '<th colspan="2">Total</th>';
            $data .= '<th colspan="2">Payment</th>';
            $data .= '<th colspan="21">Belance</th>';
            $data .= "</tr>";
            $data .= "<tr>";

            $data .= '<th colspan="2">' . $bills->sum('grand_total') . '</th>';
            $data .= '<th colspan="2">' . $bills->sum('payment') . '</th>';
            $balance = $bills->sum('grand_total') - $bills->sum('payment');
            $data .= '<th colspan="21">' . $balance . '</th>';

            $data .= "</tr>";


            $data .= "</tbody>";

        }

        return $data;
    }
    public function filter_find(Request $request)
    {
        $currencies = Currency::all();
        if ($request->type_id == 1) {
            $bills = SupplierBill::Where('invoice_number', $request->number)
                ->where('supplier_id', $request->supplier_id)
                ->get();
        } else if ($request->type_id == 2) {
            $bills = SupplierBill::Where('title', 'like', '%' . $request->title . '%')
                ->where('supplier_id', $request->supplier_id)
                ->get();
        } else {
            $bills = SupplierBill::whereBetween('invoice_date', [$request->f_date, $request->t_date])
                ->where('supplier_id', $request->supplier_id)
                ->get();
        }
        $supplier = Supplier::find($request->supplier_id);
        return view('purchase.suppliers.bills.filter', compact('currencies', 'bills', 'supplier'));
    }
    public function print($id)
    {
        $bill = SupplierBill::find($id);
        $bill_items = SupplierBillItem::where('bill_id', $id)->get();
        $supplier = Supplier::find($bill->supplier_id);
        return view('purchase.suppliers.bills.print-bill', compact('bill', 'bill_items', 'supplier'));

    }
}
