<?php

namespace App\Http\Controllers\PurchaseAdministration;

use App\Http\Controllers\Controller;
use App\Models\SupplierAdvance;
use Illuminate\Http\Request;
use App\Models\Supplier;
use App\Models\SupplierBill;
use App\Models\SupplierPayment;
use App\Models\Currency;

class SupplierController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $suppliers = Supplier::orderBy('id', 'desc')->paginate(10);
        return view('purchase.suppliers.index', compact('suppliers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('purchase.suppliers.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255|min:2',
            'phone' => 'required|max:255|min:2',
            'address' => 'required|max:255|min:2',
        ]);
        $supplier = new Supplier();
        $supplier->name = $request->name;
        $supplier->phone = $request->phone;
        $supplier->address = $request->address;
        $supplier->email = $request->email;
        $supplier->save();
        session()->flash("msg", "Success!");
        return redirect()->route('suppliers.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $supplier = Supplier::find($id);
        $currencies=Currency::all();
        $bills=SupplierBill::all();
        $payments=SupplierPayment::all();
        $advance=SupplierAdvance::all();
        return view('purchase.suppliers.show', compact('supplier','currencies','bills','payments','advance'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $supplier = Supplier::find($id);
        return view('purchase.suppliers.edit', compact('supplier'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|max:255|min:2',
        ]);
        $supplier = Supplier::find($id);
        $supplier->name = $request->name;
        $supplier->phone = $request->phone;
        $supplier->address = $request->address;
        $supplier->email = $request->email;
        $supplier->save();
        session()->flash("msg", "supplier Has Been Edited successfully!");
        return redirect()->route('suppliers.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function report_show()
    {
        $suppliers = Supplier::all();
        return view('purchase.suppliers.report', compact('suppliers'));
    }

    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $supplier_id = $request->supplier_id;
        $supplier = Supplier::find($request->supplier_id);
        $type_id = $request->type_id;
        $data = "";
        if($type_id==4){
            $suppliers = Supplier::all();
            $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center;'>All Supplier List</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
            $data .= '<table class="" id="table_style" style="margin-top:10px;">';
            $data .= '<tr>';
            $data .= '<th>#</th>';
            $data .= '<th>Name</th>';
            $data .= '<th>Address</th>';
            $data .= '<th>Phone</th>';
            $data .= '<th>Email</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            foreach ($suppliers as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->name . "</td>";
                $data .= "<td>" . $row->address . "</td>";
                $data .= "<td>" . $row->phone . "</td>";
                $data .= "<td>" . $row->email . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
            }
            $data .= "</tbody>";
            $data .= '</table>';
        }
        if ($request->supplier_id == "all") {
            //   purchase bill report
            if ($type_id == 1) {
                $bills = SupplierBill::whereBetween('invoice_date', [$fDate, $tDate])->get();
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>All Supplier Purchase Report</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>Containe Only Bill Amount</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:10px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Supplier</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->supplier->name . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->grand_total . " " . $row->currency->title_en . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= ' <tr>';
                $data .= '<th colspan="2">Total</th>';
                foreach (Currency::all() as $row) {
                    $grand_total = SupplierBill::where('currency_id', $row->id)->whereBetween('invoice_date', [$fDate, $tDate])->sum('grand_total');
                    $data .= '<th style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $grand_total . '</th>';
                }
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';
            }
            //  payment report
            if ($type_id == 2) {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>All  Payment Report</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>Containe Only Payment Amount</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:10px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Supplier</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>payment</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $payments = SupplierPayment::whereBetween('date', [$fDate, $tDate])->get();
                foreach ($payments as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->supplier->name . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->payment . " " . $row->currency->title_en . " </td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= ' <tr>';
                $data .= '<th colspan="">Total</th>';
                foreach (Currency::all() as $row) {
                    $payment = SupplierPayment::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                  
                    $data .= '<th style="color:#fff; background-color:#000; border:solid 1px #fff;">' . $row->title_en . "/" . $payment . '</th>';
                }
                $data .= ' </tr>';
                $data .= ' </tbody>';
                $data .= ' </table>';
            }
            //  balances
            if ($type_id == 3) {

                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>All Supplier Balance Sheet</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= '<table class="" id="table_style" style="margin-top:10px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Supplier</th>';
                $data .= '<th>T-Purchse</th>';
                $data .= '<th>T-Payment</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach (Supplier::all() as $supplier) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $supplier->name . "</td>";
                    $data .= "<td>";
                    foreach (Currency::all() as $currency) {
                        $data .= SupplierBill::whereBetween('invoice_date', [$fDate, $tDate])->where('supplier_id', $supplier->id)->where('currency_id', $currency->id)->sum('grand_total') . "  " . $currency->title_en . "<br>";
                    }
                    $data .= "</td>";
                    $data .= "<td>";
                    foreach (Currency::all() as $currency) {
                        $data .= SupplierPayment::whereBetween('date', [$fDate, $tDate])->where('supplier_id', $supplier->id)->where('currency_id', $currency->id)->sum('amount') . "  " . $currency->title_en . "<br>";
                    }
                    $data .= "</td>";
                    $data .= "<td>";
                    foreach (Currency::all() as $currency) {
                        $bill = SupplierBill::whereBetween('invoice_date', [$fDate, $tDate])->where('supplier_id', $supplier->id)->where('currency_id', $currency->id)->sum('grand_total');
                        $payment = SupplierPayment::whereBetween('date', [$fDate, $tDate])->where('supplier_id', $supplier->id)->where('currency_id', $currency->id)->sum('amount');
                        $balance = $bill - $payment;
                        $data .= $balance . " " . $currency->title_en . "<br>";
                    }
                    $data .= "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= ' <tr>';
                $data .= '<th colspan="">Purchase</th>';
                foreach (Currency::all() as $row) {
                    $bill = SupplierBill::whereBetween('invoice_date', [$fDate, $tDate])->where('currency_id', $row->id)->sum('grand_total');
                    $data .= '<th style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $bill . '</th>';
                }
                $data .= ' </tr>';

                $data .= ' <tr>';
                $data .= '<th colspan="">Payment</th>';
                foreach (Currency::all() as $row) {
                    $payment = SupplierPayment::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                    $data .= '<th style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $payment . '</th>';
                }
                $data .= ' </tr>';

                $data .= ' <tr>';
                $data .= '<th colspan="">Balance</th>';
                foreach (Currency::all() as $row) {
                    $bill = SupplierBill::whereBetween('invoice_date', [$fDate, $tDate])->where('currency_id', $row->id)->sum('grand_total');
                    $payment = SupplierPayment::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                    $balance = $bill - $payment;
                    $data .= '<th style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $balance . '</th>';
                }
                $data .= ' </tr>';
                $data .= ' </tbody>';
                $data .= ' </table>';
            }
        } 
        else {
            if ($type_id == 1) {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'> Purchase Report</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h4 style='text-align:center;'>$supplier->name</h4>";
                $data .= '<table class="" id="table_style" >';
                $data .= '<tr>';
                $data .= '<th>Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Invoice Number</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $bills = SupplierBill::whereBetween('invoice_date', [$fDate, $tDate])->where('supplier_id', $request->supplier_id)->get();
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . " " . $row->currency->title_en . "</td>";
                    $data .= "<td>" . $row->payment ." ".$row->currency->title_en. "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= ' <tr>';
                $data .= '<th colspan="1" rowspan="2">Total</th>';
                foreach (Currency::all() as $row) {
                    $grand_total = SupplierBill::where('currency_id', $row->id)->whereBetween('invoice_date', [$fDate, $tDate])->where('supplier_id', $request->supplier_id)->sum('grand_total');
                    $data .= '<th style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $grand_total . '</th>';
                }
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';
            }
            if ($type_id == 2) {
                $payments = SupplierPayment::whereBetween('date', [$fDate, $tDate])->where('supplier_id', $request->supplier_id)->get();
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>Payment Report</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h4 style='text-align:center;'>$supplier->name</h4>";
                $data .= '<table class="" id="table_style" style="margin-top:10px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>payment</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($payments as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->payment . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= ' <tr>';
                $data .= '<th colspan="">Total</th>';
                foreach (Currency::all() as $row) {
                    $payment = SupplierPayment::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->where('supplier_id', $request->supplier_id)->sum('amount');
                    $data .= '<th  style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $payment . '</th>';
                }
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';
            }
            if ($type_id == 3) {

                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>All Supplier Balance Sheet</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= '<table class="" id="table_style" style="margin-top:10px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Supplier</th>';
                $data .= '<th>T-Purchse</th>';
                $data .= '<th>T-Payment</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                // foreach (Supplier::all() as $supplier) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $supplier->name . "</td>";
                    $data .= "<td>";
                    foreach (Currency::all() as $currency) {
                        $data .= SupplierBill::whereBetween('invoice_date', [$fDate, $tDate])->where('supplier_id', $supplier->id)->where('currency_id', $currency->id)->sum('grand_total') . "  " . $currency->title_en . "<br>";
                    }
                    $data .= "</td>";
                    $data .= "<td>";
                    foreach (Currency::all() as $currency) {
                        $data .= SupplierPayment::whereBetween('date', [$fDate, $tDate])->where('supplier_id', $supplier->id)->where('currency_id', $currency->id)->sum('amount') . "  " . $currency->title_en . "<br>";
                    }
                    $data .= "</td>";
                    $data .= "<td>";
                    foreach (Currency::all() as $currency) {
                        $bill = SupplierBill::whereBetween('invoice_date', [$fDate, $tDate])->where('supplier_id', $supplier->id)->where('currency_id', $currency->id)->sum('grand_total');
                        $payment = SupplierPayment::whereBetween('date', [$fDate, $tDate])->where('supplier_id', $supplier->id)->where('currency_id', $currency->id)->sum('amount');
                        $balance = $bill - $payment;
                        $data .= $balance . " " . $currency->title_en . "<br>";
                    }
                    $data .= "</td>";
                    $data .= "</tr>";
                 
                // }
              
               
             
              
                $data .= ' </tbody>';
                $data .= ' </table>';
            }
        }
      
        return $data;
    }

    public function filter_find(Request $request)
    {
        if ($request->type_id == 1) {
            $suppliers = Supplier::orderBy('id', 'desc')->where('name', 'like', '%' . $request->name . '%')->get();
        }
        if ($request->type_id == 2) {
            $suppliers = Supplier::orderBy('id', 'desc')->where('phone', 'like', '%' . $request->phone . '%')->get();

        }
        if ($request->type_id == 3) {
            $suppliers = Supplier::orderBy('id', 'desc')->where('address', 'like', '%' . $request->address . '%')->get();

        }
        return view('purchase.suppliers.filter', compact('suppliers'));

    }

    public function ar_pay()
    {
        $suppliers = Supplier::orderBy('created_at', 'desc')->get();
        return view('purchase.balances.AP-payment', compact('suppliers'));
    }

    public function balance_report_show()
    {
        $suppliers = Supplier::all();
        $currencies = Currency::all();
        return view('purchase.balances.balance', compact('suppliers', 'currencies'));
    }
    public function balance_report_find(Request $request)
    {
        $supplier_id = $request->supplier_id;
        $currency_id = $request->currency_id;
        $suppliers = Supplier::all();
        $currencies = Currency::all();
        $supplier = Supplier::find($supplier_id);
        $currency = Currency::find($currency_id);
        $bills = SupplierBill::all();
        $payments = SupplierPayment::all();
        $advances = SupplierAdvance::all();
        $data = "";
        if ($supplier_id == "all") {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>Pacha Paints Production Company</h6>";
                $data .= "<h6 style='text-align:center;'>All suppliers Balances</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<td rowspan="2">Name</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Bills</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Payments</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Advances</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Balance</td>';
                $data .= '</tr>';
                $data .= '<tr>';
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                $data .= '</tr>';
                $data .= '<tbody>';
                foreach ($suppliers as $supplier_row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $supplier_row->name ."<br>".$supplier_row->phone."<br>".$supplier_row->address. "</td>";
                    foreach ($currencies as $currency_row) {
                        $data .= '<td>' . $bills->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_row->id)->sum('grand_total') . '</td>';
                    }
                    foreach ($currencies as $currency_row) {
                        $data .= '<td>' . $payments->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_row->id)->sum('amount') . '</td>';
                    }
                    foreach ($currencies as $currency_row) {
                        $data .= '<td>' . $advances->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_row->id)->sum('amount') . '</td>';
                    }
                    foreach ($currencies as $currency_row) {
                        $a_total = $advances->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_row->id)->sum('amount');
                        $p_total = $payments->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_row->id)->sum('amount');
                        $total = $a_total + $p_total;
                        $bill_total = $bills->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_row->id)->sum('grand_total');
                        $balance = $bill_total - $total;
                        $data .= '<td>' . $balance . '</td>';
                    }
                }
                
                $data .= "<tr>";
                $data .= '<th rowspan="2">Subtotal</th>';
                foreach (Currency::all() as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('grand_total');
                    $data .= '<th>' . $total . '</th>';
                }
                foreach (Currency::all() as $row) {
                    $payment = $payments->where('currency_id', $row->id)->sum('amount');
                    $data .= '<th>' . $payment . '</th>';
                }
                foreach (Currency::all() as $row) {
                    $advance = $advances->where('currency_id', $row->id)->sum('amount');
                    $data .= '<th>' . $advance . '</th>';
                }
                foreach (Currency::all() as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('grand_total');
                    $payment = $payments->where('currency_id', $row->id)->sum('amount');
                    $advance = $advances->where('currency_id', $row->id)->sum('amount');
                    $ar = $payment + $advance;
                    $balance = $total - $ar;
                    $data .= '<th>' . $balance . '</th>';
                }
                $data .= "</tr>";
                $data .= '</tbody>';
                $data .= '</table>';

            } else {
                $data .= "<h6 style='text-align:center;'>Pacha Paints Production Company</h6>";
                $data .= "<h6 style='text-align:center;'>All suppliers Balances</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= "<h6 style='text-align:center;'> Currency $currency->title_en</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<td rowspan="2">Name</td>';
                $data .= '<td colspan="">Bills</td>';
                $data .= '<td colspan="">Payments</td>';
                $data .= '<td colspan="">Advances</td>';
                $data .= '<td colspan="">Balance</td>';
                $data .= '</tr>';
                $data .= '<tbody>';
                foreach ($suppliers as $supplier_row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $supplier_row->name ."<br>".$supplier_row->phone."<br>".$supplier_row->address. "</td>";
                    $data .= "<td>" . $bills->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_id)->sum('grand_total') . "</td>";
                    $data .= "<td>" . $payments->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_id)->sum('amount') . "</td>";
                    $data .= "<td>" . $advances->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_id)->sum('amount') . "</td>";
                    $data .= "<td>";
                    $p_total = $payments->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_id)->sum('amount');
                    $a_total = $advances->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_id)->sum('amount');
                    $total = $p_total + $a_total;
                    $bill_total = $bills->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_id)->sum('grand_total');
                    $balance = $bill_total - $total;
                    $data .= $balance;
                    $data .= "</td>";
                    $data .= "</tr>";
                }
                $data .= '</tbody>';
                $data .= '</table>';
            }
        } else {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>Pacha Paints Production Company</h6>";
                $data .= "<h6 style='text-align:center;'>$supplier->name Balances</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<td colspan="' . $currencies->count() . '">Bills</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Payments</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Advances</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Balance</td>';
                $data .= '</tr>';
                $data .= '<tr>';
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                $data .= '</tr>';
                $data .= '<tbody>';
                $data .= "<tr>";
                foreach ($currencies as $currency_row) {
                    $data .= '<td>' . $bills->where('supplier_id', $supplier->id)->where('currency_id', $currency_row->id)->sum('grand_total') . '</td>';
                }
                foreach ($currencies as $currency_row) {
                    $data .= '<td>' . $payments->where('supplier_id', $supplier->id)->where('currency_id', $currency_row->id)->sum('amount') . '</td>';
                }
                foreach ($currencies as $currency_row) {
                    $data .= '<td>' . $advances->where('supplier_id', $supplier->id)->where('currency_id', $currency_row->id)->sum('amount') . '</td>';
                }
                foreach ($currencies as $currency_row) {
                    $a_total = $advances->where('supplier_id', $supplier->id)->where('currency_id', $currency_row->id)->sum('amount');
                    $p_total = $payments->where('supplier_id', $supplier->id)->where('currency_id', $currency_row->id)->sum('amount');
                    $total = $a_total + $p_total;
                    $bill_total = $bills->where('supplier_id', $supplier->id)->where('currency_id', $currency_row->id)->sum('grand_total');
                    $balance = $bill_total - $total;
                    $data .= '<td>' . $balance . '</td>';
                }

                $data .= "</tr>";
                $data .= '</tbody>';
                $data .= '</table>';

            } else {
                $data .= "<h6 style='text-align:center;'>Pacha Paints Production Company</h6>";
                $data .= "<h6 style='text-align:center;'>All suppliers Balances</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= "<h6 style='text-align:center;'> Currency $currency->title_en</h6>";
                $data .= "<h6 style='text-align:center;'> supplier $supplier->name</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<td colspan="">Bills</td>';
                $data .= '<td colspan="">Payments</td>';
                $data .= '<td colspan="">Advances</td>';
                $data .= '<td colspan="">Balance</td>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $data .= "<tr>";
                $data .= "<td>" . $bills->where('supplier_id', $supplier->id)->where('currency_id', $currency_id)->sum('grand_total') . "</td>";
                $data .= "<td>" . $payments->where('supplier_id', $supplier->id)->where('currency_id', $currency_id)->sum('amount') . "</td>";
                $data .= "<td>" . $advances->where('supplier_id', $supplier->id)->where('currency_id', $currency_id)->sum('amount') . "</td>";
                $data .= "<td>";
                $p_total = $payments->where('supplier_id', $supplier->id)->where('currency_id', $currency_id)->sum('amount');
                $a_total = $advances->where('supplier_id', $supplier->id)->where('currency_id', $currency_id)->sum('amount');
                $total = $p_total + $a_total;
                $bill_total = $bills->where('supplier_id', $supplier->id)->where('currency_id', $currency_id)->sum('grand_total');
                $balance = $bill_total - $total;
                $data .= $balance;
                $data .= "</td>";
                $data .= "</tr>";
                $data .= '</tbody>';
                $data .= '</table>';
            }
        }
        return $data;
    }

    public function ar_report_show()
    {
        $suppliers = Supplier::all();
        $currencies = Currency::all();
        return view('purchase.balances.AP', compact('suppliers', 'currencies'));
    }
    public function ar_report_find(Request $request)
    {
        $supplier_id = $request->supplier_id;
        $currency_id = $request->currency_id;
        $suppliers = Supplier::all();
        $currencies = Currency::all();
        $supplier = Supplier::find($supplier_id);
        $currency = Currency::find($currency_id);
        $bills = SupplierBill::all();
        $payments = SupplierPayment::all();
        $advances = SupplierAdvance::all();
        $data = "";
        if ($supplier_id == "all") {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>Pacha Paints Production Company</h6>";
                $data .= "<h6 style='text-align:center;'>All suppliers Balances</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<td rowspan="2">Name</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Balance</td>';
                $data .= '</tr>';
                $data .= '<tr>';

                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                $data .= '</tr>';
                $data .= '<tbody>';
                foreach ($suppliers as $supplier_row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $supplier_row->name . "</td>";

                    foreach ($currencies as $currency_row) {
                        $a_total = $advances->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_row->id)->sum('amount');
                        $p_total = $payments->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_row->id)->sum('amount');
                        $total = $a_total + $p_total;
                        $bill_total = $bills->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_row->id)->sum('grand_total');
                        $balance = $bill_total - $total;
                        $data .= '<td>' . $balance . '</td>';
                    }
                    $data .= "</tr>";
                }
                $data .= '</tbody>';
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table>';
                $data .= '<tr>';
                $data .= '<td colspan="7">Balance</td>';
                $data .= '</tr>';
                $data .= '<tr>';
                foreach ($currencies as $currency_row) {
                    $a_total = $advances->where('currency_id', $currency_row->id)->sum('amount');
                    $p_total = $payments->where('currency_id', $currency_row->id)->sum('amount');
                    $total = $a_total + $p_total;
                    $bill_total = $bills->where('currency_id', $currency_row->id)->sum('grand_total');
                    $balance = $bill_total - $total;
                    $data .= '<td>' . $currency_row->title_en." ". $balance . '</td>';
                }
                $data .= '</tr>';
                $data .= '</tbody>';
                $data .= '</table>';

            } else {
                $data .= "<h6 style='text-align:center;'>Pacha Paints Production Company</h6>";
                $data .= "<h6 style='text-align:center;'>All suppliers Balances</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= "<h6 style='text-align:center;'> Currency $currency->title_en</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<td rowspan="2">Name</td>';
                $data .= '<td colspan="">Balance</td>';
                $data .= '</tr>';
                $data .= '<tbody>';
                foreach ($suppliers as $supplier_row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $supplier_row->name . "</td>";
                    $data .= "<td>";
                    $p_total = $payments->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_id)->sum('amount');
                    $a_total = $advances->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_id)->sum('amount');
                    $total = $p_total + $a_total;
                    $bill_total = $bills->where('supplier_id', $supplier_row->id)->where('currency_id', $currency_id)->sum('grand_total');
                    $balance = $bill_total - $total;
                    $data .= $balance;
                    $data .= "</td>";
                    $data .= "</tr>";

                }
                $data .= '</tbody>';
                $data .= '</table>';
            }
        } else {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>Pacha Paints Production Company</h6>";
                $data .= "<h6 style='text-align:center;'>$supplier->name Balances</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';

                $data .= '<td colspan="' . $currencies->count() . '">Balance</td>';
                $data .= '</tr>';
                $data .= '<tr>';

                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                $data .= '</tr>';
                $data .= '<tbody>';
                $data .= "<tr>";

                foreach ($currencies as $currency_row) {
                    $a_total = $advances->where('supplier_id', $supplier->id)->where('currency_id', $currency_row->id)->sum('amount');
                    $p_total = $payments->where('supplier_id', $supplier->id)->where('currency_id', $currency_row->id)->sum('amount');
                    $total = $a_total + $p_total;
                    $bill_total = $bills->where('supplier_id', $supplier->id)->where('currency_id', $currency_row->id)->sum('grand_total');
                    $balance = $bill_total - $total;
                    $data .= '<td>' . $balance . '</td>';
                }

                $data .= "</tr>";
                $data .= '</tbody>';
                $data .= '</table>';

            } else {
                $data .= "<h6 style='text-align:center;'>Pacha Paints Production Company</h6>";
                $data .= "<h6 style='text-align:center;'>All suppliers Balances</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= "<h6 style='text-align:center;'> Currency $currency->title_en</h6>";
                $data .= "<h6 style='text-align:center;'> supplier $supplier->name</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<td colspan="">Bills</td>';
                $data .= '<td colspan="">Payments</td>';
                $data .= '<td colspan="">Advances</td>';
                $data .= '<td colspan="">Balance</td>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $data .= "<tr>";

                $data .= "<td>";
                $p_total = $payments->where('supplier_id', $supplier->id)->where('currency_id', $currency_id)->sum('amount');
                $a_total = $advances->where('supplier_id', $supplier->id)->where('currency_id', $currency_id)->sum('amount');
                $total = $p_total + $a_total;
                $bill_total = $bills->where('supplier_id', $supplier->id)->where('currency_id', $currency_id)->sum('grand_total');
                $balance = $bill_total - $total;
                $data .= $balance;
                $data .= "</td>";
                $data .= "</tr>";
                $data .= '</tbody>';
                $data .= '</table>';
            }
        }
        return $data;
    }

    public function print_profile($id)
    {
        $supplier = Supplier::find($id);
        $currencies=Currency::all();
        $bills=SupplierBill::where('supplier_id',$id)->get();
        $payments=SupplierPayment::where('supplier_id',$id)->get();
        $advance=SupplierAdvance::where('supplier_id',$id)->get();
        return view('purchase.suppliers.print', compact('supplier','currencies','bills','payments','advance'));
    }
}
