<?php

namespace App\Http\Controllers\PurchaseAdministration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\SupplierPayment;
use App\Models\Supplier;
use App\Models\Currency;
use App\Models\CashJournal;
use Illuminate\Support\Facades\Auth;

class SupplierPaymentController extends Controller
{
    public function index($id)
    {
        $supplier = Supplier::find($id);
        $payments = SupplierPayment::where('supplier_id', $id)->orderBy('id', 'desc')->paginate(10);
        $currencies = Currency::all();
        return view('purchase.suppliers.payments.index', compact('payments', 'supplier', 'currencies'));
    }

    public function create($id)
    {
        $supplier = Supplier::find($id);
        $currencies = Currency::all();
        $invoice_number = SupplierPayment::orderBy('id', 'desc')->get()->first();
        $number = "";
        // if ($invoice_number == "") {
        //     $number = $invoice_number = 1;
        // } else {
        //     $number = $invoice_number->invoice_number + 1;
        // }
        return view('purchase.suppliers.payments.create', compact('supplier', 'currencies', 'number'));
    }
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'amount' => 'required',
            'date' => 'required',
            'currency_id' => 'required',
            'supplier_id' => 'required',
            'invoice_number' => 'required',
        ]);
        $payment = new SupplierPayment();
        $payment->supplier_id = $request->supplier_id;
        $payment->invoice_number = $request->invoice_number;
        $payment->amount = $request->amount;
        $payment->date = $request->date;
        $payment->title = $request->title;
        $payment->details = $request->details;
        $payment->currency_id = $request->currency_id;
        $payment->ex_rate = $request->ex_rate;
        $payment->status = 1;
        $payment->load_from_bill = 0;
        $payment->user_id = Auth::user()->id;
        $payment->c_target = $request->cash_id;

        $payment->save();
        if ($payment) {
            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = $payment->title . " Invoice" . $payment->invoice_number;
                $cash->date = $payment->date;
                $cash->outgoing = $payment->amount;
                $cash->currency_id = $payment->currency_id;
                $cash->ex_rate = $payment->ex_rate;
                $cash->module_id = 22;
                $cash->type_id = 22;
                $cash->module_record_id = $payment->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Target From Payment";
                $cash->save();
            }
        }
        session()->flash("msg", "Success!");
        return redirect()->route('supplier_payment.index', $payment->supplier_id);
    }
    public function edit($id)
    {
        $data = SupplierPayment::find($id);
        $supplier = Supplier::find($data->supplier_id);
        $currencies = Currency::all();
        return view('purchase.suppliers.payments.edit', compact('data', 'currencies', 'supplier'));
    }
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required',
            'amount' => 'required',
            'date' => 'required',
            'currency_id' => 'required',
        ]);
        $payment = SupplierPayment::find($id);
        $payment->supplier_id = $request->supplier_id;
        $payment->invoice_number = $request->invoice_number;
        $payment->amount = $request->amount;
        $payment->date = $request->date;
        $payment->title = $request->title;
        $payment->details = $request->details;
        $payment->currency_id = $request->currency_id;
        $payment->ex_rate = $request->ex_rate;
        $payment->status = 1;
        $payment->load_from_bill = 0;
        $payment->user_id = Auth::user()->id;
        $payment->c_target = $request->cash_id;
        $payment->save();
        if ($request->cash_id == 1) {
            $cash = CashJournal::where('module_id', 22)->where('module_record_id', $payment->id)->first();
            if ($cash != null) {
                $cash->title = $payment->title;
                $cash->outgoing = $payment->amount;
                $cash->currency_id = $payment->currency_id;
                $cash->ex_rate = $payment->ex_rate;
                $cash->module_id = 22;
                $cash->type_id = 22;
                $cash->module_record_id = $payment->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Target From Payment ";
                $cash->save();
            } else {
                $cash = new CashJournal();
                $cash->title = $payment->title;
                $cash->date = $payment->date;
                $cash->outgoing = $payment->amount;
                $cash->currency_id = $payment->currency_id;
                $cash->ex_rate = $payment->ex_rate;
                $cash->module_id = 22;
                $cash->type_id = 22;
                $cash->module_record_id = $payment->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Target From Payment ";
                $cash->save();
            }

        } else {
            $cash = CashJournal::where('module_id', 22)->where('module_record_id', $payment->id)->delete();
        }
        session()->flash("msg", "Success!");
        return redirect()->route('supplier_payment.index', $request->supplier_id);
    }
    public function delete($id)
    {
        $payment = SupplierPayment::find($id)->delete();
        session()->flash("msg", "Success!");
        return back();

    }
    public function report_show($id)
    {
        $currencies = Currency::all();
        $supplier = Supplier::find($id);
        return view('purchase.suppliers.payments.report', compact('supplier', 'currencies'));
    }
    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $supplier_id = $request->supplier_id;
        $currency_id = $request->currency_id;
        $supplier = Supplier::find($supplier_id);
        $currency = Currency::find($currency_id);
        $currencies = Currency::all();
        $data = "";
        if ($currency_id == "all") {
            $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center;'>$supplier->name </h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
            $data .= "<h6 style='text-align:center;'>Payment Report</h6>";
            $data .= "<h6 style='text-align:center;'>All Currency Report</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>Number</th>';
            $data .= '<th>Title</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>payment</th>';
            $data .= '<th>Details</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $payments = SupplierPayment::whereBetween('date', [$fDate, $tDate])->where('supplier_id', $supplier_id)->get();
            foreach ($payments as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->title . "</td>";
                $data .= "<td>" . $row->date . "</td>";
                $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                $data .= "<td>" . $row->details . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
            }
            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '</table>';
            $data .= '<table class="">';
            $data .= ' <tr>';
            $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
            $data .= '<th colspan="4" class="">Payment</th>';

            $data .= ' </tr>';
            $data .= ' <tr>';
            foreach (Currency::all() as $row) {
                $payment = SupplierPayment::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                $data .= '<td style="">' . $row->title_en . "/" . $payment . '</td>';
            }
            $data .= '</tr>';
            $data .= '</table>';
        } else {
            $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center;'>$supplier->name </h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
            $data .= "<h6 style='text-align:center;'>Payment Report</h6>";
            $data .= "<h6 style='text-align:center;'>$currency->title_en Currency Report</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>Number</th>';
            $data .= '<th>Title</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>payment</th>';
            $data .= '<th>Details</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $payments = SupplierPayment::whereBetween('date', [$fDate, $tDate])->where('supplier_id', $supplier_id)->where('currency_id', $currency_id)->get();
            foreach ($payments as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->title . "</td>";
                $data .= "<td>" . $row->date . "</td>";
                $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                $data .= "<td>" . $row->details . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
            }
            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '</table>';
            $data .= '<table class="">';
            $data .= ' <tr>';
            $data .= '<th  rowspan="2">Sub Total</th>';
            $data .= ' </tr>';
            $data .= ' <tr>';
            $payment = SupplierPayment::where('currency_id', $currency_id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
            $data .= "<td colspan='4'>";
            $data .= $payment;
            $data .= "</td>";
            $data .= '</tr>';
            $data .= '</table>';
        }

        return $data;
    }

    public function filter_find(Request $request)
    {
        $currencies = Currency::all();
        if ($request->type_id == 1) {
            $payments = SupplierPayment::Where('invoice_number', $request->number)
                ->where('supplier_id', $request->supplier_id)
                ->get();
        } else if ($request->type_id == 2) {
            $payments = SupplierPayment::where('title', 'like', '%' . $request->title . '%')
                ->where('supplier_id', $request->supplier_id)
                ->get();
        } else {
            $payments = SupplierPayment::whereBetween('date', [$request->f_date, $request->t_date])
                ->where('supplier_id', $request->supplier_id)
                ->get();
        }
        $supplier = Supplier::find($request->supplier_id);
        return view('purchase.suppliers.payments.filter', compact('currencies', 'payments', 'supplier'));
    }
}
