<?php

namespace App\Http\Controllers\accounts;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\BankAccount;
class BankerAccountController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $bankerAccount=BankAccount::orderBy('id','desc')->where('status',1)->paginate(10);
        return view('accounts.bankers.create',compact('bankerAccount'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'address' => 'required',
            'phone' => 'required',
            
        ]);
        $investorAccount=new BankAccount();
        $investorAccount->name=$request->name;
        $investorAccount->phone=$request->phone;
        $investorAccount->address=$request->address;
        $investorAccount->status=1;
        $investorAccount->user_id=Auth()->user()->id;
        $investorAccount->date=date('Y-m-d');
        $isSaved=$investorAccount->save();
        if($isSaved){
            session()->flash("msg", "Success!");
            return redirect()->route('banker.index');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $bankerAccount=BankAccount::find($id);
        return view('accounts.bankers.show',compact('bankerAccount'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $bankerAccount=BankAccount::find($id);
        return view('accounts.bankers.edit',compact('bankerAccount'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'address' => 'required',
            'phone' => 'required',
            
        ]);
        $investorAccount=BankAccount::find($id);
        $investorAccount->name=$request->name;
        $investorAccount->phone=$request->phone;
        $investorAccount->address=$request->address;
        $investorAccount->status=1;
        $investorAccount->user_id=Auth()->user()->id;
        $investorAccount->date=date('Y-m-d');
        $isSaved=$investorAccount->save();
        if($isSaved){
            session()->flash("msg", "Success!");
            return redirect()->route('banker.index');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
