<?php

namespace App\Http\Controllers\configuration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ExchangeProcess;
use App\Models\Currency;

class ExchangeProcessController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data=ExchangeProcess::orderBy('id','desc')->paginate(10);
        $currencies=Currency::all();
        return view('configuration.exchange_rate.create',compact('data','currencies'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'amount' => 'required',
            'currency_id' => 'required',
        ]);
       $data=new ExchangeProcess();
       $data->currency_id=$request->currency_id;
       $data->rate_of_af=$request->amount;
       $data->save();
       if($data){
        return redirect()->route('exprocess.index')->with('msg','Success');
       }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data=ExchangeProcess::find($id);
        $currencies=Currency::all();
        return view('configuration.exchange_rate.edit',compact('data','currencies'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'amount' => 'required',
            'currency_id' => 'required',
        ]);
        $data=ExchangeProcess::find($id);
        $data->currency_id=$request->currency_id;
        $data->rate_of_af=$request->amount;
       $data->save();
       if($data){
        return redirect()->route('exprocess.index')->with('msg','Success');
       }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
