<?php

namespace App\Http\Controllers\configuration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Info;

class InfoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data=Info::all();
        return view('configuration.infos.index',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('configuration.infos.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255|min:2',
            'phone' => 'required|max:255|min:2',
        ]);
       $data = new Info();
       $data->business_name=$request->name;
       $data->business_name_ps=$request->name_ps;
       $data->business_phone=$request->phone;
       $data->business_address=$request->address;
       $data->business_email=$request->email;
       $data->business_website=$request->web_url;
       $data->business_facebook=$request->facebook_url;
       $data->invoice_text=$request->invoice_text;
       $data->invoice_text_ps=$request->invoice_text_ps;
       $data->business_whats_app=$request->w_number;
       $data->business_type=$request->b_type;
       $data->date_type=$request->d_type;
      
        $folder=date("Y-M");
        if(request()->hasFile('logo')){
            $filename = 'logo-'.time().'-'.request()->file('logo')->getClientOriginalName();
            $logo_path = request()->file('logo')->storeAs('logo/'.$folder,$filename,'public');
         }else{
            $logo_path="logo.png";
         }
        
         if(request()->hasFile('template')){
            $filename = 'template-'.time().'-'.request()->file('template')->getClientOriginalName();
            $template = request()->file('template')->storeAs('template/'.$folder,$filename,'public');
         }else{
            $template="profile.png";
         }
        $data->business_logo=$logo_path;
        $data->business_sale_invoice_template=$template;
        $data->save();
        session()->flash("msg", "Success!");
        return redirect()->route('infos.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data=Info::find($id);
        return view('configuration.infos.show',compact('data'));
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data=Info::find($id);
        return view('configuration.infos.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|max:255|min:2',
            'phone' => 'required|max:255|min:2',
        ]);
       $data =Info::find($id);
       $data->business_name=$request->name;
       $data->bussiness_name_ps=$request->name_ps;
       $data->business_phone=$request->phone;
       $data->business_address=$request->address;
       $data->business_email=$request->email;
       $data->business_website=$request->web_url;
       $data->business_facebook=$request->facebook_url;
       $data->invoice_text=$request->invoice_text;
       $data->invoice_text_ps=$request->invoice_text_ps;
       $data->business_whats_app=$request->w_number;
       $data->business_type=$request->b_type;
       $data->date_type=$request->d_type;
       $data->stock_load_type=$request->stock_load_type;
      
        $folder=date("Y-M");
        if(request()->hasFile('logo')){
            $filename = 'logo-'.time().'-'.request()->file('logo')->getClientOriginalName();
            $logo_path = request()->file('logo')->storeAs('logo/'.$folder,$filename,'public');
         }else{
            $logo_path=$data->business_logo;
         }
        
         if(request()->hasFile('template')){
            $filename = 'template-'.time().'-'.request()->file('template')->getClientOriginalName();
            $template = request()->file('template')->storeAs('template/'.$folder,$filename,'public');
         }else{
            $template=$data->business_sale_invoice_template;
         }
        $data->business_logo=$logo_path;
        $data->business_sale_invoice_template=$template;
        $data->save();
        session()->flash("msg", "Success!");
        return redirect()->route('infos.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
