<?php

namespace App\Http\Controllers\configuration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\SUnit;

class SaleUnitController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Sunits = SUnit::orderBy('id','desc')->paginate(10);
        return view('configuration.Sunits.create', compact('Sunits'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
        $Sunits = new SUnit();
        $Sunits->title_en = $request->title_en;
        $Sunits->title_ps = $request->title_ps;
        $Sunits->title_dr = $request->title_dr;
        $Sunits->save();
        if ($Sunits) {
            return redirect()->route('sunits.index')->with('msg', 'Sunits Type Was Created');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Sunits = SUnit::find($id);
        return view('configuration.Sunits.edit', compact('Sunits'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
        $Sunits = SUnit::find($id);
        $Sunits->title_en = $request->title_en;
        $Sunits->title_ps = $request->title_ps;
        $Sunits->title_dr = $request->title_dr;
        $Sunits->save();
        if ($Sunits) {
            return redirect()->route('sunits.index')->with('msg', 'Sunits Type Was Updated');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function status($id)
    {
        $Sunits = SUnit::find($id);
        if ($Sunits->status == 0) {
            SUnit::where('id', $id)->update([
                'status' => 1
            ]);
        }
        if ($Sunits->status == 1) {
            SUnit::where('id', $id)->update([
                'status' => 0
            ]);
        }
        return back()->with('msg', 'Status Was Updated');
    }
}
