<?php

namespace App\Http\Controllers\configuration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CashType;

class cashTypeController extends Controller
{
      /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $cashTypes=CashType::orderBy('id','desc')->paginate(10);
        return view('configuration.cashType.create',compact('cashTypes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
       $cashtype=new CashType();
       $cashtype->title_en=$request->title_en;
       $cashtype->title_ps=$request->title_ps;
       $cashtype->title_dr=$request->title_dr;
       $cashtype->type_id=$request->type_id;
       $cashtype->save();
       if($cashtype){
        return redirect()->route('cashType.index')->with('msg','Success');
       }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $cashtype=CashType::find($id);
        return view('configuration.cashType.edit',compact('cashtype'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
       $cashtype=CashType::find($id);
       $cashtype->title_en=$request->title_en;
       $cashtype->title_ps=$request->title_ps;
       $cashtype->title_dr=$request->title_dr;
       $cashtype->type_id=$request->type_id;
       $cashtype->save();
       if($cashtype){
        return redirect()->route('cashType.index')->with('msg','Success');
       }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function status($id){
        $cashType=CashType::find($id);
        if($cashType->status==0){
            CashType::where('id',$id)->update([
                'status'=>1
            ]);
        }
        if($cashType->status==1){
            CashType::where('id',$id)->update([
                'status'=>0
            ]);
        }
        return back()->with('msg','Status Was Updated');
    }
}
