<?php

namespace App\Http\Controllers\configuration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ExpenseType;

class expenceTypeController extends Controller
{
    public function index()
    {
        $ExpenseTypes = ExpenseType::orderBy('id','desc')->paginate(10);
        return view('configuration.expenceType.create', compact('ExpenseTypes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
        $ExpenseTypes = new ExpenseType();
        $ExpenseTypes->title_en=$request->title_en;
        $ExpenseTypes->title_ps=$request->title_ps;
        $ExpenseTypes->title_dr=$request->title_dr;
        $ExpenseTypes->save();
        if ($ExpenseTypes) {
            return redirect()->route('expencetype.index')->with('msg', 'Expence Type Was Created');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $ExpenseType=ExpenseType::find($id);
        return view('configuration.expenceType.edit',compact('ExpenseType'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
        $ExpenseTypes =ExpenseType::find($id);
        $ExpenseTypes->title_en=$request->title_en;
        $ExpenseTypes->title_ps=$request->title_ps;
        $ExpenseTypes->title_dr=$request->title_dr;
        $ExpenseTypes->save();
        if ($ExpenseTypes) {
            return redirect()->route('expencetype.index')->with('msg', 'Expence Type Type Was Update');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function status($id){
        $ExpenseType=ExpenseType::find($id);
        if($ExpenseType->status==0){
            ExpenseType::where('id',$id)->update([
                'status'=>1
            ]);
        }
        if($ExpenseType->status==1){
            ExpenseType::where('id',$id)->update([
                'status'=>0
            ]);
        }
        return back()->with('msg','Success');
    }
}
