<?php

namespace App\Http\Controllers\journals;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CashJournal;
use App\Models\CashType;
use App\Models\Currency;
use Carbon\Carbon;

class CashJournalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $currency = Currency::all();
        $cushJournal = CashJournal::orderBy('id','desc')->paginate(10);
        $cashType = cashType::all();
        return view('journals.cash.index', compact('cushJournal', 'currency', 'cashType'));
    }
    public function create()
    {
       
        $currency = Currency::all();
        $cushJournal = CashJournal::orderBy('id','desc')->paginate(10);
        $cashType = cashType::all();
        return view('journals.cash.income-create', compact('cushJournal', 'currency', 'cashType'));
    }
    public function out_create()
    {
        $currency = Currency::all();
        $cushJournal = CashJournal::orderBy('id','desc')->paginate(10);
        $cashType = cashType::all();
        return view('journals.cash.outgoing-create', compact('cushJournal', 'currency', 'cashType'));
    }
    public function income_list()
    {
        $currency = Currency::all();
        $cushJournal = CashJournal::orderBy('id','desc')->where('income', '!=', 0)->paginate(10);
        $cashType = cashType::all();
        return view('journals.cash.income-list', compact('cushJournal', 'currency', 'cashType'));
    }

    public function outgoing_list()
    {
        $currency = Currency::all();
        $cushJournal = CashJournal::orderBy('id','desc')->where('outgoing', '!=', 0)->paginate(10);
        $cashType = cashType::all();
        return view('journals.cash.outgoing-list', compact('cushJournal', 'currency', 'cashType'));
    }
    public function balance()
    {
        $cashType = cashType::all();
        $currency = Currency::all();
        $cushJournal = CashJournal::all();
        return view('journals.cash.balance', compact('cushJournal', 'currency', 'cashType'));
    }



    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'required',
            'date' => 'required',
            'type_id' => 'required',
        ]);
        $cushJournal = new CashJournal();
        $cushJournal->title = $request->title;
        if ($request->check == 1) {
            $cushJournal->income = $request->income;
            $cushJournal->outgoing = 0;
        } else {
            $cushJournal->income = 0;
            $cushJournal->outgoing = $request->outgoing;
        }
        $cushJournal->type_id = $request->type_id;
        $cushJournal->currency_id = $request->currency;
        $cushJournal->status = 1;
        $cushJournal->user_id = Auth()->user()->id;
        $cushJournal->date = $request->date;
        $cushJournal->details = $request->details;
        $isSaved = $cushJournal->save();
        if ($isSaved) {
            session()->flash("msg", "Success!");
            return redirect()->route('cash.index');
        }
    }
    public function edit($id)
    {
        $currency = Currency::all();
        $cashJournal = CashJournal::find($id);
        $cashType = cashType::all();
        return view('journals.cash.edit', compact('cashJournal', 'currency', 'cashType'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title' => 'required',
        ]);
        $cushJournal = CashJournal::find($id);
        $cushJournal->title = $request->title;
        $cushJournal->outgoing = $request->outgoing;
        $cushJournal->income = $request->income;
        $cushJournal->currency_id = $request->currency;
        $cushJournal->type_id = $request->type_id;
        $cushJournal->date = $request->date;
        $cushJournal->details = $request->details;
        $isSaved = $cushJournal->save();
        if ($isSaved) {
            session()->flash("msg", "Success!");
            return redirect()->route('cash.index');
        }
    }
    public function delete($id)
    {
        $cushJournal = CashJournal::find($id)->delete();
        session()->flash("msg", "Success!");
        return back();
    }

    public function report_show()
    {
        $currency = Currency::all();
        $cashType = cashType::all();
        return view('journals.cash.report', compact('currency', 'cashType'));
    }

    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $data = '';
        $from = $request->fromDate;
        $to = $request->toDate;
        $currency_id = $request->currency_id;
        $currency = Currency::find($currency_id);
        $type_id=$request->type_id;
        $type = cashType::find($type_id);
        if ($type_id == "all") {
            if ($currency_id == 'all') {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6><p style='text-align:center;'>From ($from) to ($to)</p>";
                $data .= "<h6 style='text-align:center;'>Cash Report</h6>";
                $data .= "<h6 style='text-align:center;'>All Currency</h6>";
                $data .= "<h6 style='text-align:center;'>All Types</h6>";
                $data .= '<table class="" dir="">';
                $data .= ' <tr>';
                $data .= '<th colspan="" rowspan="2" style="color:#6633FF">Dev Amount</th>';
                $data .= '<th colspan="4"style="color:#330066">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $yesterday = date('Y-m-d', strtotime('-1 days'));
                $journal = CashJournal::whereBetween('date', [$from, $to])->orderBy('id','desc')->get();
                foreach (Currency::all() as $row) {
                    $total_income = CashJournal::where('currency_id', $row->id)->sum('income');
                    $today_income = CashJournal::where('date', date('Y-m-d'))->where('currency_id', $row->id)->sum('income');
                    $yesterday_income = $total_income - $today_income;
                    $total_outgoing = CashJournal::where('currency_id', $row->id)->sum('outgoing');
                    $today_outgoing = CashJournal::where('date', date('Y-m-d'))->where('currency_id', $row->id)->sum('outgoing');
                    $yesterday_outgoing = $total_outgoing - $today_outgoing;
                    $balance = $yesterday_income - $yesterday_outgoing;
                    $data .= '<td >' . $row->title_en . "/" . $balance . '</td>';
                }
                $data .= '</tr>';
                $data .= '</table><br>';
                $data .= '<table class="" >';
                $data .= '<tr style="background-color:#000; color:#fff;">';
                $data .= '<th>No</th>';
                $data .= '<th>title</th>';
                $data .= '<th>Type</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Income</th>';
                $data .= '<th>outgoing</th>';
                $data .= '<th>Currency</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->type->title_en . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->currency->title_en . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table >';
                $data .= '<table class="" >';
                $data .= ' <tr>';
                $data .= '<th colspan="" rowspan="2" style="color:#6633FF">Report</th>';
                $data .= '<th colspan="4" style="color:#6633FF">Income</th>';
                $data .= '<th colspan="4" style="color:#990000">Outgoing</th>';
                $data .= '<th colspan="4"style="color:#330066">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $journal_income = CashJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('income');
                    $data .= '<td >' . $row->title_en . "/" . $journal_income . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_outgoing = CashJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('outgoing');
                    $data .= '<td >' . $row->title_en . "/" . $journal_outgoing . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_income = CashJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('income');
                    $journal_outgoing = CashJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('outgoing');
                    $balance = $journal_income - $journal_outgoing;
                    if ($journal_outgoing > $journal_income) {
                        $data .= '<td >' . $row->title_en . "/" . $balance . '</td>';
                    } else {
                        $data .= '<td >' . $row->title_en . "/" . $balance . '</td>';
                    }
                }
                $data .= '</tr>';
                $data .= '<table class=""><br>';
                $data .= ' <tr>';
                $data .= '<th colspan="" rowspan="2" style="color:#6633FF">Subtotal</th>';
                $data .= '<th colspan="4" style="color:#6633FF">Income</th>';
                $data .= '<th colspan="4" style="color:#990000">Outgoing</th>';
                $data .= '<th colspan="4"style="color:#330066">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $journal_income = CashJournal::where('currency_id', $row->id)->sum('income');
                    $data .= '<td >' . $row->title_en . "/" . $journal_income . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_outgoing = CashJournal::where('currency_id', $row->id)->sum('outgoing');
                    $data .= '<td >' . $row->title_en . "/" . $journal_outgoing . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_income = CashJournal::where('currency_id', $row->id)->sum('income');
                    $journal_outgoing = CashJournal::where('currency_id', $row->id)->sum('outgoing');
                    $balance = $journal_income - $journal_outgoing;
                    if ($journal_outgoing > $journal_income) {
                        $data .= '<td >' . $row->title_en . "/" . $balance . '</td>';
                    } else {
                        $data .= '<td >' . $row->title_en . "/" . $balance . '</td>';
                    }
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6><p style='text-align:center;'>From ($from) to ($to)</p>";
                $data .= "<h6 style='text-align:center;'>Cash Report</h6>";
                $data .= "<h6 style='text-align:center;'>Currency $currency->title_en</h6>";
                $data .= "<h6 style='text-align:center;'>All Types</h6>";
                $data .= '<table class="" >';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Type</th>';
                $data .= '<th style="color:#6633FF">income</th>';
                $data .= ' <th style="color:#990000">outgoing</th>';
                $data .= '<th>Details</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
               
                $journal = CashJournal::whereBetween('date', [$from, $to])->where('currency_id', $currency_id)->orderBy('id','desc')->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->type->title_en . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';

                $data .= '<table class="" dir="rtl">';
                $data .= ' <tr>';
                $data .= '<th colspan="">income</th>';
                $data .= '<th colspan="">outgoing</th>';
                $data .= '<th colspan=""style="color:#330066">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $data .= '<td>' . $journal->sum('income') . '</td>';
                $data .= '<td>' . $journal->sum('outgoing') . '</td>';
                $data .= '<td>';
                $data .= $journal->sum('outgoing') - $journal->sum('income');
                $data .= '</td>';
                $data .= '</tr>';
                $data .= '</table>';
            }
        }else {
            if ($currency_id == 'all') {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6><p style='text-align:center;'>From ($from) to ($to)</p>";
                $data .= "<h6 style='text-align:center;'>Cash Report</h6>";
                $data .= "<h6 style='text-align:center;'>Type $type->title_en</h6>";
                $data .= "<h6 style='text-align:center;'>All Currency</h6>";
                $data .= "<h6 style='text-align:center;'></h6>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Type</th>';
                $data .= '<th style="color:#6633FF">income</th>';
                $data .= ' <th style="color:#990000">outgoing</th>';
                $data .= '<th>Details</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $journal = CashJournal::whereBetween('date', [$from, $to])
                    ->where('type_id', $request->type_id)
                    ->orderBy('id','desc')
                    ->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->type->title_en . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="4" style="color:#6633FF">income</th>';
                $data .= '<th colspan="4" style="color:#990000">outgoing</th>';
                $data .= '<th colspan="4"style="color:#330066">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $journal_income = CashJournal::where('currency_id', $row->id)
                        ->whereBetween('date', [$from, $to])
                        ->where('type_id', $request->type_id)
                        ->sum('income');
                    $data .= '<td style="color:green;">' . $row->title_en . "/" . $journal_income . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_outgoing = CashJournal::where('currency_id', $row->id)
                        ->whereBetween('date', [$from, $to])
                        ->where('type_id', $request->type_id)
                        ->sum('outgoing');
                    $data .= '<td style="color:red;">' . $row->title_en . "/" . $journal_outgoing . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_income = CashJournal::where('currency_id', $row->id)
                        ->whereBetween('date', [$from, $to])
                        ->where('type_id', $request->type_id)
                        ->sum('income');
                    $journal_outgoing = CashJournal::where('currency_id', $row->id)
                        ->where('type_id', $request->type_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('outgoing');
                    $balance = $journal_income - $journal_outgoing;
                    if ($journal_outgoing > $journal_income) {
                        $data .= '<td style="color:#990000">' . $row->title_en . "/" . $balance . '</td>';
                    } else {
                        $data .= '<td class="text-warning">' . $row->title_en . "/" . $balance . '</td>';
                    }
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {

                $data .= "<h6 style='text-align:center;'>".$bname."</h6><p style='text-align:center;'>From ($from) to ($to)</p>";
                $data .= "<h6 style='text-align:center;'>Cash Report</h6>";
                $data .= "<h6 style='text-align:center;'>$currency->title_en</h6>";
                $data .= "<h6 style='text-align:center;'>$type->title_en</h6>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Type</th>';
                $data .= '<th style="color:#6633FF">income</th>';
                $data .= ' <th style="color:#990000">outgoing</th>';
                $data .= '<th>Details</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $currency = Currency::find($currency_id)->name;
                $journal = CashJournal::whereBetween('date', [$from, $to])
                    ->where('currency_id', $currency_id)
                    ->where('type_id', $request->type_id)
                    ->orderBy('id','desc')->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->type->title_en . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';

                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="">income</th>';
                $data .= '<th colspan="">outgoing</th>';
                $data .= '<th colspan=""style="color:#330066">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $data .= '<td>' . $journal->sum('income') . '</td>';
                $data .= '<td>' . $journal->sum('outgoing') . '</td>';
                $data .= '<td>';
                $data .= $journal->sum('income') - $journal->sum('outgoing');
                $data .= '</td>';
                $data .= '</tr>';
                $data .= '</table>';
            }
        }
        return $data;
    }

    public function filter_show()
    {
        $currency = Currency::all();
        $cashType = cashType::all();
        $filter = "page";
        return view('journals.cash.filter', compact('currency', 'cashType', 'filter'));
    }

    public function filter_find(Request $request)
    {
        $currency = Currency::all();
        $cashType = cashType::all();
        if ($request->filter_id == 1) {
            $cushJournal = CashJournal::Where('type_id', $request->type_id)->paginate(10);
        } else if ($request->filter_id == 2) {
            $cushJournal = CashJournal::Where('currency_id', $request->currency_id)->paginate(10);
        } else if ($request->filter_id == 3) {
            $cushJournal = CashJournal::Where('title', 'like', '%' . $request->title . '%')->paginate(10);
        } else if ($request->filter_id == 4) {
            $cushJournal = CashJournal::Where('income', $request->income)->paginate(10);
        } else if ($request->filter_id == 5) {
            $cushJournal = CashJournal::Where('outgoing', $request->outgoing)->paginate(10);
        } else {
            $cushJournal = CashJournal::WhereBetween('date', [$request->fromDate, $request->toDate])->paginate(10);
        }
        return view('journals.cash.index', compact('currency', 'cashType', 'cushJournal'));
    }
}
