<?php

namespace App\Http\Controllers\journals;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DebitorAccount;
use App\Models\DebitorJournal;
use App\Models\Currency;
use App\Models\CashJournal;

class DebitorJournalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
        $debitors = DebitorAccount::orderBy('id','desc')->get();
        $currency = Currency::all();
        $debetorJournal = DebitorJournal::orderBy('id','desc')->paginate(10);
        return view('journals.debitor.index', compact('debetorJournal', 'currency', 'debitors'));
    }

    public function create()
    {
        $debitors = DebitorAccount::all();
        $currency = Currency::all();
        $debetorJournal = DebitorJournal::orderBy('id','desc')->paginate(10);
        return view('journals.debitor.create', compact('debetorJournal', 'currency', 'debitors'));
    }

    public function create_outgoing()
    {
        $debitors = DebitorAccount::all();
        $currency = Currency::all();
        $debetorJournal = DebitorJournal::orderBy('id','desc')->paginate(10);
        return view('journals.debitor.outgoing-create', compact('debetorJournal', 'currency', 'debitors'));
    }

    public function income()
    {
        $debitors = DebitorAccount::all();
        $currency = Currency::all();
        $debetorJournal = DebitorJournal::orderBy('id', 'desc')->where('outgoing', 0)->paginate(10);
        return view('journals.debitor.income', compact('debetorJournal', 'currency', 'debitors'));
    }
    public function outgoing()
    {
        $debitors = DebitorAccount::all();
        $currency = Currency::all();
        $debetorJournal = DebitorJournal::orderBy('id', 'desc')->where('income', 0)->paginate(10);
        return view('journals.debitor.outgoing', compact('debetorJournal', 'currency', 'debitors'));
    }




    public function balance()
    {
        $currency = Currency::all();
        $debetorJournal = DebitorJournal::all();
        $debitors = DebitorAccount::all();
        return view('journals.debitor.balance', compact('debetorJournal', 'currency', 'debitors'));
    }



    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'required',
            'debitor_id' => 'required',
            'date' => 'required',
        ]);
        $debetorJournal = new DebitorJournal();
        $debetorJournal->title = $request->title;
        $debetorJournal->debitor_id = $request->debitor_id;
        if ($request->income == "") {
            $debetorJournal->income = 0;
        } else {
            $debetorJournal->income = $request->income;
        }
        if ($request->outgoing == "") {
            $debetorJournal->outgoing = 0;
        } else {
            $debetorJournal->outgoing = $request->outgoing;
        }
        $debetorJournal->currency_id = $request->currency;
        $debetorJournal->status = 1;
        $debetorJournal->c_target=$request->cash_id;
        $debetorJournal->user_id = Auth()->user()->id;
        $debetorJournal->date = $request->date;
        $debetorJournal->details = $request->details;
        $isSaved = $debetorJournal->save();
        if ($isSaved) {
            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = $debetorJournal->title;
                $cash->date = $debetorJournal->date;
                if($request->transaction_id==1){
                    $cash->income = $debetorJournal->income;
                }else{
                    $cash->outgoing = $debetorJournal->outgoing;
                }
                $cash->currency_id = $debetorJournal->currency_id;
                $cash->ex_rate = $debetorJournal->ex_rate;
                $cash->module_id = 24;
                $cash->type_id = 24;
                $cash->module_record_id = $debetorJournal->id;
                $cash->details = "Cash is Targeted From Debitor Journal";
                $cash->save();
            }
            session()->flash("msg", "Success!");
            return redirect()->route('debitor.index');
        }
    }
    public function edit($id)
    {
       
        $currency = Currency::all();
        $data = DebitorJournal::find($id);
        $debitors = DebitorAccount::all();
        return view('journals.debitor.edit', compact('data', 'currency', 'debitors'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title' => 'required',
        ]);
        $debetorJournal = DebitorJournal::find($id);
        $debetorJournal->title = $request->title;
        $debetorJournal->debitor_id = $request->debitor_id;
        $debetorJournal->income = $request->income;
        $debetorJournal->outgoing = $request->outgoing;
        $debetorJournal->currency_id = $request->currency;
        $debetorJournal->status = 1;
        $debetorJournal->c_target=$request->cash_id;
        $debetorJournal->user_id = Auth()->user()->id;
        $debetorJournal->date = $request->date;
        $debetorJournal->details = $request->details;
        $isSaved = $debetorJournal->save();
        if ($isSaved) {
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 24)->where('module_record_id', $debetorJournal->id)->first();
                if ($cash != null) {
                    $cash->title = $debetorJournal->title;
                    $cash->date = $debetorJournal->date;
                    if($request->income!=0){
                        $cash->income = $debetorJournal->income;
                    }
                    if($request->outgoing!=0){
                        $cash->outgoing = $debetorJournal->outgoing;
                    }
                    $cash->currency_id = $debetorJournal->currency_id;
                    $cash->module_id = 24;
                    $cash->type_id = 24;
                    $cash->module_record_id = $debetorJournal->id;
                    $cash->details = "Cash Target From Expense";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $debetorJournal->title;
                    $cash->date = $debetorJournal->date;
                    if($request->income!=0){
                        $cash->income = $debetorJournal->income;
                    }
                    if($request->outgoing!=0){
                        $cash->outgoing = $debetorJournal->outgoing;
                    }
                    $cash->currency_id = $debetorJournal->currency_id;
                    $cash->module_id = 24;
                    $cash->type_id = 24;
                    $cash->module_record_id = $debetorJournal->id;
                    $cash->details = "Cash Target From Expense";
                    $cash->save();
                }
            }else{
                $cash = CashJournal::where('module_id', 24)->where('module_record_id', $debetorJournal->id)->delete();
            }
            session()->flash("msg", "Success!");
            return redirect()->route('debitor.index');
        }
    }
    public function delete($id)
    {
        $debetorJournal = DebitorJournal::find($id)->delete();
        $cash = CashJournal::where('module_id', 24)->where('module_record_id', $id)->delete();
        session()->flash("msg", "Success!");
        return back();
    }

    public function report_show()
    {
        $currency = Currency::all();
        $debitors = DebitorAccount::all();
        return view('journals.debitor.report', compact('currency', 'debitors'));
    }

    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $data = '';
        $from = $request->fromDate;
        $to = $request->toDate;
        $currency_id = $request->currency_id;
        $currency=Currency::find($currency_id);
        $currencies=Currency::all();
        $debitor_id=$request->debitor_id;
        $debitor=DebitorAccount::find($debitor_id);
        if ($request->debitor_id == 'all') {
            $name = "";
            if ($currency_id == 'all') {
                $data .= "<h6 class='text-center'>".$bname."</h6>";
                $data .= "<h6 class='text-center'>All Currencies</h6>";
                $data .= "<h6 class='text-center'>All Accounts</h6>";
                $data .= "<h6 class='text-center'>Debitor Journal Report</h6><p class='text-center'>From ($from) to ($to)</p>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Person</th>';
                $data .= '<th class="text-success">Income</th>';
                $data .= ' <th class="text-danger">Ouggoing</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $journal = DebitorJournal::whereBetween('date', [$from, $to])->orderBy('id', 'desc')->get();
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->debitor->name . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="'.$currencies->count().'" class="text-success">Income</th>';
                $data .= '<th colspan="'.$currencies->count().'" class="text-danger">Ouggoing</th>';
                $data .= '<th colspan="'.$currencies->count().'">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $journal_income = DebitorJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('income');
                    $data .= '<td style="color:green;">' . $row->title_en . "/" . $journal_income . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_debit = DebitorJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('outgoing');
                    $data .= '<td style="color:red;">' . $row->title_en . "/" . $journal_debit . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_income = DebitorJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('income');
                    $journal_debit = DebitorJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('outgoing');
                    $balance = $journal_income - $journal_debit;
                    $data .= '<td class="text-warning">' . $row->title_en . "/" . $balance . '</td>';

                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 class='text-center'>".$bname."</h6>";
                $data .= "<h6 class='text-center'>Currency of $currency->title_en</h6>";
                $data .= "<h6 class='text-center'>All Accounts</h6>";
                $data .= "<h3 class='text-center'>Debitor Reports</h6><p class='text-center'>From ($from) to ($to)</p>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Person</th>';
                $data .= '<th class="text-success">Income</th>';
                $data .= ' <th class="text-danger">Ouggoing</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $journal = DebitorJournal::whereBetween('date', [$from, $to])->where('currency_id', $currency_id)->orderBy('id', 'desc')->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->debitor->name . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';

                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="">Income</th>';
                $data .= '<th colspan="">Ouggoing</th>';
                $data .= '<th colspan="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $data .= '<td>' . $journal->sum('income') . '</td>';
                $data .= '<td>' . $journal->sum('outgoing') . '</td>';
                $data .= '<td>';
                $data .= $journal->sum('income') - $journal->sum('outgoing');
                $data .= '</td>';
                $data .= '</tr>';
                $data .= '</table>';
            }
        } else {
            if ($currency_id == 'all') {
                $data .= "<h6 class='text-center'>".$bname."</h6>";
                $data .= "<h6 class='text-center'>All Currencies</h6>";
                $data .= "<h6 class='text-center'>Debitor of $debitor->name</h6>";
                $data .= "<h6 class='text-center'>Debitor Journal Report</h6><p class='text-center'>From ($from) to ($to)</p>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Person</th>';
                $data .= '<th class="text-success">Income</th>';
                $data .= ' <th class="text-danger">Ouggoing</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $journal = DebitorJournal::whereBetween('date', [$from, $to])
                ->where('debitor_id', $request->debitor_id)
                ->orderBy('id', 'desc')
                ->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->debitor->name . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="'.$currencies->count().'" class="text-success">Income</th>';
                $data .= '<th colspan="'.$currencies->count().'" class="text-danger">Ouggoing</th>';
                $data .= '<th colspan="'.$currencies->count().'">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $journal_income = DebitorJournal::where('currency_id', $row->id)
                        ->where('debitor_id', $request->debitor_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('income');
                    $data .= '<td style="color:green;">' . $row->title_en . "/" . $journal_income . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_debit = DebitorJournal::where('currency_id', $row->id)
                        ->where('debitor_id', $request->debitor_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('outgoing');
                    $data .= '<td style="color:red;">' . $row->title_en . "/" . $journal_debit . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_income = DebitorJournal::where('currency_id', $row->id)
                        ->where('debitor_id', $request->debitor_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('income');
                    $journal_debit = DebitorJournal::where('currency_id', $row->id)
                        ->where('debitor_id', $request->debitor_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('outgoing');
                    $balance = $journal_income - $journal_debit;
                    if ($journal_debit > $journal_income) {
                        $data .= '<td class="text-danger">' . $row->title_en . "/" . $balance . '</td>';
                    } else {
                        $data .= '<td class="text-warning">' . $row->title_en . "/" . $balance . '</td>';
                    }
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
               
                $data .= "<h6 class='text-center'>".$bname."</h6>";
                $data .= "<h6 class='text-center'>Currency of $currency->title_en</h6>";
                $data .= "<h6 class='text-center'>Account of $debitor->name</h6>";
                $data .= "<h3 class='text-center'>Debitor Reports</h6><p class='text-center'>From ($from) to ($to)</p>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th class="text-success">Income</th>';
                $data .= ' <th class="text-danger">Ouggoing</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $journal = DebitorJournal::whereBetween('date', [$from, $to])->where('currency_id', $currency_id)->orderBy('id', 'desc')->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';

                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="">Income</th>';
                $data .= '<th colspan="">Ouggoing</th>';
                $data .= '<th colspan="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $data .= '<td>' . $journal->sum('income') . '</td>';
                $data .= '<td>' . $journal->sum('outgoing') . '</td>';
                $data .= '<td>';
                $data .= $journal->sum('income') - $journal->sum('outgoing');
                $data .= '</td>';
                $data .= '</tr>';
                $data .= '</table>';
            }
        }


        return $data;
    }

    public function balancesheet_show()
    {
        $debitors = DebitorAccount::all();
        $currency = Currency::all();
        return view('journals.debitor.balancesheet', compact('debitors', 'currency'));
    }

  
    public function filter_show()
    {
        $currency = Currency::all();
        $debitors = DebitorAccount::all();
        $filter = "page";
        return view('journals.debitor.filter', compact('currency', 'debitors', 'filter'));
    }

    public function filter_find(Request $request)
    {
        $currency = Currency::all();
        $debitors = DebitorAccount::all();
        if ($request->filter_id == 1) {
             $debetorJournal = DebitorJournal::Where('debitor_id', $request->debitor_id)->paginate(10);
        } else if ($request->filter_id == 2) {
            $debetorJournal = DebitorJournal::Where('currency_id', $request->currency_id)->paginate(10);
        } else if ($request->filter_id == 3) {
            $debetorJournal = DebitorJournal::Where('title', 'like', '%' . $request->title . '%')->paginate(10);
        } else if ($request->filter_id == 4) {
            $debetorJournal = DebitorJournal::Where('income', $request->income)->paginate(10);
        } else if ($request->filter_id == 5) {
            $debetorJournal = DebitorJournal::Where('outgoing', $request->outgoing)->paginate(10);
        } else {
            $debetorJournal = DebitorJournal::WhereBetween('date', [$request->fromDate, $request->toDate])->paginate(10);
        }
        return view('journals.debitor.index', compact('currency', 'debitors', 'debetorJournal'));
    }
}
