<?php

namespace App\Http\Controllers\journals;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ExpenseJournal;
use App\Models\ExpenseType;
use App\Models\Currency;
use App\Models\CashJournal;
use App\Models\Project;

class ExpenseJournalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $currency = Currency::all();
        $types = ExpenseType::all();
        $expenseJournal = ExpenseJournal::orderBy('id','desc')->paginate(10);
        return view('journals.expense.index', compact('expenseJournal', 'currency', 'types'));
    }

    public function create(){
        $projects = Project::orderBy('id','desc')->where('status','!=',3)->get();
        $currency = Currency::all();
        $types = ExpenseType::all();
        $expenseJournal = ExpenseJournal::orderBy('id','desc')->paginate(10);
        return view('journals.expense.create', compact('expenseJournal', 'currency', 'types','projects'));
    }
    public function balance()
    {
        $currency = Currency::all();
        $expenseJournal = ExpenseJournal::all();
        $types = ExpenseType::all();
        return view('journals.expense.balance', compact('expenseJournal', 'currency', 'types'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'required',
            'amount' => 'required',
            'currency' => 'required',
            'type_id' => 'required',
            'date' => 'required',
        ]);
        $expenseJournal = new ExpenseJournal();
        $expenseJournal->title = $request->title;
        $expenseJournal->amount = $request->amount;
        $expenseJournal->currency_id = $request->currency;
        $expenseJournal->project_id=$request->project_id;
        $expenseJournal->status = 1;
        $expenseJournal->c_target = $request->cash_id;
        $expenseJournal->type_id = $request->type_id;
        $expenseJournal->user_id = Auth()->user()->id;
        $expenseJournal->date = $request->date;
        $expenseJournal->details = $request->details;
        $isSaved = $expenseJournal->save();
        if ($isSaved) {
            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = $expenseJournal->title;
                $cash->date = $expenseJournal->date;
                $cash->outgoing = $expenseJournal->amount;
                $cash->currency_id = $expenseJournal->currency_id;
                $cash->ex_rate = $expenseJournal->ex_rate;
                $cash->module_id = 25;
                $cash->type_id = 25;
                $cash->module_record_id = $expenseJournal->id;
                $cash->details = "Cash Targer From Expense";
                $cash->save();
            }
            session()->flash("msg", "Success!");
            return redirect()->route('expense.index');
        }

    }
    public function edit($id)
    {
        $expenseJournal = ExpenseJournal::find($id);
        $currency = Currency::all();
        $types = ExpenseType::all();
        $projects = Project::orderBy('id','desc')->where('status','!=',3)->get();
        return view('journals.expense.edit', compact('expenseJournal', 'currency', 'types','projects'));

    }
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title' => 'required',
            'amount' => 'required',
            'currency' => 'required',
        ]);
        $expenseJournal = ExpenseJournal::find($id);
        $expenseJournal->title = $request->title;
        $expenseJournal->amount = $request->amount;
        $expenseJournal->currency_id = $request->currency;
        $expenseJournal->project_id=$request->project_id;
        $expenseJournal->type_id = $request->type_id;
        $expenseJournal->c_target = $request->cash_id;
        $expenseJournal->date = $request->date;
        $expenseJournal->details = $request->details;
        $isSaved = $expenseJournal->save();
        if ($isSaved) {
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 25)->where('module_record_id', $expenseJournal->id)->first();
                if ($cash != null) {
                    $cash->title = $expenseJournal->title;
                    $cash->date = $expenseJournal->date;
                    $cash->outgoing = $expenseJournal->amount;
                    $cash->currency_id = $expenseJournal->currency_id;
                    $cash->module_id = 25;
                    $cash->type_id = 25;
                    $cash->module_record_id = $expenseJournal->id;
                    $cash->details = "Cash Target From Expense";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $expenseJournal->title;
                    $cash->date = $expenseJournal->date;
                    $cash->outgoing = $expenseJournal->amount;
                    $cash->currency_id = $expenseJournal->currency_id;
                    $cash->module_id = 25;
                    $cash->type_id = 25;
                    $cash->module_record_id = $expenseJournal->id;
                    $cash->details = "Cash Target From Expense";
                    $cash->save();
                }
            }else{
                $cash = CashJournal::where('module_id', 25)->where('module_record_id', $expenseJournal->id)->delete();
            }
            session()->flash("msg", "Success!");
            return redirect()->route('expense.index');
        }
    }
    public function delete($id)
    {
        $expenseJournal = ExpenseJournal::find($id)->delete();
        session()->flash("msg", "Success!");
        $cash = CashJournal::where('module_id', 25)->where('module_record_id', $id)->delete();
        return redirect()->back();
    }

    public function report_show()
    {
        $currency = Currency::all();
        $types = ExpenseType::all();
        return view('journals.expense.report', compact('currency', 'types'));
    }

    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $data = '';
        $from = $request->fromDate;
        $to = $request->toDate;
        $currency_id = $request->currency_id;
        $type_id=$request->type_id;
        $type=ExpenseType::find($type_id);
        $currency=Currency::find($currency_id);


        if ($request->type_id == "all") {
            if ($currency_id == 'all') {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>From $from To $to</h6>";
                $data .= "<h6 style='text-align:center;'>All Types</h6>";
                $data .= "<h6 style='text-align:center;'>All Currency</h6>";
                $data .= "<h6 style='text-align:center;'>Expense Report</h6>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Type</th>';
                $data .= ' <th class="text-danger">Amount</th>';
                $data .= '<th>Details</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $journal = ExpenseJournal::whereBetween('date', [$from, $to])->orderBy('id', 'desc')->get();
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->type->title_en . "</td>";
                    $data .= "<td>" . $row->amount." ".$row->currency->title_en . "</td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="4" class="text-success">Amount</th>';

                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $journal_amount = ExpenseJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('amount');
                    $data .= '<td style="color:green;">' . $row->title_en . "/" . $journal_amount . '</td>';
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>From $from To $to</h6>";
                $data .= "<h6 style='text-align:center;'>All Types</h6>";
                $data .= "<h6 style='text-align:center;'>Currency $currency->title_en</h6>";
                $data .= "<h6 style='text-align:center;'>Expense Report</h6>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Type</th>';
                $data .= ' <th class="text-danger">Amount</th>';
                $data .= '<th>Details</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $journal = ExpenseJournal::whereBetween('date', [$from, $to])->where('currency_id', $currency_id)->orderBy('id', 'desc')->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->type->title_en . "</td>";
                    $data .= "<td>" . $row->amount." ".$row->currency->title_en."</td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="0" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="">Amount</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $data .= '<td>' . $journal->sum('amount') . '</td>';
                $data .= '</tr>';
                $data .= '</table>';

            }

        } else {
            if ($currency_id == 'all') {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>From $from To $to</h6>";
                $data .= "<h6 style='text-align:center;'>Type $type->title_en</h6>";
                $data .= "<h6 style='text-align:center;'>All Currencies</h6>";
                $data .= "<h6 style='text-align:center;'>Expense Report</h6>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= ' <th class="text-danger">Amount</th>';
                $data .= '<th>Details</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $journal = ExpenseJournal::whereBetween('date', [$from, $to])
                    ->where('type_id', $request->type_id)
                    ->orderBy('id', 'desc')
                    ->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="4" class="text-success">Amount</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $journal_amount = ExpenseJournal::where('currency_id', $row->id)
                        ->where('type_id', $request->type_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('amount');
                    $data .= '<td style="color:green;">' . $row->title_en . "/" . $journal_amount . '</td>';
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>From $from To $to</h6>";
                $data .= "<h6 style='text-align:center;'>Type $type->title_en</h6>";
                $data .= "<h6 style='text-align:center;'>Currency $currency->title_en</h6>";
                $data .= "<h6 style='text-align:center;'>Expense Report</h6>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= ' <th class="text-danger">Amount</th>';
                $data .= '<th>Details</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $journal = ExpenseJournal::whereBetween('date', [$from, $to])
                ->where('type_id', $request->type_id)
                ->where('currency_id', $currency_id)
                ->orderBy('id', 'desc')->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';

                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="0" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="">Amount</th>';

                $data .= ' </tr>';
                $data .= ' <tr>';
                $data .= '<td>' . $journal->sum('amount') . '</td>';

                $data .= '</tr>';
                $data .= '</table>';

            }

        }

        return $data;
    }

    public function filter_show()
    {
        $currency = Currency::all();
        $types = ExpenseType::all();
        $filter = "page";
        return view('journals.expense.filter', compact('currency', 'types', 'filter'));

    }

    public function filter_find(Request $request)
    {
        $currency = Currency::all();
        $types = ExpenseType::all();
        if ($request->filter_id == 1) {
            $expenseJournal = ExpenseJournal::Where('type_id', $request->type_id)->paginate(10);
        } else if ($request->filter_id == 2) {
            $expenseJournal = ExpenseJournal::Where('currency_id', $request->currency_id)->paginate(10);
        } else if ($request->filter_id == 3) {
            $expenseJournal = ExpenseJournal::Where('title', 'like', '%' . $request->title . '%')->paginate(10);
        } else if ($request->filter_id == 4) {
            $expenseJournal = ExpenseJournal::Where('amount', 'like', '%' . $request->credit . '%')->paginate(10);
        } else {
            $expenseJournal = ExpenseJournal::WhereBetween('date', [$request->fromDate, $request->toDate])->paginate(10);
        }
        return view('journals.expense.index', compact('currency', 'types', 'expenseJournal'));
    }
}
