<?php

namespace App\Http\Controllers\saleAdministration\singleCustomer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CustomerAdvance;
use App\Models\Currency;
use App\Models\Customer;

class SCustomerAdvanceController extends Controller
{
    public function index($id)
    {

        $data = CustomerAdvance::orderBy('id', 'desc')->paginate(10);
        $customer = Customer::find($id);
        $currencies = currency::all();
        return view('sale.customers.advances.index', compact('data', 'customer', 'currencies'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {

        $currencies = currency::all();
        $invoice_number = CustomerAdvance::orderBy('id', 'desc')->get()->first();
        $number = "";
        if ($invoice_number == "") {
            $number = $invoice_number = 1;
        } else {
            $number = $invoice_number->invoice_number + 1;
        }
        return view('sale.customers.advances.create', compact('id', 'currencies', 'number'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'invoice_number' => 'required',
            'date' => 'required',
            'currency_id' => 'required',
            'customer_id' => 'required',
        ]);
        $data = new CustomerAdvance();
        $data->title = $request->title;
        $data->invoice_number = $request->invoice_number;
        $data->amount = $request->amount;
        $data->date = $request->date;
        $data->currency_id = $request->currency_id;
        $data->ex_rate = $request->ex_rate;
        $data->customer_id = $request->customer_id;
        $data->details = $request->details;
        $data->save();
        return redirect()->route('customer_advance_single.index', $request->customer_id);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $currencies = currency::all();
        $data = CustomerAdvance::find($id);
        return view('sale.customers.advances.edit', compact('currencies', 'data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = CustomerAdvance::find($id);
        $data->title = $request->title;
        $data->invoice_number = $request->invoice_number;
        $data->amount = $request->amount;
        $data->date = $request->date;
        $data->currency_id = $request->currency_id;
        $data->ex_rate = $request->ex_rate;
        $data->customer_id = $request->customer_id;
        $data->details = $request->details;
        $data->save();
        return redirect()->route('customer_advance_single.index', $request->customer_id);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $data = CustomerAdvance::find($id);
        $data->delete();
        return back();
    }

    public function report_show($id)
    {
        $customer = Customer::find($id);
        $currencies = currency::all();
        return view('sale.customers.advances.report', compact('customer', 'currencies'));
    }
    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $customer_id = $request->customer_id;
        $currency_id = $request->currency_id;
        $Customer = Customer::find($customer_id);
        $currency = currency::find($currency_id);
        $data = "";
        if ($currency_id == "all") {
            $advances = CustomerAdvance::whereBetween('date', [$fDate, $tDate])->where('customer_id', $customer_id)->get();
            $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center;'>From $fDate To $tDate</h6>";
            $data .= "<h6 style='text-align:center;'>$Customer->name Advance Report</h6>";
            $data .= "<h6 style='text-align:center;'>Advance Report</h6>";
            $data .= "<h6 style='text-align:center;'>Print Date" . date('Y-M-d') . "</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>#</th>';
            $data .= '<th>Invoice_number</th>';
            $data .= '<th>Title</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>Advnace</th>';
            $data .= '<th>Details</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            foreach ($advances as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->invoice_number . "</td>";
                $data .= "<td>" . $row->title . "</td>";
                $data .= "<td>" . $row->date . "</td>";
                $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                $data .= "<td>" . $row->details . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
            }
            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '</table>';
            $data .= '<table class="">';
            $data .= ' <tr>';
            $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
            $data .= '<th colspan="4" class="">Advnace</th>';
            $data .= ' </tr>';
            $data .= ' <tr>';
            foreach (Currency::all() as $row) {
                $Advnace = CustomerAdvance::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->where('customer_id', $customer_id)->sum('amount');
                $data .= '<td style="">' . $row->title_en . "/" . $Advnace . '</td>';
            }
            $data .= '</tr>';
            $data .= '</table>';
        } else {
            $advances = CustomerAdvance::whereBetween('date', [$fDate, $tDate])->where('customer_id', $customer_id)->where('currency_id', $currency_id)->where('customer_id', $customer_id)->get();
            $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center;'>$Customer->name Advance Report</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
            $data .= "<h6 style='text-align:center;'>$currency->title_en currency</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>#</th>';
            $data .= '<th>Invoice_number</th>';
            $data .= '<th>Title</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>Advnace</th>';
            $data .= '<th>Details</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            foreach ($advances as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->invoice_number . "</td>";
                $data .= "<td>" . $row->title . "</td>";
                $data .= "<td>" . $row->date . "</td>";
                $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                $data .= "<td>" . $row->details . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
            }
            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '</table>';
            $data .= '<table class="">';
            $data .= ' <tr>';
            $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
            $data .= '<th colspan="4" class="">' . $advances->sum('amount') . '</th>';
            $data .= ' </tr>';

            $data .= '</table>';
        }

        return $data;
    }

    public function filter_find(Request $request)
    {
        if ($request->type_id == 1) {
            $data = CustomerAdvance::Where('invoice_number', 'like', "%" . $request->number . "%")
                ->where('customer_id', $request->customer_id)
                ->paginate(10);
        } else if ($request->type_id == 2) {
            $data = CustomerAdvance::Where('amount', 'like', "%" . $request->amount . "%")
                ->where('customer_id', $request->customer_id)
                ->paginate(10);
        } else if ($request->type_id == 3) {
            $data = CustomerAdvance::Where('title', 'like', "%" . $request->title . "%")
                ->where('customer_id', $request->customer_id)
                ->paginate(10);
        }
        $currencies = Currency::all();
        $customer = Customer::find($request->customer_id);
        return view('sale.customers.advances.filter', compact('data', 'customer', 'currencies'));

    }
}
