<?php

namespace App\Http\Controllers\saleAdministration\singleCustomer;

use App\Http\Controllers\Controller;
use App\Models\Currency;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\CustomerBill;
use App\Models\CustomerBillItem;
use App\Models\customerBillRowItem;
use App\Models\CustomerRecieved;
use App\Models\Scategory;
use App\Models\SSubCategory;
use App\Models\SUnit;
use App\Models\SWeight;
use App\Models\PCategory;
use App\Models\PUnit;
use App\Models\Stock;
use App\Models\CashJournal;
use App\Models\CustomerLiger;
use Auth;

class SCustomerBillController extends Controller
{
    public function index($id)
    {
        $customer = Customer::find($id);
        $bills = CustomerBill::where('customer_id', $id)->orderBy('id', 'desc')->paginate(10);
        return view('sale.customers.bills.index', compact('customer', 'bills'));
    }
    public function create($id)
    {
        $customer = Customer::find($id);
        $currencies = Currency::all();
        $invoice_number = CustomerBill::orderBy('id', 'desc')->get()->first();
        $number = "";
        if ($invoice_number == "") {
            $number = $invoice_number = 1;
        } else {
            $number = $invoice_number->invoice_number + 1;
        }
        return view('sale.customers.bills.bill-create', compact('customer', 'currencies', 'number'));
    }
    public function store(Request $request)
    {
        $request->validate([
            'date' => 'required',
            'invoice_number' => 'required',
            'customer_id' => 'required',
            'currency_id' => 'required',
            'title' => 'required',
        ]);
        $bill = new CustomerBill();
        $bill->invoice_date = $request->date;
        $bill->customer_id = $request->customer_id;
        $bill->currency_id = $request->currency_id;
        $bill->type_id = $request->type_id;
        $bill->ex_rate = $request->ex_rate;
        $bill->invoice_number = $request->invoice_number;
        $bill->title = $request->title;
        $bill->status = 0;
        $bill->user_id = Auth::user()->id;
        $date = date("Y-m-d");
        if (request()->hasFile('invoice_file')) {
            $filename = 'invoice_file-' . time() . '-' . request()->file('invoice_file')->getClientOriginalName();
            $path = request()->file('invoice_file')->storeAs('invoice_file/' . $date . '/', $filename, 'public');
        } else {
            $path = "invoice_file/noimage.jpg";
        }
        $bill->invoice_file = $path;
        $bill->save();
        if ($bill) {
            return redirect()->route('customer_single.bill_next', $bill->id);
        }
    }
    public function next($id)
    {
        $bill = CustomerBill::find($id);
        $bill_id = $bill->id;
        $customer_id = $bill->customer_id;
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $units = SUnit::all();
        $weights = SWeight::all();
        $bill_items = "";
        if ($bill->type_id == 1) {
            $bill_items = CustomerBillItem::where('bill_id', $bill_id)->orderBy('id', 'desc')->get();
        } else {
            $bill_items = customerBillRowItem::where('bill_id', $bill_id)->orderBy('id', 'desc')->get();
        }
        $pcategories = PCategory::all();
        $punits = PUnit::all();
        return view('sale.customers.bills.bill-create-next', compact('categories', 'subcategories', 'weights', 'units', 'bill_items', 'bill_id', 'customer_id', 'pcategories', 'punits', 'bill'));
    }

    public function next_store(Request $request)
    {
        $request->validate([
            'grand_total' => 'required',
            'bill_discount' => 'required',
            'received' => 'required',
        ]);
        $bill = CustomerBill::find($request->bill_id);
        $bill->grand_total = $request->grand_total;
        $bill->discount = $request->bill_discount;
        $final_amount = $request->grand_total - $request->bill_discount;
        $bill->final_amount = $final_amount;
        $bill->received = $request->received;
        if ($request->received == 0 || $request->received == null) {
            $bill->balance = $final_amount;
        } else {
            $bill->balance = $request->balance_value;
        }
        $bill->received_by = $request->received_by;
        $bill->transaction_id = $request->transaction_id;
        $bill->c_target = $request->cash_id;
        $bill->save();
        if ($bill) {

            if ($request->received != 0) {
                $recieved = new CustomerRecieved();
                $recieved->customer_id = $bill->customer_id;
                $recieved->currency_id = $bill->currency_id;
                $recieved->ex_rate = $bill->ex_rate;
                $recieved->bill_id = $bill->id;
                $recieved->details = "Recieved Amount is Added From " . $bill->invoice_number;
                $recieved->amount = $request->received;
                $recieved->recieved_number = $bill->invoice_number;
                $recieved->title = "from Bill " . $bill->invoice_number;
                $recieved->date = $bill->invoice_date;
                $recieved->status = 1;
                $recieved->save();


                if ($request->cash_id == 1) {
                    $cash = new CashJournal();
                    $cash->title = $bill->title . " Invoice" . $bill->invoice_number;
                    $cash->date = $bill->invoice_date;
                    $cash->income = $bill->received;
                    $cash->currency_id = $bill->currency_id;
                    $cash->ex_rate = $bill->ex_rate;
                    $cash->module_id = 19;
                    $cash->type_id = 19;
                    $cash->module_record_id = $bill->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Is Targeted From Bill Recieved";
                    $cash->save();
                }
            }
            $lidger = new CustomerLiger();
            $lidger->customer_id = $bill->customer_id;
            $lidger->currency_id = $bill->currency_id;
            $lidger->transaction_id = 1;
            $lidger->module_rid = $bill->id;
            $lidger->bill_total = $bill->final_amount;
            $lidger->amount = $bill->received;
            $lidger->bill_balance = $bill->final_amount - $bill->received;
            // here we find related customer balance 
            $previouse_balance = CustomerLiger::where('customer_id', $bill->customer_id)
                ->where('currency_id', $bill->currency_id)
                ->orderBy('id', 'desc')
                ->get()->first();
            $total_balance = 0;
            if ($previouse_balance) {
                $previouse_balance = $previouse_balance->total_balance;
                $total_balance = $previouse_balance + ($bill->final_amount - $bill->received);
            } else {
                $total_balance = $bill->final_amount - $bill->received;
            }
            $lidger->total_balance = $total_balance;
            $lidger->date = $bill->invoice_date;
            $lidger->save();
            session()->flash("msg", "Success!");
            return redirect()->route('customer_single.bill_index', $bill->customer_id);
        }


    }

    public function show($id)
    {
        $bill = CustomerBill::find($id);
        $bill_items = "";
        if ($bill->type_id == 1) {
            $bill_items = CustomerBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
        } else {
            $bill_items = customerBillRowItem::where('bill_id', $id)->orderBy('id', 'desc')->get();

        }
        $customer = Customer::find($bill->customer_id);
        return view('sale.customers.bills.show', compact('customer', 'bill', 'bill_items'));
    }
    public function edit($id)
    {
        $bill = CustomerBill::find($id);
        $bill_id = $id;
        $customer_id = $bill->customer_id;
        $customer = Customer::find($bill->customer_id);
        $bill_items = "";
        if ($bill->type_id == 1) {

            $bill_items = CustomerBillItem::where('bill_id', $bill_id)->orderBy('id', 'desc')->get();
        } else {
            $bill_items = customerBillRowItem::where('bill_id', $bill_id)->orderBy('id', 'desc')->get();
        }
        $pcategories = PCategory::all();
        $punits = PUnit::all();
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $units = SUnit::all();
        $weights = SWeight::all();
        $currencies = Currency::all();
        return view('sale.customers.bills.bill-edit', compact('customer', 'bill', 'bill_items', 'categories', 'subcategories', 'weights', 'units', 'currencies', 'bill_id', 'customer_id', 'pcategories', 'punits'));
    }
    public function update(Request $request, $id)
    {
        $request->validate([
            'grand_total' => 'required',
            'bill_discount' => 'required',
            'received' => 'required',
        ]);

        $bill = CustomerBill::find($id);
        $bill->customer_id = $request->customer_id;
        $bill->type_id = $request->type_id;
        $bill->invoice_date = $request->date;
        $bill->invoice_number = $request->invoice_number;
        $bill->title = $request->title;
        $bill->grand_total = $request->grand_total;
        $bill->discount = $request->bill_discount;
        $final_amount = $request->grand_total - $request->bill_discount;
        $bill->final_amount = $final_amount;
        $bill->received = $request->received;
        if ($request->received == 0 || $request->received == null) {
            $bill->balance = $final_amount;
        } else {
            $bill->balance = $request->balance_value;
        }
        $bill->received_by = $request->received_by;
        $bill->currency_id = $request->currency_id;
        $bill->transaction_id = $request->transaction_id;
        $bill->c_target = $request->cash_id;
        $date = date("Y-m-d");
        if (request()->hasFile('invoice_file')) {
            $filename = 'invoice_file-' . time() . '-' . request()->file('invoice_file')->getClientOriginalName();
            $path = request()->file('invoice_file')->storeAs('invoice_file/' . $date . '/', $filename, 'public');
        } else {
            $path = $bill->invoice_file;
        }
        $bill->invoice_file = $path;
        $bill->save();
        if ($bill) {
            $recieved_recieved_table = CustomerRecieved::where('customer_id', $bill->customer_id)->where('bill_id', $bill->id)->first();
            if ($recieved_recieved_table != null) {
                $recieved_recieved_table = CustomerRecieved::where('customer_id', $bill->customer_id)->where('bill_id', $bill->id)->delete();
                if ($request->received != 0) {
                    $recieved = new CustomerRecieved();
                    $recieved->customer_id = $bill->customer_id;
                    $recieved->currency_id = $bill->currency_id;
                    $recieved->ex_rate = $bill->ex_rate;
                    $recieved->bill_id = $bill->id;
                    $recieved->details = "Recieved Amount is Added From" . $bill->invoice_number;
                    $recieved->amount = $request->received;
                    $recieved->recieved_number = $bill->invoice_number;
                    $recieved->title = "from Bill " . $bill->invoice_number;
                    $recieved->date = $bill->invoice_date;
                    $recieved->status = 1;
                    $recieved->save();
                }
            } else {
                if ($request->received != 0) {
                    $recieved = new CustomerRecieved();
                    $recieved->customer_id = $bill->customer_id;
                    $recieved->currency_id = $bill->currency_id;
                    $recieved->bill_id = $bill->id;
                    $recieved->details = "Recieved Amount is Added From " . $bill->bill_no;
                    $recieved->amount = $request->received;
                    $recieved->recieved_number = $bill->invoice_number;
                    $recieved->date = $bill->invoice_date;
                    $recieved->status = 1;
                    $recieved->save();
                    // if($recieved){
                    //     $lidger=new CustomerLiger();
                    //     $lidger->customer_id = $bill->customer_id;
                    //     $lidger->currency_id = $bill->currency_id;
                    //     $lidger->transaction_id = 2;
                    //     $lidger->module_rid	 = $recieved->id;
                    //     $lidger->amount = $recieved->amount;
                    //     $lidger->date = $recieved->date;
                    //     $lidger->save();
                    // }
                }
            }
            $lidger = CustomerLiger::
                  where('module_rid', $bill->id)
                ->where('customer_id', $bill->customer_id)
                ->where('currency_id', $bill->currency_id)
                ->delete();
            //  then entry new item 
            if ($lidger) {
                $lidger = new CustomerLiger();
                $lidger->customer_id = $bill->customer_id;
                $lidger->currency_id = $bill->currency_id;
                $lidger->transaction_id = 1;
                $lidger->module_rid = $bill->id;
                $lidger->bill_total = $bill->final_amount;
                $lidger->amount = $bill->received;
                $lidger->bill_balance = $bill->final_amount - $bill->received;
                // here we find related customer balance 
                $previouse_balance = CustomerLiger::where('customer_id', $bill->customer_id)
                    ->where('currency_id', $bill->currency_id)
                    ->orderBy('id', 'desc')
                    ->get()->first();
                $total_balance = 0;
                if ($previouse_balance) {
                    $previouse_balance = $previouse_balance->total_balance;
                    $total_balance = $previouse_balance + ($bill->final_amount - $bill->received);
                } else {
                    $total_balance = $bill->final_amount - $bill->received;
                }
                $lidger->total_balance = $total_balance;
                $lidger->date = $bill->invoice_date;
                $lidger->save();
            }
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 19)->where('module_record_id', $bill->id)->first();
                if ($cash != null) {
                    $cash->title = $bill->title . " Invoice" . $bill->invoice_number;
                    $cash->date = $bill->invoice_date;
                    $cash->income = $bill->received;
                    $cash->currency_id = $bill->currency_id;
                    $cash->ex_rate = $bill->ex_rate;
                    $cash->module_id = 19;
                    $cash->type_id = 19;
                    $cash->module_record_id = $bill->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Is Targeted From Bill Recieved";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $bill->title . " Invoice" . $bill->invoice_number;
                    $cash->date = $bill->invoice_date;
                    $cash->income = $bill->received;
                    $cash->currency_id = $bill->currency_id;
                    $cash->module_id = 19;
                    $cash->type_id = 19;
                    $cash->module_record_id = $bill->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Is Targeted From Bill Recieved";
                    $cash->save();
                }
            } else {
                $cash = CashJournal::where('module_id', 19)->where('module_record_id', $bill->id)->delete();
            }
            session()->flash("msg", "Success!");
            return redirect()->route('customer_single.bill_index', $bill->customer_id);
        }
    }

    public function delete($id)
    {
        $bill = CustomerBill::find($id);
        $received = CustomerRecieved::where('customer_id', $bill->customer_id)->where('bill_id', $bill->id)->delete();
        $lidger = CustomerLiger::where('transaction_id', 1)
            ->where('module_rid', $bill->id)
            ->delete();
        $bill_items = CustomerBillItem::where('bill_id', $id)->get();
        if ($bill_items->count() != 0) {
            foreach ($bill_items as $row) {
                $stock = Stock::find($row->stock_id);
                $quantity = $stock->qty;
                $quantity = $quantity + $row->qty;
                $stock->qty = $quantity;
                $stock->save();
            }
            $bill_items = CustomerBillItem::where('bill_id', $id)->delete();
            $bill = CustomerBill::find($id)->delete();
        } else {
            $bill = CustomerBill::find($id)->delete();
        }

        session()->flash("msg", "Success Impact on Bill, Bill Items, Stock, Customer Recieved!");
        return back();

    }
    public function print($id)
    {
        $bill = CustomerBill::find($id);
        $bill_items = "";
        if ($bill->type_id == 1) {
            $bill_items = CustomerBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
        } else {
            $bill_items = customerBillRowItem::where('bill_id', $id)->orderBy('id', 'desc')->get();

        }
        $customer = Customer::find($bill->customer_id);
        $customer = Customer::find($bill->customer_id);
        $invoices = CustomerBill::where('customer_id', $customer->id)->where('currency_id', $bill->currency_id)->sum('final_amount');
        $received = CustomerRecieved::where('customer_id', $customer->id)->where('currency_id', $bill->currency_id)->sum('amount');

        $dev_rec = $received - $bill->received;
        $dev_sale = $invoices - $bill->final_amount;
        $dev_amount = $dev_sale - $dev_rec;
        $t_balance = $invoices - $received;

        return view('sale.customers.bills.print-bill', compact('bill', 'bill_items', 'customer', 't_balance', 'dev_amount'));

    }
    public function report_show($id)
    {
        $customer = Customer::find($id);
        $currencies = Currency::all();
        return view('sale.customers.bills.report', compact('customer', 'currencies'));
    }
    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $customer_id = $request->customer_id;
        $currency_id = $request->currency_id;
        $customer = Customer::find($customer_id);
        $currency = Currency::find($currency_id);
        $currencies = currency::all();
        $data = "";
        if ($request->type_id == "all") {
            if ($currency_id == "all") {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Sale Invoices Report</h6>";
                $data .= "<h6  style='text-align:center;'>Print " . date('Y-M-d') . "</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Invoice #</th>';
                $data .= '<th>title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Currency</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $customer_bill = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->orderBy('created_at', 'asc')->where('customer_id', $customer_id)->get();
                foreach ($customer_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->currency->title_en . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->received . "</td>";
                    $data .= "<td>" . $row->balance . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
                }


                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tbody>";
                $data .= ' <tr>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Total </th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Recieved</th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $total = $customer_bill->where('currency_id', $row->id)->where('customer_id', $customer_id)->sum('final_amount');
                    $data .= '<td>' . $row->title_en . " " . $total . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $recieved = $customer_bill->where('currency_id', $row->id)->where('customer_id', $customer_id)->sum('received');
                    $data .= '<td>' . $row->title_en . " " . $recieved . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $total = $customer_bill->where('currency_id', $row->id)->where('customer_id', $customer_id)->sum('final_amount');
                    $recieved = $customer_bill->where('currency_id', $row->id)->where('customer_id', $customer_id)->sum('received');
                    $balance = $total - $recieved;
                    $data .= '<td>' . $row->title_en . " " . $balance . '</td>';
                }
                $data .= '</tr>';
                $data .= "</tbody>";
                $data .= '</table>';

            } else {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Currency $currency->title_en</h6>";
                $data .= "<h6  style='text-align:center;'>Print " . date('Y-M-d') . "</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Invoice #</th>';
                $data .= '<th>title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $customer_bill = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->where('currency_id', $currency_id)->orderBy('created_at', 'asc')->where('customer_id', $customer_id)->get();
                foreach ($customer_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->received . "</td>";
                    $data .= "<td>" . $row->balance . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "<tr>";
                $data .= '<th rowspan="2">Overview</th>';
                $data .= '<th colspan="2">Total</th>';
                $data .= '<th colspan="2">Recieved</th>';
                $data .= '<th colspan="3">Belance</th>';
                $data .= "</tr>";
                $data .= "<tr>";

                $data .= '<th colspan="2">' . $customer_bill->sum('final_amount') . '</th>';
                $data .= '<th colspan="2">' . $customer_bill->sum('received') . '</th>';
                $balance = $customer_bill->sum('final_amount') - $customer_bill->sum('received');
                $data .= '<th colspan="3">' . $balance . '</th>';
                $data .= "</tr>";
                $data .= "</tbody>";
                $data .= '</table>';

            }
        } else {
            if ($currency_id == "all") {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Sale Invoices Report</h6>";
                $data .= "<h6  style='text-align:center;'>Print " . date('Y-M-d') . "</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Invoice #</th>';
                $data .= '<th>title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Currency</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $customer_bill = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->orderBy('created_at', 'asc')->where('customer_id', $customer_id)->where('type_id', $request->type_id)->get();
                foreach ($customer_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->currency->title_en . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->received . "</td>";
                    $data .= "<td>" . $row->balance . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tbody>";
                $data .= ' <tr>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Total </th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Recieved</th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $total = $customer_bill->where('currency_id', $row->id)->where('customer_id', $customer_id)->where('type_id', $request->type_id)->sum('final_amount');
                    $data .= '<td>' . $row->title_en . " " . $total . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $recieved = $customer_bill->where('currency_id', $row->id)->where('customer_id', $customer_id)->where('type_id', $request->type_id)->sum('received');
                    $data .= '<td>' . $row->title_en . " " . $recieved . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $total = $customer_bill->where('currency_id', $row->id)->where('customer_id', $customer_id)->where('type_id', $request->type_id)->sum('final_amount');
                    $recieved = $customer_bill->where('currency_id', $row->id)->where('customer_id', $customer_id)->where('type_id', $request->type_id)->sum('received');
                    $balance = $total - $recieved;
                    $data .= '<td>' . $row->title_en . " " . $balance . '</td>';
                }
                $data .= '</tr>';
                $data .= "</tbody>";
                $data .= '</table>';

            } else {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Currency $currency->title_en</h6>";
                $data .= "<h6  style='text-align:center;'>Print " . date('Y-M-d') . "</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Invoice #</th>';
                $data .= '<th>title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $customer_bill = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->where('currency_id', $currency_id)->orderBy('created_at', 'asc')->where('customer_id', $customer_id)->where('type_id', $request->type_id)->get();
                foreach ($customer_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->received . "</td>";
                    $data .= "<td>" . $row->balance . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "<tr>";
                $data .= '<th rowspan="2">Overview</th>';
                $data .= '<th colspan="2">Total</th>';
                $data .= '<th colspan="2">Recieved</th>';
                $data .= '<th colspan="3">Belance</th>';
                $data .= "</tr>";
                $data .= "<tr>";

                $data .= '<th colspan="2">' . $customer_bill->sum('final_amount') . '</th>';
                $data .= '<th colspan="2">' . $customer_bill->sum('received') . '</th>';
                $balance = $customer_bill->sum('final_amount') - $customer_bill->sum('received');
                $data .= '<th colspan="3">' . $balance . '</th>';

                $data .= "</tr>";

                $data .= "</tbody>";
                $data .= '</table>';

            }
        }

        return $data;
    }
    public function filter_find(Request $request)
    {
        $customer = Customer::find($request->customer_id);
        if ($request->type_id == 1) {

            $bills = CustomerBill::Where('invoice_number', $request->number)
                ->where('customer_id', $request->customer_id)
                ->get();
        } else if ($request->type_id == 2) {
            $bills = CustomerBill::Where('title', 'like', '%' . $request->title . '%')
                ->where('customer_id', $request->customer_id)
                ->get();
        } else {
            $bills = CustomerBill::WhereBetween('invoice_date', [$request->f_date, $request->t_date])
                ->where('customer_id', $request->customer_id)
                ->get();
        }
        return view('sale.customers.bills.filter', compact('customer', 'bills'));

    }

    public function reporting($id)
    {
        $customer = Customer::find($id);
        return view('sale.customers.single-reporting', compact('customer'));
    }
}
