<?php

namespace App\Http\Controllers\stockAdministration;

use App\Http\Controllers\Controller;
use App\Models\Project;
use Illuminate\Http\Request;
use App\Models\ProcessRowStock;
use App\Models\PurchaseStock;
use App\Models\PCategory;
use App\Models\PUnit;
use App\Models\Currency;
use Auth;

class RowStockProcessController extends Controller
{
    public function index()
    {
        $stock = ProcessRowStock::orderBy('id', 'desc')->paginate(10);
        $category = PCategory::all();
        $units = PUnit::all();
        return view('stock.row_stock_process.index', compact('stock', 'category', 'units'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = PCategory::all();
        $units = PUnit::all();
        $currencies = Currency::all();
        $projects=Project::orderBy('id','desc')->where('status','!=',3)->get();
        return view('stock.row_stock_process.create', compact('categories', 'units', 'currencies','projects'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'cat_id' => 'required',
            'unit_id' => 'required',
           
        ]);
        $stock = new ProcessRowStock();
        $stock->cat_id = $request->cat_id;
        $stock->unit_id = $request->unit_id;
        $stock->scat_id = $request->scat_id;
        $stock->project_id=$request->project_id;
        $stock->befor_used_qty = $request->c_qty;
        $stock->qty = $request->u_qty;
        $stock->province = $request->province;
        $stock->district = $request->district;
        $stock->valige = $request->valige;
        $stock->date = date('Y-m-d');
        $stock->user_id = Auth::user()->id;
        $stock->currency_id = $request->currency_id;
        $save = $stock->save();
        if ($save) {
            $stock = PurchaseStock::where('cat_id', $stock->cat_id)->where('scat_id',$stock->scat_id)->where('unit_id', $stock->unit_id)->first();
            $quantity = $stock->qty;
            $process = $quantity - $request->u_qty;
            $stock->qty = $process;
            $stock->save();

        }

        session()->flash("msg", "Success!");
        return redirect()->route('rstockprocess.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $categories = PCategory::all();
        $units = PUnit::all();
        $currencies = Currency::all();
        $data = ProcessRowStock::find($id);
        $projects=Project::orderBy('id','desc')->where('status','!=',3)->get();
        return view('stock.row_stock_process.edit', compact('categories', 'units', 'currencies', 'data','projects'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $stock = ProcessRowStock::find($id);
        $stock->cat_id = $request->cat_id;
        $stock->unit_id = $request->unit_id;
        $stock->scat_id = $request->scat_id;
        $stock->project_id=$request->project_id;
        $stock->befor_used_qty = $request->c_qty;
        $stock->qty = $request->u_qty;
        $stock->province = $request->province;
        $stock->district = $request->district;
        $stock->valige = $request->valige;
        $stock->date = date('Y-m-d');
        $stock->user_id = Auth::user()->id;
        $stock->currency_id = $request->currency_id;
        $save = $stock->save();
        if ($save) {
            $stock = PurchaseStock::where('cat_id', $stock->cat_id)->where('scat_id',$stock->scat_id)->where('unit_id', $stock->unit_id)->first();
            $quantity = $stock->qty;
            $process = $quantity - $request->u_qty;
            $stock->qty = $process;
            $stock->save();

        }
        session()->flash("msg", "Success!");
        return redirect()->route('rstockprocess.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $stock = ProcessRowStock::find($id)->delete();
        session()->flash("msg", "Success!");
        return back();

    }

    public function report_show()
    {
        $stock = ProcessRowStock::orderBy('id', 'desc')->paginate('20');
        $categories = PCategory::all();
        $units = PUnit::all();
        return view('stock.row_stock_process.report', compact('stock', 'categories', 'units'));

    }

    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $stock = ProcessRowStock::whereBetween('date',[$fromDate,$toDate])->get();
        $data = "";
        $data .= "<h6 class='text-center'>" . $bname . "</h6>";
        $data .= "<h6 class='text-center'>Used Row Material Report</h6>";
        $data .= '<table class="" id="table_style">';
        $data .= '<tr>';
        $data .= '<th>S-NO</th>';
        $data .= '<th>Category</th>';
        $data .= '<th>Unit</th>';
        $data .= '<th>Before Used</th>';
        $data .= '<th>Used Qty</th>';
        $data .= '<th>Current Availible</th>';
        $data .= '</tr>';
        $data .= '<tbody>';
        $i = 1;
        foreach ($stock as $row) {
            $data .= "<tr><td>" . $i . "</td>";
            $data .= "<td>" . $row->category->title_en . "</td>";
            $data .= "<td>" . $row->unit->title_en . "</td>";
            $data .= "<td>" . $row->befor_used_qty . "</td>";
            $data .= "<td>" . $row->qty . "</td>";
            $data .= "<td>" .($row->befor_used_qty-$row->qty) . "</td>";
            $i++;
        }
        if ($i == 1) {
            $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
        }
        $data .= "<tr>";
        $data .= '<th>Sub Total</th>';
        $data .= '<th>' . $stock->sum('qty') . '</th>';
        $data .= "</tr>";
        $data .= "</tbody>";
        $data .= '</table>';

        return $data;
    }

    public function filter_find(Request $request)
    {
        $category = PCategory::all();
        $units = PUnit::all();
        if ($request->type_id == 1) {
            $stock = ProcessRowStock::where('cat_id', $request->cat_id)->orderBy('id', 'desc')->get();
        }
        if ($request->type_id == 2) {
            $stock = ProcessRowStock::where('unit_id', $request->unit_id)->orderBy('id', 'desc')->get();
        }
        if ($request->type_id == 3) {
            $stock = ProcessRowStock::where('qty', '<=', $request->qty)->orderBy('id', 'desc')->get();
        }
        if ($request->type_id == 4) {
            $stock = ProcessRowStock::where('cpi', $request->cpi)->orderBy('id', 'desc')->get();
        }
        if ($request->type_id == 5) {
            $stock = ProcessRowStock::where('spi', $request->spi)->orderBy('id', 'desc')->get();
        }
        return view('stock.row_stock_process.filter', compact('stock', 'category', 'units'));
    }
}
