<?php
namespace App\Http\Controllers\stockAdministration;

use App\Http\Controllers\Controller;
use HRTime\Unit;
use Illuminate\Http\Request;
use App\Models\CustomerBillItem;
use App\Models\StockHistory;
use App\Models\Scategory;
use App\Models\SSubCategory;
use App\Models\SWeight;
use App\Models\SUnit;
use App\Models\Stock;
use App\Models\StockLocation;
use App\Models\Currency;
use PDF;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redis;


class StockController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */



    public function index()
    {
        $stock = Stock::orderBy('id', 'desc')->paginate(10);
        $location = StockLocation::all();
        $category = Scategory::all();
        $sub_category = SSubCategory::all();
        $weights = SWeight::all();
        $units = SUnit::all();
        return view('stock.index', compact('stock', 'location', 'category', 'sub_category', 'weights', 'units'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $weights = SWeight::all();
        $units = SUnit::all();
        $location = StockLocation::all();
        $currencies = Currency::all();
        return view('stock.create', compact('categories', 'subcategories', 'weights', 'units', 'location', 'currencies'));

    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'category_id' => 'required',
            'subcategory_id' => 'required',
            'unit_id' => 'required',
            'weight_id' => 'required',
            'qty' => 'required',
            'cost_price' => 'required',
            'sale_price' => 'required',
        ]);
        $stock = Stock::where('cat_id', $request->category_id)
            ->where('sub_cat_id', $request->subcategory_id)
            ->where('unit_id', $request->unit_id)
            ->where('weight_id', $request->weight_id)
            ->count();
        if ($stock == 0) {
            $stock = new Stock();
            $stock->cat_id = $request->category_id;
            $stock->sub_cat_id = $request->subcategory_id;
            $stock->unit_id = $request->unit_id;
            $stock->weight_id = $request->weight_id;
            $stock->location_id = $request->location_id;
            $stock->qty = $request->qty;
            $stock->cpi = $request->cost_price;
            $stock->spi = $request->sale_price;
            $stock->currency_id = $request->currency_id;
            $stock->status = 0;
            $stock->date = date("Y-m-d");
            $stock->user_id = Auth::guard('web')->user()->id;
            $stock->save();
        } else {
            $stock = Stock::where('cat_id', $request->category_id)
                ->where('sub_cat_id', $request->subcategory_id)
                ->where('unit_id', $request->unit_id)
                ->where('weight_id', $request->weight_id)->first();
            $stock = Stock::find($stock->id);
            $qty = $stock->qty + $request->qty;
            $stock->qty = $qty;
            $save = $stock->save();
        }

        $stock = new StockHistory();
        $stock->cat_id = $request->category_id;
        $stock->sub_cat_id = $request->subcategory_id;
        $stock->unit_id = $request->unit_id;
        $stock->weight_id = $request->weight_id;
        $stock->location_id = $request->location_id;
        $stock->qty = $request->qty;
        $stock->cpi = $request->cost_price;
        $stock->spi = $request->sale_price;
        $stock->currency_id = $request->currency_id;
        $stock->status = 0;
        $stock->date = date("Y-m-d");
        $stock->user_id = Auth::guard('web')->user()->id;
        $stock->save();
        session()->flash("msg", "Success!");
        return redirect()->route('stocks.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $weights = SWeight::all();
        $units = SUnit::all();
        $data = Stock::find($id);
        $location = StockLocation::all();
        $currencies = Currency::all();
        return view('stock.edit', compact('categories', 'subcategories', 'weights', 'units', 'data', 'location', 'currencies'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'category_id' => 'required',
            'subcategory_id' => 'required',
            'unit_id' => 'required',
            'weight_id' => 'required',
            'qty' => 'required',
            'cost_price' => 'required',
            'sale_price' => 'required',
        ]);
        $stock = Stock::find($id);
        $stock->cat_id = $request->category_id;
        $stock->sub_cat_id = $request->subcategory_id;
        $stock->unit_id = $request->unit_id;
        $stock->weight_id = $request->weight_id;
        $stock->location_id = $request->location_id;
        $stock->qty = $request->qty;
        $stock->cpi = $request->cost_price;
        $stock->spi = $request->sale_price;
        $stock->currency_id = $request->currency_id;
        $stock->status = 0;
        $stock->date = date("Y-m-d");
        $stock->user_id = Auth::guard('web')->user()->id;
        $stock->save();
        session()->flash("msg", "Success!");
        return redirect()->route('stocks.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        Stock::find($id)->delete();
        return back()->with('msg', 'Success');
    }
    public function warning_page()
    {
        $stock = Stock::orderBy('id', 'desc')->where('qty', '<=', 5)->paginate(20);
        $location = StockLocation::all();
        $category = Scategory::all();
        $sub_category = SSubCategory::all();
        $weights = SWeight::all();
        $units = SUnit::all();
        return view('stock.warning', compact('stock','location','category','sub_category','weights','units'));
    }
    public function in_stock_page()
    {
        $stock = StockHistory::where('date', date('Y-m-d'))->get();
        return view('stock.in-history', compact('stock'));
    }

    public function out_stock_page()
    {
        $stock = CustomerBillItem::where('date', date('Y-m-d'))->get();
        return view('stock.out-history', compact('stock'));
    }

    public function check_stock(Request $request)
    {
        $unit_id = $request->unit_id;
        $cat_id = $request->cat_id;
        $p_category_type_id = $request->p_sub_category_id;
        $weight_id = $request->wieight_id;
        $stock_qty = Stock::where('cat_id', $cat_id)
            ->where('p_category_type_id', $p_category_type_id)
            ->where('unit_id', $unit_id)
            ->where('wieight_id', $weight_id)->sum('qty');
        return $stock_qty;
    }

    public function report_show()
    {
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $weights = SWeight::all();
        $units = SUnit::all();
        $location=StockLocation::all();
        return view('stock.report', compact('categories', 'subcategories', 'weights', 'units','location'));
    }

    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $category = $request->category_id;
        $unit_id = $request->unit_id;
        $weight_id = $request->weight_id;
        $type = $request->type_id;
        $location_id=$request->location_id;
        $data = "";
        if ($type == 1) {
            $data .= "<h6 class='text-center'>" . $bname . "</h6>";
            if ($category == "all") {
                $data .= "<h6 class='text-center'>Stock Report</h6><p class='text-center'><strong>All Avalible Stock</strong>";
                $stock = Stock::orderBy('date', 'asc')->get();
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Cats</th>';
                $data .= '<th>S-Cats</th>';
                $data .= '<th>Unit</th>';
                $data .= '<th>Wieght</th>';
                $data .= '<th>QTY</th>';
                $data .= '<th>CPI</th>';
                $data .= '<th>SPI</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $t_cpi = 0;
                $t_spi = 0;
                foreach ($stock as $row) {
                    $t_cpi = $row->cpi * $row->qty + $t_cpi;
                    $t_spi = $row->spi * $row->qty + $t_spi;
                    $profit = $t_spi - $t_cpi;

                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->category->title_en . "</td>";
                    $data .= "<td>" . $row->sub_category->title_en . "</td>";
                    $data .= "<td>" . $row->unit->title_en . "</td>";
                    $data .= "<td>" . $row->weight->title_en . "</td>";
                    $data .= "<td>" . $row->qty . "</td>";
                    $data .= "<td>" . $row->cpi . "</td>";
                    $data .= "<td>" . $row->spi . "</td>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "<tr>";
                $data .= '<th colspan="2">Total QTY</th>';
                $data .= '<th colspan="2">Total Cost Price</th>';
                $data .= '<th colspan="2">Total Sale Price</th>';
                $data .= '<th colspan="2">Profit</th>';

                $data .= "</tr>";
                $data .= "<tr>";
                $data .= '<th colspan="2">' . $stock->sum('qty') . '</th>';
                $data .= '<th colspan="2">' . $t_cpi . '</th>';
                $data .= '<th colspan="2">' . $t_spi . '</th>';
                $data .= '<th colspan="2">' . $profit . '</th>';
                $data .= "</tr>";
                $data .= "</tbody>";
                $data .= '</table>';

            } else {
                $category_name = Scategory::find($category)->title_en;
                $data .= "<h6 class='text-center'>Stock Report</h6><p class='text-center'><strong>Avalible in $category_name Category</strong>";
                $stock = Stock::where('cat_id', $category)->get();
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Cats</th>';
                $data .= '<th>S-Cats</th>';
                $data .= '<th>Unit</th>';
                $data .= '<th>Wieght</th>';
                $data .= '<th>QTY</th>';
                $data .= '<th>CPI</th>';
                $data .= '<th>SPI</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $t_cpi = 0;
                $t_spi = 0;
                foreach ($stock as $row) {
                    $t_cpi = $row->cpi * $row->qty + $t_cpi;
                    $t_spi = $row->spi * $row->qty + $t_spi;
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->category->title_en . "</td>";
                    $data .= "<td>" . $row->sub_category->title_en . "</td>";
                    $data .= "<td>" . $row->unit->title_en . "</td>";
                    $data .= "<td>" . $row->weight->title_en . "</td>";
                    $data .= "<td>" . $row->qty . "</td>";
                    $data .= "<td>" . $row->cpi . "</td>";
                    $data .= "<td>" . $row->spi . "</td>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "<tr>";
                $data .= '<th colspan="2">Total QTY</th>';
                $data .= '<th colspan="2">Total Cost Price</th>';
                $data .= '<th colspan="2">Total Sale Price</th>';
                $data .= '<th colspan="2">Profit</th>';

                $data .= "</tr>";
                $data .= "<tr>";
                $data .= '<th colspan="2">' . $stock->sum('qty') . '</th>';
                $data .= '<th colspan="2">' . $t_cpi . '</th>';
                $data .= '<th colspan="2">' . $t_spi . '</th>';
                $data .= '<th colspan="2">' . ($t_spi - $t_cpi) . '</th>';


                $data .= "</tr>";
                $data .= "</tbody>";
                $data .= '</table>';

            }
        }
        if ($type == 2) {
            if ($unit_id == "all") {
                $stock = Stock::orderBy('date', 'asc')->get();
                $data .= "<h6 class='text-center'>Stock Report</h6><p class='text-center'> <strong>All Unit Types</strong>";
            } else {
                $stock = Stock::orderBy('date', 'asc')->where('unit_id', $unit_id)->get();
                $units = SUnit::find($unit_id)->title_en;
                $data .= "<h6 class='text-center'>Stock Report</h6><p class='text-center'> <strong>$units Unit Types</strong>";

            }
            $data .= "<h6 class='text-center'>" . $bname . "</h6>";
            $data .= "<h6 class='text-center'>Stock Report</h6><p class='text-center'> <strong>Unit Types</strong>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>S-NO</th>';
            $data .= '<th>Cats</th>';
            $data .= '<th>S-Cats</th>';
            $data .= '<th>Unit</th>';
            $data .= '<th>Wieght</th>';
            $data .= '<th>QTY</th>';
            $data .= '<th>CPI</th>';
            $data .= '<th>SPI</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $t_cpi = 0;
            $t_spi = 0;
            foreach ($stock as $row) {
                $t_cpi = $row->cpi * $row->qty + $t_cpi;
                $t_spi = $row->spi * $row->qty + $t_spi;
                $data .= "<tr><td>" . $i . "</td>";
                $data .= "<td>" . $row->category->title_en . "</td>";
                $data .= "<td>" . $row->sub_category->title_en . "</td>";
                $data .= "<td>" . $row->unit->title_en . "</td>";
                $data .= "<td>" . $row->weight->title_en . "</td>";
                $data .= "<td>" . $row->qty . "</td>";
                $data .= "<td>" . $row->cpi . "</td>";
                $data .= "<td>" . $row->spi . "</td>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
            }
            $data .= "<tr>";
            $data .= '<th colspan="2">Total QTY</th>';
            $data .= '<th colspan="2">Total Cost Price</th>';
            $data .= '<th colspan="2">Total Sale Price</th>';
            $data .= '<th colspan="2">Profit</th>';

            $data .= "</tr>";
            $data .= "<tr>";
            $data .= '<th colspan="2">' . $stock->sum('qty') . '</th>';
            $data .= '<th colspan="2">' . $t_cpi . '</th>';
            $data .= '<th colspan="2">' . $t_spi . '</th>';
            $data .= '<th colspan="2">' . ($t_spi-$t_cpi) . '</th>';
            $data .= "</tbody>";

            $data .= '</table>';
        }
        if ($type == 3) {
            if ($weight_id == "all") {
                $stock = Stock::orderBy('date', 'asc')->get();
                $data .= "<h6 class='text-center'>Stock Report</h6><p class='text-center'></p> <strong>All Weight Types</strong>";
            } else {
                $stock = Stock::orderBy('date', 'asc')->where('weight_id', $weight_id)->get();
                $weight = SWeight::find($weight_id)->title_en;
                $data .= "<h6 class='text-center'>Stock Report</h6><p class='text-center'></p> <strong>$weight Avalible in stock</strong>";
            }
            $data .= "<h6 class='text-center'>" . $bname . "</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>S-NO</th>';
            $data .= '<th>Cats</th>';
            $data .= '<th>S-Cats</th>';
            $data .= '<th>Unit</th>';
            $data .= '<th>Wieght</th>';
            $data .= '<th>QTY</th>';
            $data .= '<th>CPI</th>';
            $data .= '<th>SPI</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $t_cpi = 0;
            $t_spi = 0;
            foreach ($stock as $row) {
                $t_cpi = $row->cpi * $row->qty + $t_cpi;
                $t_spi = $row->spi * $row->qty + $t_spi;
                
                $data .= "<tr><td>" . $i . "</td>";
                $data .= "<td>" . $row->category->title_en . "</td>";
                $data .= "<td>" . $row->sub_category->title_en . "</td>";
                $data .= "<td>" . $row->unit->title_en . "</td>";
                $data .= "<td>" . $row->weight->title_en . "</td>";
                $data .= "<td>" . $row->qty . "</td>";
                $data .= "<td>" . $row->cpi . "</td>";
                $data .= "<td>" . $row->spi . "</td>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
            }
            $data .= "<tr>";
            $data .= '<th colspan="2">Total QTY</th>';
            $data .= '<th colspan="2">Total Cost Price</th>';
            $data .= '<th colspan="2">Total Sale Price</th>';
            $data .= '<th colspan="2">Profit</th>';

            $data .= "</tr>";
            $data .= "<tr>";
            $data .= '<th colspan="2">' . $stock->sum('qty') . '</th>';
            $data .= '<th colspan="2">' . $t_cpi . '</th>';
            $data .= '<th colspan="2">' . $t_spi . '</th>';
            $data .= '<th colspan="2">' . ($t_spi-$t_cpi) . '</th>';
            $data .= "</tbody>";

            $data .= '</table>';
        }
        if ($type == 4) {
            if ($location_id == "all") {
                $stock = Stock::orderBy('date', 'asc')->get();
                $data .= "<h6 class='text-center'>Stock Report</h6><p class='text-center'></p> <strong>In All Location</strong>";
            } else {
                $stock = Stock::orderBy('date', 'asc')->where('location_id', $location_id)->get();
                $location = StockLocation::find($location_id)->title_en;
                $data .= "<h6 class='text-center'>Stock Report</h6><p class='text-center'></p> <strong>$location Avalible in stock</strong>";
            }
            $data .= "<h6 class='text-center'>" . $bname . "</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>S-NO</th>';
            $data .= '<th>Cats</th>';
            $data .= '<th>S-Cats</th>';
            $data .= '<th>Unit</th>';
            $data .= '<th>Wieght</th>';
            $data .= '<th>QTY</th>';
            $data .= '<th>CPI</th>';
            $data .= '<th>SPI</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $t_cpi = 0;
            $t_spi = 0;
            foreach ($stock as $row) {
                $t_cpi = $row->cpi * $row->qty + $t_cpi;
                $t_spi = $row->spi * $row->qty + $t_spi;
                
                $data .= "<tr><td>" . $i . "</td>";
                $data .= "<td>" . $row->category->title_en . "</td>";
                $data .= "<td>" . $row->sub_category->title_en . "</td>";
                $data .= "<td>" . $row->unit->title_en . "</td>";
                $data .= "<td>" . $row->weight->title_en . "</td>";
                $data .= "<td>" . $row->qty . "</td>";
                $data .= "<td>" . $row->cpi . "</td>";
                $data .= "<td>" . $row->spi . "</td>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
            }
            $data .= "<tr>";
            $data .= '<th colspan="2">Total QTY</th>';
            $data .= '<th colspan="2">Total Cost Price</th>';
            $data .= '<th colspan="2">Total Sale Price</th>';
            $data .= '<th colspan="2">Profit</th>';

            $data .= "</tr>";
            $data .= "<tr>";
            $data .= '<th colspan="2">' . $stock->sum('qty') . '</th>';
            $data .= '<th colspan="2">' . $t_cpi . '</th>';
            $data .= '<th colspan="2">' . $t_spi . '</th>';
            $data .= '<th colspan="2">' . ($t_spi-$t_cpi) . '</th>';
            $data .= "</tbody>";

            $data .= '</table>';
        }
        if ($type == 5) {
            $categories = Scategory::all();
            $weights = SWeight::all();
            $track=Stock::all();
            $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
            $data .= "<h6 style='text-align:center;'>Stocks Report</h6>";
            $data .= "<h6 style='text-align:center;'>All Categories </h6>";
            foreach ($categories as $cat_row) {
                $data .= '<table class="" id="table_style">';
                $data .= '<tr><th colspan="' . $weights->count() . '">' . $cat_row->title_ps . '</th></tr>';
                foreach ($weights as $w_row) {
                    $data .= '<th>' . $w_row->title_ps . "<br>" . $track->where('cat_id', $cat_row->id)->where('weight_id', $w_row->id)->sum('qty') . '</th>';

                }
                $data .= '</table>';
            }
            $data .= "<h2 style='text-align:center;'>Total</h2>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            foreach ($weights as $w_row) {
                $data .= '<th style="background:#000; color:#fff;">' . $w_row->title_ps . "<br>" . $track->where('weight_id', $w_row->id)->sum('qty') . '</th>';

            }
            $data .= '</tr>';
            $data .= '</table>';
        }
        return $data;
    }

    public function filter_show()
    {
        $p_category = Scategory::all();
        $p_sub_category = SSubCategory::all();
        $weights = SWeight::all();
        $units = SUnit::all();
        $stock = Stock::orderBy('id', 'desc')->limit('20')->paginate('10');
        $filter = "";
        return view('stock.filter', compact('p_category', 'p_sub_category', 'weights', 'units', 'stock', 'filter'));
    }

    public function filter_find(Request $request)
    {

        $location = StockLocation::all();
        $category = Scategory::all();
        $sub_category = SSubCategory::all();
        $weights = SWeight::all();
        $units = SUnit::all();
        if ($request->type_id == 1) {
            $stock = Stock::where('cat_id', $request->cat_id)->paginate();
        }
        if ($request->type_id == 2) {
            $stock = Stock::where('cat_id', $request->cat_id)->where('sub_cat_id', $request->sub_cat_id)->paginate();
        }
        if ($request->type_id == 3) {
            $stock = Stock::where('unit_id', $request->unit_id)->paginate();

        }
        if ($request->type_id == 4) {
            $stock = Stock::where('weight_id', $request->weight_id)->get();
        }

        if ($request->type_id == 5) {
            $stock = Stock::where('qty', '<=', $request->qty)->get();
        }
        if ($request->type_id == 6) {
            $stock = Stock::where('cpi', $request->cpi)->get();
        }
        if ($request->type_id == 7) {
            $stock = Stock::where('spi', $request->spi)->get();
        }
        if ($request->type_id == 8) {
            $stock = Stock::where('location_id', $request->location)->get();
        }
        return view('stock.filter', compact('stock', 'location', 'category', 'sub_category', 'weights', 'units'));
    }

    public function stock_barcode($id){
        $stock = Stock::find($id);
        $sale_price = $stock->spi;
        $quantity = $stock->qty;
        $code = $stock->cpi;
        PDF::SetFont('helvetica', '', 6);
        $style = array(
            'position' => '',
            'align' => 'C',
            'stretch' => false,
            'fitwidth' => true,
            'cellfitalign' => '',
            'border' => false, // border
            'hpadding' => 'auto',
            'vpadding' => 'auto',
            'fgcolor' => array(0, 0, 0),
            'bgcolor' => false, //array(255,255,255),
                     'text' => false, // whether to display the text below the barcode
                     'font' => 'helvetica', //font
                     'fontsize' => 6, //font size
            'stretchtext' => 6
        );

        $x = 0;
        $y = 1;
        $height = 20;
        $width = 20;
    
        $html_content = '<h1>نمایش</h1>';
        $lg = Array();
        $lg['a_meta_charset'] = 'UTF-8';
        $lg['a_meta_dir'] = '';
        $lg['a_meta_language'] = 'en';
        $lg['w_page'] = 'page';
        PDF::setTitle('sample PDF');
        PDF::setLanguageArray($lg);
        // PDF::SetFont('dejavusans', '', 12);
        PDF::addPage();
        PDF::writeHTML($quantity, true, false, true, false, '');
        $a=1;
        $b=1;
       
        for ($i=1; $i <= $quantity; $i++) { 
            
            if($a == 1){
                PDF::write2DBarcode($id . '- code#' . $code, 'QRCODE,H', $x, $y, $height, $width, $style, 'N');
            }
            else if($a == 2){
                PDF::write2DBarcode($id . '- code#' . $code, 'QRCODE,H', $x+20, $y, $height, $width, $style, 'N');
            }
            else if($a == 3){
                PDF::write2DBarcode($id . '- code#' . $code, 'QRCODE,H', $x+40, $y, $height, $width, $style, 'N');
            }
            else if($a == 4){
                PDF::write2DBarcode($id . '- code#' . $code, 'QRCODE,H', $x+60, $y, $height, $width, $style, 'N');
            }
            else if($a == 5){
                PDF::write2DBarcode($id . '- code#' . $code, 'QRCODE,H', $x+80, $y, $height, $width, $style, 'N');
            }
            else if($a == 6){
                PDF::write2DBarcode($id . '- code#' . $code, 'QRCODE,H', $x+100, $y, $height, $width, $style, 'N');
            }
            else if($a == 7){
                PDF::write2DBarcode($id . '- code#' . $code, 'QRCODE,H', $x+120, $y, $height, $width, $style, 'N');
            }
            else if($a == 8){
                PDF::write2DBarcode($id . '- code#' . $code, 'QRCODE,H', $x+140, $y, $height, $width, $style, 'N');
            }
            else if($a == 9){
                PDF::write2DBarcode($id . '- code#' . $code, 'QRCODE,H', $x+160, $y, $height, $width, $style, 'N');
            }
            else if($a == 10){
                PDF::write2DBarcode($id . '- code#' . $code, 'QRCODE,H', $x+180, $y, $height, $width, $style, 'N');
            }
            else if($a == 10){
                PDF::write2DBarcode($id . '- code#' . $code, 'QRCODE,H', $x+180, $y, $height, $width, $style, 'N');
            }
            
            $a++;
            $b++;
            
            if($a==11){
                $a = 1;
                $y = $y+20;
            }
            if($b==131){
                $b=1;
                PDF::addPage();
                $y = 1;
            }
            
        }
    
        PDF::Output('samplePDF.pdf');
    }



}
