<?php

namespace App\Http\Controllers\stockAdministration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Scategory;
use App\Models\SSubCategory;
use App\Models\SWeight;
use App\Models\SUnit;
use App\Models\Stock;
use App\Models\StockHistory;
use App\Models\StockLocation;
use App\Models\Currency;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redis;

class StockHistoryController extends Controller
{
    public function index()
    {
        $stock = StockHistory::orderBy('id', 'desc')->paginate(10);
        return view('stock.stock-history.index', compact('stock'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $weights = SWeight::all();
        $units = SUnit::all();
        $location=StockLocation::all();
        $currencies=Currency::all();
        return view('stock.stock-history.create', compact('categories', 'subcategories', 'weights', 'units','location','currencies'));

    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'category_id' => 'required',
            'subcategory_id' => 'required',
            'unit_id' => 'required',
            'weight_id' => 'required',
            'qty' => 'required',
            'cost_price' => 'required',
            'sale_price' => 'required',
        ]);
        $stock = new StockHistory();
        $stock->cat_id = $request->category_id;
        $stock->sub_cat_id = $request->subcategory_id;
        $stock->unit_id = $request->unit_id;
        $stock->weight_id = $request->weight_id;
        $stock->location_id=$request->location_id;
        $stock->qty = $request->qty;
        $stock->cpi = $request->cost_price;
        $stock->spi = $request->sale_price;
        $stock->currency_id = $request->currency_id;
        $stock->status = 0;
        $stock->date = date("Y-m-d");
        $stock->user_id = Auth::guard('web')->user()->id;
        $stock->save();
        session()->flash("msg", "Success!");
        return redirect()->route('stock_history.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $weights = SWeight::all();
        $units = SUnit::all();
        $data=StockHistory::find($id);
        $location=StockLocation::all();
        $currencies=Currency::all();
        return view('stock.stock-history.edit', compact('categories', 'subcategories', 'weights', 'units','data','location','currencies'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'category_id' => 'required',
            'subcategory_id' => 'required',
            'unit_id' => 'required',
            'weight_id' => 'required',
            'qty' => 'required',
            'cost_price' => 'required',
            'sale_price' => 'required',
        ]);
        $stock = StockHistory::find($id);
        $stock->cat_id = $request->category_id;
        $stock->sub_cat_id = $request->subcategory_id;
        $stock->unit_id = $request->unit_id;
        $stock->weight_id = $request->weight_id;
        $stock->location_id=$request->location_id;
        $stock->qty = $request->qty;
        $stock->cpi = $request->cost_price;
        $stock->spi = $request->sale_price;
        $stock->currency_id = $request->currency_id;
        $stock->status = 0;
        $stock->date = date("Y-m-d");
        $stock->user_id = Auth::guard('web')->user()->id;
        $stock->save();
        session()->flash("msg", "Success!");
        return redirect()->route('stock_history.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        StockHistory::find($id)->delete();
        return back()->with('msg', 'Success');
    }

    public function report_show()
    {
        $categories = Scategory::all();
        $subcategories = SSubCategory::all();
        $weights = SWeight::all();
        $units = SUnit::all();
        return view('stock.stock-history.report', compact('categories', 'subcategories', 'weights', 'units'));
    }

    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $category_id = $request->category_id;
        $weight_id = $request->weight_id;
        $unit_id = $request->unit_id;
        $type_id = $request->type_id;
        $category = Scategory::find($category_id);
        $categories = Scategory::all();
        $weight = SWeight::find($weight_id);
        $weights = SWeight::all();
        $unit = SUnit::find($unit_id);
        $units = SUnit::all();
        $track = StockHistory::whereBetween('date', [$fromDate, $toDate])->get();
        $data = "";
        if ($request->type_id == 1) {
            if ($category_id == "all") {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>Stock In History</h6>";
                $data .= "<h6 style='text-align:center;'>From $fromDate To $toDate</h6>";
                $data .= "<h6 style='text-align:center;'>Category Level</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<thead>';
                $data .= '<tr>';
                $data .= '<td>#</td>';
                $data .= '<td>Name</td>';
                $data .= '<td>Qty</td>';
                $data .= '</tr>';
                $data .= '</thead>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($categories as $row) {
                    $data .= "<tr>";
                    $data .= '<td>' . $i . '</td>';
                    $data .= '<td>' . $row->title_en . '</td>';
                    $data .= "<td>";
                    $data .= $track->where('cat_id', $row->id)->sum('qty');
                    $data .= "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                $data .= '</tbody>';
                $data .= '</table>';
            } else {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>Stock In History</h6>";
                $data .= "<h6 style='text-align:center;'>From $fromDate To $toDate</h6>";
                $data .= "<h6 style='text-align:center;'>Category Level</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<thead>';
                $data .= '<tr>';
                $data .= '<td>#</td>';
                $data .= '<td>Name</td>';
                $data .= '<td>Qty</td>';
                $data .= '</tr>';
                $data .= '</thead>';
                $data .= '<tbody>';
                $i = 1;
                    $data .= "<tr>";
                    $data .= '<td>' . $i . '</td>';
                    $data .= '<td>' . $category->title_en . '</td>';
                    $data .= "<td>";
                    $data .= $track->where('cat_id', $category->id)->sum('qty');
                    $data .= "</td>";
                    $data .= "</tr>";
                    $i++;
               
                $data .= '</tbody>';
                $data .= '</table>';
            }

        }
        if ($request->type_id == 2) {
            if($unit_id=="all"){
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>Stock In History</h6>";
                $data .= "<h6 style='text-align:center;'>From $fromDate To $toDate</h6>";
                $data .= "<h6 style='text-align:center;'>Units Level</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<thead>';
                $data .= '<tr>';
                $data .= '<td>#</td>';
                $data .= '<td>Name</td>';
                $data .= '<td>Qty</td>';
                $data .= '</tr>';
                $data .= '</thead>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($units as $row) {
                    $data .= "<tr>";
                    $data .= '<td>' . $i . '</td>';
                    $data .= '<td>' . $row->title_en . '</td>';
                    $data .= "<td>";
                    $data .= $track->where('unit_id', $row->id)->sum('qty');
                    $data .= "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                $data .= '</tbody>';
                $data .= '</table>';
            }else{
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>Stock In History</h6>";
                $data .= "<h6 style='text-align:center;'>From $fromDate To $toDate</h6>";
                $data .= "<h6 style='text-align:center;'>Units Level</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<thead>';
                $data .= '<tr>';
                $data .= '<td>#</td>';
                $data .= '<td>Name</td>';
                $data .= '<td>Qty</td>';
                $data .= '</tr>';
                $data .= '</thead>';
                $data .= '<tbody>';
                $i = 1;
              
                    $data .= "<tr>";
                    $data .= '<td>' . $i . '</td>';
                    $data .= '<td>' . $unit->title_en . '</td>';
                    $data .= "<td>";
                    $data .= $track->where('unit_id', $unit->id)->sum('qty');
                    $data .= "</td>";
                    $data .= "</tr>";
                    $i++;
                
                $data .= '</tbody>';
                $data .= '</table>';
            }

        }
        if ($request->type_id == 3) {
            if($weight_id=="all"){
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>Stock In History</h6>";
                $data .= "<h6 style='text-align:center;'>From $fromDate To $toDate</h6>";
                $data .= "<h6 style='text-align:center;'>Weights Level</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<thead>';
                $data .= '<tr>';
                $data .= '<td>#</td>';
                $data .= '<td>Name</td>';
                $data .= '<td>Qty</td>';
                $data .= '</tr>';
                $data .= '</thead>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($weights as $row) {
                    $data .= "<tr>";
                    $data .= '<td>' . $i . '</td>';
                    $data .= '<td>' . $row->title_en . '</td>';
                    $data .= "<td>";
                    $data .= $track->where('weight_id', $row->id)->sum('qty');
                    $data .= "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                $data .= '</tbody>';
                $data .= '</table>';
            }else{
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>Stock In History</h6>";
                $data .= "<h6 style='text-align:center;'>From $fromDate To $toDate</h6>";
                $data .= "<h6 style='text-align:center;'>Weights Level</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<thead>';
                $data .= '<tr>';
                $data .= '<td>#</td>';
                $data .= '<td>Name</td>';
                $data .= '<td>Qty</td>';
                $data .= '</tr>';
                $data .= '</thead>';
                $data .= '<tbody>';
                $i = 1;
               
                    $data .= "<tr>";
                    $data .= '<td>' . $i . '</td>';
                    $data .= '<td>' . $weight->title_en . '</td>';
                    $data .= "<td>";
                    $data .= $track->where('weight_id', $weight->id)->sum('qty');
                    $data .= "</td>";
                    $data .= "</tr>";
                    $i++;
             
                $data .= '</tbody>';
                $data .= '</table>';
            }

        }
        return $data;
    }



    public function add_to_stock($id)
    {
        $stock_history = StockHistory::find($id);
        $stock = Stock::where('cat_id', $stock_history->cat_id)
            ->where('sub_cat_id', $stock_history->scat_id)
            ->where('unit_id', $stock_history->unit_id)
            ->where('weight_id', $stock_history->weight_id)->count();
        if ($stock == 0) {
            $stock = new Stock();
            $stock->cat_id = $stock_history->cat_id;
            $stock->sub_cat_id = $stock_history->sub_cat_id;
            $stock->unit_id = $stock_history->unit_id;
            $stock->weight_id = $stock_history->weight_id;
            $stock->currency_id = $stock_history->currency_id;
            $stock->location_id = $stock_history->location_id;
            $stock->qty = $stock_history->qty;
            $stock->cpi = $stock_history->cpi;
            $stock->spi = $stock_history->spi;
            $stock->date = date('Y-m-d');
            $stock->user_id = Auth::user()->id;
            $save = $stock->save();
            if ($save) {
                $stock_history->status = 1;
                $stock_history->save();
            }
            session()->flash("msg", "success");
            return back();
        } else {
            $stock = Stock::where('cat_id', $stock_history->cat_id)
                ->where('sub_cat_id', $stock_history->scat_id)
                ->where('unit_id', $stock_history->unit_id)
                ->where('weight_id', $stock_history->weight_id)->get()->first();
            $stock = Stock::find($stock->id);
            $qty = $stock->qty + $stock_history->qty;
            $stock->qty = $qty;
            $save = $stock->save();
            if ($save) {
                $stock_history->status = 1;
                $stock_history->save();
            }
            session()->flash("msg", "success");
            return back();
        }

    }

}
