<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\PermissionsController;
use App\Http\Controllers\accounts\BankerAccountController;
use App\Http\Controllers\accounts\DebitorAccountController;
use App\Http\Controllers\accounts\InvestorController;



// fainance
use App\Http\Controllers\journals\CashJournalController;
use App\Http\Controllers\journals\ExpenseJournalController;
use App\Http\Controllers\journals\BankJournalController;
use App\Http\Controllers\journals\DebitorJournalController;
use App\Http\Controllers\journals\FixedAssetController;
use App\Http\Controllers\journals\InvestorJournalController;
use App\Http\Controllers\journals\InvestorInvestmentController;
use App\Http\Controllers\TaxController;


// sale multiple 
// use App\Http\Controllers\saleAdministration\CustomerController;
// use App\Http\Controllers\saleAdministration\CustomerBillController;
// use App\Http\Controllers\saleAdministration\CustomerRetailBillController;
// use App\Http\Controllers\saleAdministration\CustomerRecievedController;
// use App\Http\Controllers\saleAdministration\CustomerAdvanceController;
// use App\Http\Controllers\saleAdministration\CustomerReturnBillController;
// sale single 
// use App\Http\Controllers\saleAdministration\singleCustomer\SCustomerAdvanceController;
// use App\Http\Controllers\saleAdministration\singleCustomer\SCustomerBillController;
// use App\Http\Controllers\saleAdministration\singleCustomer\SCustomerRBillController;
// use App\Http\Controllers\saleAdministration\singleCustomer\SCustomerRecievedController;

// purchase single
use App\Http\Controllers\PurchaseAdministration\SupplierController;
use App\Http\Controllers\PurchaseAdministration\SupplierBillController;
use App\Http\Controllers\PurchaseAdministration\SupplierPaymentController;
use App\Http\Controllers\PurchaseAdministration\SupplierAdvanceController;

// purchase multiple 
use App\Http\Controllers\PurchaseAdministration\MSupplierBillController;
use App\Http\Controllers\PurchaseAdministration\MPaymentController;
use App\Http\Controllers\PurchaseAdministration\MSupplierAdvanceController;


// config
use App\Http\Controllers\configuration\CurrencyController;
// use App\Http\Controllers\configuration\SaleCategoriesController;
// use App\Http\Controllers\configuration\SaleScategoriesController;
// use App\Http\Controllers\configuration\SaleUnitController;
// use App\Http\Controllers\configuration\SaleWeightController;
use App\Http\Controllers\configuration\PurchaseCategoryController;
use App\Http\Controllers\configuration\PurchaseSubCategoryController;
use App\Http\Controllers\configuration\PurchaseUnitsController;

use App\Http\Controllers\configuration\cashTypeController;
use App\Http\Controllers\configuration\expenceTypeController;
use App\Http\Controllers\configuration\ExchangeProcessController;
use App\Http\Controllers\configuration\InfoController;
// stock
use App\Http\Controllers\stockAdministration\StockController;
use App\Http\Controllers\stockAdministration\StockHistoryController;
use App\Http\Controllers\stockAdministration\RowMaterialStockController;
use App\Http\Controllers\stockAdministration\StockTransactionController;
use App\Http\Controllers\stockAdministration\RowStockProcessController;


// HR
use App\Http\Controllers\HR\EmployeeController;
use App\Http\Controllers\HR\EmployeeAdvanceController;
use App\Http\Controllers\HR\EmployeeOvertimeController;
use App\Http\Controllers\HR\EmployeeSalariesController;
// multiple 
use App\Http\Controllers\HR\EmployeeAttendanceController;
use App\Http\Controllers\HR\multiple\EmpAdvanceController;
use App\Http\Controllers\HR\multiple\EmpOvertimeController;
use App\Http\Controllers\HR\multiple\EmpSalaryController;

// archive working 
use App\Http\Controllers\Archive\ArchiveController;
// project working 
use App\Http\Controllers\Project\ProjectController;
use App\Http\Controllers\Project\ProjectPurchaseController;
use App\Http\Controllers\Project\ProjectPurchasePaymentController;
use App\Http\Controllers\Vehicle\VehicleActivityController;
use App\Http\Controllers\Vehicle\VehicleRentController;
use App\Http\Controllers\AjaxController;

Route::get('/link', function () {
    Artisan::call('storage:link');
});
Route::get('/clear', function () {
    Artisan::call('optimize:clear');
});

Route::get('language/{lang}', function($lang){
    \Session::put('locale',$lang);
    return redirect()->back();
});


Route::middleware('auth')->group(function () {
    Route::prefix('user')->group(function () {
        Route::get('dashboard', [HomeController::class, 'dashboard'])->name('dashboard.dashboard');
        Route::get('reporting', [HomeController::class, 'reporting'])->name('reporting.reporting');
        Route::get('chart-of-accounts/show', [HomeController::class, 'chart_of_accounts_show'])->name('reporting.chart_of_account_show');
        Route::get('chart-of-accounts/find', [HomeController::class, 'chart_of_accounts_find'])->name('reporting.chart_of_account_find');
        Route::get('chart-of-accounts/asset/ar-details', [HomeController::class, 'coa_asset_ar'])->name('reporting.coa_asset_ar');
        Route::get('chart-of-accounts/asset/emp_advance-details/{f_t_date}', [HomeController::class, 'coa_asset_emp_advance'])->name('reporting.coa_emp_advance');
        Route::get('chart-of-accounts/asset/cash-details', [HomeController::class, 'coa_asset_cash'])->name('reporting.coa_asset_cash');
        Route::get('chart-of-accounts/asset/emp_advance-details', [HomeController::class, 'coa_asset_emp_advance'])->name('reporting.coa_asset_emp_advance');
        Route::get('chart-of-accounts/asset/bank_details', [HomeController::class, 'coa_asset_bank'])->name('reporting.coa_asset_bank_asset');
        Route::get('chart-of-accounts/asset/long-term-asset', [HomeController::class, 'coa_asset_long_term'])->name('reporting.coa_asset_long_term');
        Route::get('chart-of-accounts/liabilities/ap', [HomeController::class, 'coa_liabilities_ap'])->name('reporting.coa_liabilities_ap');
        Route::get('chart-of-accounts/liabilities/emp_salaries/{f_t_date}', [HomeController::class, 'coa_liabilities_emp_salary'])->name('reporting.coa_emp_salary');

        // outstanding process 
        Route::get('market-outstanding/ar', [HomeController::class, 'market_outstanding_ar'])->name('market_outstanding.ar');
        Route::get('market-outstanding/ap', [HomeController::class, 'market_outstanding_ap'])->name('market_outstanding.ap');
        Route::get('market-outstanding/cash', [HomeController::class, 'market_outstanding_cash'])->name('market_outstanding.cash');
        Route::get('market-outstanding/expense/show', [HomeController::class, 'market_outstanding_expense_show'])->name('market_outstanding.expense_show');
        Route::get('market-outstanding/expense/find', [HomeController::class, 'market_outstanding_expense_find'])->name('market_outstanding.expense_find');

        Route::get('market-outstanding/bank/show', [HomeController::class, 'market_outstanding_bank_show'])->name('market_outstanding.bank_show');
        Route::get('market-outstanding/bank/find', [HomeController::class, 'market_outstanding_bank_find'])->name('market_outstanding.bank_find');

        Route::get('market-outstanding/investor/show', [HomeController::class, 'market_outstanding_investor_show'])->name('market_outstanding.investor_show');
        Route::get('market-outstanding/investor/find', [HomeController::class, 'market_outstanding_investor_find'])->name('market_outstanding.investor_find');

        Route::resource('roles', RoleController::class);
        Route::resource('permission', PermissionsController::class);
        Route::resource("user", UserController::class);
        Route::get("user/delete/{id}", [UserController::class,'destroy'])->name('user.delete');
        Route::resource("banker", BankerAccountController::class);
        Route::resource("investor_account", InvestorController::class);
        Route::resource("debitor_account", DebitorAccountController::class);
        Route::delete('roles/delete/{id}', [RoleController::class, 'destroy'])->name('role.delete');
        Route::get("profile", [UserController::class, 'profile'])->name('user.profile');
        Route::POST("change_profile/", [UserController::class, 'change_profile'])->name('user.change_profile');
        Route::POST("change_password/", [UserController::class, 'change_password'])->name('user.change_password');
    });
    Route::prefix('configuration')->group(function () {
        // Route::resource('scategories', SaleCategoriesController::class);
        // Route::resource('sscategories', SaleScategoriesController::class);
        // Route::resource('sunits', SaleUnitController::class);
        // Route::resource('sweights', SaleWeightController::class);
        Route::resource('pcategories', PurchaseCategoryController::class);
        Route::resource('psubcategories',PurchaseSubCategoryController::class);
        Route::resource('punits', PurchaseUnitsController::class);
        Route::resource('currency', CurrencyController::class);
        Route::resource('cashType', cashTypeController::class);
        Route::get('cashType/status/{id}', [cashTypeController::class, 'status'])->name('cashType.status');
        Route::resource('expencetype', expenceTypeController::class);
        Route::get('expencetype/status/{id}', [expenceTypeController::class, 'status'])->name('expencetype.status');
        Route::resource('exprocess', ExchangeProcessController::class);
        Route::get('exprocess/status/{id}',[ExchangeProcessController::class,'status'])->name('exprocess.status');
        Route::resource('infos',InfoController::class);
    });
    Route::prefix('rrdpo')->group(function () {
        Route::resource('projects',ProjectController::class);
        Route::get('projects/report/show',[ProjectController::class,'report_show'])->name('projects.report_show');
        Route::get('projects/report/find',[ProjectController::class,'report_find'])->name('projects.report_find');
        Route::get('projects/filter/find',[ProjectController::class,'filter_find'])->name('projects.filter_find');
        Route::get('projects/archive/list/{id}',[ProjectController::class,'project_archive'])->name('projects.archive');
        Route::get('projects/pruchase/list/{id}',[ProjectController::class,'project_purchase'])->name('projects.pruchase');
        Route::get('projects/payment/list/{id}',[ProjectController::class,'project_payment'])->name('projects.payment');
        Route::get('projects/stock/list/{id}',[ProjectController::class,'project_stock'])->name('projects.stock');
        Route::get('projects/distribution/list/{id}',[ProjectController::class,'project_distribution'])->name('projects.destribution');
        Route::get('projects/expences/list/{id}',[ProjectController::class,'project_expences'])->name('projects.expences');
        Route::get('projects/stuff_salaries/list/{id}',[ProjectController::class,'project_stuff_salaries'])->name('projects.stuff_salaries');
        Route::get('projects/reporting/list/{id}',[ProjectController::class,'project_report'])->name('projects.reporting');

       
        Route::resource('archive', ArchiveController::class);
        route::get('delete/{id}',[ArchiveController::class,'delete'])->name('archive.delete');
        route::get('report/show',[ArchiveController::class,'report_show'])->name('archive.report_show');
        route::get('report/find',[ArchiveController::class,'report_find'])->name('archive.report_find');
        route::get('filter/find',[ArchiveController::class,'filter_find'])->name('archive.filter_find');

        Route::resource('vehicleActivity',VehicleActivityController::class);
        route::get('vehicleActivity/delete/{id}',[VehicleActivityController::class,'delete'])->name('vehicleActivity.delete');
        route::get('vehicleActivity/report/show',[VehicleActivityController::class,'report_show'])->name('vehicleActivity.report_show');
        route::get('vehicleActivity/report/find',[VehicleActivityController::class,'report_find'])->name('vehicleActivity.report_find');
        route::get('vehicleActivity/filter/find',[VehicleActivityController::class,'filter_find'])->name('vehicleActivity.filter_find');
        route::post('vehicleActivity/rent/store',[VehicleRentController::class,'store'])->name('vehicleActivity.rent_store');
        route::get('vehicleActivity/rent/edit/{id}',[VehicleRentController::class,'edit'])->name('vehicleActivity.rent_edit');
        route::post('vehicleActivity/rent/update/{id}',[VehicleRentController::class,'update'])->name('vehicleActivity.rent_update');
        route::get('vehicleActivity/rent/delete/{id}',[VehicleRentController::class,'delete'])->name('vehicleActivity.rent_delete');
 
    });
    
    Route::prefix('purchase/target-multiple')->group(function () {
        Route::resource('suppliers', SupplierController::class);
        Route::get('suppliers/print/profile/{id}', [SupplierController::class,'print_profile'])->name('suppliers.print_profile');
        Route::get('balances/report/show', [SupplierController::class, 'balance_report_show'])->name('supplier.balance_report_show');
        Route::get('balances/report/find', [SupplierController::class, 'balance_report_find'])->name('supplier.balance_report_find');

        Route::get('ar/report/show', [SupplierController::class, 'ar_report_show'])->name('supplier.ar_report_show');
        Route::get('ar/report/find', [SupplierController::class, 'ar_report_find'])->name('supplier.ar_report_find');

        Route::get('ar_pay', [SupplierController::class, 'ar_pay'])->name('supplier.ar_pay');
        Route::get('supplier/filter/find', [SupplierController::class, 'filter_find'])->name('supplier.filter_find');

        Route::get('report/show', [SupplierController::class, 'report_show'])->name('supplier.report_show');
        Route::get('report/find', [SupplierController::class, 'report_find'])->name('supplier.report_find');
        Route::get('filter/find', [SupplierController::class, 'filter_find'])->name('supplier.filter_find');

        Route::resource('msupplier_bill', MSupplierBillController::class);
        Route::get('msupplier_bill/next/create/{id}', [MSupplierBillController::class, 'next_create'])->name('msupplier_bill.create_next');
        Route::post('msupplier_bill/next/store', [MSupplierBillController::class, 'next_store'])->name('msupplier_bill.store_next');
        Route::get('msupplier_bill/report/show', [MSupplierBillController::class, 'report_show'])->name('msupplier_bill.report_show');
        Route::get('msupplier_bill/report/find', [MSupplierBillController::class, 'report_find'])->name('msupplier_bill.report_find');
        Route::get('msupplier_bill/filter/find', [MSupplierBillController::class, 'filter_find'])->name('msupplier_bill.filter_find');
        Route::get('msupplier_bill/print/{id}', [MSupplierBillController::class, 'print'])->name('msupplier_bill.print');
        Route::get('msupplier_bill/delete/{id}', [MSupplierBillController::class, 'delete'])->name('msupplier_bill.delete');

        Route::resource('msupplier_payment', MPaymentController::class);
        Route::get('msupplier_payment/delete/{id}', [MPaymentController::class, 'delete'])->name('msupplier_payment.delete');
        Route::get('msupplier_payment/show/{id}', [MPaymentController::class, 'show'])->name('msupplier_payment.show');
        Route::get('msupplier_payment/report/show', [MPaymentController::class, 'report_show'])->name('msupplier_payment.report_show');
        Route::get('msupplier_payment/report/find', [MPaymentController::class, 'report_find'])->name('msupplier_payment.report_find');
        Route::get('msupplier_payment/filter/find', [MPaymentController::class, 'filter_find'])->name('msupplier_payment.filter_find');
        Route::get('msupplier_payment/print/{id}', [MPaymentController::class, 'print_receipt'])->name('msupplier_payment.receipt');

        Route::resource('msupplier_advance', MSupplierAdvanceController::class);
        Route::get('msupplier_advance/delete/{id}', [MSupplierAdvanceController::class, 'delete'])->name('msupplier_advance.delete');
        Route::get('msupplier_advance/report/show', [MSupplierAdvanceController::class, 'report_show'])->name('msupplier_advance.report_show');
        Route::get('msupplier_advance/report/find', [MSupplierAdvanceController::class, 'report_find'])->name('msupplier_advance.report_find');
        Route::get('msupplier_advance/filter/find', [MSupplierAdvanceController::class, 'filter_find'])->name('msupplier_advance.filter_find');


    });
    Route::prefix('purchase/target-single')->group(function () {
        Route::get('bill/index/{id}', [SupplierBillController::class, 'index'])->name('supplier_bill.index');
        Route::get('bill/create/{id}', [SupplierBillController::class, 'create'])->name('supplier_bill.create');
        Route::post('bill/store', [SupplierBillController::class, 'store'])->name('supplier_bill.store');
        Route::get('bill/next/{id}', [SupplierBillController::class, 'create_next'])->name('supplier_bill.create_next');
        Route::get('bill/item/store', [SupplierBillController::class, 'store_item'])->name('supplier_bill.bill_item_store');
        Route::get('bill/item/delete/{id}', [SupplierBillController::class, 'item_delete'])->name('supplier_bill.bill_item_delete');

        // for finish goods purchase 
        Route::get('bill/pitem/store', [SupplierBillController::class, 'pstore_item'])->name('supplier_bill.bill_pitem_store');
        Route::get('bill/pitem/delete/{id}', [SupplierBillController::class, 'pitem_delete'])->name('supplier_bill.bill_pitem_delete'); 

        Route::post('bill/next/store', [SupplierBillController::class, 'next_store'])->name('supplier_bill.bill_next_store');
        Route::get('bill/show/{id}', [SupplierBillController::class, 'show'])->name('supplier_bill.show');
        Route::get('bill/edit/{id}', [SupplierBillController::class, 'edit'])->name('supplier_bill.edit');
        Route::post('bill/update/{id}', [SupplierBillController::class, 'update'])->name('supplier_bill.update');
        Route::get('bill/print/{id}', [SupplierBillController::class, 'print'])->name('supplier_bill.print');
        Route::get('bill/delete/{id}', [SupplierBillController::class, 'delete'])->name('supplier_bill.delete');

        Route::get('bill/report/show/{id}', [SupplierBillController::class, 'report_show'])->name('supplier_bill.report_show');
        Route::get('bill/report/find', [SupplierBillController::class, 'report_find'])->name('supplier_bill.report_find');
        Route::get('bill/filter/find', [SupplierBillController::class, 'filter_find'])->name('supplier_bill.filter_find');

        Route::get('payment/index/{id}', [SupplierPaymentController::class, 'index'])->name('supplier_payment.index');
        Route::get('payment/create/{id}', [SupplierPaymentController::class, 'create'])->name('supplier_payment.create');
        Route::post('payment/store', [SupplierPaymentController::class, 'store'])->name('supplier_payment.store');
        Route::get('payment/edit/{id}', [SupplierPaymentController::class, 'edit'])->name('supplier_payment.edit');
        Route::post('payment/update/{id}', [SupplierPaymentController::class, 'update'])->name('supplier_payment.update');
        Route::get('payment/delete/{id}', [SupplierPaymentController::class, 'delete'])->name('supplier_payment.delete');

        Route::get('payment/report/show/{id}', [SupplierPaymentController::class, 'report_show'])->name('supplier_payment.report_show');
        Route::get('payment/report/find', [SupplierPaymentController::class, 'report_find'])->name('supplier_payment.report_find');
        Route::get('payment/filter/find', [SupplierPaymentController::class, 'filter_find'])->name('supplier_payment.filter_find');

        Route::get('advance/index/{id}', [SupplierAdvanceController::class, 'index'])->name('supplier_advance.index');
        Route::get('advance/create/{id}', [SupplierAdvanceController::class, 'create'])->name('supplier_advance.create');
        Route::post('advance/store', [SupplierAdvanceController::class, 'store'])->name('supplier_advance.store');
        Route::get('advance/edit/{id}', [SupplierAdvanceController::class, 'edit'])->name('supplier_advance.edit');
        Route::post('advance/update/{id}', [SupplierAdvanceController::class, 'update'])->name('supplier_advance.update');
        Route::get('advance/delete/{id}', [SupplierAdvanceController::class, 'delete'])->name('supplier_advance.delete');

        Route::get('advance/report/show/{id}', [SupplierAdvanceController::class, 'report_show'])->name('supplier_advance.report_show');
        Route::get('advance/report/find', [SupplierAdvanceController::class, 'report_find'])->name('supplier_advance.report_find');
        Route::get('advance/filter/find', [SupplierAdvanceController::class, 'filter_find'])->name('supplier_advance.filter_find');
    });
    Route::prefix('stock')->group(function () {
        Route::resource('stocks', StockController::class);
        Route::get('stocks/delete/{id}', [StockController::class, 'delete'])->name('stocks.delete');
        Route::get('stocks/warning/page', [StockController::class, 'warning_page'])->name('stocks.warning_page');
        Route::get('stocks/in-stock/page', [StockController::class, 'in_stock_page'])->name('stocks.in_stock_page');
        Route::get('stocks/out-stock/page', [StockController::class, 'out_stock_page'])->name('stocks.out_stock_page');
        Route::get('load/category', [StockController::class, 'category'])->name('stock.load_category');
        Route::get('check/stock', [StockController::class, 'check_stock'])->name('stock.check_stock');
        Route::get('stock_report/show', [StockController::class, 'report_show'])->name('stock.report_show');
        Route::get('stock_report/find', [StockController::class, 'report_find'])->name('stock.report_find');
        Route::get('stock/filter/show', [StockController::class, 'filter_show'])->name('stock.filter_show');
        Route::get('stock/filter/find', [StockController::class, 'filter_find'])->name('stock.filter_find');
        Route::get('stock/status/{id}', [StockController::class, 'status'])->name('stock.status');
        Route::get('stock/delete/{id}', [StockController::class, 'delete'])->name('stock.delete');
        Route::get('stock/generate/barcode/{id}', [StockController::class, 'stock_barcode'])->name('stock.generate_barcode');

        Route::get('history/index', [StockHistoryController::class, 'index'])->name('stock_history.index');
        Route::get('history/create', [StockHistoryController::class, 'create'])->name('stock_history.create');
        Route::post('history/store', [StockHistoryController::class, 'store'])->name('stock_history.store');
        Route::get('history/edit/{id}', [StockHistoryController::class, 'edit'])->name('stock_history.edit');
        Route::post('history/update/{id}', [StockHistoryController::class, 'update'])->name('stock_history.update');
        Route::delete('history/delete/{id}', [StockHistoryController::class, 'delete'])->name('stock_history.delete');
        Route::get('history/add_to_stock/{id}', [StockHistoryController::class, 'add_to_stock'])->name('stock_history.add_to_stock');
        Route::get('history/report/show', [StockHistoryController::class, 'report_show'])->name('stock_history.report_show');
        Route::get('history/report/find', [StockHistoryController::class, 'report_find'])->name('stock_history.report_find');

        Route::resource('row_stock', RowMaterialStockController::class);
        Route::get('row_stock/delete/{id}', [RowMaterialStockController::class,'delete'])->name('row_stock.delete');
        Route::get('report/show', [RowMaterialStockController::class,'report_show'])->name('row_stock.report_show');
        Route::get('report/find', [RowMaterialStockController::class,'report_find'])->name('row_stock.report_find');
        Route::get('filter/find', [RowMaterialStockController::class,'filter_find'])->name('row_stock.filter_find');

        Route::get('transaction/product/report/show',[StockTransactionController::class,'p_report_show'])->name('stock.p_transaction_report_show');
        Route::get('transaction/product/report/find',[StockTransactionController::class,'p_report_find'])->name('stock.p_transaction_report_find');

        Route::get('transaction/row/report/show',[StockTransactionController::class,'r_report_show'])->name('stock.r_transaction_report_show');
        Route::get('transaction/row/report/find',[StockTransactionController::class,'r_report_find'])->name('stock.r_transaction_report_find');

        Route::resource('rstockprocess',RowStockProcessController::class);
        Route::get('rstockprocess/report/show',[RowStockProcessController::class,'report_show'])->name('rstockprocess.report_show');
        Route::get('rstockprocess/report/find',[RowStockProcessController::class,'report_find'])->name('rstockprocess.report_find');
        Route::get('rstockprocess/filter/find',[RowStockProcessController::class,'filter_find'])->name('rstockprocess.filter_find');
       

    });
    Route::prefix('fainance/journal')->group(function () {
        Route::resource('cash', CashJournalController::class);
        Route::get('cash/out/create',[CashJournalController::class,'out_create'])->name('cash.out_create');
        Route::get('cash/income/list', [CashJournalController::class, 'income_list'])->name('cash.income_list');
        Route::get('cash/outgoing/list', [CashJournalController::class, 'outgoing_list'])->name('cash.outgoing_list');
        Route::get('cash/balance/show', [CashJournalController::class, 'balance'])->name('cash.balance');
        Route::get('cash/delete/{id}', [CashJournalController::class, 'delete'])->name('cash.delete');
        Route::get('cash/report/show', [CashJournalController::class, 'report_show'])->name('cash.report_show');
        Route::get('cash/report/find', [CashJournalController::class, 'report_find'])->name('cash.report_find');
        Route::get('cash/filter/show', [CashJournalController::class, 'filter_show'])->name('cash.filter_show');
        Route::get('cash/filter/find', [CashJournalController::class, 'filter_find'])->name('cash.filter_find');

        Route::resource('expense', ExpenseJournalController::class);
        Route::get('expense/balance/show', [ExpenseJournalController::class, 'balance'])->name('expense.balance');
        Route::get('expense/delete/{id}', [ExpenseJournalController::class, 'delete'])->name('expense.delete');
        Route::get('expense/report/show', [ExpenseJournalController::class, 'report_show'])->name('expense.report_show');
        Route::get('expense/report/find', [ExpenseJournalController::class, 'report_find'])->name('expense.report_find');
        Route::get('expense/filter/show', [ExpenseJournalController::class, 'filter_show'])->name('expense.filter_show');
        Route::get('expense/filter/find', [ExpenseJournalController::class, 'filter_find'])->name('expense.filter_find');

        Route::resource('bank', BankJournalController::class);
        Route::get('bank/create/outgoing', [BankJournalController::class, 'create_outgoing'])->name('bank.create_outgoing');
        Route::get('bank/page/withdrow', [BankJournalController::class, 'withdrow'])->name('bank.withdrow');
        Route::get('bank/page/deposit', [BankJournalController::class, 'deposit'])->name('bank.deposit');
        Route::get('bank/balance/show', [BankJournalController::class, 'balance'])->name('bank.balance');
        Route::delete('bank/delete/{id}', [BankJournalController::class, 'delete'])->name('bank.delete');
        Route::get('bank/report/show', [BankJournalController::class, 'report_show'])->name('bank.report_show');
        Route::get('bank/report/find', [BankJournalController::class, 'report_find'])->name('bank.report_find');
        Route::get('bank/filter/show', [BankJournalController::class, 'filter_show'])->name('bank.filter_show');
        Route::get('bank/filter/find', [BankJournalController::class, 'filter_find'])->name('bank.filter_find');

        Route::resource('debitor', DebitorJournalController::class);
        Route::get('debitor/outgoing/create', [DebitorJournalController::class, 'create_outgoing'])->name('debitor.create_outgoing');
        Route::get('debitor/page/income', [DebitorJournalController::class, 'income'])->name('debitor.income');
        Route::get('debitor/page/outgoing', [DebitorJournalController::class, 'outgoing'])->name('debitor.outgoing');
        Route::get('debitor/balance/show', [DebitorJournalController::class, 'balance'])->name('debitor.balance');
        Route::delete('debitor/delete/{id}', [DebitorJournalController::class, 'delete'])->name('debitor.delete');
        Route::get('debitor/report/show', [DebitorJournalController::class, 'report_show'])->name('debitor.report_show');
        Route::get('debitor/report/find', [DebitorJournalController::class, 'report_find'])->name('debitor.report_find');
        Route::get('debitor/filter/show', [DebitorJournalController::class, 'filter_show'])->name('debitor.filter_show');
        Route::get('debitor/filter/find', [DebitorJournalController::class, 'filter_find'])->name('debitor.filter_find');
        route::get('debitor/balancesheet/show', [DebitorJournalController::class, 'balancesheet_show'])->name('debitor.balancesheet_show');
        route::get('debitor/balancesheet/find', [DebitorJournalController::class, 'balancesheet_find'])->name('debitor.balancesheet_find');

        Route::resource('investors',InvestorJournalController::class);
        Route::get('investors/outgoing/create',[InvestorJournalController::class,'outgoing_create'])->name('investors.create_ourgoing');
        Route::get('investors/report/show',[InvestorJournalController::class,'report_show'])->name('investors.report_show');
        Route::get('investors/report/find',[InvestorJournalController::class,'report_find'])->name('investors.report_find');
        Route::get('investors/fileter/show',[InvestorJournalController::class,'filter_show'])->name('investors.filter_show');
        Route::get('investors/fileter/find',[InvestorJournalController::class,'filter_find'])->name('investors.filter_find');
        Route::get('investors/delete/{id}',[InvestorJournalController::class,'delete'])->name('investors.delete');

        Route::resource('invester_investment',InvestorInvestmentController::class);
        route::resource('company_asset', FixedAssetController::class);
        Route::get('company_asset/report/show', [FixedAssetController::class, 'report_show'])->name('company_asset.report_show');
        Route::get('company_asset/report/find', [FixedAssetController::class, 'report_find'])->name('company_asset.report_find');
        Route::get('company_asset/filter/show', [FixedAssetController::class, 'filter_show'])->name('company_asset.filter_show');
        Route::get('company_asset/filter/find', [FixedAssetController::class, 'filter_find'])->name('company_asset.filter_find');

        Route::get('income/statement/report/show', [HomeController::class, 'income_statement_show'])->name('income_statement.show');
        Route::get('income/statement/report/find', [HomeController::class, 'income_statement_find'])->name('income_statement.find');

        Route::resource('tax', TaxController::class);
        Route::get('tax/delete/{id}', [TaxController::class, 'delete'])->name('tax.delete');
        Route::get('tax/report/show', [TaxController::class, 'report_show'])->name('tax.report_show');
        Route::get('tax/report/find', [TaxController::class, 'report_find'])->name('tax.report_find');
    });
    Route::prefix('hr')->group(function () {
        Route::prefix('emp')->group(function () {
            Route::resource('employees', EmployeeController::class);
            Route::get('status/{id}', [EmployeeController::class, 'status'])->name('employee.status');
            Route::get('report/show', [EmployeeController::class, 'report_show'])->name('employee.report_show');
            Route::get('report/find', [EmployeeController::class, 'report_find'])->name('employee.report_find');
            Route::get('filter/find', [EmployeeController::class, 'filter_find'])->name('employee.filter_find');
        });
     
        Route::prefix('multiple')->group(function () {
            Route::get('attendance/index', [EmployeeAttendanceController::class, 'index'])->name('employee_attendance.index');
            Route::get('attendance/create', [EmployeeAttendanceController::class, 'create'])->name('employee_attendance.create');
            Route::post('attendance/store', [EmployeeAttendanceController::class, 'store'])->name('employee_attendance.store');
            Route::get('attendance/edit/{id}', [EmployeeAttendanceController::class, 'edit'])->name('employee_attendance.edit');
            Route::post('attendance/update/{id}', [EmployeeAttendanceController::class, 'update'])->name('employee_attendance.update');
            Route::get('attendance/delete/{id}', [EmployeeAttendanceController::class, 'delete'])->name('employee_attendance.delete');

            Route::get('attendance/report/show', [EmployeeAttendanceController::class, 'report_show'])->name('employee_attendance.report_show');
            Route::get('attendance/report/find', [EmployeeAttendanceController::class, 'report_find'])->name('employee_attendance.report_find');
            Route::get('attendance/filter/find', [EmployeeAttendanceController::class, 'filter_find'])->name('employee_attendance.filter_find');


            Route::resource('employee_salaries', EmpSalaryController::class);
            Route::get('employee_salaries/report/show', [EmpSalaryController::class, 'report_show'])->name('employee_salaries.report_show');
            Route::get('employee_salaries/report/find', [EmpSalaryController::class, 'report_find'])->name('employee_salaries.report_find');
            Route::get('employee_salaries/filter/find', [EmpSalaryController::class, 'filter_find'])->name('employee_salaries.filter_find');

            Route::resource('employee_advances', EmpAdvanceController::class);
            Route::get('employee_advances/delete/{id}', [EmpAdvanceController::class, 'delete'])->name('employee_advances.delete');
            Route::get('employee_advances/report/show', [EmpAdvanceController::class, 'report_show'])->name('employee_advances.report_show');
            Route::get('employee_advances/report/find', [EmpAdvanceController::class, 'report_find'])->name('employee_advances.report_find');
            Route::get('employee_advances/filter/find', [EmpAdvanceController::class, 'filter_find'])->name('employee_advances.filter_find');

            Route::resource('employee_overtimes', EmpOvertimeController::class);
            Route::get('employee_overtimes/delete/{id}', [EmpOvertimeController::class, 'delete'])->name('employee_overtimes.delete');
            Route::get('employee_overtimes/report/show', [EmpOvertimeController::class, 'report_show'])->name('employee_overtimes.report_show');
            Route::get('employee_overtimes/report/find', [EmpOvertimeController::class, 'report_find'])->name('employee_overtimes.report_find');
            Route::get('employee_overtimes/filter/find', [EmpOvertimeController::class, 'filter_find'])->name('employee_overtimes.filter_find');
        });

    });
    Route::prefix('ajax')->group(function () {
        Route::get('get/category', [AjaxController::class, 'get_category'])->name('category.get');
        Route::get('get/category/other/', [AjaxController::class, 'get_category_other'])->name('category_other.get');
        Route::get('get/stock', [AjaxController::class, 'get_stock'])->name('stock.get');
        Route::get('get/stock/by_category/', [AjaxController::class, 'get_stock_by_category'])->name('stock.get_by_category');
        Route::get('get/stock/attribute', [AjaxController::class, 'get_stock_attribute'])->name('stock_attribute.get');
      
        Route::get('get/load/stock', [AjaxController::class, 'load_stock_for_return'])->name('scustomer_rbill.load_stock');
        Route::get('get/load/stock/attribute', [AjaxController::class, 'find_stock_attribute'])->name('scustomer_rbill.find_attr');

        Route::get('get/rstock', [AjaxController::class, 'rget_stock'])->name('rstock.get');
        Route::get('get/rstock/attribute', [AjaxController::class, 'rget_stock_attribute'])->name('rstock_attribute.get');

        Route::get('get/emp_data/for/salary', [AjaxController::class, 'get_emp_data_for_salary'])->name('employee_salary.load_data');
        Route::get('get/load/basic_salary', [AjaxController::class, 'get_basic_salary_for_overtime'])->name('overtime.load_basic_salary');
      
        Route::get('get/load/ex_rate', [AjaxController::class, 'get_ex_rate'])->name('get.ex_rate');
        Route::get('get/load/row_stock_value', [AjaxController::class, 'get_row_stock_value'])->name('row_stock.get_value');
        Route::get('get/row_category', [AjaxController::class, 'row_category'])->name('category.row_category');
       
     

    });

    
});

require __DIR__ . '/auth.php';
