<?php

namespace App\Http\Controllers\HR;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\EmployeeAdvance;
use App\Models\CashJournal;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class EmployeeAdvanceController extends Controller
{
    public function index($id){
        $employee=Employee::find($id);
        $payments=EmployeeAdvance::where('employee_id',$id)->orderBy('id','desc')->paginate(20);
        return view('HR.employees.advance.index',compact('payments','employee'));
    }
    public function store(Request $request){
        $request->validate([
            'title' => 'required',
            'payment' => 'required',
            'date' => 'required',
            'employee_id' => 'required',

        ]);
        $payment=new EmployeeAdvance();
        $payment->employee_id=$request->employee_id;
        $payment->payment = $request->payment;
        $payment->date=$request->date;
        $data = explode('-',$request->date);
        $year=$data[0];
        $month=$data[1];
        $day=$data[2];
        $payment->year=$year;
        $payment->month=$month;
        $payment->day=$day;
        $payment->title=$request->title;
        $payment->details=$request->details;
        $payment->status=1;
        $payment->c_target=$request->cash_id;
        $payment->user_id=Auth::user()->id;
        $payment->save();
        if($payment){
            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = $payment->title;
                $cash->date = $payment->date;
                $cash->outgoing = $payment->payment;
                $cash->currency_id = 1;
                $cash->ex_rate = 1;
                $cash->module_id = 26;
                $cash->type_id = 26;
                $cash->module_record_id = $payment->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Cash Target From Employee Advance";
                $cash->save();
            }
        }

        session()->flash("msg", "employee Payment Was Saved!");
        return back();
    }

    public function edit($id){
        $payment=EmployeeAdvance::find($id);
        $employee=Employee::find($payment->employee_id);
        return view('HR.employees.advance.edit',compact('payment','employee'));
    }

    public function update(Request $request,$id){

        $request->validate([
            'title' => 'required',
            'payment' => 'required',
            'date' => 'required',

        ]);
        $payment=EmployeeAdvance::find($id);
        $payment->employee_id=$request->employee_id;
        $payment->payment = $request->payment;
        $payment->date=$request->date;
        $data = explode('-',$request->date);
        $year=$data[0];
        $month=$data[1];
        $day=$data[2];
        $payment->year=$year;
        $payment->month=$month;
        $payment->day=$day;
        $payment->title=$request->title;
        $payment->details=$request->details;
        $payment->c_target=$request->cash_id;
        $payment->user_id=Auth::user()->id;
        $payment->save();
        if($payment){
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 26)->where('module_record_id', $payment->id)->first();
                if ($cash != null) {
                    $cash->title = $payment->title;
                    $cash->date = $payment->date;
                    $cash->outgoing = $payment->payment;
                    $cash->currency_id = 1;
                    $cash->ex_rate = 1;
                    $cash->module_id = 26;
                    $cash->type_id = 26;
                    $cash->module_record_id = $payment->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Target From Employee Advance";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $payment->title;
                    $cash->date = $payment->date;
                    $cash->outgoing = $payment->payment;
                    $cash->currency_id = 1;
                    $cash->ex_rate = 1;
                    $cash->module_id = 26;
                    $cash->type_id = 26;
                    $cash->module_record_id = $payment->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Target From Employee Advance";
                    $cash->save();
                }
            } else {
                $cash = CashJournal::where('module_id', 26)->where('module_record_id', $payment->id)->delete();
            }
        }
        session()->flash("msg", "employee Payment Was Updated!");
        return redirect()->route('employee_payment.index',$request->employee_id);
    }

    public function delete($id){
        $payment=EmployeeAdvance::find($id)->delete();
        $cash = CashJournal::where('module_id', 26)->where('module_record_id', $id)->delete();
        session()->flash("msg", "employee Payment Was Deleted!");
        return back();

    }

    public function report_show($id){
      return view('HR.employees.advance.report',compact('id'));
    }
    public function report_find(Request $request){
        $bname=\App\Models\Info::find(1)->business_name;
        $fDate=$request->fromDate;
        $tDate=$request->toDate;
        $employee_id=$request->employee_id;
        $employee=Employee::find($employee_id);
        $data="";
        $payments = EmployeeAdvance::whereBetween('date', [$fDate, $tDate])->where('employee_id',$employee_id)->get();
        $data.="<h6 style='text-align:center'>".$bname."</h6>";
          $data .= "<h6 style='text-align:center'>$employee->name Payment Report</h6><p style='text-align:center'>From ($fDate) to ($tDate)</p>";
          $data .= '<table class="" id="table_style">';
          $data .= '<tr>';
          $data .= '<th>Number</th>';
          $data .= '<th>Title</th>';
          $data .= '<th>Date</th>';
          $data .= '<th>Advance</th>';
          $data .= '<th>Details</th>';
          $data .= '</tr>';
          $data .= '<tbody>';
          $i = 1;
          foreach ($payments as $row) {
              $data .= "<tr>";
              $data.= "<td>" .$i . "</td>";
              $data .= "<td>" .$row->title . "</td>";
              $data .= "<td>" .$row->date . "</td>";
              $data .= "<td>" .$row->payment." </td>";
              $data .= "<td>" .$row->details . "</td>";
              $data.="</tr>";
              $i++;
          }
          if ($i == 1) {
              $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
          }
          $data .= "</tbody>";
          $data .= '</table>';
          $data.='</table>';
            $data.='<table class="">';
            $data.=' <tr>';
            $data.='<th colspan="0" rowspan="2"> Sub Total</th>';
            $data.='<th colspan="">Amount</th>';
            $data.=' </tr>';
            $data.=' <tr>';
            $data.='<td>'.$payments->sum('payment').'</td>';
            $data.='</tr>';
            $data.='</table>';
          return $data;
    }

    public function filter_find(Request $request){
        if($request->type_id==1){
            $payments=EmployeeAdvance::Where('title','like','%'.$request->title.'%')
            ->where('employee_id',$request->employee_id)
            ->paginate(20);
        }else if($request->type_id==2){
            $payments=EmployeeAdvance::Where('payment',$request->payment)
            ->where('employee_id',$request->employee_id)
            ->paginate(20);
        }
        else{
            $payments=EmployeeAdvance::WhereBetween('date',[$request->f_date,$request->t_date])
            ->where('employee_id',$request->employee_id)
            ->paginate(20);
        }
        $employee=Employee::find($request->employee_id);
        return view('HR.employees.advance.index',compact('payments','employee'));
    }
}
