<?php

namespace App\Http\Controllers\HR;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\Month;
use App\Models\EmployeeAttendance;
use App\Models\EmployeeOverTime;
use App\Models\EmployeeSalaries;
use App\Models\EmployeeAdvance;
use Auth;
class EmployeeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $employess=Employee::orderBy('id','desc')->paginate(20);
        return view('HR.employees.index',compact('employess'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('HR.employees.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255|min:2',
            'phone' => 'required|max:255|min:2',
            'address' => 'required',
            'position' => 'required',
            'basic_salary' => 'required',
            'date' => 'required',
        ]);
        $employee = new employee();
        $employee->name=$request->name;
        $employee->phone=$request->phone;
        $employee->address=$request->address;
        $employee->email=$request->email;
        $employee->position=$request->position;
        $employee->currency_id=1;
        $employee->user_id=Auth::user()->id;
        $employee->basic_salary=$request->basic_salary;
        $employee->date=$request->date;
        $folder=date("Y-M");
        if(request()->hasFile('image')){
            $filename = 'image-'.time().'-'.request()->file('image')->getClientOriginalName();
            $image_path = request()->file('image')->storeAs('image/'.$folder,$filename,'public');
         }else{
            $image_path="profile.png";
         }
         if(request()->hasFile('tz_scan')){
            $filename = 'tz_scan-'.time().'-'.request()->file('tz_scan')->getClientOriginalName();
            $tz_image = request()->file('tz_scan')->storeAs('tz_scan/'.$folder,$filename,'public');
         }else{
            $tz_image="profile.png";
         }
         if(request()->hasFile('document')){
            $filename = 'document-'.time().'-'.request()->file('document')->getClientOriginalName();
            $document_path = request()->file('document')->storeAs('document/'.$folder,$filename,'public');
         }else{
            $document_path="profile.png";
         }
         if(request()->hasFile('contract_letter')){
            $filename = 'contract_letter-'.time().'-'.request()->file('contract_letter')->getClientOriginalName();
            $contract_letter = request()->file('contract_letter')->storeAs('contract_letter/'.$folder,$filename,'public');
         }else{
            $contract_letter="profile.png";
         }
         $employee->image=$image_path;
         $employee->tz_scan=$tz_image;
         $employee->document=$document_path;
         $employee->contract_letter=$contract_letter;
         $employee->save();
        session()->flash("msg", "Success!");
        return redirect()->route('employees.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $date = date('Y-m-d');
        $date_week = date('Y-m-d',strtotime("-7 days"));
        $yesterday = date('Y-m-d',strtotime("-1 days"));
        $word = explode('-',$date);
        $year = $word[0];
        $month = $word[1];
        $this_month = $year.'-'.$month;

        $employee=Employee::find($id);
        return view('HR.employees.show',compact("employee"));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $employee=Employee::find($id);
        return view('HR.employees.edit',compact("employee"));
    }

    public function status($id){
        $employee=Employee::find($id);
        if($employee->status==0){
            $employee->status=1;
            $message="Active";
        }else{
            $employee->status=0;
            $message="In-Active";
        }
        $employee->save();
        session()->flash("msg", $message);
        return redirect()->back();

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|max:255|min:2',
            'phone' => 'required|max:255|min:2',
        ]);
        $employee = employee::find($id);
        $employee->name=$request->name;
        $employee->phone=$request->phone;
        $employee->address=$request->address;
        $employee->email=$request->email;
        $employee->position=$request->position;
        $employee->basic_salary=$request->basic_salary;
        $employee->date=date('Y-m-d');

        $folder=date("Y-M");
        if(request()->hasFile('image')){
            $filename = 'image-'.time().'-'.request()->file('image')->getClientOriginalName();
            $image_path = request()->file('image')->storeAs('image/'.$folder,$filename,'public');
         }else{
            $image_path=$employee->image;
         }

         if(request()->hasFile('tz_scan')){
            $filename = 'tz_scan-'.time().'-'.request()->file('tz_scan')->getClientOriginalName();
            $tz_image = request()->file('tz_scan')->storeAs('tz_scan/'.$folder,$filename,'public');
         }else{
            $tz_image=$employee->tz_scan;
         }

         if(request()->hasFile('document')){
            $filename = 'document-'.time().'-'.request()->file('document')->getClientOriginalName();
            $document_path = request()->file('document')->storeAs('document/'.$folder,$filename,'public');
         }else{
            $document_path=$employee->document;
         }

         if(request()->hasFile('contract_letter')){
            $filename = 'contract_letter-'.time().'-'.request()->file('contract_letter')->getClientOriginalName();
            $contract_letter = request()->file('contract_letter')->storeAs('contract_letter/'.$folder,$filename,'public');
         }else{
            $contract_letter=$employee->contract_letter;
         }

         $employee->image=$image_path;
         $employee->tz_scan=$tz_image;
         $employee->document=$document_path;
         $employee->contract_letter=$contract_letter;
        $employee->save();
        session()->flash("msg", "Success!");
        return redirect()->route('employees.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function report_show(){
        $employees=Employee::all();
        $months=Month::all();
        return view('HR.employees.report',compact('employees','months'));
    }
    public function report_find(Request $request){
        $bname=\App\Models\Info::find(1)->business_name;
        $fDate=$request->fromDate;
        $tDate=$request->toDate;
        $employee_id=$request->employee_id;
        $month_id=$request->month_id;
        $type_id=$request->type_id;
        $fDate=$request->fromDate;
        $tDate=$request->toDate;
        $f_data = explode('-',$request->fromDate);
        $f_year=$f_data[0];
        $f_month=$f_data[1];
        $t_data = explode('-',$request->toDate);
        $t_year=$t_data[0];
        $t_month=$t_data[1];
        $data="";
        if($type_id==6){
                $data.="<h6 style='text-align:center'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center'>All Employees Report</h6><p style='text-align:center'>From ($fDate) to ($tDate)</p>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Name</th>';
                $data .= '<th>Email</th>';
                $data .= '<th>Phone</th>';
                $data .= '<th>Address</th>';
                $data .= '<th>Hire Date</th>';
                $data .= '<th>Salary</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $employees = Employee::all();
                foreach ($employees as $row) {
                    $data .= "<tr>";
                    $data.= "<td>" .$i . "</td>";
                    $data .= "<td>" .$row->name . "</td>";
                    $data .= "<td>" .$row->email . "</td>";
                    $data .= "<td>" .$row->phone. "</td>";
                    $data .= "<td>" .$row->address." </td>";
                    $data .= "<td>" .$row->date . "</td>";
                    $data .= "<td>" .$row->basic_salary . "</td>";
                    $data.="</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data.='</table>';
               
        }
        if($employee_id=="all"){
            //   advance
             if($type_id==1){
                $fDate=$request->fromDate;
                $tDate=$request->toDate;
                $employee_id=$request->employee_id;
                $employee=Employee::find($employee_id);
                $data="";
                $advance = EmployeeAdvance::whereBetween('date', [$fDate, $tDate])->get();
                $data.="<h6 style='text-align:center'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center'>All Employee Advance Report</h6><p style='text-align:center'>From ($fDate) to ($tDate)</p>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Name</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Advance</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($advance as $row) {
                    $data .= "<tr>";
                    $data.= "<td>" .$i . "</td>";
                    $data .= "<td>" .$row->employee->name . "</td>";
                    $data .= "<td>" .$row->title . "</td>";
                    $data .= "<td>" .$row->date . "</td>";
                    $data .= "<td>" .$row->payment." </td>";
                    $data .= "<td>" .$row->details . "</td>";
                    $data.="</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data.='</table>';
                $data.='<table class="">';
                $data.=' <tr>';
                $data.='<th colspan="0" rowspan="2"> Sub Total</th>';
                $data.='<th colspan="">Amount</th>';
                $data.=' </tr>';
                $data.=' <tr>';
                $data.='<td>'.$advance->sum('payment').'</td>';
                $data.='</tr>';
                $data.='</table>';
             }
            //  overtime
             if($type_id==2){
                $fDate=$request->fromDate;
                $tDate=$request->toDate;
                $employee_id=$request->employee_id;
                $employee=Employee::find($employee_id);
                $data="";
                $overtimes = EmployeeOverTime::whereBetween('date', [$fDate, $tDate])->get();
                $data.="<h6 style='text-align:center'>Pacha Paints and Printing Industry</h6>";
                  $data .= "<h6 style='text-align:center'>All Employee overtime Report</h6><p style='text-align:center'>From ($fDate) to ($tDate)</p>";
                  $data .= '<table class="" id="table_style" style="margin-top:20px">';
                  $data .= '<tr>';
                  $data .= '<th>#</th>';
                  $data .= '<th>Employee</th>';
                  $data .= '<th>Date</th>';
                  $data .= '<th>Hours</th>';
                  $data .= '<th>Amount</th>';
                  $data .= '</tr>';
                  $data .= '<tbody>';
                  $i = 1;
                  foreach ($overtimes as $row) {
                      $data .= "<tr>";
                      $data.= "<td>" .$i . "</td>";
                      $data .= "<td>" .$row->employee->name . "</td>";
                      $data .= "<td>" .$row->date . "</td>";
                      $data .= "<td>" .$row->hourse . "</td>";
                      $data .= "<td>" .round($row->amount,2)." </td>";
                      $data.="</tr>";
                      $i++;
                  }
                  if ($i == 1) {
                      $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
                  }
                  $data .= "</tbody>";
                  $data .= '</table>';
                  $data.='</table>';
                  $data.='<table class="">';
                  $data.=' <tr>';
                  $data.='<th colspan="0" rowspan="2"> Sub Total</th>';
                  $data.='<th colspan="">Amount</th>';
                  $data.=' </tr>';
                  $data.=' <tr>';
                  $data.='<td>'.$overtimes->sum('amount').'</td>';
                  $data.='</tr>';
                  $data.='</table>';
                  return $data;
             }
            //   attendance
             if($type_id==3){
                    $attendance=EmployeeAttendance::whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->get();
                    $data.="<h6 style='text-align:center'>".$bname."</h6>";
                    $data .= "<h6 style='text-align:center'>All Employee Attendance Report of $f_month Month</h6><p style='text-align:center'></p>";
                    $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                    $data .= '<thead>';
                    $data .= '<tr>';
                    $data .= '<th>#</th>';
                    $data .= '<th>Name</th>';
                    $data .= '<th>year</th>';
                    $data .= '<th>Month</th>';
                    $data .= '<th>Present</th>';
                    $data .= '<th>Opsent</th>';
                    $data .= '<th>Leve</th>';
                    $data .= '<th>Up-to-days</th>';
                    $data .= '</tr>';
                    $data .= '</thead>';
                    $data .= '<tbody>';
                    $i=1;
                    foreach(Employee::all() as $row){
                        $present=$attendance->where('employee_id',$row->id)->where('status',1)->count('id');
                        $opsent=$attendance->where('employee_id',$row->id)->where('status',2)->count('id');
                        $leve=$attendance->where('employee_id',$row->id)->where('status',3)->count('id');
                        $days=$attendance->where('employee_id',$row->id)->count('id');
                        $data .= '<tr>';
                        $data.= "<td>" .$i . "</td>";
                        $data.= "<td>" .$row->name . "</td>";
                        $data.= "<td>" .$f_year . "</td>";
                        $data.= "<td>" .$f_month . "</td>";
                        $data.= "<td>" .$present. "</td>";
                        $data.= "<td>" .$opsent. "</td>";
                        $data.= "<td>" .$leve. "</td>";
                        $data.= "<td>" .$days. "</td>";
                        $data .= '</tr>';
                        $i++;
                    }
                    $data .= '</tbody>';
                    $data .= '</table>';
             }
            //  salary
             if($type_id==4){
                $salary = EmployeeSalaries::whereBetween('year', [$f_year, $t_year])->whereBetween('month',[$f_month,$t_month])->get();
                $data.="<h6 style='text-align:center'>".$bname."</h6>";
                  $data .= "<h6 style='text-align:center'>All Employee Salary Report</h6><p style='text-align:center'>From ($fDate) to ($tDate)</p>";
                  $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                  $data .= '<tr>';
                  $data .= '<th>#</th>';
                  $data .= '<th>Employee</th>';
                  $data .= '<th>B-S</th>';
                  $data .= '<th>Overtime</th>';
                  $data .= '<th>Attendance</th>';
                  $data .= '<th>Attend Amount</th>';
                  $data .= '<th>Gross Salary</th>';
                  $data .= '<th>Advance</th>';
                  $data .= '<th>Net Salary</th>';
                  $data .= '<th>Title</th>';
                  $data .= '</tr>';
                  $data .= '<tbody>';
                  $i = 1;
                  foreach ($salary as $row) {
                      $data .= "<tr>";
                      $data.= "<td>" .$i . "</td>";
                       $data .= "<td>" .$row->employee->name. "</td>";
                      $data .= "<td>" .$row->basic_salary . "</td>";
                      $data .= "<td>" .round($row->overtime_amount,2)." </td>";
                      $data .= "<td>" .$row->opsent_day. "</td>";
                      $data .= "<td>" .round($row->opsent_amount,2). "</td>";
                      $data .= "<td>" .round($row->gross_salary ,2). "</td>";
                      $data .= "<td>" .round($row->advance_amount,2) . "</td>";
                      $data .= "<td>" .round($row->net_salary ,2). "</td>";
                      $data .= "<td>" .$row->note."</td>";
                      $data.="</tr>";
                      $i++;
                  }
                  if ($i == 1) {
                      $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
                  }
                  $data .= "</tbody>";
                  $data .= '</table>';
                  $data.='</table>';
                    $data.='<table class="">';
                    $data.=' <tr>';
                    $data.='<th colspan="0" rowspan="2"> Sub Total</th>';
                    $data.='<th colspan="">Advance</th>';
                    $data.='<th colspan="">Overtime</th>';
                    $data.='<th colspan="">Salary</th>';
                    $data.=' </tr>';
                    $data.=' <tr>';
                    $data.='<td>'.round($salary->sum('advance_amount'),2).'</td>';
                    $data.='<td>'.round($salary->sum('overtime_amount'),2).'</td>';
                     $data.='<td>'.round($salary->sum('net_salary'),2).'</td>';
                    $data.='</tr>';
                    $data.='</table>';
             }
             if($type_id=="5")
             {
                 $employees=Employee::all();
                 $attendance=EmployeeAttendance::all();
                 $overtime=EmployeeOverTime::all();
                 $advance=EmployeeAdvance::all();
                 $salary=EmployeeSalaries::all();
                 $fDate=$request->fromDate;
                 $tDate=$request->toDate;
                 $f_data = explode('-',$request->fromDate);
                 $f_year=$f_data[0];
                 $f_month=$f_data[1];
                 $t_data = explode('-',$request->toDate);
                 $t_year=$t_data[0];
                 $t_month=$t_data[1];
                 $data.="<h6 style='text-align:center'>".$bname."</h6>";
                 $data .= "<h6 style='text-align:center'>All Employee Balance Sheet </h6>";
                 $data.="<h6 style='text-align:center'>$fDate to $tDate</h6>";
                 $data.="<h6 style='text-align:center'>Containe Content in Balance Overtime, Advance, Salery</h6>";

                 $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                 $data .= '<thead>';
                 $data .= '<tr>';
                 $data .= '<th>#</th>';
                 $data .= '<th>Name</th>';
                 $data .= '<th>year</th>';
                 $data .= '<th>Month</th>';
                 $data .= '<th>B-S</th>';
                 $data .= '<th>Overtime</th>';
                 $data .= '<th>Attendance</th>';
                 $data .= '<th>G-S</th>';
                 $data .= '<th>Advance</th>';
                 $data .= '<th>N-S</th>';
                 $data .= '</tr>';
                 $data .= '</thead>';
                 $data .= '<tbody>';
                 $i=1;
                 foreach($employees as $row){
                     $present_days=$attendance->where('employee_id',$row->id)->where('status',1)->whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->count('id');
                    //  $opsent_days=$attendance->where('employee_id',$row->id)->where('status',2)->whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->count('id');
                    //  $leve_days=$attendance->where('employee_id',$row->id)->where('status',3)->whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->count('id');
                     $advance=EmployeeAdvance::whereBetween('date', [$fDate, $tDate])->where('employee_id',$row->id)->sum('payment');
                     $overtime=EmployeeOverTime::whereBetween('date', [$fDate, $tDate])->where('employee_id',$row->id)->sum('amount');
                    //  $basic_total=EmployeeSalary::whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->where('employee_id',$row->id)->sum('basic_salary');
                    //  $gross_total=EmployeeSalary::whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->where('employee_id',$row->id)->sum('gross_salary');
                    //  $net_salary=EmployeeSalary::whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->where('employee_id',$row->id)->sum('net_salary');
                     $data .= '<tr>';
                     $data.= "<td>" .$i. "</td>";
                     $data.= "<td>" .$row->name . "</td>";
                     $data.= "<td>" .$f_year . "</td>";
                     $data.= "<td>" .$f_month . "</td>";
                     $data.= "<td>" .$row->basic_salary . "</td>";
                     $data.= "<td>" .round($overtime,2). "</td>";
                     $data.= "<td>";
                     $data.= $present_days;
                     $data.="</td>";

                     $data.="<td>";
                     $per_day_salary=$row->basic_salary/30;
                     $attend_amount=$present_days*$per_day_salary;
                     $gs_salary=$attend_amount+$overtime;
                     $data.=round($gs_salary,2);
                     $data.="</td>";
                     $data.= "<td>".round($advance,2) . "</td>";
                     $data.='<td>';
                     if($gs_salary-$advance<=0){
                        $data.="<span style='color:red; border-bottom:1px solid red;'>".round($gs_salary-$advance,2)."</span>";
                     }else{
                        $data.=round($gs_salary-$advance,2);
                     }
                     $data.="</td>";
                     $data .= '</tr>';
                     $i++;
                 }
                //  $advance=EmployeeAdvance::whereBetween('date', [$fDate, $tDate])->sum('payment');
                //  $overtime=EmployeeOverTime::whereBetween('date', [$fDate, $tDate])->sum('amount');
                //  $salary=EmployeeSalary::whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->sum('gross_salary');
                //  $net_salary=EmployeeSalary::whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->sum('net_salary');
                 $data .= '</tbody>';
                 $data .= '</table>';
                 $data.='</table>';
                //  $data.='<table class="">';
                //  $data.=' <tr>';
                //  $data.='<th colspan="0" rowspan="2"> Sub Total</th>';
                //  $data.='<th colspan="">Basic Total</th>';
                //  $data.='<th colspan="">overtime Total</th>';
                //  $data.='<th colspan="">Gross Total</th>';
                //  $data.='<th colspan="">Advance Total</th>';
                //  $data.='<th colspan="">Net Total</th>';
                //  $data.=' </tr>';
                //  $data.=' <tr>';
                //  $data.='<td>'.$advance.'</td>';
                //  $data.='<td>'.$overtime.'</td>';
                //  $data.='<td>'.$salary.'</td>';
                //  $data.='</tr>';
                //  $data.='</table>';
             }
        }
        else
        {

            // advance
            if($type_id==1){
                $fDate=$request->fromDate;
                $tDate=$request->toDate;
                $employee=Employee::find($request->employee_id);
                $payments = EmployeeAdvance::whereBetween('date', [$fDate, $tDate])->where('employee_id',$request->employee_id)->get();
                $data.="<h6 style='text-align:center'>".$bname."</h6>";
                $data.="<h6 style='text-align:center'>Payment Report</h6>";
                $data.="<h6 style='text-align:center'>From ($fDate) to ($tDate)</h6>";
                $data .= "<h6 style='text-align:center'>$employee->name </h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Advance</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($payments as $row) {
                    $data .= "<tr>";
                    $data.= "<td>" .$i . "</td>";
                    $data .= "<td>" .$row->title . "</td>";
                    $data .= "<td>" .$row->date . "</td>";
                    $data .= "<td>" .$row->payment." </td>";
                    $data .= "<td>" .$row->details . "</td>";
                    $data.="</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data.='</table>';
                $data.='<table class="">';
                $data.=' <tr>';
                $data.='<th colspan="" rowspan="2"> Sub Total</th>';
                $data.='<th colspan="5">Amount</th>';
                $data.=' </tr>';
                $data.=' <tr>';
                $data.='<td>'.$payments->sum('payment').'</td>';
                $data.='</tr>';
                $data.='</table>';
            }
            if($type_id==2){
                $employee=Employee::find($request->employee_id);
                $overtimes = EmployeeOverTime::whereBetween('date', [$fDate, $tDate])->where('employee_id',$request->employee_id)->get();
                $data.="<h6 style='text-align:center'>Pacha Paints and Printing Industry</h6>";
                $data.="<h6 style='text-align:center'>overtime Report</h6>";
                $data.="<h6 style='text-align:center'>From ($fDate) to ($tDate)</h6>";
                  $data .= "<h6 style='text-align:center'>$employee->name </h6></p>";
                  $data .= '<table class="" id="table_style">';
                  $data .= '<tr>';
                  $data .= '<th>#</th>';
                  $data .= '<th>Date</th>';
                  $data .= '<th>Hours</th>';
                  $data .= '<th>Amount</th>';
                  $data .= '</tr>';
                  $data .= '<tbody>';
                  $i = 1;
                  foreach ($overtimes as $row) {
                      $data .= "<tr>";
                      $data.= "<td>" .$i . "</td>";
                      $data .= "<td>" .$row->date . "</td>";
                      $data .= "<td>" .$row->hourse . "</td>";
                      $data .= "<td>" .$row->amount." </td>";
                      $data.="</tr>";
                      $i++;
                  }
                  if ($i == 1) {
                      $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
                  }
                $data .= "</tbody>";
                $data .= '</table>';
                $data.='</table>';
                $data.='<table class="">';
                $data.=' <tr>';
                $data.='<th colspan="0" rowspan="2"> Sub Total</th>';
                $data.='<th colspan="">Amount</th>';
                $data.=' </tr>';
                $data.=' <tr>';
                $data.='<td>'.$overtimes->sum('amount').'</td>';
                $data.='</tr>';
                $data.='</table>';
            }
            if($type_id==3)
            {
                $employee=Employee::find($request->employee_id);
                $attendance=EmployeeAttendance::whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->where('employee_id',$employee_id)->get();
                $data.="<h6 style='text-align:center'>".$bname."</h6>";
                $data.="<h6 style='text-align:center'>Attendance Report of $f_month Month</h6>";
                $data .= "<h6 style='text-align:center'>$employee->name </h6><p style='text-align:center'></p>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<thead>';
                $data .= '<tr>';
                $data .= '<th>date</th>';
                $data .= '<th>status</th>';
                $data .= '<th>reson</th>';
                $data .= '</tr>';
                $data .= '</thead>';
                $data .= '<tbody>';
                foreach($attendance as $row){
                    $data .= '<tr>';
                    $data.= "<td>" .$row->date . "</td>";
                    $data.= "<td>";
                    if($row->status==1){
                        $data.="Present";
                    }else if($row->status==2){
                        $data.="Upsent";
                    }else{
                        $data.="leave";
                    }
                     $data.="</td>";
                    $data.= "<td>" .$row->reson . "</td>";
                    $data .= '</tr>';
                }
                $data .= '</tbody>';
                $data .= '</table>';
             }
             if($type_id==4){
                $employee=Employee::find($request->employee_id);
                $salary = EmployeeSalary::whereBetween('year', [$f_year, $t_year])->whereBetween('month',[$f_month,$t_month])->where('employee_id',$employee_id)->get();
                $data.="<h6 style='text-align:center'>".$bname."</h6>";
                  $data .= "<h6 style='text-align:center'>$employee->name Salary Report</h6><p style='text-align:center'>From ($fDate) to ($tDate)</p>";
                  $data .= '<table class="" id="table_style">';
                  $data .= '<tr>';
                  $data .= '<th>Number</th>';
                  $data .= '<th>Details</th>';
                  $data .= '<th>B-S</th>';
                  $data .= '<th>Overtime</th>';
                  $data .= '<th>Attendance</th>';
                  $data .= '<th>Attend Amount</th>';
                  $data .= '<th>Gross Salary</th>';
                  $data .= '<th>Advance</th>';
                  $data .= '<th>Net Salary</th>';
                  $data .= '</tr>';
                  $data .= '<tbody>';
                  $i = 1;
                  foreach ($salary as $row) {
                      $data .= "<tr>";
                      $data.= "<td>" .$i . "</td>";
                      $data .= "<td>" .$row->basic_salary . "</td>";
                      $data .= "<td>" .$row->details . "</td>";
                      $data .= "<td>" .$row->overtime_amount." </td>";
                      $data .= "<td>" .$row->opsent_day. "</td>";
                      $data .= "<td>" .$row->opsent_amount. "</td>";
                      $data .= "<td>" .$row->gross_salary . "</td>";
                      $data .= "<td>" .$row->advance_amount . "</td>";
                      $data .= "<td>" .$row->net_salary . "</td>";
                      $data.="</tr>";
                      $i++;
                  }
                  if ($i == 1) {
                      $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
                  }
                  $data .= "</tbody>";
                  $data .= '</table>';
                  $data.='</table>';
                  $data.='<table class="">';
                  $data.=' <tr>';
                  $data.='<th colspan="0" rowspan="2"> Sub Total</th>';
                  $data.='<th colspan="">Gross Total</th>';
                  $data.=' </tr>';
                  $data.=' <tr>';
                  $data.='<td>'.$salary->sum('gross_salary').'</td>';
                  $data.='</tr>';
                  $data.='</table>';
             }
             if($type_id=="5"){
                $employee=Employee::find($request->employee_id);
                $attendance=EmployeeAttendance::all();
                $overtime=EmployeeOverTime::all();
                $advance=EmployeeAdvance::all();
                $salary=EmployeeSalary::all();
                $fDate=$request->fromDate;
                $tDate=$request->toDate;
                $f_data = explode('-',$request->fromDate);
                $f_year=$f_data[0];
                $f_month=$f_data[1];
                $t_data = explode('-',$request->toDate);
                $t_year=$t_data[0];
                $t_month=$t_data[1];
                $data.="<h6 style='text-align:center'>".$bname."</h6>";
                $data.="<h6 style='text-align:center'>$fDate to $tDate</h6>";
                $data .= "<h6 style='text-align:center'>All Report </h6>";
                $data .= "<h6 style='text-align:center'>$employee->name </h6>";
                $data .= "<h6 style='text-align:center'>Containe Content , Salary, Attendance, Overtime</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<thead>';
                $data .= '<tr>';
                $data .= '<th>Name</th>';
                $data .= '<th>year</th>';
                $data .= '<th>Month</th>';
                $data .= '<th>BS</th>';
                $data .= '<th>Attendance</th>';
                $data .= '<th>Overtime</th>';
                $data .= '<th>GS</th>';
                $data .= '<th>Advance</th>';
                $data .= '<th>NS</th>';
                $data .= '</tr>';
                $data .= '</thead>';
                $data .= '<tbody>';
                    $present=$attendance->where('employee_id',$employee->id)->where('status',1)->whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->count('id');
                    // $opsent=$attendance->where('employee_id',$employee->id)->where('status',2)->whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->count('id');
                    // $leve=$attendance->where('employee_id',$employee->id)->where('status',3)->whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->count('id');
                    $advance=EmployeeAdvance::whereBetween('date', [$fDate, $tDate])->where('employee_id',$employee->id)->sum('payment');
                    $overtime=EmployeeOverTime::whereBetween('date', [$fDate, $tDate])->where('employee_id',$employee->id)->sum('amount');
                    $salary=EmployeeSalary::whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->where('employee_id',$employee->id)->sum('gross_salary');
                    $net_salary=EmployeeSalary::whereBetween('year',[$f_year,$t_year])->whereBetween('month',[$f_month,$t_month])->where('employee_id',$employee->id)->sum('net_salary');
                    $data .= '<tr>';
                    $data.= "<td>" .$employee->name . "</td>";
                    $data.= "<td>" .$f_year . "</td>";
                    $data.= "<td>" .$f_month . "</td>";
                    $data.= "<td>" .$employee->basic_salary . "</td>";
                    $data.= "<td>";
                    $data.=$present;
                    $data.="</td>";
                    $data.= "<td>" .$overtime . "</td>";
                    $data.= "<td>";
                    $per_day_salary=$employee->basic_salary/30;
                    $attend_amount=$present*$per_day_salary;
                    $gs_salary=$attend_amount+$overtime;
                    $data.=round($gs_salary,2);
                    $data.="</td>";
                    $data.= "<td>" .$advance . "</td>";
                    $data.= "<td>" .round($gs_salary-$advance,2) . "</td>";
                    $data.= "<td>";

                    $data.="</td>";

                $data.='</table>';
            }
        }
        return $data;
    }

    public function filter_find(Request $request){
        if ($request->type_id == 1) {
            $employess=Employee::orderBy('id', 'desc')->where('name', 'like', '%' . $request->name . '%')->paginate(20);
        }
        if ($request->type_id == 2) {
            $employess=Employee::orderBy('id', 'desc')->where('phone', 'like', '%' . $request->phone . '%')->paginate(20);

        }
        if ($request->type_id == 3) {
            $employess=Employee::orderBy('id', 'desc')->where('address', 'like', '%' . $request->address . '%')->paginate(20);

        }
        return view('HR.employees.index',compact('employess'));
    }

}
