<?php

namespace App\Http\Controllers\HR;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\EmployeeOverTime;
use App\Models\Employee;
use Illuminate\Support\Facades\Auth;

class EmployeeOvertimeController extends Controller
{
    public function index($id){
        $employee=Employee::find($id);
        $overtimes=EmployeeOverTime::where('employee_id',$id)->orderBy('id','desc')->paginate(20);
        return view('HR.employees.overtime.index',compact('overtimes','employee'));
    }
    public function store(Request $request){
        $request->validate([
            'amount' => 'required',
            'date' => 'required',
            'hours' => 'required',

        ]);
        $overtime=new EmployeeOverTime();
        $overtime->employee_id=$request->employee_id;
        $overtime->amount = $request->amount;
        $overtime->hourse = $request->hours;
        $overtime->date=$request->date;
        $data = explode('-',$request->date);
        $year=$data[0];
        $month=$data[1];
        $day=$data[2];
        $overtime->year=$year;
        $overtime->month=$month;
        $overtime->day=$day;
        $overtime->status=1;
        $overtime->user_id=Auth::user()->id;
        $overtime->save();
        session()->flash("msg", "employee overtime Was Saved!");
        return back();
    }

    public function edit($id){
        $overtime=EmployeeOverTime::find($id);
        $employee=Employee::find($overtime->employee_id);

        return view('HR.employees.overtime.edit',compact('overtime','employee'));
    }

    public function update(Request $request,$id){

        $request->validate([
            'amount' => 'required',
            'date' => 'required',

        ]);
        $overtime=EmployeeOverTime::find($id);
        $overtime->employee_id=$request->employee_id;
        $overtime->date=$request->date;
        $data = explode('-',$request->date);
        $year=$data[0];
        $month=$data[1];
        $day=$data[2];
        $overtime->year=$year;
        $overtime->month=$month;
        $overtime->day=$day;
        $overtime->amount = $request->amount;
        $overtime->hourse = $request->hours;
        $overtime->user_id=Auth::user()->id;
        $overtime->save();
        session()->flash("msg", "employee overtime Was Updated!");
        return redirect()->route('employee_overtime.index',$request->employee_id);
    }

    public function delete($id){
        $overtime=EmployeeOverTime::find($id)->delete();
        session()->flash("msg", "employee overtime Was Deleted!");
        return back();

    }

    public function report_show($id){
      return view('HR.employees.overtime.report',compact('id'));
    }
    public function report_find(Request $request){
        $bname=\App\Models\Info::find(1)->business_name;
        $fDate=$request->fromDate;
        $tDate=$request->toDate;
        $employee_id=$request->employee_id;
        $employee=Employee::find($employee_id);
        $data="";
        $overtimes = EmployeeOverTime::whereBetween('date', [$fDate, $tDate])->where('employee_id',$employee_id)->get();
          $data.="<h6 style='text-align:center'>".$bname."</h6>";
          $data .= "<h6 style='text-align:center'>$employee->name overtime Report</h6>";
          $data.="<p style='text-align:center'>From ($fDate) to ($tDate)</p>";
          $data .= '<table class="" id="table_style">';
          $data .= '<tr>';
          $data .= '<th>Number</th>';
          $data .= '<th>Date</th>';
          $data .= '<th>Hours</th>';
          $data .= '<th>Amount</th>';
          $data .= '</tr>';
          $data .= '<tbody>';
          $i = 1;
          foreach ($overtimes as $row) {
              $data .= "<tr>";
              $data.= "<td>" .$i . "</td>";
              $data .= "<td>" .$row->date . "</td>";
              $data .= "<td>" .$row->hourse . "</td>";
              $data .= "<td>" .$row->amount." </td>";

              $data.="</tr>";
              $i++;
          }
          if ($i == 1) {
              $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
          }

          $data .= "</tbody>";
          $data .= '</table>';
          $data.='</table>';
          $data.='<table class="">';
          $data.=' <tr>';
          $data.='<th colspan="0" rowspan="2"> Sub Total</th>';
          $data.='<th colspan="">Amount</th>';
          $data.=' </tr>';
          $data.=' <tr>';
          $data.='<td>'.$overtimes->sum('amount').'</td>';
          $data.='</tr>';
          $data.='</table>';
          return $data;
    }

    public function filter_find(Request $request){
        if($request->type_id==1){
            $overtimes=EmployeeOverTime::Where('amount','like','%'.$request->amount.'%')
            ->where('employee_id',$request->employee_id)
            ->paginate(10);
        }
        else{
            $overtimes=EmployeeOverTime::whereBetween('date',[$request->f_date,$request->t_date])
            ->where('employee_id',$request->employee_id)
            ->paginate(10);
        }
        $employee=Employee::find($request->employee_id);
        return view('HR.employees.overtime.index',compact('overtimes','employee'));
    }
}
