<?php

namespace App\Http\Controllers\HR\multiple;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\EmployeeSalaries;
use App\Models\Month;
use App\Models\CashJournal;
use App\Models\Project;
use Auth;

class EmpSalaryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $employees = Employee::all();
        $salaries = EmployeeSalaries::orderBy('id', 'desc')->paginate(20);
        $months = Month::all();
        return view('HR.salaries.index', compact('employees', 'salaries', 'months'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $employees = Employee::all();
        $projects = Project::orderBy('id','desc')->where('status','!=',3)->get();
        return view('HR.salaries.create', compact('employees', 'projects'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'date' => 'required',
            'employee_id' => 'required',
        ]);
        $data = explode('-', $request->date);
        $year = $data[0];
        $month = $data[1];
        $day = $data[2];
        $check = EmployeeSalaries::where('employee_id', $request->employee_id)->where('year', $year)->where('month', $request->month_id)->count();
        if ($check != 0) {
            session()->flash("msg", "employee Get There Salary in This Month!");
            return back();
        } else {
            $salary = new EmployeeSalaries();
            $salary->employee_id = $request->employee_id;
            $salary->project_id = $request->project_id;
            $salary->type_id = $request->type_id;
            $salary->charge_by_donner=$request->charge_by_donner;
            $salary->charge_by_office=$request->charge_by_office;
            $salary->basic_salary = $request->basic_salary;
            $salary->advance_amount = $request->advance_payment;
            $salary->opsent_days = $request->present_days;
            $salary->opsent_amount = $request->present_amount;
            $salary->overtime_amount = $request->overtime_amount;
            $salary->gross_salary = $request->gross_salary;
            $salary->net_salary = $request->net_salary;
            $salary->date = $request->date;
            $salary->year = $year;
            $salary->month = $request->month_id;
            $salary->day = $day;
            $salary->user_id = Auth::user()->id;
            $salary->status = 0;
            $salary->details = $request->details;
            $salary->save();

            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = "as Salary";
                $cash->date = $salary->date;
                $cash->outgoing = $salary->net_salary;
                $cash->currency_id = 1;
                $cash->ex_rate = 1;
                $cash->module_id = 27;
                $cash->type_id = 27;
                $cash->module_record_id = $salary->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Cash Target From Employee Salary";
                $cash->save();
            }
        }

        session()->flash("msg", "employee Get There Salary in This Month!");
        return redirect()->route('employee_salaries.index');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $salary = EmployeeSalaries::find($id);
        return view('HR.salaries.show', compact('salary'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $salary = EmployeeSalaries::find($id);
        $employees = Employee::all();
        $projects = Project::orderBy('id','desc')->where('status','!=',3)->get();
        return view('HR.salaries.edit', compact('salary', 'employees','projects'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = explode('-', $request->date);
        $year = $data[0];
        $month = $data[1];
        $day = $data[2];

        $salary = EmployeeSalaries::find($id);
        $salary->employee_id = $request->employee_id;
        $salary->project_id = $request->project_id;
        $salary->type_id = $request->type_id;
        $salary->charge_by_donner=$request->charge_by_donner;
        $salary->charge_by_office=$request->charge_by_office;
        $salary->basic_salary = $request->basic_salary;
        $salary->advance_amount = $request->advance_payment;
        $salary->opsent_days = $request->present_days;
        $salary->opsent_amount = $request->present_amount;
        $salary->overtime_amount = $request->overtime_amount;
        $salary->gross_salary = $request->gross_salary;
        $salary->net_salary = $request->net_salary;
        $salary->date = $request->date;
        $salary->year = $year;
        $salary->month = $request->month_id;
        $salary->day = $day;
        $salary->user_id = Auth::user()->id;
        $salary->status = 0;
        $salary->details = $request->details;
        $salary->save();
        if ($salary) {
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 27)->where('module_record_id', $salary->id)->first();
                if ($cash != null) {
                    $cash->title = "as Salary";
                    $cash->date = $salary->date;
                    $cash->outgoing = $salary->net_salary;
                    $cash->currency_id = 1;
                    $cash->ex_rate = 1;
                    $cash->module_id = 27;
                    $cash->type_id = 27;
                    $cash->module_record_id = $salary->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Target From Employee Salary";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = "as Salary";
                    $cash->date = $salary->date;
                    $cash->outgoing = $salary->net_salary;
                    $cash->currency_id = 1;
                    $cash->ex_rate = 1;
                    $cash->module_id = 27;
                    $cash->type_id = 27;
                    $cash->module_record_id = $salary->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Cash Target From Employee Salary";
                    $cash->save();
                }
            } else {
                $cash = CashJournal::where('module_id', 27)->where('module_record_id', $salary->id)->delete();
            }
        }
        session()->flash("msg", "Employee Salary Has Been Updated!");
        return redirect()->route('employee_salaries.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function filter_find(Request $request)
    {
        $salaries = EmployeeSalaries::where('month', $request->month)->where('year', $request->year)->orderBy('id', 'desc')->paginate(10);
        $months = Month::all();
        return view('HR.salaries.index', compact('salaries', 'months'));
    }

    public function report_show()
    {
        $employees = Employee::all();
        return view('HR.salaries.report', compact('employees'));
    }

    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $f_data = explode('-', $request->fromDate);
        $f_year = $f_data[0];
        $f_month = $f_data[1];
        $t_data = explode('-', $request->toDate);
        $t_year = $t_data[0];
        $t_month = $t_data[1];
        $employee_id = $request->employee_id;
        $employee = Employee::find($employee_id);
        $data = "";
        if ($employee_id == "all") {
            $data .= "<h6 style='text-align:center'>" . $bname . "</h6>";
            $data .= "<h6 style='text-align:center'>All Employees Salary Report</h6><p style='text-align:center'>From ($fDate) to ($tDate)</p>";
            $data .= "<h6 style='text-align:center'>Print Date" . date('Y-M-d') . "</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>#</th>';
            $data .= '<th>Employee</th>';
            $data .= '<th>B-S</th>';
            $data .= '<th>Overtime</th>';
            $data .= '<th>Attend Days</th>';
            $data .= '<th>Attend Amount</th>';
            $data .= '<th>G-S</th>';
            $data .= '<th>Advance</th>';
            $data .= '<th>N-S</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $salary = EmployeeSalaries::whereBetween('year', [$f_year, $t_year])->whereBetween('month', [$f_month, $t_month])->get();
            $i = 1;
            foreach ($salary as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->employee->name . "</td>";
                $data .= "<td>" . $row->basic_salary . "</td>";
                $data .= "<td>" . $row->overtime_amount . " </td>";
                $data .= "<td>" . $row->opsent_days . "</td>";
                $data .= "<td>" . round($row->opsent_amount, 2) . "</td>";
                $data .= "<td>" . round($row->gross_salary, 2) . "</td>";
                $data .= "<td>" . round($row->advance_amount, 2) . "</td>";
                $data .= "<td>" . round($row->net_salary, 2) . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
            }
            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '</table>';
            $data .= '<table class="">';
            $data .= ' <tr>';
            $data .= '<th colspan="0" rowspan="2"> Sub Total</th>';
            $data .= '<th colspan=""> Total</th>';
            $data .= ' </tr>';
            $data .= ' <tr>';
            $data .= '<td>' . $salary->sum('net_salary') . '</td>';
            $data .= '</tr>';
            $data .= '</table>';

        } else {
            $data .= "<h6 style='text-align:center'>" . $bname . "</h6>";
            $data .= "<h6 style='text-align:center'>$employee->name Salary Report</h6><p style='text-align:center'>From ($fDate) to ($tDate)</p>";
            $data .= "<h6 style='text-align:center'>Print Date" . date('Y-M-d') . "</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>Number</th>';
            $data .= '<th>B-S</th>';
            $data .= '<th>Overtime</th>';
            $data .= '<th>Attendance</th>';
            $data .= '<th>Attend Amount</th>';
            $data .= '<th>G-S</th>';
            $data .= '<th>Advance</th>';
            $data .= '<th>N-S</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $salary = EmployeeSalaries::whereBetween('year', [$f_year, $t_year])->whereBetween('month', [$f_month, $t_month])->where('employee_id', $employee_id)->get();
            $i = 1;
            foreach ($salary as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->basic_salary . "</td>";
                $data .= "<td>" . $row->overtime_amount . " </td>";
                $data .= "<td>" . $row->opsent_days . "</td>";
                $data .= "<td>" . round($row->opsent_amount, 2) . "</td>";
                $data .= "<td>" . round($row->gross_salary, 2) . "</td>";
                $data .= "<td>" . round($row->advance_amount, 2) . "</td>";
                $data .= "<td>" . round($row->net_salary, 2) . "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6' style='text-align:center'>No data Available!</td></tr>";
            }
            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '</table>';
            $data .= '<table class="">';
            $data .= ' <tr>';
            $data .= '<th colspan="0" rowspan="2"> Sub Total</th>';
            $data .= '<th colspan=""> Total</th>';
            $data .= ' </tr>';
            $data .= ' <tr>';
            $data .= '<td>' . $salary->sum('net_salary') . '</td>';
            $data .= '</tr>';
            $data .= '</table>';

        }
        return $data;
    }
}
