<?php
namespace App\Http\Controllers\PurchaseAdministration;

use App\Http\Controllers\Controller;
use App\Models\SupplierBill;
use Illuminate\Http\Request;
use App\Models\SupplierPayment;
use App\Models\Currency;
use App\Models\Supplier;
use App\Models\CashJournal;
use App\Models\Project;
use Auth;

class MPaymentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $payments = SupplierPayment::orderBy('id', 'desc')->paginate(10);
        $currencies = Currency::all();
        $suppliers = Supplier::all();
        return view('purchase.payments.index', compact('payments', 'currencies', 'suppliers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $currencies = Currency::all();
        $suppliers = Supplier::all();
        $projects=Project::orderBy('id','desc')->where('status','!=',3)->get();
        $invoice_number = SupplierPayment::orderBy('id', 'desc')->get()->first();
        $number = "";
        return view('purchase.payments.create', compact('currencies', 'suppliers', 'number','projects'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'amount' => 'required',
            'date' => 'required',
            'currency_id' => 'required',
            'invoice_number' => 'required',
            'supplier_id' => 'required',
        ]);
        $payment = new SupplierPayment();
        $payment->supplier_id = $request->supplier_id;
        $payment->project_id=$request->project_id;
        $payment->invoice_number = $request->invoice_number;
        $payment->amount = $request->amount;
        $payment->date = $request->date;
        $payment->title = $request->title;
        $payment->details = $request->details;
        $payment->currency_id = $request->currency_id;
        $payment->ex_rate = $request->ex_rate;
        $payment->status = 1;
        $payment->load_from_bill = 0;
        $payment->user_id = Auth::user()->id;
        $payment->c_target = $request->c_target;
        $payment->save();
        if ($request->cash_id == 1) {
            $cash = new CashJournal();
            $cash->title = $payment->title . " Invoice" . $payment->invoice_number;
            $cash->date = $payment->date;
            $cash->outgoing = $payment->amount;
            $cash->currency_id = $payment->currency_id;
            $cash->ex_rate = $payment->ex_rate;
            $cash->module_id = 22;
            $cash->type_id = 22;
            $cash->module_record_id = $payment->id;
            $cash->user_id = Auth::user()->id;
            $cash->details = "Target From Payment";
            $cash->save();
        }
        session()->flash("msg", "Success!");
        return redirect()->route('msupplier_payment.index');
    }
    public function show($id){
        $data = SupplierPayment::find($id);
        $total_purchase=SupplierBill::where('supplier_id',$data->supplier_id)->where('currency_id',$data->currency_id)->sum('grand_total');
        $total_payment = SupplierPayment::where('supplier_id',$data->supplier_id)->where('currency_id',$data->currency_id)->sum('amount');
        $tbalance=$total_purchase-$total_payment;
        return view('purchase.payments.show',compact('data','tbalance'));

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $data = SupplierPayment::find($id);
        $suppliers = Supplier::all();
        $currencies = Currency::all();
        $projects=Project::orderBy('id','desc')->where('status','!=',3)->get();
        return view('purchase.payments.edit', compact('data', 'currencies', 'suppliers','projects'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required',
            'amount' => 'required',
            'date' => 'required',
            'currency_id' => 'required',
        ]);
        $payment = SupplierPayment::find($id);
        $payment->supplier_id = $request->supplier_id;
        $payment->project_id=$request->project_id;
        $payment->invoice_number = $request->invoice_number;
        $payment->amount = $request->amount;
        $payment->date = $request->date;
        $payment->title = $request->title;
        $payment->details = $request->details;
        $payment->currency_id = $request->currency_id;
        $payment->ex_rate = $request->ex_rate;
        $payment->status = 1;
        $payment->c_target = $request->c_target;
        $payment->load_from_bill = 0;
        $payment->user_id = Auth::user()->id;
        $payment->save();
        if ($payment) {
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 22)->where('module_record_id', $payment->id)->first();
                if ($cash != null) {
                    $cash->title = $payment->title . " Invoice" . $payment->invoice_number;
                    $cash->date = $payment->date;
                    $cash->outgoing = $payment->amount;
                    $cash->currency_id = $payment->currency_id;
                    $cash->ex_rate = $payment->ex_rate;
                    $cash->module_id = 22;
                    $cash->type_id = 22;
                    $cash->module_record_id = $payment->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Target From Payment";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $payment->title . " Invoice" . $payment->invoice_number;
                    $cash->date = $payment->date;
                    $cash->outgoing = $payment->amount;
                    $cash->currency_id = $payment->currency_id;
                    $cash->ex_rate = $payment->ex_rate;
                    $cash->module_id = 22;
                    $cash->type_id = 22;
                    $cash->module_record_id = $payment->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Target From Payment ";
                    $cash->save();
                }
            }else{
                $cash = CashJournal::where('module_id', 22)->where('module_record_id', $payment->id)->delete();
            }
        }
        session()->flash("msg", "Success!");
        return redirect()->route('msupplier_payment.index');
    }

    public function delete($id)
    {
        $payment = SupplierPayment::find($id)->delete();
        session()->flash("msg", "Success!");
        return back();

    }

    public function report_show()
    {
        $currencies = Currency::all();
        $supplier = Supplier::all();
        return view('purchase.payments.report', compact('supplier', 'currencies'));
    }
    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $supplier_id = $request->supplier_id;
        $currency_id = $request->currency_id;
        $supplier = Supplier::find($supplier_id);

        $currency = Currency::find($currency_id);
        $currencies = Currency::all();
        $data = "";
        if ($supplier_id == "all") {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>All Suppliers</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>Payment Report</h6>";
                $data .= "<h6 style='text-align:center;'>All Currency</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>Number</th>';
                $data .= '<th>supplier</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>payment</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $payments = SupplierPayment::whereBetween('date', [$fDate, $tDate])->get();
                foreach ($payments as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->supplier->name . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
                $data .= '<th colspan="22" class="">Payment</th>';

                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $payment = SupplierPayment::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                    $data .= '<td style="">' . $row->title_en . "/" . $payment . '</td>';
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>All Suppliers</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>Payment Report</h6>";
                $data .= "<h6 style='text-align:center;'>$currency->title_en Currency Report</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>Number</th>';
                $data .= '<th>Supplier</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>payment</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $payments = SupplierPayment::whereBetween('date', [$fDate, $tDate])->where('currency_id', $currency_id)->get();
                foreach ($payments as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->supplier->name . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th  rowspan="2">Sub Total</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $payment = SupplierPayment::where('currency_id', $currency_id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                $data .= "<td colspan='22'>";
                $data .= $payment;
                $data .= "</td>";
                $data .= '</tr>';
                $data .= '</table>';
            }
        } else {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>$supplier->name </h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>Payment Report</h6>";
                $data .= "<h6 style='text-align:center;'>All Currency </h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>payment</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $payments = SupplierPayment::whereBetween('date', [$fDate, $tDate])->where('supplier_id', $supplier_id)->get();
                foreach ($payments as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
                $data .= '<th colspan="22" class="">Payment</th>';

                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $payment = SupplierPayment::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                    $data .= '<td style="">' . $row->title_en . "/" . $payment . '</td>';
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>$supplier->name </h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>Payment Report</h6>";
                $data .= "<h6 style='text-align:center;'>$currency->title_en Currency Report</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>payment</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $payments = SupplierPayment::whereBetween('date', [$fDate, $tDate])->where('supplier_id', $supplier_id)->where('currency_id', $currency_id)->get();
                foreach ($payments as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th  rowspan="2">Sub Total</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $payment = SupplierPayment::where('currency_id', $currency_id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                $data .= "<td colspan='22'>";
                $data .= $payment;
                $data .= "</td>";
                $data .= '</tr>';
                $data .= '</table>';
            }
        }

        return $data;
    }
    public function filter_find(Request $request)
    {
        $currencies = Currency::all();
        if ($request->type_id == 1) {
            $payments = SupplierPayment::Where('invoice_number', $request->number)
                ->get();
        } else if($request->type_id==2){
            $payments = SupplierPayment::Where('title', 'like', '%' . $request->title . '%')
                ->get();
        }else{
            $payments = SupplierPayment::whereBetween('date',[$request->f_date,$request->t_date])
            ->get();
        }
        return view('purchase.payments.filter', compact('currencies', 'payments'));
    }
    public function print_receipt($id){
        $data = SupplierPayment::find($id);
        $total_purchase=SupplierBill::where('supplier_id',$data->supplier_id)->where('currency_id',$data->currency_id)->sum('grand_total');
        $total_payment = SupplierPayment::where('supplier_id',$data->supplier_id)->where('currency_id',$data->currency_id)->sum('amount');
        $tbalance=$total_purchase-$total_payment;
        return view('purchase.payments.invoice',compact('data','tbalance'));
    }
}
