<?php

namespace App\Http\Controllers\PurchaseAdministration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Currency;
use App\Models\Supplier;
use App\Models\SupplierAdvance;
use App\Models\CashJournal;
use Auth;

class MSupplierAdvanceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $suppliers = Supplier::all();
        $advances = SupplierAdvance::orderBy('id', 'desc')->paginate(10);
        $currencies = Currency::all();
        return view('purchase.advances.index', compact('advances', 'suppliers', 'currencies'));
    }

    public function create()
    {
        $suppliers = Supplier::all();
        $currencies = Currency::all();
        $invoice_number = SupplierAdvance::orderBy('id', 'desc')->get()->first();
        $number = "";
        if ($invoice_number == "") {
            $number = $invoice_number = 1;
        } else {
            $number = $invoice_number->invoice_number + 1;
        }
        return view('purchase.advances.create', compact('suppliers', 'currencies', 'number'));
    }
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'amount' => 'required',
            'date' => 'required',
            'currency_id' => 'required',
            'supplier_id' => 'required',
        ]);
        $advance = new SupplierAdvance();
        $advance->supplier_id = $request->supplier_id;
        $advance->invoice_number = $request->invoice_number;
        $advance->amount = $request->amount;
        $advance->date = $request->date;
        $advance->title = $request->title;
        $advance->details = $request->details;
        $advance->currency_id = $request->currency_id;
        $advance->ex_rate = $request->ex_rate;
        $advance->status = 1;
        $advance->c_target = $request->cash_id;
        $advance->user_id = Auth::user()->id;
        $advance->save();
        if ($advance) {
            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = $advance->title . " Invoice" . $advance->invoice_number;
                $cash->date = $advance->date;
                $cash->outgoing = $advance->amount;
                $cash->currency_id = $advance->currency_id;
                $cash->ex_rate = $advance->ex_rate;
                $cash->module_id = 31;
                $cash->type_id = 31;
                $cash->module_record_id = $advance->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Target From Supplier Advance";
                $cash->save();
            }
        }
        session()->flash("msg", "Success!");
        return redirect()->route('msupplier_advance.index');
    }

    public function edit($id)
    {
        $data = SupplierAdvance::find($id);
        $suppliers = Supplier::all();
        $currencies = Currency::all();
        return view('purchase.advances.edit', compact('data', 'currencies', 'suppliers'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required',
            'amount' => 'required',
            'date' => 'required',
            'currency_id' => 'required',
        ]);
        $advance = SupplierAdvance::find($id);
        $advance->supplier_id = $request->supplier_id;
        $advance->invoice_number = $request->invoice_number;
        $advance->amount = $request->amount;
        $advance->date = $request->date;
        $advance->title = $request->title;
        $advance->details = $request->details;
        $advance->currency_id = $request->currency_id;
        $advance->ex_rate = $request->ex_rate;
        $advance->status = 1;
        $advance->c_target = $request->cash_id;
        $advance->user_id = Auth::user()->id;
        $advance->save();
        if ($advance) {
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 31)->where('module_record_id', $advance->id)->first();
                if ($cash != null) {
                    $cash->title = $advance->title . " Invoice" . $advance->invoice_number;
                    $cash->date = $advance->date;
                    $cash->outgoing = $advance->amount;
                    $cash->currency_id = $advance->currency_id;
                    $cash->ex_rate = $advance->ex_rate;
                    $cash->module_id = 31;
                    $cash->type_id = 31;
                    $cash->module_record_id = $advance->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Target From Payment";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $advance->title . " Invoice" . $advance->invoice_number;
                    $cash->date = $advance->date;
                    $cash->outgoing = $advance->amount;
                    $cash->currency_id = $advance->currency_id;
                    $cash->ex_rate = $advance->ex_rate;
                    $cash->module_id = 31;
                    $cash->type_id = 31;
                    $cash->module_record_id = $advance->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Target From Payment ";
                    $cash->save();
                }
            } else {
                $cash = CashJournal::where('module_id', 31)->where('module_record_id', $advance->id)->delete();
            }
        }
        session()->flash("msg", "Success!");
        return redirect()->route('msupplier_advance.index');
    }

    public function delete($id)
    {
        $advance = SupplierAdvance::find($id)->delete();
        session()->flash("msg", "Success!");
        return back();

    }

    public function report_show()
    {
        $currencies = Currency::all();
        $suppliers = Supplier::all();
        return view('purchase.advances.report', compact('suppliers', 'currencies'));
    }
    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $supplier_id = $request->supplier_id;
        $currency_id = $request->currency_id;
        $supplier = Supplier::find($supplier_id);

        $currency = Currency::find($currency_id);
        $currencies = Currency::all();
        $data = "";
        if ($supplier_id == "all") {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>All Supplier </h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>advance Report</h6>";
                $data .= "<h6 style='text-align:center;'>All Currency</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>Number</th>';
                $data .= '<th>Supplier</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>advance</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $advances = SupplierAdvance::whereBetween('date', [$fDate, $tDate])->get();
                foreach ($advances as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->supplier->name . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
                $data .= '<th colspan="4" class="">advance</th>';

                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $advance = SupplierAdvance::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                    $data .= '<td style="">' . $row->title_en . "/" . $advance . '</td>';
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>All Supplier</h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>advance Report</h6>";
                $data .= "<h6 style='text-align:center;'>$currency->title_en Currency </h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>Number</th>';
                $data .= '<th>Supplier</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>advance</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $advances = SupplierAdvance::whereBetween('date', [$fDate, $tDate])->where('currency_id', $currency_id)->get();
                foreach ($advances as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->supplier->name . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th  rowspan="2">Sub Total</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $advance = SupplierAdvance::where('currency_id', $currency_id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                $data .= "<td colspan='4'>";
                $data .= $advance;
                $data .= "</td>";
                $data .= '</tr>';
                $data .= '</table>';
            }
        } else {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>$supplier->name </h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>advance Report</h6>";
                $data .= "<h6 style='text-align:center;'>All Currency</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>advance</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $advances = SupplierAdvance::whereBetween('date', [$fDate, $tDate])->where('supplier_id', $supplier_id)->get();
                foreach ($advances as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2">Sub Total</th>';
                $data .= '<th colspan="4" class="">advance</th>';

                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $advance = SupplierAdvance::where('currency_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                    $data .= '<td style="">' . $row->title_en . "/" . $advance . '</td>';
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
                $data .= "<h6 style='text-align:center;'>$supplier->name </h6><p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6 style='text-align:center;'>advance Report</h6>";
                $data .= "<h6 style='text-align:center;'>$currency->title_en Currency Report</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>advance</th>';
                $data .= '<th>Details</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $advances = SupplierAdvance::whereBetween('date', [$fDate, $tDate])->where('supplier_id', $supplier_id)->where('currency_id', $currency_id)->get();
                foreach ($advances as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . " </td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th  rowspan="2">Sub Total</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $advance = SupplierAdvance::where('currency_id', $currency_id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                $data .= "<td colspan='4'>";
                $data .= $advance;
                $data .= "</td>";
                $data .= '</tr>';
                $data .= '</table>';
            }
        }

        return $data;
    }

    public function filter_find(Request $request)
    {
        if ($request->type_id == 1) {
            $advances = SupplierAdvance::Where('invoice_number', $request->number)
                ->get();
        } else if ($request->type_id == 2) {
            $advances = SupplierAdvance::Where('title', 'like', '%' . $request->title . '%')
                ->get();
        } else {
            $advances = SupplierAdvance::whereBetween('date', [$request->f_date, $request->t_date])
                ->get();
        }
        return view('purchase.advances.filter', compact('advances'));
    }
}
