<?php

namespace App\Http\Controllers\PurchaseAdministration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Supplier;
use App\Models\Currency;
use App\Models\SupplierBill;
use App\Models\SupplierBillItem;
use App\Models\PCategory;
use App\Models\PUnit;
use App\Models\SupplierPayment;
use App\Models\CashJournal;

use App\Models\PurchaseBillItem;
use App\Models\Scategory;
use App\Models\SSubCategory;
use App\Models\SUnit;
use App\Models\SWeight;
use App\Models\Stock;
use App\Models\StockLocation;
use App\Models\Project;
use Auth;


class MSupplierBillController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $supplier = Supplier::all();
        $bills = supplierBill::orderBy('id', 'desc')->paginate(10);
        $currencies = Currency::all();
        return view('purchase.bills.index', compact('supplier', 'bills', 'currencies'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $suppliers = Supplier::all();
        $currencies = Currency::all();
        $projects=Project::orderBy('id','desc')->where('status','!=',3)->get();
        $invoice_number = supplierBill::orderBy('id', 'desc')->get()->first();
        $number = "";
       

        return view('purchase.bills.bill-create', compact('suppliers', 'currencies', 'number','projects'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'date' => 'required',
            'supplier_id' => 'required',
            'invoice_number' => 'required',
            'currency_id' => 'required',
        ]);
        $bill = new supplierBill();
        $bill->supplier_id = $request->supplier_id;
        $bill->type_id = 2;
        $bill->project_id = $request->project_id;
        $bill->invoice_date = $request->date;
        $bill->invoice_number = $request->invoice_number;
        $bill->title = $request->title;
        $bill->currency_id = $request->currency_id;
        $bill->ex_rate = $request->ex_rate;
        $bill->status = 0;
        $date = date("Y-m-d");
        if (request()->hasFile('bill_files')) {
            $filename = 'bill_files-' . time() . '-' . request()->file('bill_files')->getClientOriginalName();
            $path = request()->file('bill_files')->storeAs('supplier_bill_files/' . $date . '/', $filename, 'public');
        } else {
            $path = "bill_files/noimage.jpg";
        }
        $bill->invoice_file = $path;
        $bill->save();
        if ($bill) {
            return redirect()->route('msupplier_bill.create_next', $bill->id);
        }
    }
    public function next_create($id)
    {
        $bill = SupplierBill::find($id);
        $bill_id = $bill->id;
        $supplier_id = $bill->supplier_id;
        $categories = PCategory::all();
        $units = PUnit::all();
        // if ($bill->type_id == 1 || $bill->type_id == null) {
            $bill_items = supplierBillItem::where('bill_id', $id)->get();
            return view('purchase.bills.bill-create-next', compact('categories', 'units', 'bill_items', 'bill_id', 'supplier_id'));
        // } else {
            // $categories = Scategory::all();
            // $subcategories = SSubCategory::all();
            // $units = SUnit::all();
            // $weights = SWeight::all();
            // $bill_items = PurchaseBillItem::where('bill_id', $bill_id)->get();
            // $location = StockLocation::all();
            // $supplier = Supplier::find($bill->supplier_id);

            // return view('purchase.bills.tread.bill-create-next', compact('supplier', 'categories', 'weights', 'units', 'bill_id', 'bill_items', 'location'));
        // }
    }

    public function next_store(Request $request)
    {
        $request->validate([
            'grand_total' => 'required',
            'payment' => 'required',
        ]);
        $bill = supplierBill::find($request->bill_id);
        $bill->grand_total = $request->grand_total;
        $bill->payment = $request->payment;
        if ($request->balance_value == "" || $request->balance_value == 0) {
            $bill->balance = $request->grand_total;
        } else {
            $bill->balance = $request->balance_value;
        }
        $bill->payment_by = $request->payment_by;
        $bill->transaction_id = $request->transaction_id;
        $bill->c_target = $request->cash_id;
        $bill->save();
        if ($bill) {
            if ($request->payment != 0) {
                $payment = new SupplierPayment();
                $payment->supplier_id = $bill->supplier_id;
                $payment->currency_id = $bill->currency_id;
                $payment->invoice_number = $bill->invoice_number;
                $payment->bill_id = $bill->id;
                $payment->title = "Payment is Added from bill Number is " . $bill->invoice_number;
                $payment->amount = $request->payment;
                $payment->date = $bill->invoice_date;
                $payment->ex_rate = $bill->ex_rate;
                $payment->load_from_bill = 1;
                $payment->details = "Payment is Added from bill Number is " . $bill->invoice_number;
                $payment->save();
            }
            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = $bill->title . " Invoice" . $bill->invoice_number;
                $cash->date = $bill->invoice_date;
                $cash->outgoing = $bill->payment;
                $cash->currency_id = $bill->currency_id;
                $cash->module_id = 21;
                $cash->type_id = 21;
                $cash->module_record_id = $bill->id;
                $cash->user_id = Auth::user()->id;
                $cash->details = "Target cash From Purchase";
                $cash->save();
            }
        }
        session()->flash("msg", "Success!");
        return redirect()->route('msupplier_bill.index');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $bill = supplierBill::find($id);
        if ($bill->type_id == 1 || $bill->type_id == null) {
            $bill_items = supplierBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
            return view('purchase.bills.show', compact('bill', 'bill_items'));
        } else {
            $bill_items = PurchaseBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
            return view('purchase.bills.tread.show', compact('bill', 'bill_items'));
        }

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $bill = supplierBill::find($id);
        $bill_id = $bill->id;
        $supplier_id = $bill->supplier_id;
        $bill_items = supplierBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
        $suppliers = Supplier::all();
        $categories = PCategory::all();
        $units = PUnit::all();
        $currencies = Currency::all();
        $projects=Project::orderBy('id','desc')->where('status','!=',3)->get();
        // if ($bill->type_id == 1 || $bill->type_id == null) {
        return view('purchase.bills.edit', compact('bill', 'bill_items', 'suppliers', 'categories', 'units', 'currencies', 'bill_id', 'supplier_id','projects'));
        // } else {
        //     $bill_items = PurchaseBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
        //     $supplier = Supplier::find($bill->supplier_id);
        //     $categories = Scategory::all();
        //     $subcategories = SSubCategory::all();
        //     $units = SUnit::all();
        //     $weights = SWeight::all();
        //     $currencies = Currency::all();
        //     $location = StockLocation::all();
        //     return view('purchase.bills.tread.edit', compact('bill', 'bill_items', 'suppliers', 'categories', 'units', 'weights', 'currencies', 'bill_id', 'supplier_id', 'supplier', 'location'));

        // }

    }
    public function update(Request $request, $id)
    {
        $request->validate([
            'grand_total' => 'required',
            'payment' => 'required',
        ]);
        $bill = supplierBill::find($id);
        $bill->supplier_id = $request->supplier_id;
        $bill->project_id = $request->project_id;

        $bill->invoice_date = $request->date;
        $bill->invoice_number = $request->invoice_number;
        $bill->title = $request->title;
        $bill->currency_id = $request->currency_id;
        $bill->ex_rate = $request->ex_rate;
        $bill->status = 0;
        $date = date("Y-m-d");
        if (request()->hasFile('bill_files')) {
            $filename = 'bill_files-' . time() . '-' . request()->file('bill_files')->getClientOriginalName();
            $path = request()->file('bill_files')->storeAs('supplier_bill_files/' . $date . '/', $filename, 'public');
        } else {
            $path = "bill_files/noimage.jpg";
        }
        $bill->invoice_file = $path;
        $bill->grand_total = $request->grand_total;
        $bill->payment = $request->payment;
        if ($request->balance_value == "" || $request->balance_value == 0) {
            $bill->balance = $request->grand_total;
        } else {
            $bill->balance = $request->balance_value;
        }
        $bill->payment_by = $request->payment_by;
        $bill->transaction_id = $request->transaction_id;
        $bill->c_target = $request->cash_id;
        $bill->save();
        if ($bill) {
            $payment_in_payment_table = SupplierPayment::where('supplier_id', $bill->supplier_id)->where('bill_id', $bill->id)->first();
            if ($payment_in_payment_table != null) {
                SupplierPayment::where('supplier_id', $bill->supplier_id)->where('bill_id', $bill->id)->delete();
                if ($request->payment != 0) {
                    $payment = new SupplierPayment();
                    $payment->supplier_id = $bill->supplier_id;
                    $payment->currency_id = $bill->currency_id;
                    $payment->ex_rate = $bill->ex_rate;
                    $payment->bill_id = $bill->id;
                    $payment->title = "Payment is Added from bill Number is " . $bill->invoice_number;
                    $payment->amount = $request->payment;
                    $payment->invoice_number = $request->invoice_number;
                    $payment->date = $bill->date;
                    $payment->details = "Payment is Added from bill Number is " . $bill->invoice_number;
                    $payment->save();
                }
            } else {
                if ($request->payment != 0) {
                    $payment = new SupplierPayment();
                    $payment->supplier_id = $bill->supplier_id;
                    $payment->currency_id = $bill->currency_id;
                    $payment->ex_rate = $bill->ex_rate;
                    $payment->bill_id = $bill->id;
                    $payment->title = "Payment is Added from bill Number is " . $bill->invoice_number;
                    $payment->amount = $request->payment;
                    $payment->invoice_number = $request->invoice_number;
                    $payment->date = $bill->date;
                    $payment->details = "Payment is Added from bill Number is " . $bill->invoice_number;
                    $payment->save();
                }
            }
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 21)->where('module_record_id', $bill->id)->first();
                if ($cash != null) {
                    $cash->title = $bill->title . " Invoice" . $bill->invoice_number;
                    $cash->date = $bill->invoice_date;
                    $cash->outgoing = $bill->payment;
                    $cash->currency_id = $bill->currency_id;
                    $cash->module_id = 21;
                    $cash->type_id = 21;
                    $cash->module_record_id = $bill->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Target cash From Purchase";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $bill->title . " Invoice" . $bill->invoice_number;
                    $cash->date = $bill->invoice_date;
                    $cash->outgoing = $bill->payment;
                    $cash->currency_id = $bill->currency_id;
                    $cash->module_id = 21;
                    $cash->type_id = 21;
                    $cash->module_record_id = $bill->id;
                    $cash->user_id = Auth::user()->id;
                    $cash->details = "Target cash From Purchase";
                    $cash->save();
                }
            } else {
                $cash = CashJournal::where('module_id', 21)->where('module_record_id', $bill->id)->delete();

            }


        }
        session()->flash("msg", "Success Updaded!");
        return redirect()->route('msupplier_bill.index');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $bill = supplierBill::find($id);
        $bill_items = supplierBillItem::where('bill_id', $id)->delete();

    }
    public function report_show()
    {
        $suppliers = Supplier::all();
        $currencies = Currency::all();
        return view('purchase.bills.report', compact('suppliers', 'currencies'));
    }

    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $supplier_id = $request->supplier_id;
        $currency_id = $request->currency_id;
        $supplier = Supplier::find($supplier_id);
        $currency = Currency::find($currency_id);
        $currencies = Currency::all();
        $bills = supplierBill::all();
        $data = "";
        if ($supplier_id == "all") {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'>Purchase Invoices Report</h6>";
                $data .= "<h6 style='text-align:center;'>All Suppliers Report</h6>";
                $data .= "<p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<p style='text-align:center;'>Print Date " . date('Y-M-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Invoice No</th>';
                $data .= '<th>Supplier</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Payment</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $supplier_bill = supplierBill::whereBetween('invoice_date', [$fDate, $tDate])->orderBy('invoice_date', 'asc')->get();
                foreach ($supplier_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->supplier->name . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->payment . "</td>";
                    $data .= "<td>" . $row->balance . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Total </th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Payment</th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $grand_total = $bills->where('currency_id', $row->id)->whereBetween('invoice_date', [$fDate, $tDate])->sum('grand_total');
                    $data .= '<td>' . $row->title_en . "/" . $grand_total . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $payment = $bills->where('currency_id', $row->id)->whereBetween('invoice_date', [$fDate, $tDate])->sum('payment');
                    $data .= '<td>' . $row->title_en . "/" . $payment . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $grand_total = $bills->where('currency_id', $row->id)->whereBetween('invoice_date', [$fDate, $tDate])->sum('grand_total');
                    $payment = $bills->where('currency_id', $row->id)->whereBetween('invoice_date', [$fDate, $tDate])->sum('payment');
                    $balance = $grand_total - $payment;
                    $data .= '<td>' . $row->title_en . "/" . $balance . '</td>';
                }

                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'>Purchase Invoices Report</h6>";
                $data .= "<h6 style='text-align:center;'>All Supplier</h6>";
                $data .= "<h6 style='text-align:center;'>$currency->title_en</h6>";
                $data .= "<p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<p style='text-align:center;'>Print Date " . date('Y-M-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Invoice No</th>';
                $data .= '<th>Supplier</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Payment</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $supplier_bill = supplierBill::whereBetween('invoice_date', [$fDate, $tDate])->orderBy('invoice_date', 'asc')->where('currency_id', $currency_id)->get();
                foreach ($supplier_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->supplier->name . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->payment . "</td>";
                    $data .= "<td>" . $row->balance . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "<tr>";
                $data .= '<th rowspan="2">Overview</th>';
                $data .= '<th colspan="2">Total</th>';
                $data .= '<th colspan="2">Payment</th>';
                $data .= '<th colspan="3">Belance</th>';
                $data .= "</tr>";
                $data .= "<tr>";

                $data .= '<th colspan="2">' . $bills->sum('grand_total') . '</th>';
                $data .= '<th colspan="2">' . $bills->sum('payment') . '</th>';
                $balance = $bills->sum('grand_total') - $bills->sum('payment');
                $data .= '<th colspan="3">' . $balance . '</th>';

                $data .= "</tr>";


                $data .= "</tbody>";

            }
        } else {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'>Purchase Invoices Report</h6>";
                $data .= "<h6 style='text-align:center;'>All Currency $supplier->name</h6>";
                $data .= "<p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<p style='text-align:center;'>Print Date " . date('Y-M-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Invoice No</th>';
                $data .= '<th>Supplier</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Payment</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $supplier_bill = supplierBill::whereBetween('invoice_date', [$fDate, $tDate])->where('supplier_id', $request->supplier_id)->orderBy('invoice_date', 'asc')->get();
                foreach ($supplier_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->supplier->name . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->payment . "</td>";
                    $data .= "<td>" . $row->balance . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Total </th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Payment</th>';
                $data .= '<th colspan="' . $currencies->count() . '" class="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $grand_total = $bills->where('currency_id', $row->id)->where('supplier_id', $request->supplier_id)->whereBetween('invoice_date', [$fDate, $tDate])->sum('grand_total');
                    $data .= '<td>' . $row->title_en . "/" . $grand_total . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $payment = $bills->where('currency_id', $row->id)->where('supplier_id', $request->supplier_id)->whereBetween('invoice_date', [$fDate, $tDate])->sum('payment');
                    $data .= '<td>' . $row->title_en . "/" . $payment . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $grand_total = $bills->where('currency_id', $row->id)->where('supplier_id', $request->supplier_id)->whereBetween('invoice_date', [$fDate, $tDate])->sum('grand_total');
                    $payment = $bills->where('currency_id', $row->id)->where('supplier_id', $request->supplier_id)->whereBetween('invoice_date', [$fDate, $tDate])->sum('payment');
                    $balance = $grand_total - $payment;
                    $data .= '<td>' . $row->title_en . "/" . $balance . '</td>';
                }

                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'>Purchase Invoices Report</h6>";
                $data .= "<h6 style='text-align:center;'>$supplier->name</h6>";
                $data .= "<h6 style='text-align:center;'>$currency->title_en</h6>";
                $data .= "<p style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<p style='text-align:center;'>Print Date " . date('Y-M-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Invoice No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Payment</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $supplier_bill = supplierBill::whereBetween('invoice_date', [$fDate, $tDate])->orderBy('invoice_date', 'asc')->where('currency_id', $currency_id)->where('supplier_id', $request->supplier_id)->get();
                foreach ($supplier_bill as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "<td>" . $row->payment . "</td>";
                    $data .= "<td>" . $row->balance . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "<tr>";
                $data .= '<th rowspan="2">Overview</th>';
                $data .= '<th colspan="2">Total</th>';
                $data .= '<th colspan="2">Payment</th>';
                $data .= '<th colspan="3">Belance</th>';
                $data .= "</tr>";
                $data .= "<tr>";

                $data .= '<th colspan="2">' . $bills->sum('grand_total') . '</th>';
                $data .= '<th colspan="2">' . $bills->sum('payment') . '</th>';
                $balance = $bills->sum('grand_total') - $bills->sum('payment');
                $data .= '<th colspan="3">' . $balance . '</th>';

                $data .= "</tr>";
                $data .= "</tbody>";

            }
        }

        return $data;
    }

    public function filter_find(Request $request)
    {
        $currencies = Currency::all();
        if ($request->type_id == 1) {
            $bills = supplierBill::Where('invoice_number', $request->number)
                ->get();
        } else if ($request->type_id == 2) {
            $bills = supplierBill::Where('title', 'like', '%' . $request->title . '%')
                ->get();
        } else {
            $bills = supplierBill::whereBetween('invoice_date', [$request->f_date, $request->t_date])
                ->get();
        }
        return view('purchase.bills.filter', compact('currencies', 'bills'));
    }

    public function print($id)
    {
        $bill = supplierBill::find($id);
        $bill_items = supplierBillItem::where('bill_id', $id)->get();
        $supplier = Supplier::find($bill->supplier_id);
        return view('purchase.bills.print-bill', compact('bill', 'bill_items', 'supplier'));

    }
}
