<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Tex;
use App\Models\Project;

class TaxController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $tax = Tex::orderBy('date', 'desc')->paginate(20);
        return view('journals.taxes.index', compact('tax'));
    }

    public function create()
    {
        $projects = Project::where('status', 2)->get();
        $tax = Tex::orderBy('date', 'desc')->paginate(20);
        return view('journals.taxes.create', compact('tax','projects'));
    }


    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'required',
            'amount' => 'required',
        ]);
        $tax = new Tex();
        $tax->title = $request->title;
        $tax->amount = $request->amount;
        $tax->project_id=$request->project_id;
        $tax->status = 1;
        $tax->user_id = Auth()->user()->id;
        $tax->date = $request->date;
        $tax->details = $request->details;
        $isSaved = $tax->save();
        if ($isSaved) {
            session()->flash("msg", "Success!");
            return redirect()->route('tax.index');
        }

    }
    public function edit($id)
    {
        $tax = Tex::find($id);
        $projects = Project::where('status', 2)->get();
        return view('journals.taxes.edit', compact('tax','projects'));

    }
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title' => 'required',
            'amount' => 'required',
        ]);
        $tax = Tex::find($id);
        $tax->project_id=$request->project_id;
        $tax->title = $request->title;
        $tax->amount = $request->amount;
        $tax->date = $request->date;
        $tax->details = $request->details;
        $isSaved = $tax->save();
        if ($isSaved) {
            session()->flash("msg", "Success!");
            return redirect()->route('tax.index');
        }
    }
    public function delete($id)
    {
        $tax = Tex::find($id)->delete();
        session()->flash("msg", "Success!");
        return redirect()->back();
    }

    public function report_show()
    {
        return view('journals.taxes.report');
    }

    public function report_find(Request $request)
    {
        $data = '';
        $from = $request->fromDate;
        $to = $request->toDate;
        $data .= "<h6 style='text-align:center;'>WAYGAL GREEN PAINT LTD</h6>";
        $data .= "<h6 style='text-align:center;'>From $from To $to</h6>";
        $data .= "<h6 style='text-align:center;'>Tax Report</h6>";
        $data .= '<table class="">';
        $data .= '<tr>';
        $data .= '<th>S-NO</th>';
        $data .= '<th>Title</th>';
        $data .= ' <th class="text-danger">Amount</th>';
        $data .= '<th>Details</th>';
        $data .= '<th>Date</th>';
        $data .= '</tr>';
        $data .= '<tbody>';
        $journal = Tex::whereBetween('date', [$from, $to])->orderBy('date', 'desc')->get();
        $i = 1;
        foreach ($journal as $row) {
            $data .= "<tr><td>" . $i . "</td>";
            $data .= "<td>" . $row->title . "</td>";
            $data .= "<td>" . $row->amount . "</td>";
            $data .= "<td>" . $row->details . "</td>";
            $data .= "<td>" . $row->date . "</td></tr>";
            $i++;
        }
        if ($i == 1) {
            $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
        }
        $data .= "</tbody>";
        $data .= '</table>';

        $data .= '<table class="">';
        $data .= ' <tr>';
        $data .= '<th colspan="0" rowspan="2"> Sub Total</th>';
        $data .= '<th colspan="">Amount</th>';

        $data .= ' </tr>';
        $data .= ' <tr>';
        $data .= '<td>' . $journal->sum('amount') . '</td>';

        $data .= '</tr>';
        $data .= '</table>';

        return $data;
    }

    public function filter_show()
    {
        $currency = Currency::all();
        $types = ExpenseType::all();
        $filter = "page";
        return view('journals.taxes.filter', compact('currency', 'types', 'filter'));

    }

    public function filter_find(Request $request)
    {
        $currency = Currency::all();
        $types = ExpenseType::all();
        if ($request->filter_id == 1) {
            $filter = Tex::Where('type_id', $request->type_id)->get();
        } else if ($request->filter_id == 2) {
            $filter = Tex::Where('currency_id', $request->currency_id)->get();
        } else if ($request->filter_id == 3) {
            $filter = Tex::Where('title', 'like', '%' . $request->title . '%')->get();
        } else if ($request->filter_id == 4) {
            $filter = Tex::Where('amount', 'like', '%' . $request->credit . '%')->get();
        } else {
            $filter = Tex::WhereBetween('date', [$request->fromDate, $request->toDate])->get();
        }
        return view('journals.taxes.filter', compact('currency', 'types', 'filter'));
    }
}
