<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Spatie\Activitylog\Contracts\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
use Validator;
use Auth;
class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $users = User::orderBy('id','desc')->paginate(10);
        $roles = Role::all();
        return view('accounts.user.create',compact('users','roles'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $roles = Role::all();
        return view('Admin.systemAdmin.AccessControl.user.create',compact('roles'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required',
            'password-confirm' => 'required|same:password',
            'roles' => 'required'
        ]);



        $input = $request->all();
        $input['password'] = Hash::make($input['password']);


        $user = User::create($input);
        $user->assignRole($request->input('roles'));
        session()->flash("msg", "Success!");
                return redirect()->route('user.index');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = User::find($id);
        return view('adminPanel.users.show',compact('user'));
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::find($id);
        $roles = Role::all();
        $userRole = $user->roles->all();



        return view('accounts.user.edit',compact('user','roles','userRole'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users,email,'.$id,
            'roles' => 'required'
        ]);

        $user = User::find($id);
        // $input = $request->all();
        $user->name=$request->name;
        $user->email=$request->email;
        if(!empty($request->password)){
            // $input['password'] = Hash::make($input['password']);
            $user->password= Hash::make($request->password);
        }
        else
        {
           $user->password=$user->password;
        }

        if($user->save()){
        // $user->update($input);
        DB::table('model_has_roles')->where('model_id',$id)->delete();


        $user->assignRole($request->input('roles'));
        }
        session()->flash("msg", "Success!");
        return redirect()->route('user.index');

        
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    public function profile() {
        return view("accounts.user.profile");
    }

    public function change_profile(Request $request) {
      

        $data = Validator::make($request->all(), [
                    'name' => ['required', 'string', 'max:255'],
                    'email' => ['required', 'string', 'email', 'max:191'],
                ])->validate();

        $user = User::find(Auth::id());
        $user->name = $request->name;
        $user->email = $request->email;
        $is_saved = $user->save();
        if ($is_saved) {
            session()->flash("msg", "Profile Has been Updated successfully!");
            return redirect()->route('user.profile');
        }
    }

    public function change_password(Request $request) {
        $data = Validator::make($request->all(), [
                    'password' => ['required', 'string', 'min:8', 'confirmed']
                ])->validate();
        if (Hash::check($request->current_password, Auth::user()->password)) {
            $user = User::find(Auth::id());
            $user->password = Hash::make($request->password);
            $is_saved = $user->save();
            if ($is_saved) {
                session()->flash("msg", "Passowrd Changed successfully!");
                return redirect()->route('user.profile');
            }
        } else {
            session()->flash("msg", "Currenct Password in incorrect!");
            return redirect()->route('user.profile');
        }
    }




    public function destroy($id)
    {
        User::find($id)->delete();
        session()->flash("msg", "Success");
                return redirect()->route('user.index');
    }

    
}
