<?php

namespace App\Http\Controllers\accounts;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DebitorAccount;
use App\Models\DebitorJournal;

class DebitorAccountController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $debitors=DebitorAccount::orderBy('created_at','desc')->where('status',1)->paginate(10);
        return view('accounts.debitors.create',compact('debitors'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'address' => 'required',
            'phone' => 'required',
            
        ]);
        $debitorAccount=new DebitorAccount();
        $debitorAccount->name=$request->name;
        $debitorAccount->phone=$request->phone;
        $debitorAccount->address=$request->address;
        $debitorAccount->status=1;
        $debitorAccount->user_id=Auth()->user()->id;
        $debitorAccount->date=date('Y-m-d');
        $isSaved=$debitorAccount->save();
        if($isSaved){
            session()->flash("msg", "Success");
            return redirect()->route('debitor_account.index');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function debit($id)
    {
        $debitorAccount=DebitorAccount::find($id);
        // DebitorJournal::where('debetor_id',$id)->
        return view('accounts.debitors.show',compact('debitorAccount'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $debitor=DebitorAccount::find($id);
        return view('accounts.debitors.edit',compact('debitor'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'address' => 'required',
            'phone' => 'required',
            
        ]);
        $debitorAccount=DebitorAccount::find($id);
        $debitorAccount->name=$request->name;
        $debitorAccount->phone=$request->phone;
        $debitorAccount->address=$request->address;
        $isSaved=$debitorAccount->save();
        if($isSaved){
            session()->flash("msg", "Success");
            return redirect()->route('debitor_account.index');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
