<?php

namespace App\Http\Controllers\accounts;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\InvestorAccount;

class InvestorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = InvestorAccount::orderBy('id','desc')->where('status', 1)->paginate(10);
        return view('accounts.investors.create', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'address' => 'required',
            'phone' => 'required',

        ]);
        $data = new InvestorAccount();
        $data->name = $request->name;
        $data->phone = $request->phone;
        $data->address = $request->address;
        $data->status = 1;
        $data->user_id = Auth()->user()->id;
        $data->date = date('Y-m-d');
        $isSaved = $data->save();
        if ($isSaved) {
            session()->flash("msg", "Success!");
            return redirect()->route('investor_account.index');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data = InvestorAccount::find($id);
        return view('accounts.investors.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = InvestorAccount::find($id);
        return view('accounts.investors.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'address' => 'required',
            'phone' => 'required',

        ]);
        $data = InvestorAccount::find($id);
        $data->name = $request->name;
        $data->phone = $request->phone;
        $data->address = $request->address;
        $data->status = 1;
        $data->user_id = Auth()->user()->id;
        $data->date = date('Y-m-d');
        $isSaved = $data->save();
        if ($isSaved) {
            session()->flash("msg", "Success!");
            return redirect()->route('investor_account.index');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
