<?php

namespace App\Http\Controllers\configuration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Currency;

class CurrencyController extends Controller
{
     /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $currency=Currency::orderBy('id','desc')->paginate(10);
        return view('configuration.currencies.create',compact('currency'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
       $currency=new Currency();
       $currency->title_en=$request->title_en;
       $currency->title_ps=$request->title_ps;
       $currency->title_dr=$request->title_dr;
       $currency->save();
       if($currency){
        return redirect()->route('currency.index')->with('msg','currency Type Was Created');
       }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $currency=Currency::find($id);
        return view('configuration.currencies.edit',compact('currency'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
       $currency=Currency::find($id);
       $currency->title_en=$request->title_en;
       $currency->title_ps=$request->title_ps;
       $currency->title_dr=$request->title_dr;
       $currency->save();
       if($currency){
        return redirect()->route('currency.index')->with('msg','currency Type Was Updated');
       }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function status($id){
        $currency=Currency::find($id);
        if($currency->status==0){
            Currency::where('id',$id)->update([
                'status'=>1
            ]);
        }
        if($currency->status==1){
            Currency::where('id',$id)->update([
                'status'=>0
            ]);
        }
        return back()->with('msg','Status Was Updated');
    }
}
