<?php

namespace App\Http\Controllers\configuration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PCategory;

class PurchaseCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Pcategory = Pcategory::orderBy('id','desc')->paginate(10);
        return view('configuration.Pcategories.create', compact('Pcategory'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
        $Pcategory = new Pcategory();
        $Pcategory->title_en = $request->title_en;
        $Pcategory->title_ps = $request->title_ps;
        $Pcategory->title_dr = $request->title_dr;
        $Pcategory->save();
        if ($Pcategory) {
            return redirect()->route('pcategories.index')->with('msg', 'Cash Type Was Created');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Pcategory = Pcategory::find($id);
        return view('configuration.Pcategories.edit', compact('Pcategory'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
        $Pcategory = Pcategory::find($id);
        $Pcategory->title_en = $request->title_en;
        $Pcategory->title_ps = $request->title_ps;
        $Pcategory->title_dr = $request->title_dr;
        $Pcategory->save();
        if ($Pcategory) {
            return redirect()->route('pcategories.index')->with('msg', 'Success');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function status($id)
    {
        $Pcategory = Pcategory::find($id);
        if ($Pcategory->status == 0) {
            Pcategory::where('id', $id)->update([
                'status' => 1
            ]);
        }
        if ($Pcategory->status == 1) {
            Pcategory::where('id', $id)->update([
                'status' => 0
            ]);
        }
        return back()->with('msg', 'Success');
    }
}
