<?php

namespace App\Http\Controllers\configuration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PCategory;
use App\Models\p_sub_category;

class PurchaseSubCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $categories = p_sub_category::orderBy('id','desc')->paginate(10);
        $scategories=PCategory::all();
        return view('configuration.PScategory.create', compact('categories','scategories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
        $categories = new p_sub_category();
        $categories->cat_id = $request->category_id;
        $categories->title_en = $request->title_en;
        $categories->title_ps = $request->title_ps;
        $categories->title_dr = $request->title_dr;
        $categories->save();
        if ($categories) {
            return redirect()->route('psubcategories.index')->with('msg', 'Cash Type Was Created');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $category = PCategory::find($id);
        $scategories=PCategory::all();
        return view('configuration.PScategory.edit', compact('scategories','category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
        $categories = p_sub_category::find($id);
        $categories->cat_id = $request->category_id;
        $categories->title_en = $request->title_en;
        $categories->title_ps = $request->title_ps;
        $categories->title_dr = $request->title_dr;
        $categories->save();
        if ($categories) {
            return redirect()->route('psubcategories.index')->with('msg', 'Success');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function status($id)
    {
        $categories = p_sub_category::find($id);
        if ($categories->status == 0) {
            p_sub_category::where('id', $id)->update([
                'status' => 1
            ]);
        }
        if ($categories->status == 1) {
            p_sub_category::where('id', $id)->update([
                'status' => 0
            ]);
        }
        return back()->with('msg', 'Success');
    }
}
