<?php

namespace App\Http\Controllers\configuration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PUnit;

class PurchaseUnitsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $PUnits=PUnit::orderBy('id','desc')->paginate(10);
        return view('configuration.Punits.create',compact('PUnits'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
       $PUnit=new PUnit();
       $PUnit->title_en=$request->title_en;
       $PUnit->title_ps=$request->title_ps;
       $PUnit->title_dr=$request->title_dr;
       $PUnit->save();
       if($PUnit){
        return redirect()->route('punits.index')->with('msg','Cash Type Was Created');
       }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $PUnit=PUnit::find($id);
        return view('configuration.Punits.edit',compact('PUnit'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
       $PUnit=PUnit::find($id);
       $PUnit->title_en=$request->title_en;
       $PUnit->title_ps=$request->title_ps;
       $PUnit->title_dr=$request->title_dr;
       $PUnit->save();
       if($PUnit){
        return redirect()->route('punits.index')->with('msg','Cash Type Was Updated');
       }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function status($id){
        $PUnit=PUnit::find($id);
        if($PUnit->status==0){
            PUnit::where('id',$id)->update([
                'status'=>1
            ]);
        }
        if($PUnit->status==1){
            PUnit::where('id',$id)->update([
                'status'=>0
            ]);
        }
        return back()->with('msg','Status Was Updated');
    }
}
