<?php

namespace App\Http\Controllers\configuration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Scategory;
use App\Models\SSubCategory;

class SaleScategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $Scategory = Scategory::all();
        $SSubCategory = SSubCategory::orderBy('id','desc')->paginate(10);
        return view('configuration.SScategory.create', compact('SSubCategory', 'Scategory'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'title_en' => 'required',
            'category_id' => 'required',
        ]);
        $SSubCategory = new SSubCategory();
        $SSubCategory->title_en = $request->title_en;
        $SSubCategory->title_ps = $request->title_ps;
        $SSubCategory->title_dr = $request->title_dr;
        $SSubCategory->category_id = $request->category_id;
        $SSubCategory->save();
        if ($SSubCategory) {
            return redirect()->route('sscategories.index')->with('msg', 'Scategory Type Was Created');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Scategory = Scategory::all();
        $SSubCategory = SSubCategory::find($id);
        return view('configuration.SScategory.edit', compact('SSubCategory', 'Scategory'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
        $SSubCategory = SSubCategory::find($id);
        $SSubCategory->title_en = $request->title_en;
        $SSubCategory->title_ps = $request->title_ps;
        $SSubCategory->title_dr = $request->title_dr;
        $SSubCategory->category_id = $request->category_id;
        $SSubCategory->save();
        if ($SSubCategory) {
            return redirect()->route('sscategories.index')->with('msg', 'Success');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function status($id)
    {
        $SSubCategory = SSubCategory::find($id);
        if ($SSubCategory->status == 0) {
            SSubCategory::where('id', $id)->update([
                'status' => 1
            ]);
        }
        if ($SSubCategory->status == 1) {
            SSubCategory::where('id', $id)->update([
                'status' => 0
            ]);
        }
        return back()->with('msg', 'Status Was Updated');
    }
}
