<?php

namespace App\Http\Controllers\configuration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\SWeight;

class SaleWeightController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $Sweights = SWeight::orderBy('id','desc')->paginate(10);
        return view('configuration.Sweights.create', compact('Sweights'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
        $Sweights = new SWeight();
        $Sweights->title_en = $request->title_en;
        $Sweights->title_ps = $request->title_ps;
        $Sweights->title_dr = $request->title_dr;
        $Sweights->save();
        if ($Sweights) {
            return redirect()->route('sweights.index')->with('msg', 'Success');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $Sweights = SWeight::find($id);
        return view('configuration.Sweights.edit', compact('Sweights'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title_en' => 'required',
        ]);
        $Sweights = SWeight::find($id);
        $Sweights->title_en = $request->title_en;
        $Sweights->title_ps = $request->title_ps;
        $Sweights->title_dr = $request->title_dr;
        $Sweights->save();
        if ($Sweights) {
            return redirect()->route('sweights.index')->with('msg', 'Success');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function status($id)
    {
        $Sweights = SWeight::find($id);
        if ($Sweights->status == 0) {
            SWeight::where('id', $id)->update([
                'status' => 1
            ]);
        }
        if ($Sweights->status == 1) {
            SWeight::where('id', $id)->update([
                'status' => 0
            ]);
        }
        return back()->with('msg', 'Status Was Updated');
    }
}
