<?php

namespace App\Http\Controllers\journals;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\BankAccount;
use App\Models\Currency;
use App\Models\BankJournal;
use App\Models\CashJournal;

class BankJournalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $bankers = BankAccount::all();
        $currency = Currency::all();
        $bankerJournal = BankJournal::orderBy('id','desc')->paginate(10);
        return view('journals.banker.index', compact('bankerJournal', 'currency', 'bankers'));
    }

    public function create()
    {
        $bankers = BankAccount::all();
        $currency = Currency::all();
        $bankerJournal = BankJournal::orderBy('id','desc')->paginate(10);
        return view('journals.banker.create', compact('bankerJournal', 'currency', 'bankers'));
    }
    public function create_outgoing()
    {
        $bankers = BankAccount::all();
        $currency = Currency::all();
        $bankerJournal = BankJournal::orderBy('id','desc')->paginate(10);
        return view('journals.banker.create-outgoing', compact('bankerJournal', 'currency', 'bankers'));
    }

    public function withdrow()
    {
        $bankers = BankAccount::all();
        $currency = Currency::all();
        $bankerJournal = BankJournal::orderBy('id','desc')->where('outgoing', 0)->paginate(10);
        return view('journals.banker.withdrow', compact('bankerJournal', 'currency', 'bankers'));
    }

    public function deposit()
    {
        $bankers = BankAccount::all();
        $currency = Currency::all();
        $bankerJournal = BankJournal::orderBy('id','desc')->where('income', 0)->paginate(10);
        return view('journals.banker.deposit', compact('bankerJournal', 'currency', 'bankers'));
    }


    public function balance()
    {
        $bankers = BankAccount::all();
        $currency = Currency::all();
        $bankerJournal = BankJournal::all();
        return view('journals.banker.balance', compact('bankerJournal', 'currency', 'bankers'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'required',
            'date' => 'required',
            'banker_id' => 'required',
        ]);
        $bankerJournal = new BankJournal();
        $bankerJournal->title = $request->title;
        $bankerJournal->sender=$request->sender;
        $bankerJournal->reciever=$request->reciever;
        $bankerJournal->banker_id = $request->banker_id;
        if ($request->income == "") {
            $bankerJournal->income = 0;
        } else {
            $bankerJournal->income = $request->income;
        }
        if ($request->outgoing == "") {
            $bankerJournal->outgoing = 0;
        } else {
            $bankerJournal->outgoing = $request->outgoing;
        }
        $bankerJournal->currency_id = $request->currency;
        $bankerJournal->status = 1;
        $bankerJournal->c_target=$request->cash_id;
        $bankerJournal->user_id = Auth()->user()->id;
        $bankerJournal->date = $request->date;
        $bankerJournal->details = $request->details;
        $isSaved = $bankerJournal->save();
        if ($isSaved) {
            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = $bankerJournal->title;
                $cash->date = $bankerJournal->date;
                if ($request->outgoing == "") {
                    $cash->income = $bankerJournal->income;
                } else {
                    $cash->outgoing = $bankerJournal->outgoing;
                }
                $cash->currency_id = $bankerJournal->currency_id;
                $cash->ex_rate = $bankerJournal->ex_rate;
                $cash->module_id = 23;
                $cash->type_id = 23;
                $cash->module_record_id = $bankerJournal->id;
                $cash->details = "Cash Targer From Sarafi";
                $cash->save();
            }
            session()->flash("msg", "Success!");
            return redirect()->route('bank.index');
        }
    }
    public function edit($id)
    {
        $bankers = BankAccount::all();
        $currency = Currency::all();
        $bankerJournal = BankJournal::find($id);
        return view('journals.banker.edit', compact('bankerJournal', 'currency', 'bankers'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title' => 'required',
        ]);
        $bankerJournal = BankJournal::find($id);
        $bankerJournal->title = $request->title;
        $bankerJournal->sender=$request->sender;
        $bankerJournal->reciever=$request->reciever;
        $bankerJournal->banker_id = $request->banker_id;
        $bankerJournal->outgoing = $request->outgoing;
        $bankerJournal->income = $request->income;
        $bankerJournal->currency_id = $request->currency;
        $bankerJournal->status = 1;
        $bankerJournal->c_target=$request->cash_id;
        $bankerJournal->user_id = Auth()->user()->id;
        $bankerJournal->date = $request->date;
        $bankerJournal->details = $request->details;
        $isSaved = $bankerJournal->save();
        if ($isSaved) {
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 23)->where('module_record_id', $bankerJournal->id)->first();
                if ($cash != null) {
                    $cash->title = $bankerJournal->title;
                    $cash->date = $bankerJournal->date;
                    if ($request->outgoing == "") {
                        $cash->income = $bankerJournal->income;
                    } else {
                        $cash->outgoing = $bankerJournal->outgoing;
                    }
                    $cash->currency_id = $bankerJournal->currency_id;
                    $cash->module_id = 23;
                    $cash->type_id = 23;
                    $cash->module_record_id = $bankerJournal->id;
                    $cash->details = "Cash Target From Sarafi";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $bankerJournal->title;
                    $cash->date = $bankerJournal->date;
                    if ($request->outgoing == "" || $request->outgoing==0) {
                        $cash->income = $bankerJournal->outgoing;
                    } else {
                        $cash->outgoing = $bankerJournal->income;
                    }
                    $cash->currency_id = $bankerJournal->currency_id;
                    $cash->module_id = 23;
                    $cash->type_id = 23;
                    $cash->module_record_id = $bankerJournal->id;
                    $cash->details = "Cash Target From Sarafi";
                    $cash->save();
                }
            }else{
                $cash = CashJournal::where('module_id', 23)->where('module_record_id', $bankerJournal->id)->delete();
            }
            session()->flash("msg", "Success!");
            return redirect()->route('bank.index');
        }
    }
    public function delete($id)
    {
        $bankerJournal = BankJournal::find($id)->delete();
        $cash = CashJournal::where('module_id', 23)->where('module_record_id', $id)->delete();

        session()->flash("msg", "Success!");
        return back();
    }

    public function report_show()
    {
        $bankers = BankAccount::all();
        $currency = Currency::all();
        return view('journals.banker.report', compact('currency', 'bankers'));
    }

    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $from = $request->fromDate;
        $to = $request->toDate;
        $currency_id = $request->currency_id;
        $banker_id = $request->banker_id;
        $banker = BankAccount::find($banker_id);
        $currency = Currency::find($currency_id);
        $name = "";
        $data = "";
        if ($banker_id == "all") {
            if ($currency_id == 'all') {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6><p style='text-align:center;'>From ($from) to ($to)</p>";
                $data .= "<h6 style='text-align:center;'>Bank & Sarafi Report</h6>";
                $data .= "<h6 style='text-align:center;'>All Bankers/Sarafs</h6>";
                $data .= "<h6 style='text-align:center;'>All Currency</h6>";
                $data .= "<h6 style='text-align:center;'>Print Date " . date('Y-M-d') . "</h6>";
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="" rowspan="2" style="color:#6633FF">Dev Amount</th>';
                $data .= '<th colspan="4"style="color:#330066">Amount</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $total = BankJournal::where('currency_id', $row->id)->sum('income');
                    $today = BankJournal::where('date', date('Y-m-d'))->where('currency_id', $row->id)->sum('income');
                    $income = $total - $today;
                }
                foreach (Currency::all() as $row) {
                    $total = BankJournal::where('currency_id', $row->id)->sum('outgoing');
                    $today = BankJournal::where('date', date('Y-m-d'))->where('currency_id', $row->id)->sum('outgoing');
                    $outgoing = $total - $today;
                }
                foreach (Currency::all() as $row) {
                    $total_income = BankJournal::where('currency_id', $row->id)->sum('income');
                    $today_income = BankJournal::where('date', date('Y-m-d'))->where('currency_id', $row->id)->sum('income');
                    $yesterday_income = $total_income - $today_income;
                    $total_outgoing = BankJournal::where('currency_id', $row->id)->sum('outgoing');
                    $today_outgoing = BankJournal::where('date', date('Y-m-d'))->where('currency_id', $row->id)->sum('outgoing');
                    $yesterday_outgoing = $total_outgoing - $today_outgoing;
                    $balance = $yesterday_outgoing - $yesterday_income;
                    $data .= '<td >' . $row->title_ps . "/" . $balance . '</td>';
                }
                $data .= '</tr>';
                $data .= '</table><br>';

                $data .= '<table class="">';
                $data .= '<tr style="background-color:#000; color:#fff;">';
                $data .= '<th>#</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Bank/Sarafi</th>';
                $data .= '<th>Currency</th>';
                $data .= '<th class="">Withdrow/به نام</th>';
                $data .= ' <th class="">Deposit/جمع</th>';
                $data .= '<th>Details</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $journal = BankJournal::whereBetween('date', [$from, $to])->orderBy('id','desc')->get();
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->bank->name . "</td>";
                    $data .= "<td>" . $row->currency->title_en . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th rowspan="2" >Report</th>';
                $data .= '<th colspan="4" >Withdrow/به نام</th>';
                $data .= '<th colspan="4" >Deposit/جمع</th>';
                $data .= '<th colspan="4">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $journal_income = BankJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('income');
                    $data .= '<td style="color:red;">' . $row->title_ps . "/" . $journal_income . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_outgoing = BankJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('outgoing');
                    $data .= '<td style="color:green;">' . $row->title_ps . "/" . $journal_outgoing . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_income = BankJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('income');
                    $journal_outgoing = BankJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('outgoing');
                    $balance = $journal_outgoing - $journal_income;
                    $data .= '<td>' . $row->title_ps . "/" . $balance . '</td>';

                }
                $data .= '</tr>';
                $data .= '</table><br>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="" rowspan="2" style="color:#6633FF">Sub Total</th>';
                $data .= '<th colspan="4" style="color:#990000">Withdrow/به نام</th>';
                $data .= '<th colspan="4" style="color:#6633FF">Deposit/جمع</th>';
                $data .= '<th colspan="4"style="color:#330066">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $total = BankJournal::where('currency_id', $row->id)->sum('income');
                    $data .= '<td >' . $row->title_ps . "/" . $total . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $total = BankJournal::where('currency_id', $row->id)->sum('outgoing');

                    $data .= '<td >' . $row->title_ps . "/" . $total . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $total_income = BankJournal::where('currency_id', $row->id)->sum('income');
                    $total_outgoing = BankJournal::where('currency_id', $row->id)->sum('outgoing');
                    $balance = $total_outgoing - $total_income;
                    $data .= '<td >' . $row->title_ps . "/" . $balance . '</td>';
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {

                $data .= "<h6 style='text-align:center;'>".$bname."</h6><p style='text-align:center;'>From ($from) to ($to)</p>";
                $data .= "<h6 style='text-align:center;'>Bank & Sarafi Report</h6>";
                $data .= "<h6 style='text-align:center;'>All Bankers & Sarafs</h6>";
                $data .= "<h6 style='text-align:center;'>$currency->title_en</h6>";
                $data .= "<h6 style='text-align:center;'>Print Date " . date('Y-M-d') . "</h6>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th class="text-danger">WithDrow/به نام</th>';
                $data .= ' <th class="text-success">Deposit/جمع</th>';
                $data .= '<th>Details</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $journal = BankJournal::whereBetween('date', [$from, $to])->where('currency_id', $currency_id)->orderBy('id','desc')->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";

                $data .= '</table>';

                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th rowspan="2">SubTotal</th>';
                $data .= '<th colspan="">WithDrow/به نام</th>';
                $data .= '<th colspan="">Deposit/جمع</th>';
                $data .= '<th colspan="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $data .= '<td>' . $journal->sum('income') . '</td>';
                $data .= '<td>' . $journal->sum('outgoing') . '</td>';
                $data .= '<td>';
                $data .= $journal->sum('outgoing') - $journal->sum('income');
                $data .= '</td>';
                $data .= '</tr>';
                $data .= '</table>';
            }
        } else {
            if ($currency_id == 'all') {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6><p style='text-align:center;'>From ($from) to ($to)</p>";
                $data .= "<h6 style='text-align:center;'>Bank & Sarafi Report</h6>";
                $data .= "<h6 style='text-align:center;'>$banker->name</h6>";
                $data .= "<h6 style='text-align:center;'>All Currency</h6>";
                $data .= "<h6 style='text-align:center;'>Print Date " . date('Y-M-d') . "</h6>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th class="text-danger">WithDrow/به نام</th>';
                $data .= ' <th class="text-success">Deposit/جمع</th>';
                $data .= '<th>Details</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $journal = BankJournal::whereBetween('date', [$from, $to])
                    ->where('banker_id', $request->banker_id)
                    ->orderBy('id','desc')
                    ->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="4">WithDrow/به نام</th>';
                $data .= '<th colspan="4">Deposit/جمع</th>';
                $data .= '<th colspan="4">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $journal_income = BankJournal::where('currency_id', $row->id)
                        ->where('banker_id', $request->banker_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('income');
                    $data .= '<td style="color:green;">' . $row->title_en . "/" . $journal_income . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_outgoing = BankJournal::where('currency_id', $row->id)
                        ->where('banker_id', $request->banker_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('outgoing');
                    $data .= '<td style="color:red;">' . $row->title_en . "/" . $journal_outgoing . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_income = BankJournal::where('currency_id', $row->id)
                        ->where('banker_id', $request->banker_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('income');
                    $journal_outgoing = BankJournal::where('currency_id', $row->id)
                        ->where('banker_id', $request->banker_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('outgoing');
                    $balance = $journal_outgoing - $journal_income;

                    $data .= '<td class="text-warning">' . $row->title_en . "/" . $balance . '</td>';

                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 style='text-align:center;'>".$bname."</h6><p style='text-align:center;'>From ($from) to ($to)</p>";
                $data .= "<h6 style='text-align:center;'>Bank & Sarafi Report</h6>";
                $data .= "<h6 style='text-align:center;'>$banker->name</h6>";
                $data .= "<h6 style='text-align:center;'>$currency->title_en</h6>";
                $data .= "<h6 style='text-align:center;'>Print Date " . date('Y-M-d') . "</h6>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th class="text-danger">WithDrow/به نام</th>';
                $data .= ' <th class="text-success">Deposit/جمع</th>';
                $data .= '<th>Details</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $journal = BankJournal::whereBetween('date', [$from, $to])
                    ->where('banker_id', $request->banker_id)
                    ->where('currency_id', $currency_id)
                    ->orderBy('id','desc')
                    ->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';

                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="">WithDrow/به نام</th>';
                $data .= '<th colspan="">Deposit/جمع</th>';
                $data .= '<th colspan="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $data .= '<td>' . $journal->sum('income') . '</td>';
                $data .= '<td>' . $journal->sum('outgoing') . '</td>';
                $data .= '<td>';
                $data .= $journal->sum('outgoing') - $journal->sum('income');
                $data .= '</td>';
                $data .= '</tr>';
                $data .= '</table>';
            }
        }
        return $data;
    }

    public function filter_show()
    {
        $currency = Currency::all();
        $bankers = BankAccount::all();
        $filter = "page";
        return view('journals.banker.filter', compact('currency', 'bankers', 'filter'));
    }

    public function filter_find(Request $request)
    {
        $currency = Currency::all();
        $bankers = BankAccount::all();
        if ($request->filter_id == 1) {
            $bankerJournal = BankJournal::Where('banker_id', $request->banker_id)->paginate(10);
        } else if ($request->filter_id == 2) {
            $bankerJournal = BankJournal::Where('currency_id', $request->currency_id)->paginate(10);
        } else if ($request->filter_id == 3) {
            $bankerJournal = BankJournal::Where('title', 'like', '%' . $request->title . '%')->paginate(10);
        } else if ($request->filter_id == 4) {
            $bankerJournal = BankJournal::Where('income', $request->income)->paginate(10);
        } else if ($request->filter_id == 7) {
            $bankerJournal = BankJournal::Where('outgoing', $request->outgoing)->paginate(10);
        } else {
            $bankerJournal = BankJournal::WhereBetween('date', [$request->fromDate, $request->toDate])->paginate(10);
        }
        return view('journals.banker.index', compact('currency', 'bankers', 'bankerJournal'));
    }

}
