<?php

namespace App\Http\Controllers\journals;

use App\Http\Controllers\Controller;
use App\Models\Currency;
use Illuminate\Http\Request;
use App\Models\InvestorInvestment;
use App\Models\InvestorAccount;

class InvestorInvestmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data=InvestorInvestment::orderBy('id','desc')->paginate(10);
        return view('journals.investors.investment.index',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $currencies=Currency::all();
        $investors=InvestorAccount::all();
        return view('journals.investors.investment.create',compact('currencies','investors'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=new InvestorInvestment();
        $data->title=$request->title;
        $data->currency_id=$request->currency;
        $data->date=$request->date;
        $data->invester_id=$request->investor_id;
        $data->investment_amount=$request->amount;
        $data->investment_percentage=$request->percentage;
        $data->detials=$request->details;
        $data->save();
        session()->flash("msg", "Success!");
        return redirect()->route('invester_investment.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data=InvestorInvestment::find($id);
        $currencies=Currency::all();
        $investors=InvestorAccount::all();
        return view('journals.investors.investment.edit',compact('currencies','investors','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data=InvestorInvestment::find($id);
        $data->title=$request->title;
        $data->currency_id=$request->currency;
        $data->date=$request->date;
        $data->invester_id=$request->investor_id;
        $data->investment_amount=$request->amount;
        $data->investment_percentage=$request->percentage;
        $data->detials=$request->details;
        $data->save();
        session()->flash("msg", "Success!");
        return redirect()->route('invester_investment.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
