<?php

namespace App\Http\Controllers\journals;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\InvestorJournal;
use App\Models\InvestorAccount;
use App\Models\Currency;
use App\Models\CashJournal;

class InvestorJournalController extends Controller
{
    public function index()
    {
        $investors = InvestorAccount::all();
        $currency = Currency::all();
        $data = InvestorJournal::orderBy('id','desc')->paginate(10);
        return view('journals.investors.index', compact('data', 'currency', 'investors'));
    }
    public function create()
    {
        $investors = InvestorAccount::all();
        $currency = Currency::all();
        $data = InvestorJournal::orderBy('id','desc')->paginate(10);
        return view('journals.investors.create', compact('data', 'currency', 'investors'));
    }
    public function outgoing_create()
    {
        $investors = InvestorAccount::all();
        $currency = Currency::all();
        $data = InvestorJournal::orderBy('id','desc')->paginate(10);
        return view('journals.investors.outgoing-create', compact('data', 'currency', 'investors'));
    }

    public function income()
    {
        $investors = InvestorAccount::all();
        $currency = Currency::all();
        $data = InvestorJournal::orderBy('id', 'desc')->where('outgoing', 0)->paginate(10);
        return view('journals.investors.income', compact('data', 'currency', 'investors'));
    }
    public function outgoing()
    {
        $investors = InvestorAccount::all();
        $currency = Currency::all();
        $data = InvestorJournal::orderBy('id', 'desc')->where('income', 0)->paginate(10);
        return view('journals.investors.outgoing', compact('data', 'currency', 'investors'));
    }

    public function balance()
    {
        $currency = Currency::all();
        $data = InvestorJournal::all();
        $investors = InvestorAccount::all();
        return view('journals.investors.balance', compact('data', 'currency', 'investors'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'title' => 'required',
            'investor_id' => 'required',
            'date' => 'required',
        ]);
        $data = new InvestorJournal();
        $data->title = $request->title;
        $data->investor_id = $request->investor_id;
        if ($request->income == "") {
            $data->income = 0;
        } else {
            $data->income = $request->income;
        }
        if ($request->outgoing == "") {
            $data->outgoing = 0;
        } else {
            $data->outgoing = $request->outgoing;
        }
        $data->currency_id = $request->currency;
        $data->status = 1;
        $data->c_target=$request->cash_id;
        $data->user_id = Auth()->user()->id;
        $data->date = $request->date;
        $data->details = $request->details;
        $isSaved = $data->save();
        if ($isSaved) {
            if ($request->cash_id == 1) {
                $cash = new CashJournal();
                $cash->title = $data->title;
                $cash->date = $data->date;
                if($request->transaction_id==1){
                    $cash->income = $data->income;
                }else{
                    $cash->outgoing = $data->outgoing;
                }
                $cash->currency_id = $data->currency_id;
                $cash->ex_rate = $data->ex_rate;
                $cash->module_id = 32;
                $cash->type_id = 32;
                $cash->module_record_id = $data->id;
                $cash->details = "Cash is Targeted From Investor Journal";
                $cash->save();
            }
            session()->flash("msg", "Success!");
            return redirect()->route('investors.index');
        }
    }
    public function edit($id)
    {
        $currency = Currency::all();
        $data = InvestorJournal::find($id);
        $investors = InvestorAccount::all();
        return view('journals.investors.edit', compact('data', 'currency', 'investors'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'title' => 'required',
        ]);
        $data = InvestorJournal::find($id);
        $data->title = $request->title;
        $data->investor_id = $request->investor_id;
        $data->income = $request->income;
        $data->outgoing = $request->outgoing;
        $data->currency_id = $request->currency;
        $data->status = 1;
        $data->c_target=$request->cash_id;
        $data->user_id = Auth()->user()->id;
        $data->date = $request->date;
        $data->details = $request->details;
        $isSaved = $data->save();
        if ($isSaved) {
            if ($request->cash_id == 1) {
                $cash = CashJournal::where('module_id', 32)->where('module_record_id', $data->id)->first();
                if ($cash != null) {
                    $cash->title = $data->title;
                    $cash->date = $data->date;
                    if($request->income!=0){
                        $cash->income = $data->income;
                    }
                    if($request->outgoing!=0){
                        $cash->outgoing = $data->outgoing;
                    }
                    $cash->currency_id = $data->currency_id;
                    $cash->module_id = 32;
                    $cash->type_id = 32;
                    $cash->module_record_id = $data->id;
                    $cash->details = "Cash Target From Expense";
                    $cash->save();
                } else {
                    $cash = new CashJournal();
                    $cash->title = $data->title;
                    $cash->date = $data->date;
                    if($request->income!=0){
                        $cash->income = $data->income;
                    }
                    if($request->outgoing!=0){
                        $cash->outgoing = $data->outgoing;
                    }
                    $cash->currency_id = $data->currency_id;
                    $cash->module_id = 32;
                    $cash->type_id = 32;
                    $cash->module_record_id = $data->id;
                    $cash->details = "Cash Target From Expense";
                    $cash->save();
                }
            }else{
                $cash = CashJournal::where('module_id', 32)->where('module_record_id', $data->id)->delete();
            }
            session()->flash("msg", "Success!");
            return redirect()->route('investors.index');
        }
    }
    public function delete($id)
    {
        $data = InvestorJournal::find($id)->delete();
        $cash = CashJournal::where('module_id', 32)->where('module_record_id', $id)->delete();
        session()->flash("msg", "Success!");
        return back();
    }

    public function report_show()
    {
        $currency = Currency::all();
        $investors = InvestorAccount::all();
        return view('journals.investors.report', compact('currency', 'investors'));
    }

    public function report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $data = '';
        $from = $request->fromDate;
        $to = $request->toDate;
        $currency_id = $request->currency_id;
        $currency=Currency::find($currency_id);
        $currencies=Currency::all();
        $investor_id=$request->investor_id;
        $debitor=InvestorAccount::find($investor_id);
        if ($request->investor_id == 'all') {
            $name = "";
            if ($currency_id == 'all') {
                $data .= "<h6 class='text-center'>".$bname."</h6>";
                $data .= "<h6 class='text-center'>All Currencies</h6>";
                $data .= "<h6 class='text-center'>All Accounts</h6>";
                $data .= "<h6 class='text-center'>Investor Journal Report</h6><p class='text-center'>From ($from) to ($to)</p>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Person</th>';
                $data .= '<th class="text-success">Income</th>';
                $data .= ' <th class="text-danger">Ouggoing</th>';
                $data .= '<th>Currency</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $journal = InvestorJournal::whereBetween('date', [$from, $to])->orderBy('id', 'desc')->get();
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->investor->name . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->currency->title_en . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="'.$currencies->count().'" class="text-success">Income</th>';
                $data .= '<th colspan="'.$currencies->count().'" class="text-danger">Ouggoing</th>';
                $data .= '<th colspan="'.$currencies->count().'">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $journal_income = InvestorJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('income');
                    $data .= '<td style="color:green;">' . $row->title_en . "/" . $journal_income . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_debit = InvestorJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('outgoing');
                    $data .= '<td style="color:red;">' . $row->title_en . "/" . $journal_debit . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_income = InvestorJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('income');
                    $journal_debit = InvestorJournal::where('currency_id', $row->id)->whereBetween('date', [$from, $to])->sum('outgoing');
                    $balance = $journal_income - $journal_debit;
                    $data .= '<td class="text-warning">' . $row->title_en . "/" . $balance . '</td>';

                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
                $data .= "<h6 class='text-center'>".$bname."</h6>";
                $data .= "<h6 class='text-center'>Currency of $currency->title_en</h6>";
                $data .= "<h6 class='text-center'>All Accounts</h6>";
                $data .= "<h3 class='text-center'>Investor Journal Report</h6><p class='text-center'>From ($from) to ($to)</p>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Person</th>';
                $data .= '<th class="text-success">Income</th>';
                $data .= ' <th class="text-danger">Ouggoing</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $journal = InvestorJournal::whereBetween('date', [$from, $to])->where('currency_id', $currency_id)->orderBy('id', 'desc')->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->investor->name . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';

                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="">Income</th>';
                $data .= '<th colspan="">Ouggoing</th>';
                $data .= '<th colspan="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $data .= '<td>' . $journal->sum('income') . '</td>';
                $data .= '<td>' . $journal->sum('outgoing') . '</td>';
                $data .= '<td>';
                $data .= $journal->sum('income') - $journal->sum('outgoing');
                $data .= '</td>';
                $data .= '</tr>';
                $data .= '</table>';
            }
        } else {
            if ($currency_id == 'all') {
                $data .= "<h6 class='text-center'>".$bname."</h6>";
                $data .= "<h6 class='text-center'>All Currencies</h6>";
                $data .= "<h6 class='text-center'>Debitor of $debitor->name</h6>";
                $data .= "<h6 class='text-center'>Investor Journal Report</h6><p class='text-center'>From ($from) to ($to)</p>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Person</th>';
                $data .= '<th class="text-success">Income</th>';
                $data .= ' <th class="text-danger">Ouggoing</th>';
                $data .= '<th>Currency</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $journal = InvestorJournal::whereBetween('date', [$from, $to])
                ->where('investor_id', $request->investor_id)
                ->orderBy('id', 'desc')
                ->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->investor->name . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->currency->title_en . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="'.$currencies->count().'" class="text-success">Income</th>';
                $data .= '<th colspan="'.$currencies->count().'" class="text-danger">Ouggoing</th>';
                $data .= '<th colspan="'.$currencies->count().'">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                foreach (Currency::all() as $row) {
                    $journal_income = InvestorJournal::where('currency_id', $row->id)
                        ->where('investor_id', $request->investor_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('income');
                    $data .= '<td style="color:green;">' . $row->title_en . "/" . $journal_income . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_debit = InvestorJournal::where('currency_id', $row->id)
                        ->where('investor_id', $request->investor_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('outgoing');
                    $data .= '<td style="color:red;">' . $row->title_en . "/" . $journal_debit . '</td>';
                }
                foreach (Currency::all() as $row) {
                    $journal_income = InvestorJournal::where('currency_id', $row->id)
                        ->where('investor_id', $request->investor_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('income');
                    $journal_debit = InvestorJournal::where('currency_id', $row->id)
                        ->where('investor_id', $request->investor_id)
                        ->whereBetween('date', [$from, $to])
                        ->sum('outgoing');
                    $balance = $journal_income - $journal_debit;
                    if ($journal_debit > $journal_income) {
                        $data .= '<td class="text-danger">' . $row->title_en . "/" . $balance . '</td>';
                    } else {
                        $data .= '<td class="text-warning">' . $row->title_en . "/" . $balance . '</td>';
                    }
                }
                $data .= '</tr>';
                $data .= '</table>';
            } else {
               
                $data .= "<h6 class='text-center'>".$bname."</h6>";
                $data .= "<h6 class='text-center'>Currency of $currency->title_en</h6>";
                $data .= "<h6 class='text-center'>Account of $debitor->name</h6>";
                $data .= "<h3 class='text-center'>Investor Journal Report</h6><p class='text-center'>From ($from) to ($to)</p>";
                $data .= '<table class="">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Title</th>';
                $data .= '<th class="text-success">Income</th>';
                $data .= ' <th class="text-danger">Ouggoing</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $journal = InvestorJournal::whereBetween('date', [$from, $to])->where('currency_id', $currency_id)->orderBy('id', 'desc')->get();
                $i = 1;
                foreach ($journal as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->income . "</td>";
                    $data .= "<td>" . $row->outgoing . "</td>";
                    $data .= "<td>" . $row->date . "</td></tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';

                $data .= '<table class="">';
                $data .= ' <tr>';
                $data .= '<th colspan="3" rowspan="2"> Sub Total</th>';
                $data .= '<th colspan="">Income</th>';
                $data .= '<th colspan="">Ouggoing</th>';
                $data .= '<th colspan="">Balance</th>';
                $data .= ' </tr>';
                $data .= ' <tr>';
                $data .= '<td>' . $journal->sum('income') . '</td>';
                $data .= '<td>' . $journal->sum('outgoing') . '</td>';
                $data .= '<td>';
                $data .= $journal->sum('income') - $journal->sum('outgoing');
                $data .= '</td>';
                $data .= '</tr>';
                $data .= '</table>';
            }
        }


        return $data;
    }

   
    public function filter_show()
    {
        $currency = Currency::all();
        $investors = InvestorAccount::all();
        $filter = "page";
        return view('journals.investors.filter', compact('currency', 'investors', 'filter'));
    }

    public function filter_find(Request $request)
    {
        $currency = Currency::all();
        $investors = InvestorAccount::all();
        if ($request->filter_id == 1) {
            $data = InvestorJournal::Where('investor_id', $request->investor_id)->paginate(10);
        } else if ($request->filter_id == 2) {
            $data = InvestorJournal::Where('currency_id', $request->currency_id)->paginate(10);
        } else if ($request->filter_id == 3) {
            $data = InvestorJournal::Where('title', 'like', '%' . $request->title . '%')->paginate(10);
        } else if ($request->filter_id == 4) {
            $data = InvestorJournal::Where('income', $request->incom)->paginate(10);
        } else if ($request->filter_id == 5) {
            $data = InvestorJournal::Where('outgoing', $request->outgoing)->paginate(10);
        } else {
            $data = InvestorJournal::WhereBetween('date', [$request->fromDate, $request->toDate])->paginate(10);
        }      
        return view('journals.investors.index', compact('data', 'currency', 'investors'));
    }
}
