<?php
namespace App\Http\Controllers\saleAdministration;

use App\Http\Controllers\Controller;
use App\Models\CustomerBillItem;
use App\Models\CustomerLiger;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\CustomerBill;
use App\Models\CustomerReturnBill;
use App\Models\CustomerRecieved;
use App\Models\CustomerAdvance;
use App\Models\Province;
use App\Models\Currency;
use App\Models\Scategory;
use App\Models\SSubCategory;
use App\Models\SUnit;
use App\Models\SWeight;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class CustomerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $customers = Customer::orderBy('id', 'desc')->paginate(10);
        return view('sale.customers.index', compact('customers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $provinces = Province::all();
        return view('sale.customers.create', compact('provinces'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|max:255|min:2',
            'phone' => 'required',
            'address' => 'required',
            'province_id' => 'required',
        ]);
        $customer = new customer();
        $customer->name = $request->name;
        $customer->phone = $request->phone;
        $customer->address = $request->address;
        $customer->province_id = $request->province_id;
        $customer->type_id = $request->type_id;
        if ($request->type_id == 2) {
            $customer->email = $request->email;
            if ($request->password == "") {
                $customer->password = $customer->password;
            } else {
                $customer->password = Hash::make($request->password);
            }

        }
        $customer->status = 1;
        $customer->user_id = Auth::user()->id;
        $customer->save();
        session()->flash("msg", "Success!");
        return redirect()->route('customers.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $customer_sale = CustomerBill::where('customer_id', $id)->get();
        $customer_recieved = CustomerRecieved::where('customer_id', $id)->get();
        $customer_advance = CustomerAdvance::where('customer_id', $id)->get();
        $customer_return = CustomerReturnBill::where('customer_id', $id)->get();
        $customer = Customer::find($id);
        $currencies = Currency::all();
        return view('sale.customers.show', compact('customer', 'customer_sale', 'customer_recieved', 'customer_advance', 'customer_return', 'currencies'));
    }

    public function print_profile($id)
    {
        $customer_sale = CustomerBill::where('customer_id', $id)->get();
        $customer_recieved = CustomerRecieved::where('customer_id', $id)->get();
        $customer_advance = CustomerAdvance::where('customer_id', $id)->get();
        $customer_return = CustomerReturnBill::where('customer_id', $id)->get();
        $customer = Customer::find($id);
        $currencies = Currency::all();
        return view('sale.customers.print', compact('customer', 'customer_sale', 'customer_recieved', 'customer_advance', 'customer_return', 'currencies'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $customer = Customer::find($id);
        $provinces = Province::all();
        return view('sale.customers.edit', compact('customer', 'provinces'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|max:255|min:2',
        ]);
        $customer = Customer::find($id);
        $customer->name = $request->name;
        $customer->phone = $request->phone;
        $customer->address = $request->address;
        $customer->province_id = $request->province_id;
        $customer->type_id = $request->type_id;
        if ($request->type_id == 2) {
            $customer->email = $request->email;
            if ($request->password == "") {
                $customer->password = $request->password;
            } else {
                $customer->password = Hash::make($request->password);
            }

        }
        $customer->status = 1;
        $customer->user_id = Auth::user()->id;
        $customer->save();
        session()->flash("msg", "Success!");
        return redirect()->route('customers.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function balances()
    {
        $recieved = CustomerRecieved::sum('received');
        $advance = CustomerAdvance::sum('amount');
        $sale = CustomerBill::sum('final_amount');
        $customers = Customer::orderBy('id', 'desc')->paginate(10);
        return view('sale.balances.index', compact('customers', 'recieved', 'advance', 'sale'));
    }
    public function balance_show()
    {
        $customers = Customer::all();
        $currencies = Currency::all();
        return view('sale.balances.balance', compact('customers', 'currencies'));
    }

    public function balance_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $customer_id = $request->customer_id;
        $currency_id = $request->currency_id;
        $Customer = Customer::find($customer_id);
        $currency = Currency::find($currency_id);
        $customers = Customer::all();
        $payments = CustomerRecieved::all();
        $advances = CustomerAdvance::all();
        $bills = CustomerBill::all();
        $currencies = Currency::all();

        $currencies_amount = $currencies->count();
        $data = "";
        if ($customer_id == "all") {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'>All Customers</h6>";
                $data .= "<h6 style='text-align:center;'>Balances Overview</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<td rowspan="2">Name</td>';
                $data .= '<td colspan="' . $currencies_amount . '">Bills</td>';
                $data .= '<td colspan="' . $currencies_amount . '">Recieved</td>';
                $data .= '<td colspan="' . $currencies_amount . '">Advances</td>';
                $data .= '<td colspan="' . $currencies_amount . '">Balance</td>';
                $data .= '</tr>';
                $data .= '<tr>';

                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                $data .= '</tr>';
                $data .= '<tbody>';

                $i = 1;
                foreach ($customers as $customer_row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $customer_row->name . '<br>' . $customer_row->phone . '<br>' . $customer_row->address . "</td>";
                    foreach ($currencies as $currency_row) {
                        $data .= '<td>' . $bills->where('customer_id', $customer_row->id)->where('currency_id', $currency_row->id)->sum('final_amount') . '</td>';
                    }
                    foreach ($currencies as $currency_row) {
                        $data .= '<td>' . $payments->where('customer_id', $customer_row->id)->where('currency_id', $currency_row->id)->sum('amount') . '</td>';
                    }
                    foreach ($currencies as $currency_row) {
                        $data .= '<td>' . $advances->where('customer_id', $customer_row->id)->where('currency_id', $currency_row->id)->sum('amount') . '</td>';
                    }
                    foreach ($currencies as $currency_row) {
                        $a_total = $advances->where('customer_id', $customer_row->id)->where('currency_id', $currency_row->id)->sum('amount');
                        $p_total = $payments->where('customer_id', $customer_row->id)->where('currency_id', $currency_row->id)->sum('amount');
                        $total = $a_total + $p_total;
                        $bill_total = $bills->where('customer_id', $customer_row->id)->where('currency_id', $currency_row->id)->sum('final_amount');
                        $balance = $bill_total - $total;
                        $data .= '<td>' . $balance . '</td>';
                    }

                    $data .= "</tr>";
                    $i++;

                }
                $data .= "<tr>";
                $data .= '<th rowspan="2">Subtotal</th>';
                foreach (Currency::all() as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('final_amount');
                    $data .= '<th>' . $total . '</th>';
                }
                foreach (Currency::all() as $row) {
                    $recieved = $payments->where('currency_id', $row->id)->sum('amount');
                    $data .= '<th>' . $recieved . '</th>';
                }
                foreach (Currency::all() as $row) {
                    $advance = $advances->where('currency_id', $row->id)->sum('amount');
                    $data .= '<th>' . $advance . '</th>';
                }
                foreach (Currency::all() as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('final_amount');
                    $recieved = $payments->where('currency_id', $row->id)->sum('amount');
                    $advance = $advances->where('currency_id', $row->id)->sum('amount');
                    $ar = $recieved + $advance;
                    $balance = $total - $ar;
                    $data .= '<th>' . $balance . '</th>';
                }
                $data .= "</tr>";
                $data .= '</tbody>';
                $data .= '</table>';

            } else {
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'>All Customers</h6>";
                $data .= "<h6 style='text-align:center;'>Balance Overview</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= "<h6 style='text-align:center;'> Currency $currency->title_en</h6>";

                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<td rowspan="2">Name</td>';
                $data .= '<td colspan="">Bills</td>';
                $data .= '<td colspan="">Payments</td>';
                $data .= '<td colspan="">Advances</td>';
                $data .= '<td colspan="">Balance</td>';
                $data .= '</tr>';

                $data .= '<tbody>';
                foreach ($customers as $customer_row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $customer_row->name . '<br>' . $customer_row->phone . '' . $customer_row->address . "</td>";
                    $data .= "<td>" . $bills->where('customer_id', $customer_row->id)->where('currency_id', $currency_id)->sum('final_amount') . "</td>";
                    $data .= "<td>" . $payments->where('customer_id', $customer_row->id)->where('currency_id', $currency_id)->sum('amount') . "</td>";
                    $data .= "<td>" . $advances->where('customer_id', $customer_row->id)->where('currency_id', $currency_id)->sum('amount') . "</td>";
                    $data .= "<td>";
                    $p_total = $payments->where('customer_id', $customer_row->id)->where('currency_id', $currency_id)->sum('amount');
                    $a_total = $advances->where('customer_id', $customer_row->id)->where('currency_id', $currency_id)->sum('amount');
                    $total = $p_total + $a_total;
                    $bill_total = $bills->where('customer_id', $customer_row->id)->where('currency_id', $currency_id)->sum('final_amount');
                    $balance = $bill_total - $total;
                    $data .= $balance;
                    $data .= "</td>";
                    $data .= "</tr>";

                }
                $data .= '<tr>';
                $data .= '<td rowspan="2">Subtotal</td>';
                $data .= "<th>" . $bills->where('currency_id', $currency_id)->sum('final_amount') . "</th>";
                $data .= "<th>" . $payments->where('currency_id', $currency_id)->sum('amount') . "</th>";
                $data .= "<th>" . $advances->where('currency_id', $currency_id)->sum('amount') . "</th>";
                $bills = $bills->where('currency_id', $currency_id)->sum('final_amount');
                $recieved = $payments->where('currency_id', $currency_id)->sum('amount');
                $advance = $advances->where('currency_id', $currency_id)->sum('amount');
                $ar = $recieved + $advance;
                $balance = $bills - $ar;
                $data .= '<th colspan="">' . $balance . '</td>';
                $data .= '</tr>';
                $data .= '</tbody>';
                $data .= '</table>';
            }
        } else {
            if ($currency_id == "all") {
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'>$Customer->name</h6>";
                $data .= "<h6 style='text-align:center;'>$Customer->phone</h6>";
                $data .= "<h6 style='text-align:center;'>$Customer->address</h6>";
                $data .= "<h6 style='text-align:center;'>Balances Overview</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<td colspan="' . $currencies_amount . '">Bills</td>';
                $data .= '<td colspan="' . $currencies_amount . '">Recieved</td>';
                $data .= '<td colspan="' . $currencies_amount . '">Advances</td>';
                $data .= '<td colspan="' . $currencies_amount . '">Balance</td>';
                $data .= '</tr>';
                $data .= '<tr>';
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                $data .= '</tr>';
                $data .= '<tbody>';
                // foreach ($customers as $customer_row) {
                $data .= "<tr>";
                // $data .= "<td>" . $Customer->name . "</td>";
                foreach ($currencies as $currency_row) {
                    $data .= '<td>' . $bills->where('customer_id', $Customer->id)->where('currency_id', $currency_row->id)->sum('final_amount') . '</td>';
                }
                foreach ($currencies as $currency_row) {
                    $data .= '<td>' . $payments->where('customer_id', $Customer->id)->where('currency_id', $currency_row->id)->sum('amount') . '</td>';
                }
                foreach ($currencies as $currency_row) {
                    $data .= '<td>' . $advances->where('customer_id', $Customer->id)->where('currency_id', $currency_row->id)->sum('amount') . '</td>';
                }
                foreach ($currencies as $currency_row) {
                    $a_total = $advances->where('customer_id', $Customer->id)->where('currency_id', $currency_row->id)->sum('amount');
                    $p_total = $payments->where('customer_id', $Customer->id)->where('currency_id', $currency_row->id)->sum('amount');
                    $total = $a_total + $p_total;
                    $bill_total = $bills->where('customer_id', $Customer->id)->where('currency_id', $currency_row->id)->sum('final_amount');
                    $balance = $bill_total - $total;
                    $data .= '<td>' . $balance . '</td>';
                }
                $data .= "</tr>";

                $data .= '</tbody>';
                $data .= '</table>';

            } else {
                $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6 style='text-align:center;'>All Customers</h6>";
                $data .= "<h6 style='text-align:center;'>Balances Overview</h6>";
                $data .= "<h6 style='text-align:center;'> Print Date</h6><p style='text-align:center;'>" . date('Y-m-d') . "</p>";
                $data .= "<h6 style='text-align:center;'> Currency $currency->title_en</h6>";
                $data .= "<h6 style='text-align:center;'> Customer $Customer->name</h6>";
                $data .= "<h6 style='text-align:center;'> Customer $Customer->phone</h6>";
                $data .= "<h6 style='text-align:center;'> Customer $Customer->address</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<td colspan="">Bills</td>';
                $data .= '<td colspan="">Payments</td>';
                $data .= '<td colspan="">Advances</td>';
                $data .= '<td colspan="">Balance</td>';
                $data .= '</tr>';

                $data .= '<tbody>';
                $data .= "<tr>";
                $data .= "<td>" . $bills->where('customer_id', $Customer->id)->where('currency_id', $currency_id)->sum('final_amount') . "</td>";
                $data .= "<td>" . $payments->where('customer_id', $Customer->id)->where('currency_id', $currency_id)->sum('amount') . "</td>";
                $data .= "<td>" . $advances->where('customer_id', $Customer->id)->where('currency_id', $currency_id)->sum('amount') . "</td>";
                $data .= "<td>";
                $p_total = $payments->where('customer_id', $Customer->id)->where('currency_id', $currency_id)->sum('amount');
                $a_total = $advances->where('customer_id', $Customer->id)->where('currency_id', $currency_id)->sum('amount');
                $total = $p_total + $a_total;
                $bill_total = $bills->where('customer_id', $Customer->id)->where('currency_id', $currency_id)->sum('final_amount');
                $balance = $bill_total - $total;
                $data .= $balance;
                $data .= "</td>";
                $data .= "</tr>";

                // }
                $data .= '</tbody>';
                $data .= '</table>';
            }
        }
        return $data;
    }
    public function report_show()
    {

        $customers = Customer::all();
        return view('sale.customers.report', compact('customers'));
    }
    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;

        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $customer_id = $request->customer_id;
        $type_id = $request->type_id;
        $customer = Customer::find($request->customer_id);
        $currencies = Currency::all();
        $data = "";

        if ($customer_id == "all") {
            // sale report
            if ($type_id == 1) {
                $bills = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->get();
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>All customer Sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Contain Only Bill Amount</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:10px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>customer</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . " " . $row->currency->title_en . "</td>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= "<td>Sub Total</td>";
                foreach ($currencies as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('final_amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';
            }
            // recieved report
            if ($type_id == 2) {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>All customer Recieved Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>#RNO</th>';
                $data .= '<th>Customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $reciveds = CustomerRecieved::whereBetween('date', [$fDate, $tDate])->get();
                foreach ($reciveds as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->recieved_number . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= '<td>SubTotal</td>';
                foreach ($currencies as $row) {
                    $total = $reciveds->where('currency_id', $row->id)->sum('amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';
            }
            // advance report
            if ($type_id == 3) {
                $advance = CustomerAdvance::whereBetween('date', [$fDate, $tDate])->get();
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>All customer Advance Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Customer</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($advance as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= '<th>SubTotal</th>';
                foreach ($currencies as $row) {
                    $total = $advance->where('currency_id', $row->id)->sum('amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';
            }
            // full report
            if ($type_id == 5) {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>Full Report of All Customers</h6>";
                $data .= "<h6  style='text-align:center;'>From $fDate To $tDate</h6>";
                $data . "<br>";
                // sale 
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>Sale Report</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $bills = CustomerBill::orderBy('invoice_date', 'desc')->get();
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= "<td>Sub Total</td>";
                foreach ($currencies as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('final_amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';
                $data .= '<br>';
                $data .= '<br>';

                // recieved 
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>Recieved Report</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>#RNO</th>';
                $data .= '<th>Customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $reciveds = CustomerRecieved::orderBy('date', 'desc')->get();
                foreach ($reciveds as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->recieved_number . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= '<th>SubTotal</th>';
                foreach ($currencies as $row) {
                    $total = $reciveds->where('currency_id', $row->id)->sum('amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';
                $data .= '<br>';
                $data .= '<br>';

                // advance 
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>Advance Report</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $advance = CustomerAdvance::orderBy('date', 'desc')->get();
                foreach ($advance as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= '<th>SubTotal</th>';
                foreach ($currencies as $row) {
                    $total = $advance->where('currency_id', $row->id)->sum('amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';
                // return sale 
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>Return Sale</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $bills = CustomerReturnBill::orderBy('invoice_date', 'desc')->get();
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';

                $data .= '<table>';
                $data .= "<tr>";
                $data .= '<th>SubTotal</th>';
                foreach ($currencies as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';
                $customers = Customer::all();
                $payments = CustomerRecieved::all();
                $advances = CustomerAdvance::all();
                $bills = CustomerBill::all();
                $currencies = Currency::all();
                // balance 
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>Balance</h6>";

                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<td rowspan="2">Name</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Bills</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Recieved</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Advances</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Balance</td>';
                $data .= '</tr>';
                $data .= '<tr>';

                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                $data .= '</tr>';
                $data .= '<tbody>';

                $i = 1;
                foreach ($customers as $customer_row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $customer_row->name . "</td>";
                    foreach ($currencies as $currency_row) {
                        $data .= '<td>' . $bills->where('customer_id', $customer_row->id)->where('currency_id', $currency_row->id)->sum('final_amount') . '</td>';
                    }
                    foreach ($currencies as $currency_row) {
                        $data .= '<td>' . $payments->where('customer_id', $customer_row->id)->where('currency_id', $currency_row->id)->sum('amount') . '</td>';
                    }
                    foreach ($currencies as $currency_row) {
                        $data .= '<td>' . $advances->where('customer_id', $customer_row->id)->where('currency_id', $currency_row->id)->sum('amount') . '</td>';
                    }
                    foreach ($currencies as $currency_row) {
                        $a_total = $advances->where('customer_id', $customer_row->id)->where('currency_id', $currency_row->id)->sum('amount');
                        $p_total = $payments->where('customer_id', $customer_row->id)->where('currency_id', $currency_row->id)->sum('amount');
                        $total = $a_total + $p_total;
                        $bill_total = $bills->where('customer_id', $customer_row->id)->where('currency_id', $currency_row->id)->sum('final_amount');
                        $balance = $bill_total - $total;
                        $data .= '<td>' . $balance . '</td>';
                    }

                    $data .= "</tr>";
                    $i++;

                }
                $data .= "<tr>";
                $data .= '<th rowspan="2">Subtotal</th>';
                foreach (Currency::all() as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('final_amount');
                    $data .= '<th>' . $total . '</th>';
                }
                foreach (Currency::all() as $row) {
                    $recieved = $payments->where('currency_id', $row->id)->sum('amount');
                    $data .= '<th>' . $recieved . '</th>';
                }
                foreach (Currency::all() as $row) {
                    $advance = $advances->where('currency_id', $row->id)->sum('amount');
                    $data .= '<th>' . $advance . '</th>';
                }
                foreach (Currency::all() as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('final_amount');
                    $recieved = $payments->where('currency_id', $row->id)->sum('amount');
                    $advance = $advances->where('currency_id', $row->id)->sum('amount');
                    $ar = $recieved + $advance;
                    $balance = $total - $ar;
                    $data .= '<th>' . $balance . '</th>';
                }
                $data .= "</tr>";
                $data .= '</tbody>';
                $data .= '</table>';

            }
            // Return Report 
            if ($type_id == 6) {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center; '>Return Report</h6>";
                $data .= "<h6  style='text-align:center;'></h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $bills = CustomerReturnBill::where('invoice_date', $fDate, $tDate)->get();
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= "<td>Sub Total</td>";
                foreach ($currencies as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';

            }

        }
        // end of all customer
        else {
            // sale report
            if ($type_id == 1) {
                $bills = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->where('customer_id', $customer_id)->get();
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= '<table class="" id="table_style" style="margin-top:10px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->grand_total . " " . $row->currency->title_en . "</td>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= "<td>Sub Total</td>";
                foreach ($currencies as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('final_amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';
            }
            // recieved report
            if ($type_id == 2) {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name Received Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>#RNO</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $reciveds = CustomerRecieved::whereBetween('date', [$fDate, $tDate])->where('customer_id', $customer_id)->get();
                foreach ($reciveds as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= '<td>SubTotal</td>';
                foreach ($currencies as $row) {
                    $total = $reciveds->where('currency_id', $row->id)->sum('amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';
            }
            // advance report
            if ($type_id == 3) {
                $advance = CustomerAdvance::whereBetween('date', [$fDate, $tDate])->where('customer_id', $customer_id)->get();
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name Advance Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($advance as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . " " . $row->currency->title_en . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= '<th>SubTotal</th>';
                foreach ($currencies as $row) {
                    $total = $advance->where('currency_id', $row->id)->sum('amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';
            }
            // full report
            if ($type_id == 5) {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name Full Report</h6>";
                $data .= "<h6  style='text-align:center;'>From $fDate To $tDate</h6>";
                $data . "<br>";
                // sale report 
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>Sale Report</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $bills = CustomerBill::orderBy('invoice_date', 'desc')->where('customer_id', $customer_id)->get();
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= "<td>Sub Total</td>";
                foreach ($currencies as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('final_amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';
                $data .= '<br>';
                $data .= '<br>';

                // recieved 
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>Recieved Report</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>#RNO</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $reciveds = CustomerRecieved::orderBy('date', 'desc')->where('customer_id', $customer_id)->get();
                foreach ($reciveds as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->recieved_number . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= '<th>SubTotal</th>';
                foreach ($currencies as $row) {
                    $total = $reciveds->where('currency_id', $row->id)->sum('amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';
                $data .= '<br>';
                $data .= '<br>';

                // advance 
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>Advance Report</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $advance = CustomerAdvance::orderBy('date', 'desc')->where('customer_id', $customer_id)->get();
                foreach ($advance as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= '<th>SubTotal</th>';
                foreach ($currencies as $row) {
                    $total = $advance->where('currency_id', $row->id)->sum('amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';

                // return 
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>Return Sale</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $bills = CustomerReturnBill::orderBy('invoice_date', 'desc')->where('customer_id', $customer_id)->get();
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= '<th>SubTotal</th>';
                foreach ($currencies as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';

                // balance 
                $payments = CustomerRecieved::all();
                $advances = CustomerAdvance::all();
                $bills = CustomerBill::all();
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>Balance</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<td colspan="' . $currencies->count() . '">Bills</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Recieved</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Advances</td>';
                $data .= '<td colspan="' . $currencies->count() . '">Balance</td>';
                $data .= '</tr>';
                $data .= '<tr>';
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                foreach ($currencies as $row) {
                    $data .= '<td>' . $row->title_en . '</td>';
                }
                $data .= '</tr>';
                $data .= '<tbody>';
                // foreach ($customers as $customer_row) {
                $data .= "<tr>";
                // $data .= "<td>" . $Customer->name . "</td>";
                foreach ($currencies as $currency_row) {
                    $data .= '<td>' . $bills->where('customer_id', $customer_id)->where('currency_id', $currency_row->id)->sum('final_amount') . '</td>';
                }
                foreach ($currencies as $currency_row) {
                    $data .= '<td>' . $payments->where('customer_id', $customer_id)->where('currency_id', $currency_row->id)->sum('amount') . '</td>';
                }
                foreach ($currencies as $currency_row) {
                    $data .= '<td>' . $advances->where('customer_id', $customer_id)->where('currency_id', $currency_row->id)->sum('amount') . '</td>';
                }
                foreach ($currencies as $currency_row) {
                    $a_total = $advances->where('customer_id', $customer_id)->where('currency_id', $currency_row->id)->sum('amount');
                    $p_total = $payments->where('customer_id', $customer_id)->where('currency_id', $currency_row->id)->sum('amount');
                    $total = $a_total + $p_total;
                    $bill_total = $bills->where('customer_id', $customer_id)->where('currency_id', $currency_row->id)->sum('final_amount');
                    $balance = $bill_total - $total;
                    $data .= '<td>' . $balance . '</td>';
                }
                $data .= "</tr>";

                $data .= '</tbody>';
                $data .= '</table>';
            }
            // Return Report 
            if ($type_id == 6) {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center; '>$customer->name Return Report</h6>";
                $data .= "<h6  style='text-align:center;'></h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $bills = CustomerReturnBill::where('invoice_date', $fDate, $tDate)->where('customer_id', $customer_id)->get();
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->invoice_date . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<table>';
                $data .= "<tr>";
                $data .= "<td>Sub Total</td>";
                foreach ($currencies as $row) {
                    $total = $bills->where('currency_id', $row->id)->sum('amount');
                    $data .= '<td style="color:#fff; background-color:#000;">' . $row->title_en . "/" . $total . '</td>';
                }
                $data .= "</tr>";
                $data .= '</table>';

            }
        }

        if ($type_id == 7) {
            $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
            $data .= "<h6 style='text-align:center;'>Customers List</h6>";
            $data .= '<table class="" id="table_style" style="margin-top:10px;">';
            $data .= '<thead>';
            $data .= '<tr>';
            $data .= '<th>#</th>';
            $data .= '<th>Name</th>';
            $data .= '<th>Phone</th>';
            $data .= '<th>Address</th>';
            $data .= '</tr>';
            $data .= '</thead>';
            $data .= '<tbody>';
            $i = 1;
            $customers = Customer::all();
            foreach ($customers as $row) {
                $data .= '<tr>';
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->name . "</td>";
                $data .= "<td>" . $row->phone . "</td>";
                $data .= "<td>" . $row->address . "</td>";
                $data .= '</tr>';
                $i++;
            }
            $data .= '<tr>';
            $data .= '<th>Total</th>';
            $data .= '<th colspan="5">' . $customers->count() . '</th>';

            $data .= '</tr>';
            $data .= '</tbody>';
        }


        return $data;


    }

    public function report_find1(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $customer_id = $request->customer_id;
        $type_id = $request->type_id;
        $customer = Customer::find($request->customer_id);
        $data = "";
        if ($customer_id == "all") {
            // sale report
            if ($type_id == 1) {
                $bills = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->get();
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>All customer Sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Contain Only Bill Amount</h6>";
                $data .= "<h6  style='text-align:center;'>This Report Dont Have Recieved in Bill Becasue That is Containe in Received List</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:10px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>customer</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Bill Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= '<tr>';
                $data .= '<th colspan="2">Total</th>';
                $data .= "<th colspan='6' style='color:#fff; background-color:#000;'>" . $bills->sum('final_amount') . "</th>";
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';
            }
            // recieved report
            if ($type_id == 2) {
                $reciveds = CustomerRecieved::whereBetween('date', [$fDate, $tDate])->get();
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>All customer Recieved Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Containe Only Bills Recieved</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Recieved Number</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Recieved</th>';
                $data .= '<th>customer</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($reciveds as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->recieved_number . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= '<tr>';
                $data .= '<th colspan="2">Total</th>';
                $data .= " <th colspan='6' style='color:#fff; background-color:#000;'>" . $reciveds->sum('amount') . "</th>";
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';

            }
            // advance report
            if ($type_id == 3) {
                $advance = CustomerAdvance::whereBetween('date', [$fDate, $tDate])->get();
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>All customer Advance Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>customer</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($advance as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= '<tr>';
                $data .= '<th colspan="2">Total</th>';
                $data .= " <th colspan='6' style='color:#fff; background-color:#000;'>" . $advance->sum('amount') . "</th>";
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';
            }
            if ($type_id == 4) {
                // balances
                $data = "";
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>All customer Balance Sheets</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Name</th>';
                $data .= '<th>Phone</th>';
                $data .= '<th>Address</th>';
                $data .= '<th>T-Sale</th>';
                $data .= '<th>T-Recieved</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Advance</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $total_sale = 0;
                $total_recieved = 0;
                $total_advance = 0;
                $total_balance = 0;
                foreach (Customer::all() as $row) {
                    $sale = CustomerBill::where('customer_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('final_amount');
                    $total_sale = $total_sale + $sale;
                    $recieved = CustomerRecieved::where('customer_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                    $total_recieved = $total_recieved + $recieved;
                    $advance = CustomerAdvance::where('customer_id', $row->id)->whereBetween('date', [$fDate, $tDate])->sum('amount');
                    $total_advance = $total_advance + $advance;
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->name . "</td>";
                    $data .= "<td>" . $row->phone . "</td>";
                    $data .= "<td>" . $row->address . "</td>";
                    $data .= "<td>" . $sale . "</td>";
                    $data .= "<td>" . $recieved . "</td>";
                    $total = $sale - $recieved;
                    $data .= "<td>" . $total . "</td>";
                    $data .= "<td>" . $advance . "</td>";
                    $data .= '<td>';
                    // $t_r=$recieved+$advance;
                    $balance = $total - $advance;
                    $data .= $balance;
                    $data .= '</td>';
                    $data .= '</tr>';
                    $i++;
                }
                $data .= '<tr>';
                $data .= '<th colspan="2" rowspan="2">Overview</th>';
                $data .= "<th colspan=''>T-Sale</th>";
                $data .= "<th colspan=''>T-Recieved</th>";
                $data .= "<th colspan='2'>Total</th>";
                $data .= "<th colspan=''>Advance</th>";
                $data .= "<th colspan='2'>Balance</th>";
                $data .= ' </tr>';
                $data .= '<tr>';
                $data .= "<th colspan=''>" . $total_sale . "</th>";
                $data .= "<th colspan=''>" . $total_recieved . "</th>";
                $total = $total_sale - $total_recieved;
                $data .= "<th colspan='2'>" . $total . "</th>";
                $data .= "<th colspan=''>" . $total_advance . "</th>";
                $total_RA = $total_recieved + $total_advance;
                $total_balance = $total_sale - $total_RA;
                $data .= "<th colspan='2'>" . $total_balance . "</th>";
                $data .= '</tr>';
                $data .= "</tbody>";
                $data .= '</table>';
            }
            // start full report
            if ($type_id == 5) {
                // bill report
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>Abave We Have All Three Report Include</h6>";
                $data .= "<h6  style='text-align:center;'>Customer Sale</h6>";
                $data .= "<h6  style='text-align:center;'>Customer Recieved</h6>";
                $data .= "<h6  style='text-align:center;'>Customer Advance</h6>";
                $data .= "<h6  style='text-align:center;'>Customer Balance</h6>";
                $data .= "<h6  style='text-align:center;'>Full Report of All Customers</h6>";
                $data . "<br>";

                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>All Sale From Company</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $bills = CustomerBill::orderBy('date', 'desc')->get();
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= '<tr>';
                $data .= '<th colspan="2">Total</th>';
                $data .= "<th colspan='6' style='color:#fff; background-color:#000;'>" . $bills->sum('final_amount') . " AFN" . "</th>";
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= '<br>';
                $data .= '<br>';


                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>All Recieved From Customer</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Recieved Number</th>';
                $data .= '<th>Recieved</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $reciveds = CustomerRecieved::orderBy('date', 'desc')->get();
                foreach ($reciveds as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->recieved_number . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= '<tr>';
                $data .= '<th colspan="2">Total</th>';
                $data .= "<th colspan='6' style='color:#fff; background-color:#000;'>" . $reciveds->sum('amount') . "</th>";

                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';

                $data .= '<br>';
                $data .= '<br>';


                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>All Advance From Customer</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $advance = CustomerAdvance::orderBy('date', 'desc')->get();
                foreach ($advance as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= '<tr>';
                $data .= '<th colspan="1">Total</th>';
                $data .= "<th colspan='6' style='color:#fff; background-color:#000;'>" . $advance->sum('amount') . " AFN" . "</th>";
                $data .= '</tr>';
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= "<br>";
                $data .= "<br>";
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>All Customer Balances</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Name</th>';
                $data .= '<th>Phone</th>';
                $data .= '<th>Address</th>';
                $data .= '<th>T-Sale</th>';
                $data .= '<th>T-Recieved</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Advance</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $total_sale = 0;
                $total_recieved = 0;
                $total_advance = 0;
                $total_balance = 0;
                foreach (Customer::all() as $row) {
                    $sale = CustomerBill::where('customer_id', $row->id)->sum('final_amount');
                    $total_sale = $total_sale + $sale;
                    $recieved = CustomerRecieved::where('customer_id', $row->id)->sum('amount');
                    $total_recieved = $total_recieved + $recieved;
                    $advance = CustomerAdvance::where('customer_id', $row->id)->sum('amount');
                    $total_advance = $total_advance + $advance;
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->name . "</td>";
                    $data .= "<td>" . $row->phone . "</td>";
                    $data .= "<td>" . $row->address . "</td>";
                    $data .= "<td>" . $sale . "</td>";
                    $data .= "<td>" . $recieved . "</td>";
                    $total = $sale - $recieved;
                    $data .= "<td>" . $total . "</td>";
                    $data .= "<td>" . $advance . "</td>";
                    $data .= '<td>';
                    $balance = $total - $advance;
                    $data .= $balance;
                    $data .= '</td>';
                    $data .= '</tr>';
                    $i++;
                }
                $data .= '<tr>';
                $data .= '<th colspan="2" rowspan="2">Overview</th>';
                $data .= "<th colspan='' style='color:#fff; background-color:#000;'>T-Sale</th>";
                $data .= "<th colspan='' style='color:#fff; background-color:#000;'>T-Recieved</th>";
                $data .= "<th colspan='2' style='color:#fff; background-color:#000;'>Total</th>";
                $data .= "<th colspan='' style='color:#fff; background-color:#000;'>Advance</th>";
                $data .= "<th colspan='2' style='color:#fff; background-color:#000;'>Balance</th>";
                $data .= ' </tr>';
                $data .= '<tr>';
                $data .= "<th colspan=''>" . $total_sale . "</th>";
                $data .= "<th colspan=''>" . $total_recieved . "</th>";
                $total = $total_sale - $total_recieved;
                $data .= "<th colspan='2'>" . $total . "</th>";
                $data .= "<th colspan=''>" . $total_advance . "</th>";
                $total_RA = $total_recieved + $total_advance;
                $total_balance = $total_sale - $total_RA;
                $data .= "<th colspan='2'>" . $total_balance . "</th>";
                $data .= '</tr>';
                $data .= "</tbody>";
                $data .= '</table>';

            }
            if ($type_id == 6) {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>All Return From Company</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>customer</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $bills = CustomerReturnBill::orderBy('date', 'desc')->get();
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= '<tr>';
                $data .= '<th colspan="2">Total</th>';
                $data .= "<th colspan='6' style='color:#fff; background-color:#000;'>" . $bills->sum('amount') . " AFN" . "</th>";
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';

            }

        }
        // end of all customer
        else {
            // sale report
            if ($type_id == 1) {
                // bill report
                $bills = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->where('customer_id', $customer_id)->get();
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name Sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Containe only Bills</h6>";
                $data .= "<h4  style='text-align:center;'>$customer->name</h4>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }

                $data .= '<tr>';
                $data .= '<th colspan="2">Total</th>';
                $data .= "<th colspan='6' style='color:#fff; background-color:#000;'>" . $bills->sum('final_amount') . "</th>";
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';
            }
            // recieved report
            if ($type_id == 2) {
                $reciveds = CustomerRecieved::whereBetween('date', [$fDate, $tDate])->where('customer_id', $customer_id)->get();
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name Recieved Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h6  style='text-align:center;'>Containe only Recieved</h6>";
                $data .= "<h4  style='text-align:center;'>$customer->name</h4>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Recieved Number</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Recieved</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($reciveds as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->recieved_number . "</td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= '<tr>';
                $data .= '<th colspan="1">Total</th>';
                $data .= "<th colspan='4' style='color:#fff; background-color:#000;'>" . $reciveds->sum('amount') . "</th>";
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';

            }
            // advance report
            if ($type_id == 3) {
                $advance = CustomerAdvance::whereBetween('date', [$fDate, $tDate])->where('customer_id', $request->customer_id)->get();
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name Advance Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
                $data .= "<h4  style='text-align:center;'>$customer->name</h4>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($advance as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= '<tr>';
                $data .= '<th colspan="">Total</th>';
                $data .= " <th colspan='6' style='color:#fff; background-color:#000;'>" . $advance->sum('amount') . "</th>";
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';
            }
            // balance
            if ($type_id == 4) {
                $data = "";
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>$customer->name  Balance Sheets</h6>";
                $data .= "<h4  style='text-align:center;'>$customer->name</h4>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Name</th>';
                $data .= '<th>Phone</th>';
                $data .= '<th>Address</th>';
                $data .= '<th>T-Sale</th>';
                $data .= '<th>T-Recieved</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Advance</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;

                $sale = CustomerBill::whereBetween('invoice_date', [$fDate, $tDate])->where('customer_id', $request->customer_id)->sum('final_amount');
                $recieved = CustomerRecieved::whereBetween('date', [$fDate, $tDate])->where('customer_id', $request->customer_id)->sum('amount');
                $advance = CustomerAdvance::whereBetween('date', [$fDate, $tDate])->where('customer_id', $request->customer_id)->sum('amount');
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $customer->name . "</td>";
                $data .= "<td>" . $customer->phone . "</td>";
                $data .= "<td>" . $customer->address . "</td>";
                $data .= "<td>" . $sale . "</td>";
                $data .= "<td>" . $recieved . "</td>";
                $total = $sale - $recieved;
                $data .= "<td>" . $total . "</td>";
                $data .= "<td>" . $advance . "</td>";
                $data .= '<td>';
                $balance = $total - $advance;
                $data .= $balance;
                $data .= '</td>';
                $data .= '</tr>';
                $data .= "</tbody>";
                $data .= '</table>';
            }
            if ($type_id == 5) {
                // full report
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center;'>Abave We Have All Three Report Include Company, Customer Sale, Recieved, Advance And All Balance From ($fDate) to ($tDate) of MR $customer->name</h6>";
                $data .= "<h4  style='text-align:center;'>$customer->name</h4>";
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>All Sale From Company</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Bill Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $bills = CustomerBill::orderBy('date', 'desc')->where('customer_id', $request->customer_id)->get();
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->invoice_number . "</td>";
                    $data .= "<td>" . $row->grand_total . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= '<tr>';
                $data .= '<th colspan="2">Total</th>';
                $data .= "<th colspan='6' style='color:#fff; background-color:#000;'>" . $bills->sum('final_amount') . " AFN" . "</th>";
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>All Recieved</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Details</th>';
                $data .= '<th>Recieved Number</th>';
                $data .= '<th>Recieved</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $reciveds = CustomerRecieved::where('customer_id', $request->customer_id)->get();
                foreach ($reciveds as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->details . "</td>";
                    $data .= "<td>" . $row->recieved_number . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= '<tr>';
                $data .= '<th colspan="2">Total</th>';
                $data .= "<th colspan='6' style='color:#fff; background-color:#000;'>" . $reciveds->sum('amount') . " AFN" . "</th>";
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';

                // advance
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>All Advance </h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>customer</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '<th>Date</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $advance = CustomerAdvance::where('customer_id', $request->customer_id)->get();
                foreach ($advance as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->customer->name . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= '<tr>';
                $data .= '<th colspan="1">Total</th>';
                $data .= "<th colspan='6' style='color:#fff; background-color:#000;'>" . $advance->sum('amount') . " AFN" . "</th>";
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';

                //  all balance
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>Balance </h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>T-Sale</th>';
                $data .= '<th>T-Recieved</th>';
                $data .= '<th>Total</th>';
                $data .= '<th>Advance</th>';
                $data .= '<th>Balance</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;

                $sale = CustomerBill::where('customer_id', $request->customer_id)->sum('final_amount');
                $recieved = CustomerRecieved::where('customer_id', $request->customer_id)->sum('amount');
                $advance = CustomerAdvance::where('customer_id', $request->customer_id)->sum('amount');
                $data .= "<tr style='color:#fff; background-color:#000;'>";
                $data .= "<th>" . $sale . "</th>";
                $data .= "<th>" . $recieved . "</th>";
                $total = $sale - $recieved;
                $data .= "<th>" . $total . "</th>";
                $data .= "<th>" . $advance . "</th>";
                $data .= '<th>';
                $balance = $total - $advance;
                $data .= $balance . " AFN";
                $data .= '</th>';
                $data .= '</tr>';
                $data .= "</tbody>";
                $data .= '</table>';
            }
            if ($type_id == 6) {
                $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
                $data .= "<h6  style='text-align:center; color:#fff; background-color:#000; margin-top:20px;'>$customer->name Return From Company</h6>";
                $data .= '<table class="" id="table_style" style="margin-top:20px;">';
                $data .= '<tr>';
                $data .= '<th>#</th>';
                $data .= '<th>Date</th>';
                $data .= '<th>Bill No</th>';
                $data .= '<th>Title</th>';
                $data .= '<th>Amount</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $bills = CustomerReturnBill::orderBy('date', 'desc')->where('customer_id', $request->customer_id)->get();
                foreach ($bills as $row) {
                    $data .= "<tr>";
                    $data .= "<td>" . $i . "</td>";
                    $data .= "<td>" . $row->date . "</td>";
                    $data .= "<td>" . $row->number . "</td>";
                    $data .= "<td>" . $row->title . "</td>";
                    $data .= "<td>" . $row->amount . "</td>";
                    $data .= "</tr>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='9'  style='text-align:center;'>No data Available!</td></tr>";
                }
                $data .= '<tr>';
                $data .= '<th colspan="2">Total</th>';
                $data .= "<th colspan='6' style='color:#fff; background-color:#000;'>" . $bills->sum('amount') . " AFN" . "</th>";
                $data .= ' </tr>';
                $data .= "</tbody>";
                $data .= '</table>';

            }
        }
        return $data;
    }
    public function tracking_show()
    {
        $customers = Customer::all();
        $province = Province::all();
        $units = SUnit::all();
        $weights = SWeight::all();
        $category = Scategory::all();
        $subcategory = SSubCategory::all();
        return view('sale.balances.sale-overview', compact('customers', 'province', 'units', 'weights', 'category', 'subcategory'));
    }

    public function tracking_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;

        $fromDate = $request->fromDate;
        $toDate = $request->toDate;
        $customer_id = $request->customer_id;
        $category_id = $request->category_id;
        $weight_id = $request->weight_id;
        $unit_id = $request->unit_id;
        $type_id = $request->type_id;
        $Customer = Customer::find($customer_id);
        $customers = Customer::all();
        $category = Scategory::find($category_id);
        $categories = Scategory::all();
        $weight = SWeight::find($weight_id);
        $weights = SWeight::all();
        $unit = SUnit::find($unit_id);
        $units = SUnit::all();
        $track = CustomerBillItem::whereBetween('date', [$fromDate, $toDate])->get();
        $data = "";
        if ($customer_id == "all") {
            $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
            $data .= "<h6 style='text-align:center;'>Customers Report</h6>";
            $data .= "<h6 style='text-align:center;'>Categories </h6>";
            $data .= "<h6 style='text-align:center;'>All Customers</h6>";
            $data .= "<h6 style='text-align:center;'>Form $fromDate To $toDate</h6>";
            foreach ($categories as $cat_row) {
                $data .= '<table class="" id="table_style">';
                $data .= '<tr><th colspan="' . $weights->count() . '">' . $cat_row->title_ps . '</th></tr>';
                foreach ($weights as $w_row) {
                    $data .= '<th>' . $w_row->title_ps . "<br>" . $track->where('cat_id', $cat_row->id)->where('weight_id', $w_row->id)->sum('qty') . '</th>';

                }
                $data .= '</table>';
            }
            $data .= "<h2 style='text-align:center;'>Total</h2>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            foreach ($weights as $w_row) {
                $data .= '<th style="background:#000; color:#fff;">' . $w_row->title_ps . "<br>" . $track->where('weight_id', $w_row->id)->sum('qty') . '</th>';

            }
            $data .= '</tr>';
            $data .= '</table>';


        } else {
            $data .= "<h6 style='text-align:center;'>" . $bname . "</h6>";
            $data .= "<h6 style='text-align:center;'>Customers Report</h6>";
            $data .= "<h6 style='text-align:center;'>Categories Level</h6>";
            $data .= "<h6 style='text-align:center;'>$Customer->name</h6>";
            $data .= "<h6 style='text-align:center;'>Form $fromDate To $toDate</h6>";
            foreach ($categories as $cat_row) {
                $data .= '<table class="" id="table_style">';
                $data .= '<tr><th colspan="' . $weights->count() . '">' . $cat_row->title_ps . '</th></tr>';
                foreach ($weights as $w_row) {
                    $data .= '<th>' . $w_row->title_ps . "<br>" . $track->where('customer_id', $customer_id)->where('cat_id', $cat_row->id)->where('weight_id', $w_row->id)->sum('qty') . '</th>';

                }
                $data .= '</table>';
            }
            $data .= "<h2 style='text-align:center;'>Total</h2>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            foreach ($weights as $w_row) {
                $data .= '<th style="background:#000; color:#fff;">' . $w_row->title_ps . "<br>" . $track->where('weight_id', $w_row->id)->where('customer_id', $customer_id)->sum('qty') . '</th>';

            }
            $data .= '</tr>';
            $data .= '</table>';
        }
        return $data;
    }



    public function filter_find(Request $request)
    {
        if ($request->type_id == 1) {
            $customers = Customer::orderBy('id', 'desc')->where('name', 'like', '%' . $request->name . '%')->get();
        }
        if ($request->type_id == 2) {
            $customers = Customer::orderBy('id', 'desc')->where('phone', 'like', '%' . $request->phone . '%')->get();
        }
        if ($request->type_id == 3) {
            $customers = Customer::orderBy('id', 'desc')->where('address', 'like', '%' . $request->address . '%')->get();
        }


        return view('sale.customers.filter', compact('customers'));

    }


    public function ledger_show()
    {
        $page = "";
        $currencies = Currency::all();
        $customers = Customer::all();

        return view('sale.balances.ledger', compact('currencies', 'customers','page'));
    }

    public function ledger_find(Request $request)
    {
        $page = "data";
        $from=$request->fromDate;
        $to=$request->toDate;
        $currencies = Currency::all();
        $customers = Customer::all();
        $customer=Customer::find($request->customer_id);
        if($request->currency_id=="all"){
            if($request->customer_id=="all"){
                $ledger=CustomerLiger::whereBetween('date',[$request->fromDate,$request->toDate])->get();
            }else{
                $ledger=CustomerLiger::whereBetween('date',[$request->fromDate,$request->toDate])->where('customer_id',$request->customer_id)->get();
            }
        }else{
            if($request->customer_id=="all"){
                $ledger=CustomerLiger::whereBetween('date',[$request->fromDate,$request->toDate])->where('currency_id',$request->currency_id)->get();
            }else{
                $ledger=CustomerLiger::whereBetween('date',[$request->fromDate,$request->toDate])->where('customer_id',$request->customer_id)->where('currency_id',$request->currency_id)->get();
            }
        }
        
        return view('sale.balances.ledger', compact('currencies', 'customers','ledger','page','from','to','customer'));
    }

}
