<?php

namespace App\Http\Controllers\saleAdministration\singleCustomer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\Currency;
use App\Models\CustomerReturnBill;
use App\Models\CustomerReturnBillItem;
use App\Models\CustomerRecieved;
use App\Models\Scategory;
use App\Models\SSubCategory;
use App\Models\SUnit;
use App\Models\SWeight;
use App\Models\Stock;
use Carbon\Carbon;
use Auth;

class SCustomerRBillController extends Controller
{
    public function index($id)
    {
        $customer = Customer::find($id);
        $bills = CustomerReturnBill::where('customer_id', $id)->orderBy('id', 'desc')->paginate(10);
        $recieved = CustomerRecieved::where('customer_id', $id)->get();
        $currencies = Currency::all();
        return view('sale.customers.returns.index', compact('customer', 'bills', 'recieved', 'currencies'));
    }
    public function create($id)
    {
        $customer = Customer::find($id);
        $currencies = Currency::all();
        $invoice_number = CustomerReturnBill::orderBy('id', 'desc')->get()->first();
        $number = "";
        if ($invoice_number == "") {
            $number = $invoice_number = 1;
        } else {
            $number = $invoice_number->invoice_number + 1;
        }
        return view('sale.customers.returns.bill-create', compact('customer', 'currencies', 'number'));
    }
    public function store(Request $request)
    {
        $request->validate([
            'date' => 'required',
            'invoice_number' => 'required',
            'customer_id' => 'required',
            'currency_id' => 'required',
            'title' => 'required',
        ]);
        $bill = new CustomerReturnBill();
        $bill->customer_id = $request->customer_id;
        $bill->currency_id = $request->currency_id;
        $bill->ex_rate = $request->ex_rate;
        $bill->invoice_date = $request->date;
        $bill->invoice_number = $request->invoice_number;
        $bill->title = $request->title;
        $bill->status = 0;
        $date = date("Y-m-d");
        if (request()->hasFile('bill_files')) {
            $filename = 'bill_files-' . time() . '-' . request()->file('bill_files')->getClientOriginalName();
            $path = request()->file('bill_files')->storeAs('return_bill_files/' . $date . '/', $filename, 'public');
        } else {
            $path = "bill_files/noimage.jpg";
        }
        $bill->scan_file = $path;
        $bill->save();
        if ($bill) {
            session()->flash("msg", "Success!");
            return redirect()->route('scustomer_rbill.next_create', $bill->id);
        }
    }
    public function next_create($id)
    {
        $bill_id = $id;
        $bill = CustomerReturnBill::find($bill_id);
        $customer_id = $bill->customer_id;
        $customer = Customer::find($customer_id);
        $categories = Scategory::all();
        $scategories = SSubCategory::all();
        $weights = SWeight::all();
        $units = SUnit::all();
        $bill_items = CustomerReturnBillItem::where('bill_id', $bill_id)->orderBy('id', 'desc')->get();
        return view('sale.customers.returns.bill-create-next', compact('bill', 'customer', 'categories', 'scategories', 'weights', 'units', 'bill_items', 'bill_id', 'customer_id'));
    }

    public function item_store(Request $request)
    {
        $request->validate([
            'bill_id' => 'required',
            'return_price' => 'required',
            'qty' => 'required',
        ]);

        $items = new CustomerReturnBillItem();
        $items->bill_id = $request->bill_id;
        $items->customer_id = $request->customer_id;
        $items->cat_id = $request->cat_id;
        $items->sub_cat_id = $request->sub_cat_id;
        $items->unit_id = $request->unit_id;
        $items->weight_id = $request->weight_id;
        $items->price = $request->return_price;
        $items->qty = $request->qty;
        $items->user_id = Auth::user()->id;
        $items->date = $request->date;
        $items->total = $request->return_price * $request->qty;
        $items->save();
        if ($items) {
            $stock = Stock::where('cat_id', $request->cat_id)
                ->where('sub_cat_id', $request->sub_cat_id)
                ->where('unit_id', $request->unit_id)
                ->where('weight_id', $request->weight_id)->first();
            $stock = Stock::find($stock->id);
            $sqty=$stock->qty;
            $qty = $sqty + $request->qty;
            $stock->qty = $qty;
            $save = $stock->save();
        }
        session()->flash("msg", "success");
        return back();
    }
    public function item_delete($id)
    {
        $item = CustomerReturnBillItem::find($id);
        $stock = Stock::find($item->stock_id);
        $quantity = $stock->qty;
        $quantity = $quantity - $item->qty;
        $stock->qty = $quantity;
        $stock->save();
        if ($stock) {
            $item->delete();
            session()->flash("msg", "Success Deleted!");
            return back();
        }

    }
    public function next_store(Request $request)
    {

        $request->validate([
            'grand_total' => 'required',
        ]);

        $bill = CustomerReturnBill::find($request->bill_id);
        $bill->amount = $request->grand_total;
        $bill->return_by = $request->return_by;
        $bill->transaction_id = $request->payment_id;
        $bill->save();
        if ($bill) {
            if ($request->payment_id == 1) {
                $recieved = new CustomerRecieved();
                $recieved->customer_id = $bill->customer_id;
                $recieved->currency_id = $bill->currency_id;
                $recieved->ex_rate = $bill->ex_rate;
                $recieved->bill_id = $bill->id;
                $recieved->details = "From Return Bill = " . $bill->invoice_number;
                $recieved->amount = $request->grand_total;
                $recieved->recieved_number = "From Bill" . $bill->invoice_number;
                $recieved->date = $bill->invoice_date;
                $recieved->save();
            }
            session()->flash("msg", "Success!");
            return redirect()->route('scustomer_rbill.index', $bill->customer_id);
        }
    }

    public function show($id)
    {
        $bill = CustomerReturnBill::find($id);
        $bill_items = CustomerReturnBillItem::where('bill_id', $id)->get();
        $customer = Customer::find($bill->customer_id);
        return view('sale.customers.returns.show', compact('customer', 'bill', 'bill_items'));
    }
    public function edit($id)
    {
        $bill = CustomerReturnBill::find($id);
        $bill_id = $id;
        $customer_id = $bill->customer_id;
        $customer = Customer::find($bill->customer_id);
        $categories = Scategory::all();
        $scategories = SSubCategory::all();
        $weights = SWeight::all();
        $units = SUnit::all();
        $currencies = Currency::all();
        $bill_items = CustomerReturnBillItem::where('bill_id', $id)->orderBy('id', 'desc')->get();
        return view('sale.customers.returns.bill-edit', compact('customer', 'bill', 'bill_items', 'categories', 'scategories', 'weights', 'units', 'currencies', 'bill_id', 'customer_id'));
    }
    public function update(Request $request, $id)
    {


        $bill = CustomerReturnBill::find($id);
        $bill->customer_id = $request->customer_id;
        $bill->currency_id = $request->currency_id;
        $bill->ex_rate = $request->ex_rate;
        $bill->invoice_date = $request->date;
        $bill->invoice_number = $request->invoice_number;
        $bill->title = $request->title;
        $bill->status = 0;
        $bill->amount = $request->grand_total;
        $bill->return_by = $request->return_by;
        $bill->transaction_id = $request->payment_id;
        $date = date("Y-m-d");
        if (request()->hasFile('bill_files')) {
            $filename = 'bill_files-' . time() . '-' . request()->file('bill_files')->getClientOriginalName();
            $path = request()->file('bill_files')->storeAs('bill_files/' . $date . '/', $filename, 'public');
        } else {
            $path = $bill->scan_file;
        }
        $bill->scan_file = $path;
        $bill->save();
        if ($bill) {
            $recieved_recieved_table = CustomerRecieved::where('customer_id', $bill->customer_id)->where('bill_id', $bill->id)->first();
            if ($recieved_recieved_table != null) {
                $recieved_recieved_table = CustomerRecieved::where('customer_id', $bill->customer_id)->where('bill_id', $bill->id)->delete();
                if ($request->received != 0) {
                    $recieved = new CustomerRecieved();
                    $recieved->customer_id = $bill->customer_id;
                    $recieved->currency_id = $bill->currency_id;
                    $recieved->ex_rate = $bill->ex_rate;
                    $recieved->bill_id = $bill->id;
                    $recieved->details = "Recieved Amount is Added From  " . $bill->invoice_number;
                    $recieved->amount = $request->received;
                    $recieved->recieved_number = "From Bill" . $bill->invoice_number;
                    $recieved->status = 2;
                    $recieved->date = $bill->invoice_date;
                    $recieved->save();
                }
            } else {
                if ($request->received != 0) {
                    $recieved = new CustomerRecieved();
                    $recieved->customer_id = $bill->customer_id;
                    $recieved->currency_id = $bill->currency_id;
                    $recieved->bill_id = $bill->id;
                    $recieved->details = "Recieved Amount is Added From " . $bill->bill_no;
                    $recieved->received = $request->received;
                    $recieved->rasid_number = "From Bill" . $bill->number;
                    $recieved->status = 2;
                    $recieved->date = $bill->date;
                    $recieved->save();
                }
            }

            session()->flash("msg", "Success!");
            return redirect()->route('scustomer_rbill.index', $bill->customer_id);
        }
    }

    public function report_show($id)
    {
        $customer = Customer::find($id);
        $currencies = Currency::all();
        return view('sale.customers.returns.report', compact('customer', 'currencies'));
    }
    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $fDate = $request->fromDate;
        $tDate = $request->toDate;
        $customer_id = $request->customer_id;
        $currency_id = $request->currency_id;
        $customer = Customer::find($customer_id);
        $currency = Currency::find($currency_id);
        $currencies = currency::all();
        $data = "";
        if ($currency_id == "all") {
            $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
            $data .= "<h6  style='text-align:center;'>$customer->name</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
            $data .= "<h6  style='text-align:center;'>Sale Return Invoices Report</h6>";
            $data .= "<h6  style='text-align:center;'>Print " . date('Y-M-d') . "</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>#</th>';
            $data .= '<th>invoice Number</th>';

            $data .= '<th>title</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>Currency</th>';
            $data .= '<th>Total</th>';

            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $customer_bill = CustomerReturnBill::whereBetween('invoice_date', [$fDate, $tDate])->orderBy('created_at', 'asc')->where('customer_id', $customer_id)->get();
            foreach ($customer_bill as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->invoice_number . "</td>";
                $data .= "<td>" . $row->title . "</td>";
                $data .= "<td>" . $row->date . "</td>";
                $data .= "<td>" . $row->currency->title_en . "</td>";
                $data .= "<td>" . $row->amount . "</td>";

                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
            }


            $data .= "</tbody>";
            $data .= '</table>';
            $data .= '<table>';
            $data .= "<tbody>";
            $data .= ' <tr>';
            $data .= '<th colspan="' . $currencies->count() . '" class="">Total </th>';

            $data .= ' </tr>';
            $data .= ' <tr>';
            foreach (Currency::all() as $row) {
                $total = $customer_bill->where('currency_id', $row->id)->where('customer_id', $customer_id)->sum('amount');
                $data .= '<td>' . $row->title_en . "/" . $total . '</td>';
            }

            $data .= '</tr>';
            $data .= "</tbody>";
            $data .= '</table>';

        } else {
            $data .= "<h6  style='text-align:center;'>" . $bname . "</h6>";
            $data .= "<h6  style='text-align:center;'>$customer->name sale Report</h6><p  style='text-align:center;'>From ($fDate) to ($tDate)</p>";
            $data .= "<h6  style='text-align:center;'>Currency $currency->title_en</h6>";
            $data .= "<h6  style='text-align:center;'>Print " . date('Y-M-d') . "</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>#</th>';
            $data .= '<th>invoice Number</th>';
            $data .= '<th>title</th>';
            $data .= '<th>Date</th>';
            $data .= '<th>Total</th>';

            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $customer_bill = CustomerReturnBill::whereBetween('invoice_date', [$fDate, $tDate])->where('currency_id', $currency_id)->orderBy('created_at', 'asc')->where('customer_id', $customer_id)->get();
            foreach ($customer_bill as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->invoice_number . "</td>";
                $data .= "<td>" . $row->title . "</td>";
                $data .= "<td>" . $row->date . "</td>";
                $data .= "<td>" . $row->amount . "</td>";

                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='6'  style='text-align:center;'>No data Available!</td></tr>";
            }
            $data .= "<tr>";
            $data .= '<th rowspan="2">Overview</th>';
            $data .= '<th colspan="2">Total</th>';

            $data .= "</tr>";
            $data .= "<tr>";

            $data .= '<th colspan="2">' . $customer_bill->sum('amount') . '</th>';


            $data .= "</tr>";

            $data .= "</tbody>";
            $data .= '</table>';

        }

        return $data;
    }
    public function filter_find(Request $request)
    {
        $customer = Customer::find($request->customer_id);
        if ($request->type_id == 1) {
            $bills = CustomerReturnBill::Where('invoice_number', $request->bill_number)
                ->where('customer_id', $request->customer_id)
                ->paginate(10);
        } else {
            $bills = CustomerReturnBill::where('title', 'like', "%" . $request->title . "%")
                ->where('customer_id', $request->customer_id)
                ->paginate(10);
        }
        return view('sale.customers.returns.filter', compact('bills', 'customer'));
    }
}
