<?php

namespace App\Http\Controllers\stockAdministration;

use App\Http\Controllers\Controller;
use App\Models\Currency;
use Illuminate\Http\Request;
use App\Models\PurchaseStock;
use App\Models\PCategory;
use App\Models\PUnit;
use App\Models\RowStockHistory;
use App\Models\Project;
use Auth;

class RowMaterialStockController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $stock = PurchaseStock::orderBy('id', 'desc')->paginate(10);
        $category = PCategory::all();
        $units = PUnit::all();
        return view('stock.rowStock.index', compact('stock', 'category', 'units'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = PCategory::all();
        $units = PUnit::all();
        $currencies = Currency::all();
        $projects=Project::orderBy('id','desc')->where('status','!=',3)->get();
        return view('stock.rowStock.create', compact('categories', 'units', 'currencies','projects'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'cat_id' => 'required',
            'scat_id' => 'required',
            'unit_id' => 'required',
            'qty' => 'required',
            'cpi' => 'required',
            'spi' => 'required',
            'currency_id' => 'required',
        ]);
        $check = PurchaseStock::where('cat_id', $request->cat_id)
            ->where('scat_id', $request->scat_id)
            ->where('unit_id', $request->unit_id)
            ->count();
        if ($check == 0) {
            $stock = new PurchaseStock();
            $stock->project_id=$request->project_id;
            $stock->cat_id = $request->cat_id;
            $stock->scat_id = $request->scat_id;
            $stock->unit_id = $request->unit_id;
            $stock->qty = $request->qty;
            $stock->cpi = $request->cpi;
            $stock->spi = $request->spi;
            $stock->date = date('Y-m-d');
            $stock->user_id = Auth::user()->id;
            $stock->currency_id = $request->currency_id;
            $save = $stock->save();
        } else {
            $stock = PurchaseStock::where('cat_id', $request->cat_id)
                ->where('scat_id', $request->scat_id)
                ->where('unit_id', $request->unit_id)
                ->get()->first();
            $stock = PurchaseStock::find($stock->id);
            $qty = $stock->qty + $request->qty;
            $stock->qty = $qty;
            $save = $stock->save();
        }

        if ($save) {
            $rstock = new RowStockHistory();
            $rstock->cat_id = $request->cat_id;
            $rstock->unit_id = $request->unit_id;
            $rstock->scat_id = $request->scat_id;
            $rstock->qty = $request->qty;
            $rstock->cpi = $request->cpi;
            $rstock->spi = $request->spi;
            $rstock->date = date('Y-m-d');
            $rstock->total = $request->qty * $request->cpi;
            $rstock->user_id = Auth::user()->id;
            $rstock->currency_id = $request->currency_id;
            $rstock->save();
        }

        session()->flash("msg", "Success!");
        return redirect()->route('row_stock.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $categories = PCategory::all();
        $units = PUnit::all();
        $currencies = Currency::all();
        $stock = PurchaseStock::find($id);
        $projects=Project::orderBy('id','desc')->where('status','!=',3)->get();

        return view('stock.rowStock.edit', compact('categories', 'units', 'currencies', 'stock','projects'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $stock = PurchaseStock::find($id);
        $stock->project_id=$request->project_id;
        $stock->cat_id = $request->cat_id;
        $stock->scat_id = $request->scat_id;
        $stock->unit_id = $request->unit_id;
        $stock->qty = $request->qty;
        $stock->cpi = $request->cpi;
        $stock->spi = $request->spi;
        $stock->date = date('Y-m-d');
        $stock->user_id = Auth::user()->id;
        $stock->currency_id = $request->currency_id;
        $stock->save();
        session()->flash("msg", "Success!");
        return redirect()->route('row_stock.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $stock = PurchaseStock::find($id)->delete();
        session()->flash("msg", "Success!");
        return back();

    }

    public function report_show()
    {
        $stock = PurchaseStock::orderBy('id', 'desc')->paginate('20');
        $categories = PCategory::all();
        $units = PUnit::all();
        return view('stock.rowStock.report', compact('stock', 'categories', 'units'));

    }

    public function report_find(Request $request)
    {
        $bname = \App\Models\Info::find(1)->business_name;
        $category_id = $request->category_id;
        $unit_id = $request->unit_id;
        $unit = PUnit::find($unit_id);
        $category = PCategory::find($category_id);
        $stock = PurchaseStock::all();
        $data = "";
        if ($category_id == "all") {
            if ($unit_id == "all") {
                $data .= "<h6 class='text-center'>" . $bname . "</h6>";
                $data .= "<h6 class='text-center'>Stock Report</h6><p class='text-center'> <strong>Unit Types</strong>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Category</th>';
                $data .= '<th>Sub Category</th>';
                $data .= '<th>Unit</th>';
                $data .= '<th>QTY</th>';
                $data .= '<th>CPI</th>';
                $data .= '<th>SPI</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                foreach ($stock as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->category->title_en . "</td>";
                    $data .= "<td>" . $row->sub_category->title_en . "</td>";
                    $data .= "<td>" . $row->unit->title_en . "</td>";
                    $data .= "<td>" . $row->qty . "</td>";
                    $data .= "<td>" . $row->cpi . "</td>";
                    $data .= "<td>" . $row->spi . "</td>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "<tr>";
                $data .= '<th>Sub Total</th>';
                $data .= '<th>' . $stock->sum('qty') . '</th>';
                $data .= "</tr>";
                $data .= "</tbody>";
                $data .= '</table>';
            } else {
                $data .= "<h6 class='text-center'>" . $bname . "</h6>";
                $data .= "<h6 class='text-center'>Stock Report</h6>";
                $data .= "<h6 class='text-center'> By Unit of $unit->title_en</h6>";

                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Category</th>';
                $data .= '<th>Sub Category</th>';
                $data .= '<th>Unit</th>';
                $data .= '<th>QTY</th>';
                $data .= '<th>CPI</th>';
                $data .= '<th>SPI</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $stock = PurchaseStock::where('unit_id', $unit_id)->get();
                foreach ($stock as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->category->title_en . "</td>";
                    $data .= "<td>" . $row->sub_category->title_en . "</td>";
                    $data .= "<td>" . $row->unit->title_en . "</td>";
                    $data .= "<td>" . $row->qty . "</td>";
                    $data .= "<td>" . $row->cpi . "</td>";
                    $data .= "<td>" . $row->spi . "</td>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "<tr>";
                $data .= '<th>Sub Total</th>';
                $data .= '<th>' . $stock->sum('qty') . '</th>';
                $data .= "</tr>";
                $data .= "</tbody>";
                $data .= '</table>';
            }
        } else {
            if ($unit_id == "all") {
                $data .= "<h6 class='text-center'>" . $bname . "</h6>";
                $data .= "<h6 class='text-center'>Stock Report</h6>";
                $data .= "<h6 class='text-center'> By Category of $category->title_en</h6>";
                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Category</th>';
                $data .= '<th>Sub Category</th>';
                $data .= '<th>Unit</th>';
                $data .= '<th>QTY</th>';
                $data .= '<th>CPI</th>';
                $data .= '<th>SPI</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $stock = PurchaseStock::where('cat_id', $category)->get();
                foreach ($stock as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->category->title_en . "</td>";
                    $data .= "<td>" . $row->sub_category->title_en . "</td>";
                    $data .= "<td>" . $row->unit->title_en . "</td>";
                    $data .= "<td>" . $row->qty . "</td>";
                    $data .= "<td>" . $row->cpi . "</td>";
                    $data .= "<td>" . $row->spi . "</td>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "<tr>";
                $data .= '<th>Sub Total</th>';
                $data .= '<th>' . $stock->sum('qty') . '</th>';
                $data .= "</tr>";
                $data .= "</tbody>";
                $data .= '</table>';
            } else {
                $data .= "<h6 class='text-center'>" . $bname . "</h6>";
                $data .= "<h6 class='text-center'>Stock Report</h6>";
                $data .= "<h6 class='text-center'> By Unit of $unit->title_en</h6>";

                $data .= '<table class="" id="table_style">';
                $data .= '<tr>';
                $data .= '<th>S-NO</th>';
                $data .= '<th>Category</th>';
                $data .= '<th>Sub Category</th>';
                $data .= '<th>Unit</th>';
                $data .= '<th>QTY</th>';
                $data .= '<th>CPI</th>';
                $data .= '<th>SPI</th>';
                $data .= '</tr>';
                $data .= '<tbody>';
                $i = 1;
                $stock = PurchaseStock::where('unit_id', $unit_id)->where('cat_id', $category_id)->get();
                foreach ($stock as $row) {
                    $data .= "<tr><td>" . $i . "</td>";
                    $data .= "<td>" . $row->category->title_en . "</td>";
                    $data .= "<td>" . $row->sub_category->title_en . "</td>";
                    $data .= "<td>" . $row->unit->title_en . "</td>";
                    $data .= "<td>" . $row->qty . "</td>";
                    $data .= "<td>" . $row->cpi . "</td>";
                    $data .= "<td>" . $row->spi . "</td>";
                    $i++;
                }
                if ($i == 1) {
                    $data .= "<tr><td colspan='6' class='text-center'>No data Available!</td></tr>";
                }
                $data .= "<tr>";
                $data .= '<th>Sub Total</th>';
                $data .= '<th>' . $stock->sum('qty') . '</th>';
                $data .= "</tr>";
                $data .= "</tbody>";
                $data .= '</table>';
            }
        }

        return $data;
    }

    public function filter_find(Request $request)
    {
        $category = PCategory::all();
        $units = PUnit::all();
        if ($request->type_id == 1) {
            $stock = PurchaseStock::where('cat_id', $request->cat_id)->orderBy('id', 'desc')->get();
        }
        if ($request->type_id == 2) {
            $stock = PurchaseStock::where('unit_id', $request->unit_id)->orderBy('id', 'desc')->get();
        }
        if ($request->type_id == 3) {
            $stock = PurchaseStock::where('qty', '<=', $request->qty)->orderBy('id', 'desc')->get();
        }
        if ($request->type_id == 4) {
            $stock = PurchaseStock::where('cpi', $request->cpi)->orderBy('id', 'desc')->get();
        }
        if ($request->type_id == 5) {
            $stock = PurchaseStock::where('spi', $request->spi)->orderBy('id', 'desc')->get();
        }
        return view('stock.rowStock.filter', compact('stock', 'category', 'units'));
    }

}
