<?php

namespace App\Http\Controllers\stockAdministration;

use App\Http\Controllers\Controller;
use App\Models\CustomerBillItem;
use App\Models\SupplierBillItem;
use Illuminate\Http\Request;
use App\Models\Scategory;
use App\Models\SSubCategory;
use App\Models\SWeight;
use App\Models\SUnit;
use App\Models\Stock;
use App\Models\StockHistory;
use App\Models\StockLocation;
use App\Models\Currency;
use App\Models\PurchaseStock;
use App\Models\PCategory;
use App\Models\PUnit;
use App\Models\RowStockHistory;

class StockTransactionController extends Controller
{
    public function p_report_show()
    {
        return view('stock.transaction');

    }

    public function p_report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $from_date = $request->fromDate;
        $to_date = $request->toDate;
        $type_id = $request->type_id;
        $data = "";
        if ($type_id == 1) {
            $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center;'>Stock Report</h6>";
            $data .= "<h6 style='text-align:center;'>Incoming History</h6>";
            $data .= "<h6 style='text-align:center;'>From $from_date To $to_date</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>S-NO</th>';
            $data .= '<th>Category</th>';
            $data .= '<th>Sub Category</th>';
            $data .= '<th>Unit</th>';
            $data .= '<th>Weight</th>';
            $data .= '<th>QTY</th>';
            $data .= '<th>CPI</th>';
            $data .= '<th>SPI</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $record = StockHistory::whereBetween('date', [$from_date, $to_date])->get();
            foreach ($record as $row) {
                $data .= "<tr><td>" . $i . "</td>";
                $data .= "<td>" . $row->category->title_en . "</td>";
                $data .= "<td>" . $row->sub_category->title_en . "</td>";
                $data .= "<td>" . $row->unit->title_en . "</td>";
                $data .= "<td>" . $row->weight->title_en . "</td>";
                $data .= "<td>" . $row->qty . "</td>";
                $data .= "<td>" . $row->cpi . "</td>";
                $data .= "<td>" . $row->spi . "</td>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='9' style='text-align:center;'>No data Available!</td></tr>";
            }

            $data .= "</tbody>";
            $data .= '</table>';
        }
        if ($type_id == 2) {
            $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center;'>Stock Report</h6>";
            $data .= "<h6 style='text-align:center;'>Outgoing History</h6>";
            $data .= "<h6 style='text-align:center;'>From $from_date To $to_date</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>S-NO</th>';
            $data .= '<th>Category</th>';
            $data .= '<th>Sub Category</th>';
            $data .= '<th>Unit</th>';
            $data .= '<th>Weight</th>';
            $data .= '<th>QTY</th>';
            $data .= '<th>CPI</th>';
            $data .= '<th>SPI</th>';
            $data .= '<th>Profit</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $record = CustomerBillItem::whereBetween('date', [$from_date, $to_date])->get();
            foreach ($record as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->category->title_en . "</td>";
                $data .= "<td>" . $row->sub_category->title_en . "</td>";
                $data .= "<td>" . $row->unit->title_en . "</td>";
                $data .= "<td>" . $row->weight->title_en . "</td>";
                $data .= "<td>" . $row->qty . "</td>";
                $data .= "<td>" . $row->cost_price . "</td>";
                $data .= "<td>" . $row->sale_price . "</td>";
                $data .= "<td>";
                $cpi = $row->cost_price;
                $spi = $row->sale_price;
                $data .= $spi - $cpi;
                $data .= "</td>";
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='9' style='text-align:center;'>No data Available!</td></tr>";
            }
            $data .= "<tr>";
            $data .= "<td colspan='3'>Total Cost</td>";
            $data .= "<td colspan='3'>Total Sale</td>";
            $data .= "<td colspan='3'>Profit</td>";
            $data .= "</tr>";
            $data .= "<tr>";
            $t_cpi = $record->sum('cost_price');
            $t_spi = $record->sum('sale_price');
            $p_total = $t_spi - $t_cpi;
            $data .= "<td colspan='3'>$t_cpi</td>";
            $data .= "<td colspan='3'>$t_spi</td>";
            $data .= "<td colspan='3'>" . $p_total . "</td>";
            $data .= "</tr>";
            $data .= "</tbody>";
            $data .= '</table>';
        }
        if ($type_id == 3) {
            $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center;'>Stock Report</h6>";
            $data .= "<h6 style='text-align:center;'>Warning Stock</h6>";
            $data .= "<h6 style='text-align:center;'>From $from_date To $to_date</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>S-NO</th>';
            $data .= '<th>Category</th>';
            $data .= '<th>Sub Category</th>';
            $data .= '<th>Unit</th>';
            $data .= '<th>Weight</th>';
            $data .= '<th>QTY</th>';
            $data .= '<th>CPI</th>';
            $data .= '<th>SPI</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $record = Stock::orderBy('id', 'desc')->where('qty', '<=', 5)->get();
            foreach ($record as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->category->title_en . "</td>";
                $data .= "<td>" . $row->sub_category->title_en . "</td>";
                $data .= "<td>" . $row->unit->title_en . "</td>";
                $data .= "<td>" . $row->weight->title_en . "</td>";
                $data .= "<td style='color:red;'>" . $row->qty . "</td>";
                $data .= "<td>" . $row->cpi . "</td>";
                $data .= "<td>" . $row->spi . "</td>";             
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='9' style='text-align:center;'>No data Available!</td></tr>";
            }
         
            $data .= "</tbody>";
            $data .= '</table>';
        }
        return $data;
    }


    public function r_report_show()
    {
        return view('stock.rowStock.transaction');

    }

    public function r_report_find(Request $request)
    {
        $bname=\App\Models\Info::find(1)->business_name;
        $from_date = $request->fromDate;
        $to_date = $request->toDate;
        $type_id = $request->type_id;
        $data = "";
        if ($type_id == 1) {
            $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center;'>Row Stock Report</h6>";
            $data .= "<h6 style='text-align:center;'>Incoming History</h6>";
            $data .= "<h6 style='text-align:center;'>From $from_date To $to_date</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>S-NO</th>';
            $data .= '<th>Category</th>';
            $data .= '<th>Unit</th>';
            $data .= '<th>QTY</th>';
            $data .= '<th>CPI</th>';
            $data .= '<th>SPI</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $record = RowStockHistory::whereBetween('date', [$from_date, $to_date])->get();
            foreach ($record as $row) {
                $data .= "<tr><td>" . $i . "</td>";
                $data .= "<td>" . $row->category->title_en . "</td>";
                $data .= "<td>" . $row->unit->title_en . "</td>";
                $data .= "<td>" . $row->qty . "</td>";
                $data .= "<td>" . $row->cpi . "</td>";
                $data .= "<td>" . $row->spi . "</td>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='9' style='text-align:center;'>No data Available!</td></tr>";
            }

            $data .= "</tbody>";
            $data .= '</table>';
        }
        if ($type_id == 2) {
            $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center;'>Stock Report</h6>";
            $data .= "<h6 style='text-align:center;'>Outgoing History</h6>";
            $data .= "<h6 style='text-align:center;'>From $from_date To $to_date</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>S-NO</th>';
            $data .= '<th>Category</th>';
            $data .= '<th>Unit</th>';
            $data .= '<th>QTY</th>';
            $data .= '<th>CPI</th>';
            $data .= '<th>SPI</th>';
            $data .= '<th>Profit</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $record = SupplierBillItem::whereBetween('date', [$from_date, $to_date])->get();
            foreach ($record as $row) {
                $data .= "<tr><td>" . $i . "</td>";
                $data .= "<td>" . $row->category->title_en . "</td>";
                $data .= "<td>" . $row->unit->title_en . "</td>";
                $data .= "<td>" . $row->qty . "</td>";
                $data .= "<td>" . $row->cpi . "</td>";
                $data .= "<td>" . $row->spi . "</td>";
                $data .= "<td>";
                $cpi = $row->cpi;
                $spi = $row->spi;
                $data .= $spi - $cpi;
                $data .= "</td>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='9' style='text-align:center;'>No data Available!</td></tr>";
            }
            $data .= "<tr>";
            $data .= "<td colspan='3'>Total Cost</td>";
            $data .= "<td colspan='3'>Total Sale</td>";
            $data .= "<td colspan='3'>Profit</td>";
            $data .= "</tr>";
            $data .= "<tr>";
            $t_cpi = $record->sum('cpi');
            $t_spi = $record->sum('spi');
            $p_total = $t_spi - $t_cpi;
            $data .= "<td colspan='3'>$t_cpi</td>";
            $data .= "<td colspan='3'>$t_spi</td>";
            $data .= "<td colspan='3'>" . $p_total . "</td>";
            $data .= "</tr>";
            $data .= "</tbody>";
            $data .= '</table>';
        }
        if ($type_id == 3) {
            $data .= "<h6 style='text-align:center;'>".$bname."</h6>";
            $data .= "<h6 style='text-align:center;'>Stock Report</h6>";
            $data .= "<h6 style='text-align:center;'>Warning Stock</h6>";
            $data .= "<h6 style='text-align:center;'>From $from_date To $to_date</h6>";
            $data .= '<table class="" id="table_style">';
            $data .= '<tr>';
            $data .= '<th>S-NO</th>';
            $data .= '<th>Category</th>';
            $data .= '<th>Unit</th>';
            $data .= '<th>QTY</th>';
            $data .= '<th>CPI</th>';
            $data .= '<th>SPI</th>';
            $data .= '</tr>';
            $data .= '<tbody>';
            $i = 1;
            $record = PurchaseStock::orderBy('id', 'desc')->where('qty', '<=', 5)->get();
            foreach ($record as $row) {
                $data .= "<tr>";
                $data .= "<td>" . $i . "</td>";
                $data .= "<td>" . $row->category->title_en . "</td>";
                $data .= "<td>" . $row->unit->title_en . "</td>";
                $data .= "<td style='color:red;'>" . $row->qty . "</td>";
                $data .= "<td>" . $row->cpi . "</td>";
                $data .= "<td>" . $row->spi . "</td>";             
                $data .= "</tr>";
                $i++;
            }
            if ($i == 1) {
                $data .= "<tr><td colspan='9' style='text-align:center;'>No data Available!</td></tr>";
            }
         
            $data .= "</tbody>";
            $data .= '</table>';
        }
        return $data;
    }
}
