<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Scategory;
use App\Models\SSubCategory;
use App\Models\SUnit;
use App\Models\SWeight;
use App\Models\CustomerBillItem;
use App\Models\StockLocation;

class Stock extends Model
{
    use HasFactory;

    public function category(){
        return $this->belongsTo(Scategory::class,'cat_id','id');
    }

    public function sub_category(){
        return $this->belongsTo(SSubCategory::class,'sub_cat_id','id');
    }
    public function unit(){
        return $this->belongsTo(SUnit::class,'unit_id','id');
    }

    public function weight(){
        return $this->belongsTo(SWeight::class,'weight_id','id');
    }

    public function customer_bill_item(){
        return $this->hasMany(CustomerBillItem::class);
    }

    public function location(){
        return $this->belongsTo(StockLocation::class,'location_id','id');
    }
}
